/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Spore;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BiomeModification
implements BiomeModifier {
    private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)new ResourceLocation("spore", "inf_spawns"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"spore");

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.ADD) {
            return;
        }
        if (this.isBiomeBlacklisted(biome)) {
            return;
        }
        int biomeModifier = biome.m_203656_(Tags.Biomes.IS_MUSHROOM) ? 20 : 0;
        for (String allowedBiome : (List)SConfig.SERVER.dimension_parameters.get()) {
            ResourceLocation biomeLocation = new ResourceLocation(allowedBiome);
            TagKey biomeTag = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)biomeLocation);
            if (!biome.m_203656_(biomeTag) && !biome.m_203373_(biomeLocation)) continue;
            this.addSpawns(builder, biomeModifier);
            break;
        }
    }

    private void addSpawns(ModifiableBiomeInfo.BiomeInfo.Builder builder, int modifier) {
        List spawnEntries = (List)SConfig.SERVER.spawns.get();
        for (String entry : spawnEntries) {
            String[] parts = entry.split("\\|");
            if (parts.length != 4) {
                Spore.LOGGER.warn("Invalid spawn config entry: {}", (Object)entry);
                continue;
            }
            ResourceLocation entityId = new ResourceLocation(parts[0]);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                Spore.LOGGER.warn("Unknown entity type: {}", (Object)parts[0]);
                continue;
            }
            try {
                int weight = Integer.parseUnsignedInt(parts[1]) + modifier;
                int minCount = Integer.parseUnsignedInt(parts[2]);
                int maxCount = Integer.parseUnsignedInt(parts[3]);
                builder.getMobSpawnSettings().getSpawner(entityType.m_20674_()).add(new MobSpawnSettings.SpawnerData(entityType, weight, minCount, maxCount));
            }
            catch (NumberFormatException e) {
                Spore.LOGGER.error("Invalid spawn config number format in: {}", (Object)entry, (Object)e);
            }
        }
    }

    private boolean isBiomeBlacklisted(Holder<Biome> biome) {
        for (String blacklisted : (List)SConfig.SERVER.dimension_blacklist.get()) {
            ResourceLocation blacklistedLocation = new ResourceLocation(blacklisted);
            TagKey blacklistTag = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)blacklistedLocation);
            if (!biome.m_203656_(blacklistTag) && !biome.m_203373_(blacklistedLocation)) continue;
            return true;
        }
        return false;
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SERIALIZER.get();
    }

    public static Codec<BiomeModification> makeCodec() {
        return Codec.unit(BiomeModification::new);
    }
}

