/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings;

import com.Harbinger.Spore.Core.SticketType;
import com.Harbinger.Spore.ExtremelySusThings.ChunkLoadRequest;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class ChunkLoaderHelper {
    public static final Map<String, ChunkLoadRequest> ACTIVE_REQUESTS = new HashMap<String, ChunkLoadRequest>();

    public static void addRequest(ChunkLoadRequest request) {
        ACTIVE_REQUESTS.put(request.getRequestID(), request);
        ServerLevel level = request.getDimension();
        SporeSavedData data = SporeSavedData.getDataLocation(level);
        for (ChunkPos pos : request.getChunkPositionsToLoad()) {
            ChunkLoaderHelper.forceChunk(level, pos);
        }
        data.addRequest(request);
    }

    public static void removeRequest(String requestId) {
        ChunkLoadRequest request = ACTIVE_REQUESTS.remove(requestId);
        if (request != null) {
            ServerLevel level = request.getDimension();
            SporeSavedData data = SporeSavedData.getDataLocation(level);
            for (ChunkPos pos : request.getChunkPositionsToLoad()) {
                ChunkLoaderHelper.unforceChunk(level, pos);
            }
            data.removeRequest(requestId);
        }
    }

    public static void tick() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, ChunkLoadRequest> entry : ACTIVE_REQUESTS.entrySet()) {
            ChunkLoadRequest request = entry.getValue();
            request.decrementTicksUntilExpiration(1);
            if (!request.isExpired() || request.refreshIfOwnerStillPresent(request.getTickAmount())) continue;
            toRemove.add(request.getRequestID());
        }
        for (String id : toRemove) {
            ChunkLoaderHelper.removeRequest(id);
        }
    }

    public static void forceChunk(ServerLevel level, ChunkPos pos) {
        level.m_7726_().m_8387_(SticketType.SPORE_CHUNK_LOADER, pos, 2, (Object)pos);
    }

    public static void unforceChunk(ServerLevel level, ChunkPos pos) {
        level.m_7726_().m_8438_(SticketType.SPORE_CHUNK_LOADER, pos, 2, (Object)pos);
    }
}

