/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.SBlockEntities.HiveSpawnBlockEntity;
import com.Harbinger.Spore.SBlockEntities.LivingStructureBlocks;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HiveSpawn
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public HiveSpawn() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_164530_).m_60913_(4.0f, 4.0f).m_60918_(SoundType.f_56750_).m_60977_().m_60955_().m_60910_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HiveSpawnBlockEntity(pos, state);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState blockState, boolean value) {
        super.m_6807_(state, level, pos, blockState, value);
        level.m_186460_(pos, (Block)this, 80);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource random) {
        BlockEntity entity = level.m_7702_(blockPos);
        level.m_186460_(blockPos, (Block)this, 80);
        if (entity instanceof LivingStructureBlocks) {
            LivingStructureBlocks livingStructureBlocks = (LivingStructureBlocks)entity;
            AABB searchbox = AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)50.0, (double)50.0, (double)50.0);
            List entities = level.m_45976_(Infected.class, searchbox);
            for (Object entity1 : entities) {
                Infected infected;
                if (!(entity1 instanceof Infected) || (infected = (Infected)((Object)entity1)).getKills() <= 1 || livingStructureBlocks.getKills() > (Integer)SConfig.DATAGEN.hive_spawn_kills.get()) continue;
                infected.setSearchPos(blockPos);
            }
            if (livingStructureBlocks.getKills() >= (Integer)SConfig.DATAGEN.hive_spawn_kills.get() && this.checkForOtherMinds(blockPos, (Level)level)) {
                level.m_7471_(blockPos, true);
                Proto proto = (Proto)((EntityType)Sentities.PROTO.get()).m_20615_((Level)level);
                if (proto != null) {
                    proto.loadChunks();
                    proto.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                    proto.tickEmerging();
                    if (((Boolean)SConfig.SERVER.teleport_hive.get()).booleanValue()) {
                        Proto.teleportToSurface(level, (Mob)proto);
                    }
                    level.m_7967_((Entity)proto);
                }
                for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
                    player.m_6330_((SoundEvent)Ssounds.REBIRTH.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"hivemind_summon_message"), false);
                }
            } else if (livingStructureBlocks.getKills() >= (Integer)SConfig.DATAGEN.hive_spawn_kills.get() && !this.checkForOtherMinds(blockPos, (Level)level)) {
                StructureTemplate template = level.m_215082_().m_230359_(new ResourceLocation("spore", "mega_biomass_tower"));
                BlockPos pos = new BlockPos(blockPos.m_123341_() - 4, blockPos.m_123342_() - 4, blockPos.m_123343_() - 4);
                template.m_230328_((ServerLevelAccessor)level, pos, pos, new StructurePlaceSettings().m_74392_(true), random, 3);
            }
        }
    }

    boolean checkForOtherMinds(BlockPos blockPos, Level level) {
        int e = (Integer)SConfig.DATAGEN.hive_generate.get();
        AABB searchbox = AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)e, (double)e, (double)e);
        List entities = level.m_45976_(Proto.class, searchbox);
        for (Entity entity1 : entities) {
            if (!(entity1 instanceof Proto)) continue;
            return false;
        }
        return true;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LivingStructureBlocks) {
            Infected infected;
            LivingStructureBlocks livingStructureBlocks = (LivingStructureBlocks)blockEntity;
            if (entity instanceof Infected && (infected = (Infected)entity).getKills() > 1) {
                infected.setKills(infected.getKills() - 1);
                livingStructureBlocks.addKills();
            }
        }
        super.m_7892_(state, level, pos, entity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder);
        stateBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public PushReaction m_5537_(BlockState p_153494_) {
        return PushReaction.PUSH_ONLY;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState p_153274_, BlockEntityType<T> type) {
        return HiveSpawn.createBrainTicker(level, type, (BlockEntityType<? extends HiveSpawnBlockEntity>)((BlockEntityType)SblockEntities.HIVE_SPAWN.get()));
    }

    @javax.annotation.Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createBrainTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends HiveSpawnBlockEntity> p_151990_) {
        return level.f_46443_ ? HiveSpawn.m_152132_(type, p_151990_, HiveSpawnBlockEntity::clientTick) : null;
    }
}

