/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.SBlockEntities.IncubatorBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class IncubatorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public IncubatorBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(6.0f, 20.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new IncubatorBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return IncubatorBlock.m_49796_((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)16.0, (double)15.9).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState p_153274_, BlockEntityType<T> type) {
        return IncubatorBlock.createIncubatorTicker(level, type, (BlockEntityType<? extends IncubatorBlockEntity>)((BlockEntityType)SblockEntities.INCUBATOR.get()));
    }

    @javax.annotation.Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createIncubatorTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends IncubatorBlockEntity> p_151990_) {
        return level.f_46443_ ? IncubatorBlock.m_152132_(type, p_151990_, IncubatorBlockEntity::clientTick) : IncubatorBlock.m_152132_(type, p_151990_, IncubatorBlockEntity::serverTick);
    }

    public BlockState m_6843_(BlockState p_54360_, Rotation p_54361_) {
        return (BlockState)p_54360_.m_61124_((Property)FACING, (Comparable)p_54361_.m_55954_((Direction)p_54360_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_54357_, Mirror p_54358_) {
        return p_54357_.m_60717_(p_54358_.m_54846_((Direction)p_54357_.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_54370_) {
        p_54370_.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        super.m_6227_(state, level, pos, player, hand, result);
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof IncubatorBlockEntity) {
            IncubatorBlockEntity blockEntity = (IncubatorBlockEntity)entity;
            ItemStack item = player.m_21120_(hand);
            if (item.m_41720_() == Sitems.BIOMASS.get() && blockEntity.getFuel() <= 750) {
                blockEntity.setFuel(blockEntity.getFuel() + 250);
                item.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)blockEntity, (BlockPos)pos);
                return InteractionResult.SUCCESS;
            }
            if (blockEntity.m_8020_(0).m_41619_()) {
                if (item.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("spore:weapons")))) {
                    if (level.f_46443_) {
                        blockEntity.m_6836_(0, item.m_41777_());
                    } else {
                        blockEntity.m_6836_(0, item.m_41777_());
                        item.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (level.f_46443_) {
                    blockEntity.m_6836_(0, ItemStack.f_41583_);
                } else {
                    IncubatorBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)blockEntity.m_8020_(0).m_41777_());
                    blockEntity.m_6836_(0, ItemStack.f_41583_);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void setFuelTag(ItemStack stack, int value) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("fuel", value);
    }

    public int getFuelTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_("fuel");
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IncubatorBlockEntity) {
            IncubatorBlockEntity incubatorBlock = (IncubatorBlockEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)this);
            this.setFuelTag(stack, incubatorBlock.getFuel());
            ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
            level.m_7967_((Entity)item);
            IncubatorBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)incubatorBlock.m_8020_(0).m_41777_());
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IncubatorBlockEntity) {
            IncubatorBlockEntity incubatorBlock = (IncubatorBlockEntity)blockEntity;
            incubatorBlock.setFuel(this.getFuelTag(stack));
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_5871_(stack, getter, components, tooltipFlag);
        String string = Component.m_237115_((String)((Item)Sitems.BIOMASS.get()).m_5524_()).getString();
        components.add((Component)Component.m_237113_((String)(string + " " + this.getFuelTag(stack) + "/1000")));
    }
}

