/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sentities.Projectile.AcidBall;
import com.Harbinger.Spore.Sentities.Projectile.Vomit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Organoid
extends UtilityEntity
implements Enemy {
    public static final EntityDataAccessor<Integer> BORROW = SynchedEntityData.m_135353_(Organoid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EMERGE = SynchedEntityData.m_135353_(Organoid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    protected Organoid(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 25;
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.ORGANOID_DAMAGE.get();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19861_) {
            this.m_7601_(Blocks.f_50016_.m_49966_(), new Vec3(0.0, 1.0, 0.0));
        }
        if (!this.f_19853_.f_46443_) {
            if (this.isEmerging()) {
                this.tickEmerging();
            } else if (this.isBurrowing()) {
                this.tickBurrowing();
            }
        }
        if (this.f_19797_ % 200 == 0 && !(this instanceof Proto) && !(this instanceof Mound)) {
            this.regulateSpawns();
        }
    }

    public void awardHivemind() {
        int summonerUUID;
        Level level;
        Entity summoner;
        CompoundTag data = this.getPersistentData();
        if (data.m_128441_("hivemind") && (summoner = (level = this.f_19853_).m_6815_(summonerUUID = data.m_128451_("hivemind"))) instanceof Proto) {
            Proto smartMob = (Proto)summoner;
            int decision = data.m_128451_("decision");
            int member = data.m_128451_("member");
            smartMob.praisedForDecision(decision, member);
        }
    }

    public void punishHivemind() {
        int summonerUUID;
        Level level;
        Entity summoner;
        CompoundTag data = this.getPersistentData();
        if (data.m_128441_("hivemind") && (summoner = (level = this.f_19853_).m_6815_(summonerUUID = data.m_128451_("hivemind"))) instanceof Proto) {
            Proto smartMob = (Proto)summoner;
            int decision = data.m_128451_("decision");
            int member = data.m_128451_("member");
            smartMob.punishForDecision(decision, member);
        }
    }

    public boolean m_213854_() {
        return true;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float p_21017_) {
        if (source.m_7640_() instanceof AcidBall || source.m_7640_() instanceof Vomit) {
            return false;
        }
        return super.m_6469_(source, p_21017_);
    }

    public int getEmerge_tick() {
        return 20;
    }

    public int getBorrow_tick() {
        return 20;
    }

    public boolean isEmerging() {
        return (Integer)this.f_19804_.m_135370_(EMERGE) > 0;
    }

    public void tickEmerging() {
        int emerging = (Integer)this.f_19804_.m_135370_(EMERGE);
        if (emerging > this.getEmerge_tick()) {
            emerging = -1;
        }
        this.f_19804_.m_135381_(EMERGE, (Object)(emerging + 1));
    }

    public boolean isBurrowing() {
        return (Integer)this.f_19804_.m_135370_(BORROW) > 0;
    }

    public void tickBurrowing() {
        int burrowing = (Integer)this.f_19804_.m_135370_(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            burrowing = -1;
        }
        this.f_19804_.m_135381_(BORROW, (Object)(burrowing + 1));
    }

    public int getEmerge() {
        return (Integer)this.f_19804_.m_135370_(EMERGE);
    }

    public int getBorrow() {
        return (Integer)this.f_19804_.m_135370_(BORROW);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BORROW, (Object)0);
        this.f_19804_.m_135372_(EMERGE, (Object)0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        this.tickEmerging();
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isEmerging() || this.isBurrowing()) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            Level world = this.f_19853_;
            RandomSource randomsource = this.m_217043_();
            for (int l = 0; l < this.getNumberOfParticles(); ++l) {
                Level level = this.f_19853_;
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                int xi = randomsource.m_216339_(-1, 1);
                int zi = randomsource.m_216339_(-1, 1);
                if (world.m_8055_(new BlockPos((int)x, (int)y - 1, (int)z)).m_60734_().m_5456_() == ItemStack.f_41583_.m_41720_()) continue;
                serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)world.m_8055_(new BlockPos((int)x, (int)y - 1, (int)z)).m_60734_())), x + (double)xi, y - 0.1, z + (double)zi, 3, ((double)randomsource.m_188501_() - 1.0) * 0.08, ((double)randomsource.m_188501_() - 1.0) * 0.08, ((double)randomsource.m_188501_() - 1.0) * 0.08, (double)0.15f);
            }
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.f_19797_ % 20 == 0 && this.m_21223_() < this.m_21233_() && this.m_146888_() <= 0) {
            this.m_21153_(this.m_21223_() + 1.0f);
        }
    }

    public int getNumberOfParticles() {
        return 2;
    }

    public boolean m_147207_(MobEffectInstance instance, @Nullable Entity entity) {
        if (instance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL && instance.m_19564_() < 1) {
            return false;
        }
        return super.m_147207_(instance, entity);
    }

    public void regulateSpawns() {
        AABB aabb = this.m_20191_().m_82400_(6.0);
        List entityList = this.f_19853_.m_6249_((Entity)this, aabb, entity -> entity instanceof Organoid && !(entity instanceof Proto) && !(entity instanceof Mound));
        if (entityList.size() > 4) {
            this.tickBurrowing();
        }
    }

    public boolean isCloseCombatant() {
        return false;
    }
}

