/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.HybridPathNavigation;
import com.Harbinger.Spore.Sentities.AI.ReturnToWater;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.MovementControls.WaterXlandMovement;
import com.Harbinger.Spore.Sentities.WaterInfected;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class Bloater
extends EvolvedInfected
implements WaterInfected {
    public static final EntityDataAccessor<Integer> TUMORS = SynchedEntityData.m_135353_(Bloater.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int explosionTicks = 0;

    public Bloater(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new WaterXlandMovement((Mob)this);
        this.f_21344_ = new HybridPathNavigation((Mob)this, level);
    }

    @Override
    public void m_7023_(Vec3 p_32858_) {
        if (this.m_6142_() && this.isInFluidType()) {
            this.m_19920_(0.1f, p_32858_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.85));
        } else {
            super.m_7023_(p_32858_);
        }
    }

    public float getStepHeight() {
        return this.isInFluidType() ? 2.0f : 1.0f;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.bloater_melee_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.braio_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.bloater_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 28.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    public int getAmountOfTumors() {
        return (Integer)this.f_19804_.m_135370_(TUMORS);
    }

    public void setAmountOfTumors(int value) {
        this.f_19804_.m_135381_(TUMORS, (Object)value);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TUMORS, (Object)4);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAmountOfTumors(tag.m_128451_("tumors"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("tumors", this.getAmountOfTumors());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.explosionTicks > 0) {
            this.tickExplosion();
        }
        if (this.f_19797_ % 400 == 0 && this.getAmountOfTumors() < 4) {
            this.setAmountOfTumors(this.getAmountOfTumors() + 1);
        }
    }

    public void tickExplosion() {
        if (this.explosionTicks == 1) {
            this.m_216990_(SoundEvents.f_11837_);
        }
        ++this.explosionTicks;
        if (this.explosionTicks == 50) {
            this.explodeTumor();
            this.explosionTicks = 0;
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.bloater_loot.get();
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (Math.random() < 0.5 && this.getAmountOfTumors() > 0) {
            this.tickExplosion();
        }
        if (entity.isInFluidType()) {
            entity.m_20256_(this.m_20184_().m_82520_(0.0, -1.0, 0.0));
        }
        return super.m_7327_(entity);
    }

    public void explodeTumor() {
        Entity entity22;
        AABB aabb = this.m_20191_().m_82400_(8.0);
        List entities = this.f_19853_.m_6249_((Entity)this, aabb, entity -> {
            LivingEntity living;
            return entity instanceof LivingEntity && this.TARGET_SELECTOR.test(living = (LivingEntity)entity);
        });
        for (Entity entity22 : entities) {
            if (!(entity22 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity22;
            if (Utilities.helmetList().contains(living.m_6844_(EquipmentSlot.HEAD).m_41720_())) continue;
            living.m_7292_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 200, 2));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 0));
        }
        this.m_216990_(SoundEvents.f_11913_);
        this.setAmountOfTumors(this.getAmountOfTumors() - 1);
        entity22 = this.f_19853_;
        if (entity22 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity22;
            double x0 = this.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
            double y0 = this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.25) * 0.25 * 5.0;
            double z0 = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)Sparticles.SPORE_PARTICLE.get()), x0, y0, z0, 12, 0.0, 0.0, 0.0, 1.0);
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.3, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0f + entity.m_20205_() * entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new ReturnToWater((PathfinderMob)this, 1.2));
        super.m_8099_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.DROWNED_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_11875_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }
}

