/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.GrieferSwellGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.GrieferVariants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class Griefer
extends EvolvedInfected
implements VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(Griefer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Griefer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int swell;
    private final int maxSwell = 30;

    public Griefer(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_griefer_loot.get();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128376_("Fuse", (short)this.maxSwell);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i = this.getSwellDir();
            if (i > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeGriefer();
            }
            if (this.getVariant() == GrieferVariants.RADIOACTIVE && this.f_19797_ % 30 == 0) {
                AABB boundingBox = this.m_20191_().m_82400_(6.0);
                List entities = this.f_19853_.m_6249_((Entity)this, boundingBox, EntitySelector.f_20406_);
                for (Entity entity1 : entities) {
                    LivingEntity livingEntity;
                    if (!(entity1 instanceof LivingEntity) || (livingEntity = (LivingEntity)entity1) instanceof Infected || livingEntity instanceof UtilityEntity) continue;
                    if (ModList.get().isLoaded("alexscaves")) {
                        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("alexscaves:irradiated"));
                        if (effect == null) continue;
                        livingEntity.m_7292_(new MobEffectInstance(effect, 200, 0));
                        continue;
                    }
                    livingEntity.m_6469_((DamageSource)new EntityDamageSource("radiation_damage", (Entity)this), 4.0f);
                }
            }
        }
        super.m_8119_();
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public boolean grieferExplosion() {
        return this.swell >= 1;
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    public int getSwell() {
        return this.swell;
    }

    private void explodeGriefer() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int explosionRadius = this.getTypeVariant() == 2 ? 2 * (Integer)SConfig.SERVER.explosion.get() : (Integer)SConfig.SERVER.explosion.get();
            Explosion.BlockInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) && (Boolean)SConfig.SERVER.explosion_on.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)explosionRadius, explosion$blockinteraction);
            this.summonScent((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (this.getTypeVariant() == 1 || this.getTypeVariant() == 3) {
                this.explodeToxicTumor(this.getTypeVariant() == 1);
            }
            if (this.getTypeVariant() == 4) {
                Utilities.convertBlocks(serverLevel, (Entity)this, this.m_20097_(), 7.0, Blocks.f_50083_.m_49966_());
            }
            this.m_146870_();
        }
    }

    private void explodeToxicTumor(boolean poison) {
        AABB boundingBox = this.m_20191_().m_82400_(6.0);
        List entities = this.f_19853_.m_6249_((Entity)this, boundingBox, EntitySelector.f_20406_);
        for (Entity entity1 : entities) {
            LivingEntity livingEntity;
            if (!(entity1 instanceof LivingEntity) || !Utilities.TARGET_SELECTOR.Test(livingEntity = (LivingEntity)entity1)) continue;
            if (poison) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 1200, 2));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 400, 0));
                continue;
            }
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                livingEntity.m_7292_(instance);
            }
        }
    }

    private void summonScent(LevelAccessor world, double x, double y, double z) {
        if (world instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)world;
            if (((Boolean)SConfig.SERVER.scent_spawn.get()).booleanValue()) {
                ScentEntity entityToSpawn = new ScentEntity((EntityType<? extends PathfinderMob>)((EntityType)Sentities.SCENT.get()), (Level)_level);
                entityToSpawn.m_7678_(x, y, z, world.m_213780_().m_188501_() * 360.0f, 0.0f);
                entityToSpawn.m_6518_((ServerLevelAccessor)_level, world.m_6436_(entityToSpawn.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                world.m_7967_((Entity)entityToSpawn);
            }
        }
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.3) {
            return new EntityDamageSource("griefer_damage", (Entity)entity);
        }
        return super.getCustomDamage(entity);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new GrieferSwellGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    public boolean m_7327_(Entity entity) {
        LivingEntity livingEntity;
        if (this.getTypeVariant() == 1 && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 600, 0));
        }
        if (this.getTypeVariant() == 3 && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                livingEntity.m_7292_(instance);
            }
        }
        return super.m_7327_(entity);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.griefer_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.griefer_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.griefer_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.INF_GROWL.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    private boolean checkForNucMod() {
        return ModList.get().isLoaded("alexscaves") || ModList.get().isLoaded("bigreactors");
    }

    private GrieferVariants getSpawnVariant() {
        GrieferVariants variants = (GrieferVariants)((Object)Util.m_214670_((Object[])GrieferVariants.values(), (RandomSource)this.f_19796_));
        if (variants == GrieferVariants.TOXIC || variants == GrieferVariants.RADIOACTIVE) {
            if (this.checkForNucMod()) {
                return GrieferVariants.RADIOACTIVE;
            }
            return GrieferVariants.TOXIC;
        }
        return variants;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        this.setVariant(this.getSpawnVariant());
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public GrieferVariants getVariant() {
        return GrieferVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        if (i > GrieferVariants.values().length || i < 0) {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)0);
        } else {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
        }
    }

    @Override
    public int amountOfMutations() {
        return GrieferVariants.values().length;
    }

    private void setVariant(GrieferVariants variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }
}

