/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class Inebriator
extends EvolvedInfected {
    private int attackAnimationTick;
    private LivingEntity patient;

    public Inebriator(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public void setPatient(LivingEntity patient) {
        this.patient = patient;
    }

    public LivingEntity getPatient() {
        return this.patient;
    }

    public List<MobEffectInstance> getEffects() {
        ArrayList<MobEffectInstance> values = new ArrayList<MobEffectInstance>();
        for (String s : (List)SConfig.SERVER.ineb_buffs.get()) {
            String[] val = s.split("\\|");
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(val[0]));
            if (effect == null) continue;
            values.add(new MobEffectInstance(effect, Integer.parseUnsignedInt(val[1]), Integer.parseUnsignedInt(val[2])));
        }
        return values;
    }

    public void checkForPatients() {
        Level level = this.f_19853_;
        if (!level.m_5776_()) {
            LivingEntity livingEntity;
            AABB aabb = this.m_20191_().m_82377_(4.0, 1.0, 4.0);
            List entities = level.m_6249_((Entity)this, aabb, entity -> {
                LivingEntity livingEntity;
                return entity instanceof LivingEntity && ((livingEntity = (LivingEntity)entity) instanceof Infected || livingEntity instanceof UtilityEntity);
            });
            if (entities.isEmpty()) {
                return;
            }
            Entity entity2 = (Entity)entities.get(this.f_19796_.m_188503_(entities.size()));
            if (entity2 instanceof LivingEntity && !((livingEntity = (LivingEntity)entity2) instanceof Inebriator) && this.m_142582_((Entity)livingEntity) && !this.m_20147_()) {
                this.setPatient(livingEntity);
            }
        }
    }

    public void InjectMedicine(List<MobEffectInstance> effects) {
        LivingEntity entity = this.getPatient();
        if (entity != null) {
            for (MobEffectInstance instance : effects) {
                entity.m_7292_(instance);
            }
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            this.m_216990_((SoundEvent)Ssounds.INEBRIATER_INJECT.get());
        }
    }

    public void m_7822_(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.m_7822_(value);
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.attackAnimationTick = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        return super.m_7327_(entity);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.f_19797_ % 40 == 0) {
            this.checkForPatients();
            LivingEntity livingEntity = this.getPatient();
            if (this.getPatient() != null && !this.getPatient().m_6084_()) {
                this.setPatient(null);
            }
            if (livingEntity != null) {
                if (!livingEntity.m_6084_()) {
                    this.setPatient(null);
                } else if (livingEntity.m_20270_((Entity)this) < 4.0f) {
                    this.InjectMedicine(this.getEffects());
                }
            }
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inebriater_loot.get();
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.ineb_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.ineb_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.ineb_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new FollowPatientGoal(this, 1.5, 4.0f, 2.0f));
        this.f_21345_.m_25352_(3, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 4.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }

            @Override
            public boolean m_8036_() {
                AABB aabb = this.mob.m_20191_().m_82377_(4.0, 1.0, 4.0);
                List allies = this.mob.f_19853_.m_6249_((Entity)this.mob, aabb, entity -> (entity instanceof Infected || entity instanceof UtilityEntity) && !(entity instanceof Inebriator));
                return allies.isEmpty() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.SCIENTIST_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public static class FollowPatientGoal
    extends Goal {
        private final Inebriator mob;
        private LivingEntity target;
        private final double speedModifier;
        private final float stopDistance;
        private final float startDistance;

        public FollowPatientGoal(Inebriator mob, double speedModifier, float startDistance, float stopDistance) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.mob.getPatient();
            return this.target != null && this.target.m_6084_() && this.mob.m_20270_((Entity)this.target) > this.startDistance;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && this.mob.m_20270_((Entity)this.target) > this.stopDistance;
        }

        public void m_8037_() {
            if (this.target != null) {
                this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
        }

        public void m_8041_() {
            this.target = null;
            this.mob.m_21573_().m_26573_();
        }
    }
}

