/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidType;

public class Jagdhund
extends EvolvedInfected {
    private static final EntityDataAccessor<Boolean> UNDERGROUND = SynchedEntityData.m_135353_(Jagdhund.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> BORROW = SynchedEntityData.m_135353_(Jagdhund.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EMERGE = SynchedEntityData.m_135353_(Jagdhund.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Jagdhund(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.jagd_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.jagd_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.jagd_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 46.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.jagd_loot.get();
    }

    public void setUnderground(boolean value) {
        this.f_19804_.m_135381_(UNDERGROUND, (Object)value);
    }

    public boolean isUnderground() {
        return (Boolean)this.f_19804_.m_135370_(UNDERGROUND);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("underground", ((Boolean)this.f_19804_.m_135370_(UNDERGROUND)).booleanValue());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(UNDERGROUND, (Object)tag.m_128471_("underground"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(UNDERGROUND, (Object)false);
        this.f_19804_.m_135372_(BORROW, (Object)0);
        this.f_19804_.m_135372_(EMERGE, (Object)0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f){

            public boolean m_8036_() {
                return super.m_8036_() && !Jagdhund.this.isUnderground();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.5, false){

            @Override
            protected void checkAndPerformAttack(LivingEntity entity, double at) {
                if (!Jagdhund.this.isUnderground() || Jagdhund.this.isEmerging()) {
                    super.checkAndPerformAttack(entity, at);
                }
            }

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 6.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (this.f_19797_ % 20 == 0 && (!this.isSoftEnough(this.m_20097_()) || this.isInFluidType()) && this.isUnderground() && !this.isEmerging()) {
            this.tickEmerging();
        }
        if (this.f_19797_ % 10 == 0 && target != null) {
            if (target.m_20280_((Entity)this) > 100.0 && !this.isUnderground() && !this.isBurrowing() && this.isSoftEnough(this.m_20097_())) {
                this.tickBurrowing();
            }
            if (target.m_20280_((Entity)this) < 50.0 && this.isUnderground() && !this.isEmerging()) {
                this.tickEmerging();
            }
        }
        if (this.isEmerging() || this.isBurrowing()) {
            this.SummonParticles(this.m_20097_());
        }
        if (this.f_21344_.m_26572_() && this.isUnderground()) {
            this.SummonParticles(this.m_20097_());
        }
        if (this.isEmerging()) {
            this.tickEmerging();
        } else if (this.isBurrowing()) {
            this.tickBurrowing();
        }
    }

    private void SummonParticles(BlockPos pos) {
        for (int l = 0; l < this.f_19796_.m_216339_(3, 6); ++l) {
            Level level = this.f_19853_;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            int xi = this.f_19796_.m_216339_(-1, 1);
            int zi = this.f_19796_.m_216339_(-1, 1);
            if (this.f_19853_.m_8055_(pos).m_60734_().m_5456_() == ItemStack.f_41583_.m_41720_()) continue;
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)this.f_19853_.m_8055_(pos).m_60734_())), this.m_20185_() + (double)xi, this.m_20186_() - 0.1, this.m_20189_() + (double)zi, 3, ((double)this.f_19796_.m_188501_() - 1.0) * 0.08, ((double)this.f_19796_.m_188501_() - 1.0) * 0.08, ((double)this.f_19796_.m_188501_() - 1.0) * 0.08, (double)0.15f);
        }
    }

    public boolean m_20145_() {
        return this.isUnderground() && !this.isEmerging();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return super.canDrownInFluidType(type) && !this.isUnderground();
    }

    private boolean isSoftEnough(BlockPos pos) {
        return this.f_19853_.m_8055_(pos).m_60800_((BlockGetter)this.f_19853_, pos) < 4.0f;
    }

    public boolean isEmerging() {
        return (Integer)this.f_19804_.m_135370_(EMERGE) > 0;
    }

    public void tickEmerging() {
        int emerging = (Integer)this.f_19804_.m_135370_(EMERGE);
        if (emerging > this.getEmerge_tick()) {
            this.setUnderground(false);
            emerging = -1;
        }
        this.f_19804_.m_135381_(EMERGE, (Object)(emerging + 1));
    }

    public boolean isBurrowing() {
        return (Integer)this.f_19804_.m_135370_(BORROW) > 0;
    }

    public void tickBurrowing() {
        int burrowing = (Integer)this.f_19804_.m_135370_(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            this.setUnderground(true);
            burrowing = -1;
        }
        this.f_19804_.m_135381_(BORROW, (Object)(burrowing + 1));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_19384_() || source.m_19372_()) {
            return super.m_6469_(source, amount);
        }
        if (this.isUnderground()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public double m_6049_() {
        return -1.0;
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (UNDERGROUND.equals(accessor)) {
            this.m_6210_();
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isUnderground()) {
            return new EntityDimensions(1.2f, 0.1f, false);
        }
        return super.m_6972_(pose);
    }

    public int getEmerge() {
        return (Integer)this.f_19804_.m_135370_(EMERGE);
    }

    public int getBorrow() {
        return (Integer)this.f_19804_.m_135370_(BORROW);
    }

    public int getBorrow_tick() {
        return 60;
    }

    public int getEmerge_tick() {
        return 60;
    }

    protected SoundEvent m_7515_() {
        return this.isUnderground() ? null : (SoundEvent)Ssounds.HUSK_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.isUnderground()) {
            this.m_5496_(state.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this).m_56775_(), 0.15f, 0.5f);
        } else {
            this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 1200, 0));
        }
        return super.m_7327_(entity);
    }
}

