/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.Projectile.ThrownBlockProjectile;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Ogre
extends Hyper
implements RangedAttackMob,
ArmorPersentageBypass {
    public static final EntityDataAccessor<Boolean> HAS_IMPALED_BODY = SynchedEntityData.m_135353_(Ogre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int attackAnimationTick;
    private int attacks;

    public Ogre(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public boolean canDoTailAttack() {
        return this.attacks > 2;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.ogre_loot.get();
    }

    public boolean hasImpaledBody() {
        return (Boolean)this.f_19804_.m_135370_(HAS_IMPALED_BODY);
    }

    public void setHasImpaledBody(boolean value) {
        this.f_19804_.m_135381_(HAS_IMPALED_BODY, (Object)value);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("impaled_body", this.hasImpaledBody());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setHasImpaledBody(tag.m_128471_("impaled_body"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_IMPALED_BODY, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.ogre_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.ogre_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.ogre_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22279_, 0.27).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(3, (Goal)new AOEMeleeAttackGoal((PathfinderMob)this, 1.2, true, 1.2, 7.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return Ogre.this.canDoTailAttack() ? super.getAttackReachSqr(entity) * 1.5 : super.getAttackReachSqr(entity);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        LivingEntity livingEntity;
        super.m_8119_();
        if (this.f_19797_ % 40 == 0 && this.m_5912_()) {
            this.performRangedThrow((LivingEntity)this);
        }
        if (this.f_19797_ % 200 == 0 && (livingEntity = this.m_5448_()) != null && this.m_142582_((Entity)livingEntity)) {
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            for (int i = 0; i < this.f_19796_.m_216339_(1, 4); ++i) {
                this.m_6504_(livingEntity, 0.0f);
            }
        }
    }

    public void m_7822_(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.m_7822_(value);
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        LivingEntity living;
        if (this.canDoTailAttack() && !this.m_20160_() && entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            this.attackAnimationTick = 10;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            living.m_147240_(10.0, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            this.attacks = 0;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 120));
        } else {
            ++this.attacks;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (Math.random() < 0.2) {
                player.m_20329_((Entity)this);
            }
        }
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            living.m_147207_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600, 0), (Entity)this);
        }
        return super.m_7327_(entity);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    @Override
    public void m_5993_(Entity entity, int i, DamageSource damageSource) {
        if (this.canDoTailAttack() && !this.hasImpaledBody()) {
            this.setHasImpaledBody(true);
        }
        super.m_5993_(entity, i, damageSource);
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        this.attackAnimationTick = 10;
        BlockState state = this.getBlock();
        if (!this.f_19853_.f_46443_ && state != null) {
            ThrownBlockProjectile thrownBlockProjectile = new ThrownBlockProjectile(this.f_19853_, (LivingEntity)this, Float.valueOf(10.0f), state, this.TARGET_SELECTOR);
            double dx = livingEntity.m_20185_() - this.m_20185_();
            double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_() - 1.0;
            double dz = livingEntity.m_20189_() - this.m_20189_();
            thrownBlockProjectile.m_6027_(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_());
            thrownBlockProjectile.m_6686_(dx, dy - thrownBlockProjectile.m_20186_() + Math.hypot(dx, dz) * (double)0.05f, dz, 1.0f, 6.0f);
            this.f_19853_.m_7967_((Entity)thrownBlockProjectile);
        }
    }

    public BlockState getBlock() {
        AABB aabb = this.m_20191_().m_82400_(0.2);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.f_19853_.m_8055_(blockpos);
            if (!(blockstate.m_60800_((BlockGetter)this.f_19853_, blockpos) < 5.0f) || !(blockstate.m_60800_((BlockGetter)this.f_19853_, blockpos) >= 0.0f) || blockstate.m_60795_()) continue;
            this.f_19853_.m_46961_(blockpos, false);
            return blockstate;
        }
        return null;
    }

    public void performRangedThrow(LivingEntity entity) {
        LivingEntity livingEntity = this.m_5448_();
        if (livingEntity != null) {
            this.attackAnimationTick = 10;
            Vec3 vec3 = entity.m_20184_();
            double d0 = entity.m_20185_() + vec3.f_82479_ - livingEntity.m_20185_();
            double d1 = entity.m_20188_() - (double)1.1f - this.m_20186_();
            double d2 = entity.m_20189_() + vec3.f_82481_ - livingEntity.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            AABB boundingBox = entity.m_20191_().m_82400_(1.2);
            List entities = entity.f_19853_.m_45933_((Entity)entity, boundingBox);
            for (Entity en : entities) {
                if (!(en instanceof Mob) || !((List)SConfig.SERVER.can_be_carried.get()).contains(en.m_20078_())) continue;
                en.m_20334_(d0 * -0.2, (d1 + d3) * 0.02, d2 * -0.2);
                ((Mob)en).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0));
            }
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    @Override
    public float amountOfDamage(float value) {
        return this.canDoTailAttack() ? value * 0.5f : 0.0f;
    }

    public void m_7332_(Entity entity) {
        super.m_7332_(entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Vec3 vec3 = new Vec3(1.1, 1.4, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            player.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
        }
    }

    public boolean m_20160_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_20124_(Pose.SWIMMING);
        }
        return super.m_20160_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.OGRE_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.INF_VILLAGER_DAMAGE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }
}

