/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.Utility.Illusion;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class Delusionare
extends Organoid {
    private static final EntityDataAccessor<Integer> SPELL_TIME = SynchedEntityData.m_135353_(Delusionare.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPELL_ID = SynchedEntityData.m_135353_(Delusionare.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Delusionare(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public int getEmerge_tick() {
        return 100;
    }

    @Override
    public int getBorrow_tick() {
        return 100;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.delusioner_loot.get();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("spell_timer", ((Integer)this.f_19804_.m_135370_(SPELL_TIME)).intValue());
        tag.m_128405_("spell_id", ((Integer)this.f_19804_.m_135370_(SPELL_ID)).intValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(SPELL_TIME, (Object)tag.m_128451_("spell_timer"));
        this.f_19804_.m_135381_(SPELL_ID, (Object)tag.m_128451_("spell_id"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_TIME, (Object)0);
        this.f_19804_.m_135372_(SPELL_ID, (Object)0);
    }

    public int getSpellById() {
        return (Integer)this.f_19804_.m_135370_(SPELL_ID);
    }

    public boolean isCasting() {
        return (Integer)this.f_19804_.m_135370_(SPELL_TIME) > 0;
    }

    public void setSpellTime(int value) {
        this.f_19804_.m_135381_(SPELL_TIME, (Object)value);
    }

    public void setSpellId(int value) {
        this.f_19804_.m_135381_(SPELL_ID, (Object)value);
    }

    protected void tickSpell() {
        this.f_19804_.m_135381_(SPELL_TIME, (Object)((Integer)this.f_19804_.m_135370_(SPELL_TIME) + 1));
        if ((Integer)this.f_19804_.m_135370_(SPELL_TIME) == 40) {
            this.m_216990_((SoundEvent)Ssounds.DELUSIONER_CASTING.get());
        }
        if ((Integer)this.f_19804_.m_135370_(SPELL_TIME) > 80) {
            this.castSpell(this.getSpellById());
            this.f_19804_.m_135381_(SPELL_TIME, (Object)0);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if ((Integer)this.f_19804_.m_135370_(SPELL_TIME) > 0) {
            this.tickSpell();
        }
        if (this.f_19797_ % 1200 == 0 && this.m_5448_() == null) {
            this.tickBurrowing();
        }
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.f_19804_.m_135370_(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            this.m_146870_();
            burrowing = -1;
        }
        this.f_19804_.m_135381_(BORROW, (Object)(burrowing + 1));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.delusioner_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.delusioner_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.addTargettingGoals();
        this.f_21345_.m_25352_(4, (Goal)new CastMagicGoal(this));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.DELUSIONER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    public void castSpell(int value) {
        int i;
        LivingEntity entity = this.m_5448_();
        if (entity == null) {
            return;
        }
        if (value == Spells.SUMMON_ILLUSION.getId()) {
            for (i = 0; i < this.f_19796_.m_216339_(2, 5); ++i) {
                Illusion illusion = new Illusion((EntityType<? extends PathfinderMob>)((EntityType)Sentities.ILLUSION.get()), this.f_19853_);
                illusion.setSeeAble(true);
                illusion.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    illusion.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
                }
                illusion.m_6710_(entity);
                this.f_19853_.m_7967_((Entity)illusion);
            }
        }
        if (value == Spells.CAST_ARROWS.getId()) {
            for (i = 0; i < this.f_19796_.m_216339_(3, 7); ++i) {
                int randomX = this.f_19796_.m_216339_(-4, 4);
                int randomZ = this.f_19796_.m_216339_(-4, 4);
                Arrow arrow = new Arrow(EntityType.f_20548_, this.f_19853_);
                arrow.m_6027_(entity.m_20185_() + (double)randomX, entity.m_20186_() + 3.0, entity.m_20189_() + (double)randomZ);
                arrow.m_5602_((Entity)this);
                if (Math.random() < 0.3) {
                    arrow.m_20254_(4);
                }
                double d0 = entity.m_20185_() - arrow.m_20185_();
                double d1 = entity.m_20227_(0.3333333333333333) - arrow.m_20186_();
                double d2 = entity.m_20189_() - arrow.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                arrow.m_36870_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600));
                arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
                this.f_19853_.m_7967_((Entity)arrow);
            }
        }
        if (value == Spells.CAST_INVISIBILITY.getId()) {
            AABB aabb = this.m_20191_().m_82400_(32.0);
            List entities = this.f_19853_.m_45933_((Entity)this, aabb);
            for (Entity entity1 : entities) {
                if (!(entity1 instanceof Infected)) continue;
                Infected infected = (Infected)entity1;
                infected.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 600));
            }
        }
        if (value == Spells.CAST_TELEPORTATION.getId()) {
            AABB aabb = this.m_20191_().m_82400_(32.0);
            List entities = this.f_19853_.m_45933_((Entity)this, aabb);
            for (Entity entity1 : entities) {
                double randomX = entity.m_20185_() + (double)this.f_19796_.m_216339_(-4, 4);
                double randomZ = entity.m_20189_() + (double)this.f_19796_.m_216339_(-4, 4);
                if (!(entity1 instanceof Infected)) continue;
                Infected infected = (Infected)entity1;
                infected.m_20984_(randomX, entity.m_20186_(), randomZ, true);
                infected.m_216990_(SoundEvents.f_11852_);
            }
        }
        this.awardHivemind();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_ && this.isCasting()) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float p_21017_) {
        if (this.isEmerging()) {
            return false;
        }
        return super.m_6469_(source, p_21017_);
    }

    public static class CastMagicGoal
    extends Goal {
        Delusionare delusionare;

        public CastMagicGoal(Delusionare delusionare) {
            this.delusionare = delusionare;
        }

        public boolean m_8036_() {
            if (this.delusionare.isCasting()) {
                return false;
            }
            return this.delusionare.m_5448_() != null;
        }

        private boolean hasAlliesAround() {
            AABB aabb = this.delusionare.m_20191_().m_82400_(8.0);
            List possible_allies = this.delusionare.f_19853_.m_45933_((Entity)this.delusionare, aabb);
            ArrayList<Infected> allies = new ArrayList<Infected>();
            for (Entity entity : possible_allies) {
                if (!(entity instanceof Infected)) continue;
                Infected infected = (Infected)entity;
                allies.add(infected);
            }
            return allies.size() > 2;
        }

        private boolean isFar() {
            LivingEntity entity = this.delusionare.m_5448_();
            if (entity == null) {
                return false;
            }
            return this.delusionare.m_20280_((Entity)entity) > 140.0;
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.hasAlliesAround() && this.isFar()) {
                this.delusionare.setSpellId(3);
            }
            if (this.hasAlliesAround() && !this.isFar()) {
                this.delusionare.setSpellId(2);
            }
            if (!this.hasAlliesAround() && this.isFar()) {
                this.delusionare.setSpellId(1);
            }
            if (!this.hasAlliesAround() && !this.isFar()) {
                this.delusionare.setSpellId(0);
            }
            this.delusionare.setSpellTime(1);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static enum Spells {
        SUMMON_ILLUSION(0),
        CAST_ARROWS(1),
        CAST_INVISIBILITY(2),
        CAST_TELEPORTATION(3);

        private final int id;

        private Spells(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

