/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.Utility.NukeEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FleshBomb
extends AbstractArrow {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(FleshBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> BOMB_TYPE = SynchedEntityData.m_135353_(FleshBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EXPLOSION = SynchedEntityData.m_135353_(FleshBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CARRIER = SynchedEntityData.m_135353_(FleshBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Predicate<LivingEntity> livingEntityPredicate = entity -> true;
    @Nullable
    private Entity target;

    public FleshBomb(Level level, LivingEntity entity2, float damage, BombType type, int range) {
        super((EntityType)Sentities.FLESH_BOMB.get(), level);
        this.setBombType(type.getValue());
        this.setExplosion(range);
        this.setDamage(damage);
        this.m_5602_((Entity)entity2);
    }

    public void setTarget(@Nullable Entity entity) {
        this.target = entity;
    }

    public FleshBomb(EntityType<FleshBomb> fleshBombEntityType, Level level) {
        super(fleshBombEntityType, level);
    }

    public FleshBomb(PlayMessages.SpawnEntity spawnEntity, Level level) {
        super((EntityType)Sentities.FLESH_BOMB.get(), level);
    }

    public void setLivingEntityPredicate(Predicate<LivingEntity> value) {
        this.livingEntityPredicate = value;
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(2.0f));
        this.f_19804_.m_135372_(BOMB_TYPE, (Object)0);
        this.f_19804_.m_135372_(EXPLOSION, (Object)5);
        this.f_19804_.m_135372_(CARRIER, (Object)false);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setDamage(tag.m_128457_("damage"));
        this.setBombType(tag.m_128451_("bomb_type"));
        this.setExplosion(tag.m_128451_("explosion"));
        this.setCarrier(tag.m_128471_("carrier"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("damage", this.getDamage());
        tag.m_128405_("bomb_type", this.getBombType());
        tag.m_128405_("explosion", this.getExplosion());
        tag.m_128379_("carrier", this.getCarrier());
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float value) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(value));
    }

    public int getBombType() {
        return (Integer)this.f_19804_.m_135370_(BOMB_TYPE);
    }

    public void setBombType(int value) {
        this.f_19804_.m_135381_(BOMB_TYPE, (Object)value);
    }

    public int getExplosion() {
        return (Integer)this.f_19804_.m_135370_(EXPLOSION);
    }

    public void setExplosion(int value) {
        this.f_19804_.m_135381_(EXPLOSION, (Object)value);
    }

    public boolean getCarrier() {
        return (Boolean)this.f_19804_.m_135370_(CARRIER);
    }

    public void setCarrier(boolean value) {
        this.f_19804_.m_135381_(CARRIER, (Object)value);
    }

    protected boolean m_5603_(Entity entity) {
        LivingEntity living;
        return entity instanceof LivingEntity && this.livingEntityPredicate.test(living = (LivingEntity)entity);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity2 = result.m_82443_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Utilities.explodeCircle(serverLevel, this.m_37282_(), result.m_82443_().m_20097_(), this.getExplosion(), this.getDamage(), ((Integer)SConfig.SERVER.calamity_bd.get()).intValue(), entity -> {
                    LivingEntity livingEntity;
                    return entity instanceof LivingEntity && this.livingEntityPredicate.test(livingEntity = (LivingEntity)entity);
                });
                if (this.getBombType() == 1) {
                    living.m_20254_(20);
                    Utilities.convertBlocks(serverLevel, this.m_37282_(), result.m_82443_().m_20097_(), this.getExplosion(), Blocks.f_50083_.m_49966_());
                }
                if (this.getBombType() == 2) {
                    Utilities.convertBlocks(serverLevel, this.m_37282_(), result.m_82443_().m_20097_(), this.getExplosion(), ((LiquidBlock)Sblocks.BILE.get()).m_49966_());
                }
                if (this.getBombType() == 4) {
                    NukeEntity nukeEntity = new NukeEntity((EntityType)Sentities.NUKE.get(), this.f_19853_);
                    nukeEntity.setInitRange(1.0f);
                    nukeEntity.setRange((float)((Double)SConfig.SERVER.nuke_range.get() * 1.0));
                    nukeEntity.setInitDuration(0);
                    nukeEntity.setDuration((Integer)SConfig.SERVER.nuke_time.get());
                    nukeEntity.setDamage((float)((Double)SConfig.SERVER.nuke_damage.get() * 1.0));
                    nukeEntity.livingEntityPredicate = this.livingEntityPredicate;
                    nukeEntity.m_6034_(living.m_20185_(), living.m_20186_(), living.m_20189_());
                    this.f_19853_.m_7967_((Entity)nukeEntity);
                }
            }
        }
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 70 == 0) {
            this.m_216990_((SoundEvent)Ssounds.FALLING_BOMB.get());
        }
        if (this.getBombType() == 1) {
            for (int i = 0; i < 360; ++i) {
                if (i % 40 != 0) continue;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), Math.cos(i) * 0.25, 0.25, Math.sin(i) * 0.25);
            }
        }
        this.aimForTarget();
    }

    private float calculate(Entity entity, Entity entity1) {
        float f = (float)(entity.m_20185_() - entity1.m_20185_());
        float f2 = (float)(entity.m_20189_() - entity1.m_20189_());
        return Mth.m_14116_((float)(f * f + f2 * f2));
    }

    private void aimForTarget() {
        if (this.target != null && this.m_20184_().f_82480_ < 0.0) {
            Vec3 vec3 = this.m_20184_();
            Vec3 vec31 = new Vec3(this.target.m_20185_() - this.m_20185_(), 0.0, this.target.m_20189_() - this.m_20189_());
            if (vec31.m_82556_() > 1.0E-7) {
                vec31 = vec31.m_82541_().m_82490_(0.05);
            }
            if (this.target != null && this.calculate((Entity)this, this.target) < 3.5f) {
                this.m_20256_(new Vec3(vec31.f_82479_, vec3.f_82480_, vec31.f_82481_));
            } else {
                this.m_20256_(vec3.m_82520_(vec31.f_82479_, 0.0, vec31.f_82481_));
            }
        }
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11913_;
    }

    protected void m_8060_(BlockHitResult result) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Utilities.explodeCircle(serverLevel, this.m_37282_(), result.m_82425_(), this.getExplosion(), this.getDamage(), 8.0, entity -> {
                LivingEntity livingEntity;
                return entity instanceof LivingEntity && this.livingEntityPredicate.test(livingEntity = (LivingEntity)entity);
            });
            if (this.getBombType() == 1) {
                Utilities.convertBlocks(serverLevel, this.m_37282_(), result.m_82425_(), this.getExplosion(), Blocks.f_50083_.m_49966_());
            }
            if (this.getBombType() == 2) {
                Utilities.convertBlocks(serverLevel, this.m_37282_(), result.m_82425_(), this.getExplosion(), ((LiquidBlock)Sblocks.BILE.get()).m_49966_());
            }
            if (this.getBombType() == 3) {
                this.summonAcid(this.m_20185_(), this.m_20186_() - (double)(this.getExplosion() - 2), this.m_20189_(), this.getExplosion());
            }
            if (this.getBombType() == 4) {
                NukeEntity nukeEntity = new NukeEntity((EntityType)Sentities.NUKE.get(), this.f_19853_);
                nukeEntity.setInitRange(1.0f);
                nukeEntity.setRange((float)((Double)SConfig.SERVER.nuke_range.get() * 1.0));
                nukeEntity.setInitDuration(0);
                nukeEntity.setDuration((Integer)SConfig.SERVER.nuke_time.get());
                nukeEntity.setDamage((float)((Double)SConfig.SERVER.nuke_damage.get() * 1.0));
                nukeEntity.livingEntityPredicate = this.livingEntityPredicate;
                nukeEntity.m_6034_(result.m_82425_().m_123341_(), result.m_82425_().m_123342_() - this.getExplosion() + 1, result.m_82425_().m_123343_());
                this.f_19853_.m_7967_((Entity)nukeEntity);
            }
            if (this.getCarrier()) {
                this.SummonInfected(serverLevel);
            }
            this.m_216990_(SoundEvents.f_11913_);
        }
        this.m_146870_();
    }

    private void summonAcid(double x, double y, double z, int range) {
        AreaEffectCloud cloud = new AreaEffectCloud(this.f_19853_, x, y, z);
        cloud.m_19716_(new MobEffectInstance((MobEffect)Seffects.CORROSION.get(), 300, 1));
        cloud.m_19712_((float)range);
        this.f_19853_.m_7967_((Entity)cloud);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (accessor.equals(CARRIER)) {
            this.m_6210_();
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.getCarrier() ? super.m_6972_(pose).m_20388_(2.0f) : super.m_6972_(pose);
    }

    private void SummonInfected(ServerLevel serverLevel) {
        int randomIndex;
        List values = (List)SConfig.SERVER.howit_summmons.get();
        ResourceLocation randomElement1 = new ResourceLocation((String)values.get(randomIndex = this.f_19796_.m_188503_(values.size())));
        EntityType randomElement = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(randomElement1);
        Mob waveentity = (Mob)randomElement.m_20615_(this.f_19853_);
        if (waveentity != null) {
            waveentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            waveentity.m_6518_((ServerLevelAccessor)serverLevel, this.f_19853_.m_6436_(new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_())), MobSpawnType.NATURAL, null, null);
            serverLevel.m_7967_((Entity)waveentity);
        }
    }

    public static enum BombType {
        BASIC(0),
        FLAME(1),
        BILE(2),
        ACID(3),
        NUCLEAR(4);

        private final int value;

        private BombType(int value1) {
            this.value = value1;
        }

        public int getValue() {
            return this.value;
        }
    }
}

