/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Senchantments;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Organoids.Usurper;
import com.Harbinger.Spore.Sentities.Organoids.Verwa;
import com.Harbinger.Spore.Sentities.Projectile.FleshBomb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;

public class ArenaEntity
extends UtilityEntity {
    public static final EntityDataAccessor<Integer> BORROW = SynchedEntityData.m_135353_(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EMERGE = SynchedEntityData.m_135353_(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> WAVE_SIZE = SynchedEntityData.m_135353_(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> WAVE_LEVEL = SynchedEntityData.m_135353_(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SPECIAL_SPAWNS = SynchedEntityData.m_135353_(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> START = SynchedEntityData.m_135353_(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private List<Entity> waveHosts = new ArrayList<Entity>();
    public List<FleshBomb.BombType> bombTypes = new ArrayList<FleshBomb.BombType>(){
        {
            this.add(FleshBomb.BombType.BASIC);
            this.add(FleshBomb.BombType.FLAME);
            this.add(FleshBomb.BombType.BILE);
            this.add(FleshBomb.BombType.ACID);
        }
    };
    public List<Enchantment> enchantmentList = new ArrayList<Enchantment>(){
        {
            this.add((Enchantment)Senchantments.CRYOGENIC_ASPECT.get());
            this.add((Enchantment)Senchantments.SYMBIOTIC_RECONSTITUTION.get());
            this.add((Enchantment)Senchantments.CORROSIVE_POTENCY.get());
            this.add((Enchantment)Senchantments.GASTRIC_SPEWAGE.get());
        }
    };

    public ArenaEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BORROW, (Object)0);
        this.f_19804_.m_135372_(EMERGE, (Object)0);
        this.f_19804_.m_135372_(WAVE_SIZE, (Object)0);
        this.f_19804_.m_135372_(WAVE_LEVEL, (Object)0);
        this.f_19804_.m_135372_(SPECIAL_SPAWNS, (Object)0);
        this.f_19804_.m_135372_(START, (Object)false);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setWaveSize(compoundTag.m_128451_("size"));
        this.setWaveLevel(compoundTag.m_128451_("level"));
        this.setAmountOfSpecialSpawns(compoundTag.m_128451_("special"));
        this.startWave(compoundTag.m_128471_("start"));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("size", this.getWaveSize());
        compoundTag.m_128405_("level", this.getWaveLevel());
        compoundTag.m_128405_("special", this.getSpecialSpawns());
        compoundTag.m_128379_("start", this.isWaveActive());
    }

    public void setWaveSize(int size) {
        this.f_19804_.m_135381_(WAVE_SIZE, (Object)size);
    }

    public void setWaveLevel(int level) {
        this.f_19804_.m_135381_(WAVE_LEVEL, (Object)level);
    }

    public void setAmountOfSpecialSpawns(int amount) {
        this.f_19804_.m_135381_(SPECIAL_SPAWNS, (Object)amount);
    }

    public int getWaveSize() {
        return (Integer)this.f_19804_.m_135370_(WAVE_SIZE);
    }

    public int getWaveLevel() {
        return (Integer)this.f_19804_.m_135370_(WAVE_LEVEL);
    }

    public int getSpecialSpawns() {
        return (Integer)this.f_19804_.m_135370_(SPECIAL_SPAWNS);
    }

    public void startWave(boolean value) {
        this.f_19804_.m_135381_(START, (Object)value);
    }

    public boolean isWaveActive() {
        return (Boolean)this.f_19804_.m_135370_(START);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22277_, 8.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean isEmerging() {
        return (Integer)this.f_19804_.m_135370_(EMERGE) > 0;
    }

    public void tickEmerging() {
        int emerging = (Integer)this.f_19804_.m_135370_(EMERGE);
        if (emerging > 60) {
            this.recalculateHosts();
            emerging = -1;
        }
        this.f_19804_.m_135381_(EMERGE, (Object)(emerging + 1));
    }

    public boolean isBurrowing() {
        return (Integer)this.f_19804_.m_135370_(BORROW) > 0;
    }

    public void tickBurrowing() {
        int burrowing = (Integer)this.f_19804_.m_135370_(BORROW);
        if (burrowing > 60) {
            burrowing = -1;
            if (this.isWaveActive()) {
                this.dropLoot();
            }
            this.m_146870_();
        }
        this.f_19804_.m_135381_(BORROW, (Object)(burrowing + 1));
    }

    public int getEmerge() {
        return (Integer)this.f_19804_.m_135370_(EMERGE);
    }

    public int getBorrow() {
        return (Integer)this.f_19804_.m_135370_(BORROW);
    }

    public boolean m_6469_(DamageSource source, float p_21017_) {
        if (source == DamageSource.f_19317_) {
            return super.m_6469_(source, p_21017_);
        }
        return false;
    }

    public void recalculateHosts() {
        this.waveHosts.clear();
        this.waveHosts = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82400_(16.0), entity -> (entity instanceof Infected || entity instanceof UtilityEntity) && !(entity instanceof ArenaEntity));
        if (!this.waveHosts.isEmpty()) {
            if (!this.isWaveActive()) {
                this.compareEntity(this.waveHosts);
            }
            for (Entity entity2 : this.waveHosts) {
                if (!(entity2.m_20186_() > this.m_20186_() + 3.0) || !(Math.random() < (double)0.1f)) continue;
                this.summonUsurper();
            }
        }
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    public void compareEntity(List<Entity> entities) {
        for (Entity entity : entities) {
            int i;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            for (i = 0; i < living.m_21230_(); ++i) {
                if (i % 5 == 0) {
                    this.setWaveSize(this.getWaveSize() + 1);
                }
                if (i % 7 != 0) continue;
                this.setWaveLevel(this.getWaveLevel() + 1);
            }
            i = 0;
            while ((float)i < living.m_21233_()) {
                if (i % 4 == 0) {
                    this.setWaveSize(this.getWaveSize() + 1);
                }
                if (i % 50 == 0) {
                    this.setWaveLevel(this.getWaveLevel() + 1);
                }
                ++i;
            }
            if (living.m_21023_((MobEffect)Seffects.SYMBIOSIS.get())) {
                this.setAmountOfSpecialSpawns(this.getSpecialSpawns() + 1);
            }
            if (living instanceof InventoryCarrier) {
                ItemStack stack;
                int e;
                InventoryCarrier carrier = (InventoryCarrier)living;
                int l = 0;
                int f = 0;
                for (e = 0; e < carrier.m_35311_().m_6643_(); ++e) {
                    stack = carrier.m_35311_().m_8020_(e);
                    if (stack.m_41720_().m_41472_()) {
                        l += stack.m_41613_();
                    }
                    if (l % 32 != 0) continue;
                    this.setAmountOfSpecialSpawns(this.getSpecialSpawns() + 1);
                }
                for (e = 0; e < carrier.m_35311_().m_6643_(); ++e) {
                    stack = carrier.m_35311_().m_8020_(e);
                    for (Enchantment enchantment : this.enchantmentList) {
                        if (stack.getEnchantmentLevel(enchantment) <= 0) continue;
                        f += stack.m_41613_();
                    }
                    if (f % 3 != 0) continue;
                    this.setAmountOfSpecialSpawns(this.getSpecialSpawns() + 1);
                }
            }
            this.startWave(true);
        }
    }

    public void summonVerva(boolean special, List<? extends String> mob) {
        int X = this.f_19796_.m_216339_(-16, 16);
        int Z = this.f_19796_.m_216339_(-16, 16);
        String creature = mob.get(this.f_19796_.m_188503_(mob.size()));
        Verwa verva = new Verwa((EntityType<? extends PathfinderMob>)((EntityType)Sentities.VERVA.get()), this.f_19853_);
        verva.m_20984_(this.m_20185_() + (double)X, this.m_20186_(), this.m_20189_() + (double)Z, false);
        verva.setStoredMob(creature);
        verva.tickEmerging();
        this.f_19853_.m_7967_((Entity)verva);
        if (special) {
            this.setAmountOfSpecialSpawns(this.getSpecialSpawns() - 1);
        } else {
            this.setWaveSize(this.getWaveSize() - 1);
        }
        if (this.getWaveLevel() >= 2 && Math.random() < (double)((float)(this.getWaveLevel() - 1) * 0.05f)) {
            this.summonBomb();
        }
    }

    public void summonUsurper() {
        int X = this.f_19796_.m_216339_(-16, 16);
        int Z = this.f_19796_.m_216339_(-16, 16);
        Usurper verva = new Usurper((EntityType<? extends PathfinderMob>)((EntityType)Sentities.USURPER.get()), this.f_19853_);
        verva.m_20984_(this.m_20185_() + (double)X, this.m_20186_(), this.m_20189_() + (double)Z, false);
        verva.tickEmerging();
        this.f_19853_.m_7967_((Entity)verva);
    }

    public void summonBomb() {
        int X = this.f_19796_.m_216339_(-32, 32);
        int Z = this.f_19796_.m_216339_(-32, 32);
        FleshBomb.BombType type = this.bombTypes.get(this.f_19796_.m_188503_(this.bombTypes.size()));
        FleshBomb verva = new FleshBomb(this.f_19853_, (LivingEntity)this, 10.0f, type, this.f_19796_.m_216339_(2, 5));
        verva.setLivingEntityPredicate(Utilities.TARGET_SELECTOR_PREDICATE);
        verva.m_6027_(this.m_20185_() + (double)X, this.m_20186_() + 100.0, this.m_20189_() + (double)Z);
        this.f_19853_.m_7967_((Entity)verva);
    }

    public Map<Integer, List<? extends String>> getWaveSpawns() {
        HashMap<Integer, List<? extends String>> values = new HashMap<Integer, List<? extends String>>();
        values.put(0, (List)SConfig.DATAGEN.raid_level_1.get());
        values.put(1, (List)SConfig.DATAGEN.raid_level_2.get());
        values.put(2, (List)SConfig.DATAGEN.raid_level_3.get());
        return values;
    }

    public void calculateSummons() {
        int e = this.getWaveSize() > 3 ? this.f_19796_.m_188503_(4) : this.getWaveSize();
        int wave = Math.min(this.getWaveLevel(), 2);
        if (this.getWaveSize() <= 0 && this.checkForInfected() && this.isWaveActive()) {
            this.tickBurrowing();
            return;
        }
        for (int i = 0; i < e; ++i) {
            boolean special = this.getSpecialSpawns() > 0 && Math.random() < (double)0.1f;
            this.summonVerva(special, special ? (List<? extends String>)SConfig.DATAGEN.special.get() : this.getWaveSpawns().get(wave));
        }
        this.m_216990_(SoundEvents.f_11700_);
    }

    public boolean checkForInfected() {
        AABB aabb = this.m_20191_().m_82400_(8.0);
        List list = this.f_19853_.m_6249_((Entity)this, aabb, entity -> (entity instanceof Infected || entity instanceof UtilityEntity) && !(entity instanceof ArenaEntity));
        return list.size() < 4;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isBurrowing()) {
            this.tickBurrowing();
        }
        if (this.isEmerging()) {
            this.tickEmerging();
        }
        if (this.f_19797_ % 300 == 0) {
            this.calculateSummons();
        }
        if (this.f_19797_ % 40 == 0) {
            this.recalculateHosts();
        }
    }

    public void dropLoot() {
        for (String string : (List)SConfig.DATAGEN.drops.get()) {
            int i;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string));
            if (item == null) continue;
            int n = i = this.getWaveLevel() > 0 ? this.f_19796_.m_216339_(this.getWaveLevel(), 3 * this.getWaveLevel()) : 1;
            if (!(Math.random() < (double)(0.2f * (float)Math.min(1, this.getWaveLevel())))) continue;
            ItemStack itemStack = new ItemStack((ItemLike)item, i);
            ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack);
            this.f_19853_.m_7967_((Entity)itemEntity);
        }
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_20147_() {
        return true;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() == Sitems.VIGIL_EYE.get()) {
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }
}

