/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Senchantments;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsBaseItem;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class InfectedShield
extends SporeToolsBaseItem {
    public static final String CHARGE_TAG = "ShieldCharge";
    public static final int MAX_CHARGE = 25;

    public InfectedShield() {
        super(((Integer)SConfig.SERVER.shield_damage.get()).intValue(), 0.0, 1.0, (Integer)SConfig.SERVER.shield_durability.get(), 0);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    public UseAnim m_6164_(ItemStack p_43105_) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack p_43107_) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_43099_, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.tooHurt(itemstack)) {
            player.m_6672_(hand);
        }
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.hurtTool(stack, attacker, 1);
        return true;
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.OFFHAND;
    }

    public void setCharge(ItemStack stack, int value) {
        stack.m_41784_().m_128405_(CHARGE_TAG, value);
    }

    public int getCharge(ItemStack stack) {
        return stack.m_41784_().m_128451_(CHARGE_TAG);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int durabilityLeft;
        int current = this.getCharge(stack);
        this.setCharge(stack, ++current);
        if (current >= 25) {
            this.triggerBash(entity, stack);
        }
        if ((durabilityLeft = stack.m_41776_() - stack.m_41773_()) - amount <= 11) {
            entity.m_216990_((SoundEvent)Ssounds.INFECTED_GEAR_BREAK.get());
        }
        if (this.tooHurt(stack)) {
            if (this.getAdditionalDurability(stack) > 0) {
                this.hurtExtraDurability(stack, amount, entity);
                return 0;
            }
            return super.damageItem(stack, this.calculateDurabilityLostForMutations(amount, stack), entity, onBroken);
        }
        return 0;
    }

    public void triggerBash(LivingEntity player, ItemStack stack) {
        if (!player.f_19853_.f_46443_) {
            double radius = 5.0;
            Vec3 look = player.m_20154_();
            AABB area = player.m_20191_().m_82369_(look.m_82490_(radius)).m_82400_(2.0);
            List entities = player.f_19853_.m_6443_(LivingEntity.class, area, e -> e != player && e.m_6084_() && player.m_142582_((Entity)e));
            for (LivingEntity target : entities) {
                ((ServerLevel)target.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)Sparticles.SPORE_IMPACT.get()), target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                Vec3 direction = target.m_20182_().m_82546_(player.m_20182_()).m_82541_();
                target.f_19864_ = true;
                target.m_147240_(this.getVariant(stack) == SporeToolsMutations.CALCIFIED ? 2.5 : 1.5, -direction.f_82479_, -direction.f_82481_);
                target.m_6469_(DamageSource.f_19318_, (float)((Integer)SConfig.SERVER.shield_damage.get()).intValue());
                this.abstractEffects(stack, target);
                if (this.getVariant(stack) == SporeToolsMutations.TOXIC) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
                }
                if (this.getVariant(stack) != SporeToolsMutations.ROTTEN) continue;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
            }
            if (this.getVariant(stack) == SporeToolsMutations.VAMPIRIC) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 0));
            }
            if (this.getVariant(stack) == SporeToolsMutations.BEZERK) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 1));
            }
            this.setCharge(stack, 0);
            player.f_19853_.m_5594_(null, player.m_20183_(), (SoundEvent)Ssounds.SHIELD_BASH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.hurtTool(stack, player, 1);
        }
    }

    public void abstractEffects(ItemStack stack, LivingEntity arrow) {
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.CORROSIVE_POTENCY.get()) > 0) {
            arrow.m_7292_(new MobEffectInstance((MobEffect)Seffects.CORROSION.get(), 200, 1));
        }
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.GASTRIC_SPEWAGE.get()) > 0) {
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                arrow.m_7292_(instance);
            }
        }
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.CRYOGENIC_ASPECT.get()) > 0 && arrow.m_142079_()) {
            arrow.m_146917_(arrow.m_146888_() + 300);
        }
        arrow.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        super.m_7373_(stack, p_41422_, components, p_41424_);
        components.add((Component)Component.m_237113_((String)("Charge " + this.getCharge(stack) + "/25")));
    }
}

