/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.Projectile.ThrownSickle;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeSwordBase;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class InfectedSickle
extends SporeSwordBase {
    private static final String SICKLE_THROWN = "sickle_thrown";
    private static final String THROWN = "thrown";

    public InfectedSickle() {
        super(((Integer)SConfig.SERVER.sickle_damage.get()).intValue(), 2.0, 2.0, (Integer)SConfig.SERVER.sickle_durability.get());
    }

    @Override
    public float m_8102_(ItemStack stack, BlockState state) {
        return state.m_204336_(BlockTags.f_144281_) ? 2.0f : 1.0f;
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity living, LivingEntity entity) {
        if (this.getThrownSickle(stack)) {
            return false;
        }
        return super.m_7579_(stack, living, entity);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return this.getThrownSickle(stack) ? ImmutableMultimap.of() : super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean reversedKnockback() {
        return true;
    }

    public void setThrownSickle(ItemStack stack, boolean value) {
        CompoundTag tag = stack.m_41698_(SICKLE_THROWN);
        tag.m_128379_(THROWN, value);
    }

    public boolean getThrownSickle(ItemStack stack) {
        CompoundTag tag = stack.m_41698_(SICKLE_THROWN);
        return tag.m_128471_(THROWN);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        ItemStack itemstack = player.m_21205_();
        if (!level.f_46443_) {
            List projectiles = level.m_6443_(ThrownSickle.class, player.m_20191_().m_82400_(32.0), s -> s.m_37282_() == player && !s.m_213877_());
            this.setThrownSickle(itemstack, false);
            if (!projectiles.isEmpty()) {
                ThrownSickle sickle = (ThrownSickle)((Object)projectiles.get(0));
                if (sickle.getHookState() == ThrownSickle.SickelState.HOOKED_IN_ENTITY && sickle.getHookedEntity() != null) {
                    LivingEntity le;
                    Entity hooked = sickle.getHookedEntity();
                    if (hooked instanceof LivingEntity && (le = (LivingEntity)hooked).m_21051_(Attributes.f_22278_).m_22135_() > 0.5) {
                        this.pullEntityToward((Entity)player, hooked.m_20182_());
                    } else {
                        this.pullEntityToward(hooked, player.m_20182_());
                    }
                } else if (sickle.getHookState() == ThrownSickle.SickelState.HOOKED_BLOCK && sickle.getHookedBlockPos() != null) {
                    this.pullEntityToward((Entity)player, sickle.getHookedBlockPos());
                }
                sickle.m_146870_();
            } else {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private void pullEntityToward(Entity toMove, Vec3 targetPos) {
        Vec3 direction = targetPos.m_82546_(toMove.m_20182_()).m_82541_();
        double strength = 4.0;
        Vec3 velocity = direction.m_82542_(strength, strength / 2.0, strength);
        toMove.m_20256_(velocity);
        toMove.f_19864_ = true;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int T) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.getThrownSickle(stack)) {
                int i = this.m_8105_(stack) - T;
                if (i >= 10 && !level.f_46443_) {
                    int k;
                    stack.m_41622_(1, (LivingEntity)player, ss -> ss.m_21190_(entity.m_7655_()));
                    ThrownSickle thrownSpear = new ThrownSickle(level, (LivingEntity)player, stack, this.getVariant(stack).getColor());
                    thrownSpear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.0f, 0.75f);
                    level.m_7967_((Entity)thrownSpear);
                    this.setThrownSickle(stack, true);
                    level.m_6269_(null, (Entity)thrownSpear, (SoundEvent)Ssounds.INFECTED_WEAPON_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)stack);
                    if (j > 0) {
                        thrownSpear.m_36781_(thrownSpear.m_36789_() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)stack)) > 0) {
                        thrownSpear.m_36735_(k);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && !ImmutableSet.of((Object)Enchantments.f_44980_).contains((Object)enchantment);
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHEARS_ACTIONS.contains(toolAction);
    }
}

