/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.ScreativeTab;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sitems.BaseWeapons.LootModifierWeapon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class Reaver
extends SwordItem
implements LootModifierWeapon {
    private final List<ComboValues> basicInfectedList;
    private final List<ComboValues> evolvedList;
    private final List<ComboValues> hyperList;
    private final List<ComboValues> organoidList;
    private final List<ComboValues> calamityList;

    public Reaver() {
        super(new Tier(){

            public int m_6609_() {
                return (Integer)SConfig.SERVER.reaver_durability.get();
            }

            public float m_6624_() {
                return -1.0f;
            }

            public float m_6631_() {
                return (Integer)SConfig.SERVER.reaver_damage.get() - 1;
            }

            public int m_6604_() {
                return 3;
            }

            public int m_6601_() {
                return 3;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_});
            }
        }, 0, -1.0f, new Item.Properties().m_41491_(ScreativeTab.SPORE_T));
        this.basicInfectedList = this.calculateMap((List)SConfig.SERVER.reaver_loot.get());
        this.evolvedList = this.calculateMap((List)SConfig.SERVER.reaver_loot1.get());
        this.hyperList = this.calculateMap((List)SConfig.SERVER.reaver_loot2.get());
        this.organoidList = this.calculateMap((List)SConfig.SERVER.reaver_loot3.get());
        this.calamityList = this.calculateMap((List)SConfig.SERVER.reaver_loot4.get());
    }

    public List<ComboValues> calculateMap(List<? extends String> list) {
        ArrayList<ComboValues> values = new ArrayList<ComboValues>();
        for (String string : list) {
            String[] s = string.split("\\|");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s[0]));
            int value = Integer.parseInt(s[1]);
            if (item == null || value == 0) continue;
            ItemStack stack = new ItemStack((ItemLike)item);
            ComboValues comboValues = new ComboValues(stack, value);
            values.add(comboValues);
        }
        return values;
    }

    @Override
    public int getLootingLevel() {
        return 3;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity livingEntity, LivingEntity victim) {
        if (livingEntity instanceof Calamity) {
            return this.shaveLoot(stack, livingEntity, victim, this.getRandomFromList(this.calamityList));
        }
        if (livingEntity instanceof Organoid) {
            return this.shaveLoot(stack, livingEntity, victim, this.getRandomFromList(this.organoidList));
        }
        if (livingEntity instanceof Hyper) {
            return this.shaveLoot(stack, livingEntity, victim, this.getRandomFromList(this.hyperList));
        }
        if (livingEntity instanceof EvolvedInfected) {
            return this.shaveLoot(stack, livingEntity, victim, this.getRandomFromList(this.evolvedList));
        }
        if (livingEntity instanceof Infected) {
            return this.shaveLoot(stack, livingEntity, victim, this.getRandomFromList(this.basicInfectedList));
        }
        return super.m_7579_(stack, livingEntity, victim);
    }

    public ComboValues getRandomFromList(List<ComboValues> values) {
        RandomSource source = RandomSource.m_216327_();
        return values.get(source.m_188503_(values.size()));
    }

    public boolean shaveLoot(ItemStack stack, LivingEntity livingEntity, LivingEntity victim, ComboValues values) {
        Level level = livingEntity.f_19853_;
        BlockPos pos = livingEntity.m_20097_();
        if (!level.f_46443_ && values != null && Math.random() < (double)values.value.intValue() * 0.01) {
            ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), values.stack);
            level.m_7967_((Entity)item);
            livingEntity.m_216990_((SoundEvent)Ssounds.REAVER_REAVE.get());
        }
        return super.m_7579_(stack, livingEntity, victim);
    }

    public record ComboValues(ItemStack stack, Integer value) {
    }
}

