/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Client.AnimationTrackers.SGAnimationTracker;
import com.Harbinger.Spore.Client.AnimationTrackers.SGReloadAnimationTracker;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.ScreativeTab;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.Projectile.SyringeProjectile;
import com.Harbinger.Spore.Sitems.Agents.ArmorSyringe;
import com.Harbinger.Spore.Sitems.Agents.WeaponSyringe;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class SyringeGun
extends Item
implements CustomModelArmorData,
Vanishable {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore:textures/item/syringe_gun.png");
    private static final String DATA = "data";
    public static final List<Item> AMMO = List.of((Item)Sitems.SYRINGE.get(), (Item)Sitems.VAMPIRIC_SYRINGE.get(), (Item)Sitems.CALCIFIED_SYRINGE.get(), (Item)Sitems.BEZERK_SYRINGE.get(), (Item)Sitems.TOXIC_SYRINGE.get(), (Item)Sitems.ROTTEN_SYRINGE.get(), (Item)Sitems.REINFORCED_SYRINGE.get(), (Item)Sitems.SKELETAL_SYRINGE.get(), (Item)Sitems.DROWNED_SYRINGE.get(), (Item)Sitems.CHARRED_SYRINGE.get());

    public SyringeGun() {
        super(new Item.Properties().m_41487_(1).m_41503_(((Integer)SConfig.SERVER.syringe_durability.get()).intValue()).m_41491_(ScreativeTab.SPORE_T));
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return TEXTURE;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    private boolean isValidAmmo(ItemStack stack) {
        return !stack.m_41619_() && AMMO.contains(stack.m_41720_());
    }

    private NonNullList<ItemStack> getMagazine(ItemStack gun) {
        NonNullList magazine = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        CompoundTag tag = gun.m_41784_();
        if (tag.m_128425_("Magazines", 9)) {
            ListTag magTag = tag.m_128437_("Magazines", 10);
            for (int i = 0; i < 4 && i < magTag.size(); ++i) {
                magazine.set(i, (Object)ItemStack.m_41712_((CompoundTag)magTag.m_128728_(i)));
            }
        }
        return magazine;
    }

    public NonNullList<Integer> getClip(ItemStack gun) {
        NonNullList clip = NonNullList.m_122780_((int)4, (Object)0);
        CompoundTag tag = gun.m_41784_();
        if (tag.m_128425_("Clip", 9)) {
            ListTag clipTag = tag.m_128437_("Clip", 3);
            for (int i = 0; i < 4 && i < clipTag.size(); ++i) {
                clip.set(i, (Object)((IntTag)clipTag.get(i)).m_7047_());
            }
        }
        return clip;
    }

    private void saveMagazineAndClip(ItemStack gun, NonNullList<ItemStack> magazine, NonNullList<Integer> clip) {
        CompoundTag tag = gun.m_41784_();
        ListTag magTag = new ListTag();
        for (ItemStack ammo : magazine) {
            CompoundTag entry = new CompoundTag();
            if (!ammo.m_41619_()) {
                ammo.m_41739_(entry);
            }
            magTag.add((Object)entry);
        }
        tag.m_128365_("Magazines", (Tag)magTag);
        ListTag clipTag = new ListTag();
        for (Integer c : clip) {
            clipTag.add((Object)IntTag.m_128679_((int)c));
        }
        tag.m_128365_("Clip", (Tag)clipTag);
    }

    public void setMagazine(ItemStack gun, ItemStack ammo, int slot) {
        NonNullList<ItemStack> magazine = this.getMagazine(gun);
        NonNullList<Integer> clip = this.getClip(gun);
        if (this.isValidAmmo(ammo)) {
            magazine.set(slot, (Object)ammo.m_41777_());
            clip.set(slot, (Object)this.encodeColors(ammo));
        }
        this.saveMagazineAndClip(gun, magazine, clip);
    }

    public void removeMagazine(ItemStack gun, int slot) {
        NonNullList<ItemStack> magazine = this.getMagazine(gun);
        NonNullList<Integer> clip = this.getClip(gun);
        magazine.set(slot, (Object)ItemStack.f_41583_);
        clip.set(slot, (Object)0);
        this.saveMagazineAndClip(gun, magazine, clip);
    }

    private int encodeColors(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_().equals(Sitems.SYRINGE.get())) {
            return -1;
        }
        Item item = stack.m_41720_();
        if (item instanceof WeaponSyringe) {
            WeaponSyringe w = (WeaponSyringe)item;
            return w.getColor();
        }
        item = stack.m_41720_();
        if (item instanceof ArmorSyringe) {
            ArmorSyringe a = (ArmorSyringe)item;
            return a.getColor();
        }
        return 0;
    }

    private int getCurrentChamber(ItemStack gun) {
        CompoundTag tag = gun.m_41698_(DATA);
        return tag.m_128451_("CurrentChamber");
    }

    private void setCurrentChamber(ItemStack gun, int value) {
        CompoundTag tag = gun.m_41698_(DATA);
        tag.m_128405_("CurrentChamber", value);
    }

    private int getReloadTimer(ItemStack gun) {
        CompoundTag tag = gun.m_41698_(DATA);
        return tag.m_128451_("ReloadTimer");
    }

    private void setReloadTimer(ItemStack gun, int value) {
        CompoundTag tag = gun.m_41698_(DATA);
        tag.m_128405_("ReloadTimer", value);
    }

    private boolean isReloading(ItemStack gun) {
        CompoundTag tag = gun.m_41698_(DATA);
        return tag.m_128471_("Reloading");
    }

    private void setReloading(ItemStack gun, boolean value) {
        CompoundTag tag = gun.m_41698_(DATA);
        tag.m_128379_("Reloading", value);
    }

    private int getShootCooldown(ItemStack gun) {
        CompoundTag tag = gun.m_41698_(DATA);
        return tag.m_128451_("ShootCooldown");
    }

    private void setShootCooldown(ItemStack gun, int value) {
        CompoundTag tag = gun.m_41698_(DATA);
        tag.m_128405_("ShootCooldown", value);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        boolean inHand;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean bl = inHand = player.m_21205_() == stack || player.m_21206_() == stack;
        if (inHand && this.isReloading(stack)) {
            if (this.getReloadTimer(stack) == 5) {
                player.m_6330_((SoundEvent)Ssounds.SYRINGE_SPIN.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
            }
            if (this.getReloadTimer(stack) > 0) {
                this.setReloadTimer(stack, this.getReloadTimer(stack) - 1);
            } else {
                this.reloadOne(stack, player);
                this.setReloadTimer(stack, 10);
            }
        }
        if (this.getShootCooldown(stack) > 0) {
            if (this.getShootCooldown(stack) == 5 && level.f_46443_) {
                int chamber = this.getCurrentChamber(stack);
                player.m_6330_((SoundEvent)Ssounds.SYRINGE_SPIN.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
                SGReloadAnimationTracker.triggerRotationToChamber(player, chamber, 10);
            }
            this.setShootCooldown(stack, this.getShootCooldown(stack) - 1);
        }
    }

    public void startReload(ItemStack stack) {
        this.setReloading(stack, true);
        this.setReloadTimer(stack, 10);
    }

    private void reloadOne(ItemStack gun, Player player) {
        NonNullList<ItemStack> magazine = this.getMagazine(gun);
        for (int i = 0; i < magazine.size(); ++i) {
            if (!((ItemStack)magazine.get(i)).m_41619_()) continue;
            ItemStack ammo = this.findAmmo(player);
            if (!ammo.m_41619_()) {
                if (player.f_19853_.f_46443_) {
                    SGReloadAnimationTracker.triggerRotationToChamber(player, i, 10);
                    player.m_6330_((SoundEvent)Ssounds.SYRINGE_RELOAD.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
                } else {
                    ItemStack taken = ammo.m_41620_(1);
                    this.setMagazine(gun, taken, i);
                }
            } else {
                this.setReloading(gun, false);
                break;
            }
            return;
        }
        this.setReloading(gun, false);
    }

    private ItemStack findAmmo(Player player) {
        ItemStack offhand = player.m_21206_();
        if (this.isValidAmmo(offhand)) {
            return offhand;
        }
        if (player.m_150110_().f_35937_) {
            return new ItemStack((ItemLike)Sitems.SYRINGE.get());
        }
        for (ItemStack invStack : player.m_150109_().f_35974_) {
            if (!this.isValidAmmo(invStack)) continue;
            return invStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean shoot(ItemStack gun, Player player, Level level, InteractionHand hand) {
        int chamber;
        if (this.getShootCooldown(gun) > 0) {
            return false;
        }
        NonNullList<ItemStack> magazine = this.getMagazine(gun);
        ItemStack ammo = (ItemStack)magazine.get(chamber = this.getCurrentChamber(gun));
        if (!ammo.m_41619_()) {
            if (!level.f_46443_) {
                int enchantment = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)gun);
                float power = enchantment > 0 ? (float)enchantment * 1.5f : 0.0f;
                SyringeProjectile arrow = new SyringeProjectile(level, (LivingEntity)player, (float)((Integer)SConfig.SERVER.syringe_damage.get()).intValue() + power, ammo);
                Vec3 vec3 = new Vec3(0.0, 0.0, hand == InteractionHand.MAIN_HAND ? 0.2 : -0.2).m_82524_(-player.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
                arrow.m_20219_(player.m_20182_().m_82520_(vec3.f_82479_, 1.4, vec3.f_82481_));
                arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                level.m_7967_((Entity)arrow);
                player.m_6330_((SoundEvent)Ssounds.SYRINGE_SHOOT.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
            } else {
                SGAnimationTracker.trigger(player);
            }
            this.removeMagazine(gun, chamber);
            this.setCurrentChamber(gun, (chamber + 1) % 4);
            this.setShootCooldown(gun, 10);
            player.m_6330_(SoundEvents.f_11796_, SoundSource.AMBIENT, 1.0f, 1.0f);
            return true;
        }
        player.m_6330_(SoundEvents.f_12088_, SoundSource.AMBIENT, 1.0f, 1.0f);
        this.setCurrentChamber(gun, (chamber + 1) % 4);
        this.triggerMagazineRotation(chamber, player);
        return false;
    }

    private void triggerMagazineRotation(int chamber, Player player) {
        if (player.f_19853_.f_46443_) {
            SGReloadAnimationTracker.triggerRotationToChamber(player, chamber, 10);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack gun = player.m_21120_(hand);
        player.m_6672_(hand);
        if (player.m_6144_()) {
            if (!this.isReloading(gun)) {
                this.startReload(gun);
            }
            return InteractionResultHolder.m_19096_((Object)gun);
        }
        if (this.getShootCooldown(gun) > 0 || this.isReloading(gun)) {
            return InteractionResultHolder.m_19100_((Object)gun);
        }
        if (this.shoot(gun, player, level, hand)) {
            gun.m_41622_(1, (LivingEntity)player, p_43296_ -> p_43296_.m_21190_(hand));
            return InteractionResultHolder.m_19096_((Object)gun);
        }
        this.startReload(gun);
        return InteractionResultHolder.m_19100_((Object)gun);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || ImmutableSet.of((Object)Enchantments.f_44988_).contains((Object)enchantment);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        for (ItemStack ammo : this.getMagazine(stack)) {
            if (ammo.m_41619_()) continue;
            list.add(ammo.m_41777_().m_41611_());
        }
    }

    public boolean m_6832_(ItemStack stack, ItemStack itemStack) {
        return itemStack.m_150930_((Item)Sitems.CIRCUIT_BOARD.get());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                ItemStack stack = entityLiving.m_21120_(hand);
                if (stack.equals(itemStack)) {
                    return HumanoidModel.ArmPose.CROSSBOW_HOLD;
                }
                return super.getArmPose(entityLiving, hand, itemStack);
            }
        });
    }
}

