/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.sEvents;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Senchantments;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.ChunkLoadRequest;
import com.Harbinger.Spore.ExtremelySusThings.ChunkLoaderHelper;
import com.Harbinger.Spore.ExtremelySusThings.CoolDamageSources;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.SBlockEntities.CDUBlockEntity;
import com.Harbinger.Spore.SBlockEntities.LivingStructureBlocks;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedDrowned;
import com.Harbinger.Spore.Sentities.Calamities.Gazenbrecher;
import com.Harbinger.Spore.Sentities.Calamities.Hinderburg;
import com.Harbinger.Spore.Sentities.Calamities.Sieger;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Protector;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.Organoids.Brauerei;
import com.Harbinger.Spore.Sentities.Organoids.Delusionare;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sentities.Organoids.Umarmer;
import com.Harbinger.Spore.Sentities.Organoids.Vigil;
import com.Harbinger.Spore.Sentities.Organoids.Womb;
import com.Harbinger.Spore.Sentities.Utility.GastGeber;
import com.Harbinger.Spore.Sentities.Utility.Illusion;
import com.Harbinger.Spore.Sentities.Utility.InfestedConstruct;
import com.Harbinger.Spore.Sentities.Utility.NukeEntity;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.Sentities.Utility.Specter;
import com.Harbinger.Spore.Sitems.BaseWeapons.DamagePiercingModifier;
import com.Harbinger.Spore.Sitems.BaseWeapons.LootModifierWeapon;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeBaseArmor;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsBaseItem;
import com.Harbinger.Spore.Sitems.PCI;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="spore")
public class HandlerEvents {
    private static int tickCounter = 0;
    private static final int CHECK_INTERVAL = 1200;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter >= 1200) {
            MinecraftServer server = event.getServer();
            if (server != null) {
                for (ServerLevel level : server.m_129785_()) {
                    HandlerEvents.cleanUpMobs(level);
                }
            }
            tickCounter = 0;
        }
        ChunkLoaderHelper.tick();
    }

    private static void cleanUpMobs(ServerLevel level) {
        ArrayList<Infected> infected = new ArrayList<Infected>();
        ArrayList<EvolvedInfected> evolved = new ArrayList<EvolvedInfected>();
        ArrayList<Hyper> hyper = new ArrayList<Hyper>();
        ArrayList<Organoid> organoid = new ArrayList<Organoid>();
        ArrayList<ScentEntity> scent = new ArrayList<ScentEntity>();
        for (Entity entity : level.m_8583_()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            if (((List)SConfig.SERVER.despawn_blacklist.get()).contains(living.m_20078_()) || living.m_8077_()) continue;
            if (living instanceof Organoid) {
                Organoid o = (Organoid)living;
                organoid.add(o);
                continue;
            }
            if (living instanceof EvolvedInfected) {
                EvolvedInfected e = (EvolvedInfected)living;
                evolved.add(e);
                continue;
            }
            if (living instanceof Hyper) {
                Hyper h = (Hyper)living;
                hyper.add(h);
                continue;
            }
            if (living instanceof ScentEntity) {
                ScentEntity s = (ScentEntity)living;
                scent.add(s);
                continue;
            }
            if (!(living instanceof Infected)) continue;
            Infected i = (Infected)living;
            infected.add(i);
        }
        HandlerEvents.despawnExcess(level, infected, (Integer)SConfig.SERVER.max_infected_cap.get());
        HandlerEvents.despawnExcess(level, evolved, (Integer)SConfig.SERVER.max_evolved_cap.get());
        HandlerEvents.despawnExcess(level, hyper, (Integer)SConfig.SERVER.max_hyper_cap.get());
        HandlerEvents.despawnExcess(level, organoid, (Integer)SConfig.SERVER.max_organoid_cap.get());
        HandlerEvents.despawnExcess(level, scent, (Integer)SConfig.SERVER.max_scent_cap.get());
    }

    private static <T extends LivingEntity> void despawnExcess(ServerLevel level, List<T> entities, int cap) {
        if (entities.size() <= cap) {
            return;
        }
        int toRemove = entities.size() - cap;
        int despawns = 0;
        List players = level.m_8795_(p -> true);
        if (players.isEmpty()) {
            for (int i = 0; i < toRemove; ++i) {
                LivingEntity entity = (LivingEntity)entities.get(i);
                entity.m_146870_();
                ++despawns;
            }
        } else {
            entities.sort(Comparator.comparingDouble(e -> level.m_45930_((Entity)e, -1.0) != null ? e.m_20280_((Entity)Objects.requireNonNull(level.m_45930_((Entity)e, -1.0))) : Double.MAX_VALUE).reversed());
            for (int i = 0; i < toRemove; ++i) {
                LivingEntity entity = (LivingEntity)entities.get(i);
                entity.m_146870_();
                ++despawns;
            }
        }
        System.out.println("Despawned " + despawns + " mobs in level: " + level.m_46472_().m_135782_());
    }

    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinLevelEvent event) {
        if (event != null && event.getEntity() != null) {
            Object object;
            if (event.getEntity() instanceof Proto && (object = event.getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)object;
                SporeSavedData.addHivemind(serverLevel);
            }
            if ((object = event.getEntity()) instanceof Protector) {
                Protector protector = (Protector)object;
                SporeSavedData.addProtector(protector);
            }
            if ((object = event.getEntity()) instanceof PathfinderMob) {
                String[] iterations;
                String[] mod;
                PathfinderMob mob = (PathfinderMob)object;
                for (String string : (List)SConfig.SERVER.attack.get()) {
                    if (string.endsWith(":")) {
                        mod = string.split(":");
                        if (!Objects.equals(mod[0], (iterations = mob.m_20078_().split(":"))[0])) continue;
                        mob.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Infected.class, false));
                        mob.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Calamity.class, false));
                        mob.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Organoid.class, false));
                        continue;
                    }
                    if (!((List)SConfig.SERVER.attack.get()).contains(mob.m_20078_())) continue;
                    mob.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Infected.class, false));
                    mob.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Calamity.class, false));
                    mob.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Organoid.class, false));
                }
                for (String string : (List)SConfig.SERVER.flee.get()) {
                    if (string.endsWith(":")) {
                        mod = string.split(":");
                        if (!Objects.equals(mod[0], (iterations = mob.m_20078_().split(":"))[0])) continue;
                        mob.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal(mob, Infected.class, 6.0f, 1.0, 0.9));
                        mob.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal(mob, UtilityEntity.class, 8.0f, 1.0, 0.9));
                        continue;
                    }
                    if (!((List)SConfig.SERVER.flee.get()).contains(mob.m_20078_())) continue;
                    mob.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal(mob, Infected.class, 6.0f, 1.0, 0.9));
                    mob.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal(mob, UtilityEntity.class, 8.0f, 1.0, 0.9));
                }
            }
        }
    }

    @SubscribeEvent
    public static void Command(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spore:set_area").executes(arguments -> {
            ServerLevel world = ((CommandSourceStack)arguments.getSource()).m_81372_();
            double x = ((CommandSourceStack)arguments.getSource()).m_81371_().m_7096_();
            double y = ((CommandSourceStack)arguments.getSource()).m_81371_().m_7098_();
            double z = ((CommandSourceStack)arguments.getSource()).m_81371_().m_7094_();
            Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
            if (entity == null) {
                entity = FakePlayerFactory.getMinecraft((ServerLevel)world);
            }
            if (entity != null) {
                BlockPos pos = new BlockPos(x, y, z);
                AABB hitbox = entity.m_20191_().m_82400_(20.0);
                List entities = entity.f_19853_.m_45933_(entity, hitbox);
                for (Entity entity1 : entities) {
                    if (entity1 instanceof Infected) {
                        Infected infected = (Infected)entity1;
                        infected.setSearchPos(pos);
                        continue;
                    }
                    if (!(entity1 instanceof Calamity)) continue;
                    Calamity calamity = (Calamity)entity1;
                    calamity.setSearchArea(pos);
                }
            }
            return 1;
        })).requires(s -> s.m_6761_(1)));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spore:nuke_the_land").executes(arguments -> {
            ServerLevel world = ((CommandSourceStack)arguments.getSource()).m_81372_();
            int x = (int)((CommandSourceStack)arguments.getSource()).m_81371_().m_7096_();
            int y = (int)((CommandSourceStack)arguments.getSource()).m_81371_().m_7098_();
            int z = (int)((CommandSourceStack)arguments.getSource()).m_81371_().m_7094_();
            NukeEntity nukeEntity = new NukeEntity((EntityType)Sentities.NUKE.get(), (Level)world);
            nukeEntity.setInitRange(1.0f);
            nukeEntity.setRange((float)((Double)SConfig.SERVER.nuke_range.get() * 1.0));
            nukeEntity.setInitDuration(0);
            nukeEntity.setDuration((Integer)SConfig.SERVER.nuke_time.get());
            nukeEntity.setDamage((float)((Double)SConfig.SERVER.nuke_damage.get() * 1.0));
            nukeEntity.m_6034_(x, y, z);
            world.m_7967_((Entity)nukeEntity);
            return 1;
        })).requires(s -> s.m_6761_(1)));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spore:erase_the_fungus").executes(arguments -> {
            ServerLevel serverLevel = ((CommandSourceStack)arguments.getSource()).m_81372_();
            for (Entity entity : serverLevel.m_8583_()) {
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || !((living = (LivingEntity)entity) instanceof Infected) && !(living instanceof UtilityEntity)) continue;
                living.m_146870_();
            }
            return 1;
        })).requires(s -> s.m_6761_(1)));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spore:evolve").executes(arguments -> {
            ServerLevel world = ((CommandSourceStack)arguments.getSource()).m_81372_();
            Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
            if (entity == null) {
                entity = FakePlayerFactory.getMinecraft((ServerLevel)world);
            }
            if (entity != null) {
                AABB hitbox = entity.m_20191_().m_82400_(20.0);
                List entities = entity.f_19853_.m_45933_(entity, hitbox);
                for (Entity entity1 : entities) {
                    if (entity1 instanceof Infected) {
                        Infected infected = (Infected)entity1;
                        infected.setEvolution((Integer)SConfig.SERVER.evolution_age_human.get());
                        if (entity1 instanceof Scamper) {
                            Scamper scamper = (Scamper)entity1;
                            scamper.setAge((Integer)SConfig.SERVER.scamper_age.get());
                            continue;
                        }
                        if (infected instanceof EvolvedInfected) {
                            EvolvedInfected evolvedInfected = (EvolvedInfected)infected;
                            evolvedInfected.setEvoPoints((Integer)SConfig.SERVER.min_kills_hyper.get());
                            continue;
                        }
                        infected.setEvoPoints((Integer)SConfig.SERVER.min_kills.get());
                        continue;
                    }
                    if (entity1 instanceof Mound) {
                        Mound mound = (Mound)entity1;
                        mound.setAge(mound.getAge() + 1);
                        continue;
                    }
                    if (!(entity1 instanceof Calamity)) continue;
                    Calamity calamity = (Calamity)entity1;
                    calamity.activateAdaptation();
                }
            }
            return 1;
        })).requires(s -> s.m_6761_(1)));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spore:get_data").executes(arguments -> {
            ServerLevel world = ((CommandSourceStack)arguments.getSource()).m_81372_();
            Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                SporeSavedData data = SporeSavedData.getDataLocation(world);
                int numberofprotos = data.getAmountOfHiveminds();
                player.m_5661_((Component)Component.m_237113_((String)"........................................"), false);
                player.m_5661_((Component)Component.m_237113_((String)("There are " + numberofprotos + " proto hiveminds in this dimension")), false);
                for (ChunkLoadRequest request : data.getRequests()) {
                    String id = request.getRequestID();
                    long getDefaultTicks = request.getTickAmount();
                    long ticks = request.getTicksUntilExpiration();
                    player.m_5661_((Component)Component.m_237113_((String)("Loaded chunk " + id + " " + ticks + "/" + getDefaultTicks)), false);
                }
            }
            return 1;
        })).requires(s -> s.m_6761_(1)));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spore:feed").executes(arguments -> {
            ServerLevel world = ((CommandSourceStack)arguments.getSource()).m_81372_();
            Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
            if (entity == null) {
                entity = FakePlayerFactory.getMinecraft((ServerLevel)world);
            }
            if (entity != null) {
                AABB hitbox = entity.m_20191_().m_82400_(20.0);
                List entities = entity.f_19853_.m_45933_(entity, hitbox);
                for (Entity entity1 : entities) {
                    if (entity1 instanceof Infected) {
                        Infected infected = (Infected)entity1;
                        infected.setKills(infected.getKills() + 1);
                        infected.setEvoPoints(infected.getEvoPoints() + 1);
                        continue;
                    }
                    if (!(entity1 instanceof Calamity)) continue;
                    Calamity calamity = (Calamity)entity1;
                    calamity.setKills(calamity.getKills() + 1);
                }
            }
            return 1;
        })).requires(s -> s.m_6761_(1)));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spore:check_entity").executes(arguments -> {
            ServerLevel world = ((CommandSourceStack)arguments.getSource()).m_81372_();
            Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
            if (entity == null) {
                entity = FakePlayerFactory.getMinecraft((ServerLevel)world);
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.f_19853_.f_46443_) {
                    AABB hitbox = entity.m_20191_().m_82400_(5.0);
                    List entities = entity.f_19853_.m_45933_(entity, hitbox);
                    for (Entity entity1 : entities) {
                        if (entity1 instanceof Infected) {
                            Infected scamper;
                            Infected infected = (Infected)entity1;
                            player.m_5661_((Component)Component.m_237113_((String)("Entity " + infected.m_20078_() + " " + infected.m_7770_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Health " + infected.m_21223_() + "/" + infected.m_21233_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Kills " + infected.getKills())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Evolution Points " + infected.getEvoPoints())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Position to be Searched " + infected.getSearchPos())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Buffs " + infected.m_21220_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Seconds until evolution: " + infected.getEvolutionCoolDown() + "/" + SConfig.SERVER.evolution_age_human.get())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Seconds until starvation: " + infected.getHunger() + "/" + SConfig.SERVER.hunger.get())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Is Linked ? " + infected.getLinked())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Target ? " + infected.m_5448_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Partner ? " + infected.getFollowPartner())), false);
                            if (infected instanceof Scamper) {
                                scamper = (Scamper)infected;
                                player.m_5661_((Component)Component.m_237113_((String)("Time before its overtaken ? " + ((Scamper)scamper).getAge() + "/" + SConfig.SERVER.scamper_age.get())), false);
                            }
                            if (infected instanceof Hyper) {
                                scamper = (Hyper)infected;
                                player.m_5661_((Component)Component.m_237113_((String)("Nest location ? " + ((Hyper)scamper).getNestLocation())), false);
                            }
                            if (infected instanceof GastGeber) {
                                GastGeber geber = (GastGeber)infected;
                                player.m_5661_((Component)Component.m_237113_((String)("RootTimer ? " + geber.getTimeRooted())), false);
                                player.m_5661_((Component)Component.m_237113_((String)("Aggression ? " + geber.getAggression())), false);
                                player.m_5661_((Component)Component.m_237113_((String)("Spread ? " + geber.getSpreadInterval())), false);
                            }
                            player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                            continue;
                        }
                        if (entity1 instanceof Calamity) {
                            Calamity sieger;
                            Calamity calamity = (Calamity)entity1;
                            player.m_5661_((Component)Component.m_237113_((String)("Entity " + calamity.m_20078_() + " " + calamity.m_7770_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Health " + calamity.m_21223_() + "/" + calamity.m_21233_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Kills " + calamity.getKills())), false);
                            if (calamity instanceof Sieger) {
                                sieger = (Sieger)calamity;
                                player.m_5661_((Component)Component.m_237113_((String)("Tail health " + ((Sieger)sieger).getTailHp() + "/" + ((Sieger)sieger).getMaxTailHp())), false);
                            }
                            if (calamity instanceof Gazenbrecher) {
                                sieger = (Gazenbrecher)calamity;
                                player.m_5661_((Component)Component.m_237113_((String)("Tongue health " + ((Gazenbrecher)sieger).getTongueHp() + "/" + ((Gazenbrecher)sieger).getMaxTongueHp())), false);
                                player.m_5661_((Component)Component.m_237113_((String)("Is adapted to fire " + ((Gazenbrecher)sieger).isAdaptedToFire() + " fire points" + ((Gazenbrecher)sieger).getAdaptationCount())), false);
                            }
                            if (calamity instanceof Hinderburg) {
                                sieger = (Hinderburg)calamity;
                                player.m_5661_((Component)Component.m_237113_((String)("Is armed " + ((Hinderburg)sieger).isArmed())), false);
                            }
                            player.m_5661_((Component)Component.m_237113_((String)("Position to be Searched " + calamity.getSearchArea())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Buffs " + calamity.m_21220_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Target ? " + calamity.m_5448_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                            continue;
                        }
                        if (entity1 instanceof Mound) {
                            Mound mound = (Mound)entity1;
                            player.m_5661_((Component)Component.m_237113_((String)("Entity " + mound.m_20078_() + " " + mound.m_7770_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Health " + mound.m_21223_() + "/" + mound.m_21233_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Is Linked ? " + mound.getLinked())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Age " + mound.getAge())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Seconds until growth " + mound.getAgeCounter() + "/" + SConfig.SERVER.mound_age.get())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Seconds until puff " + mound.getCounter() + "/" + mound.getMaxCounter())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Buffs " + mound.m_21220_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                            continue;
                        }
                        if (entity1 instanceof Proto) {
                            Proto proto = (Proto)entity1;
                            player.m_5661_((Component)Component.m_237113_((String)("Entity " + proto.m_20078_() + " " + proto.m_7770_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Health " + proto.m_21223_() + "/" + proto.m_21233_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Target " + proto.m_5448_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Buffs " + proto.m_21220_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Mobs under control " + proto.getHosts())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Biomass " + proto.getBiomass())), false);
                            for (int i = 0; i < proto.getWeights().length; ++i) {
                                player.m_5661_((Component)Component.m_237113_((String)("Neuron_" + i + " " + proto.getWeightsValue(i))), false);
                            }
                            for (String s : proto.team_1) {
                                player.m_5661_((Component)Component.m_237113_((String)("TEAM_1 " + s)), false);
                            }
                            for (String s : proto.team_2) {
                                player.m_5661_((Component)Component.m_237113_((String)("TEAM_2 " + s)), false);
                            }
                            for (String s : proto.team_3) {
                                player.m_5661_((Component)Component.m_237113_((String)("TEAM_3 " + s)), false);
                            }
                            for (String s : proto.team_4) {
                                player.m_5661_((Component)Component.m_237113_((String)("TEAM_4 " + s)), false);
                            }
                            for (String s : proto.team_5) {
                                player.m_5661_((Component)Component.m_237113_((String)("Beloved Mobs " + s)), false);
                            }
                            player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                            continue;
                        }
                        if (entity1 instanceof Womb) {
                            Womb reformator = (Womb)entity1;
                            player.m_5661_((Component)Component.m_237113_((String)("Entity " + reformator.m_20078_() + " " + reformator.m_7770_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Health " + reformator.m_21223_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Stored Location " + reformator.getLocation())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Buffs " + reformator.m_21220_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Biomass " + reformator.getBiomass())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("State " + reformator.getVariant().getValue())), false);
                            for (String s : reformator.getAttributeIDs()) {
                                player.m_5661_((Component)Component.m_237115_((String)s), false);
                            }
                            player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                            continue;
                        }
                        if (entity1 instanceof Vigil) {
                            Vigil vigil = (Vigil)entity1;
                            player.m_5661_((Component)Component.m_237113_((String)("Entity " + vigil.m_20078_() + " " + vigil.m_7770_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Health " + vigil.m_21223_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Buffs " + vigil.m_21220_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("State " + vigil.getTrigger())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Horde size " + vigil.getWaveSize())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Time until it leaves " + vigil.getTimer() + "/6000")), false);
                            player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                            continue;
                        }
                        if (entity1 instanceof Umarmer) {
                            Umarmer umarmer = (Umarmer)entity1;
                            player.m_5661_((Component)Component.m_237113_((String)("Entity " + umarmer.m_20078_() + " " + umarmer.m_7770_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Health " + umarmer.m_21223_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Buffs " + umarmer.m_21220_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Shielded? " + umarmer.isShielding())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Pins? " + umarmer.isPinned())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Time until it leaves " + umarmer.getTimer() + "/2400")), false);
                            player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                            continue;
                        }
                        if (entity1 instanceof Brauerei) {
                            Brauerei brauerei = (Brauerei)entity1;
                            player.m_5661_((Component)Component.m_237113_((String)("Entity " + brauerei.m_20078_() + " " + brauerei.m_7770_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Health " + brauerei.m_21223_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Buffs " + brauerei.m_21220_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Time until it leaves " + brauerei.getTimer() + "/300")), false);
                            player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                            continue;
                        }
                        if (entity1 instanceof Delusionare) {
                            Delusionare delusionare = (Delusionare)entity1;
                            player.m_5661_((Component)Component.m_237113_((String)("Entity " + delusionare.m_20078_() + " " + delusionare.m_7770_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Health " + delusionare.m_21223_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Buffs " + delusionare.m_21220_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Target ? " + delusionare.m_5448_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Magic state " + delusionare.getSpellById() + " casting " + delusionare.isCasting())), false);
                            player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                            continue;
                        }
                        if (entity1 instanceof Specter) {
                            Specter specter = (Specter)entity1;
                            player.m_5661_((Component)Component.m_237113_((String)("Entity " + specter.m_20078_() + " " + specter.m_7770_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Current Health " + specter.m_21223_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Buffs " + specter.m_21220_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Target ? " + specter.m_5448_())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Target Pos " + specter.getTargetPos())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Stomach " + specter.getStomach())), false);
                            player.m_5661_((Component)Component.m_237113_((String)("Biomass " + specter.getBiomass())), false);
                            player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                            continue;
                        }
                        if (!(entity1 instanceof InfestedConstruct)) continue;
                        InfestedConstruct construct = (InfestedConstruct)entity1;
                        player.m_5661_((Component)Component.m_237113_((String)("Entity " + construct.m_20078_() + " " + construct.m_7770_())), false);
                        player.m_5661_((Component)Component.m_237113_((String)("Current Health " + construct.m_21223_())), false);
                        player.m_5661_((Component)Component.m_237113_((String)("Buffs " + construct.m_21220_())), false);
                        player.m_5661_((Component)Component.m_237113_((String)("Target ? " + construct.m_5448_())), false);
                        player.m_5661_((Component)Component.m_237113_((String)("Machine hp " + construct.getMachineHealth())), false);
                        player.m_5661_((Component)Component.m_237113_((String)("Metal " + construct.getMetalReserve())), false);
                        player.m_5661_((Component)Component.m_237113_((String)"-------------------------"), false);
                    }
                }
            }
            return 1;
        })).requires(s -> s.m_6761_(1)));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spore:check_block_entity").executes(arguments -> {
            ServerLevel world = ((CommandSourceStack)arguments.getSource()).m_81372_();
            Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
            if (entity == null) {
                entity = FakePlayerFactory.getMinecraft((ServerLevel)world);
            }
            if (entity != null) {
                AABB aabb = entity.m_20191_().m_82400_(5.0);
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    BlockEntity blockEntity = entity.f_19853_.m_7702_(blockpos);
                    if (!(entity instanceof Player)) continue;
                    Player player = (Player)entity;
                    if (player.f_19853_.f_46443_) continue;
                    if (blockEntity instanceof LivingStructureBlocks) {
                        LivingStructureBlocks structureBlocks = (LivingStructureBlocks)blockEntity;
                        player.m_5661_((Component)Component.m_237113_((String)("Structure block with " + structureBlocks.getKills() + " kills")), false);
                        continue;
                    }
                    if (!(blockEntity instanceof CDUBlockEntity)) continue;
                    CDUBlockEntity block = (CDUBlockEntity)blockEntity;
                    player.m_5661_((Component)Component.m_237113_((String)("Fuel " + block.fuel)), false);
                }
            }
            return 1;
        })).requires(s -> s.m_6761_(1)));
    }

    @SubscribeEvent
    public static void DiscardProto(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Protector) {
            Protector protector = (Protector)entity;
            SporeSavedData.removeProtector(protector);
        }
        if (event.getEntity() instanceof Proto && (entity = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)entity;
            SporeSavedData.removeHivemind(level);
        }
    }

    @SubscribeEvent
    public static void Effects(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.m_21023_((MobEffect)Seffects.CORROSION.get()) && player2.f_19797_ % 60 == 0) {
                player2.m_150109_().m_150072_(CoolDamageSources.CORROSION, 0.5f, Inventory.f_150068_);
            }
            if (player2.m_21023_((MobEffect)Seffects.SYMBIOSIS.get()) && player2.f_19797_ % 200 == 0) {
                int size = player2.m_150109_().m_6643_();
                for (int i = 0; i <= size; ++i) {
                    ItemStack itemStack = player2.m_150109_().m_8020_(i);
                    if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)Senchantments.SYMBIOTIC_RECONSTITUTION.get()), (ItemStack)itemStack) == 0 || !itemStack.m_41768_()) continue;
                    Item item = itemStack.m_41720_();
                    if (item instanceof SporeToolsBaseItem) {
                        SporeToolsBaseItem base = (SporeToolsBaseItem)item;
                        base.healTool(itemStack, 2);
                        continue;
                    }
                    item = itemStack.m_41720_();
                    if (item instanceof SporeArmorData) {
                        SporeArmorData base = (SporeArmorData)item;
                        base.healTool(itemStack, 2);
                        continue;
                    }
                    int l = itemStack.m_41773_() - 2;
                    itemStack.m_41721_(l);
                }
            }
        }
    }

    @SubscribeEvent
    public static void drops(LootingLevelEvent event) {
        LivingEntity living;
        Item item;
        if (event.getDamageSource() == null) {
            return;
        }
        Entity entity = event.getDamageSource().m_7640_();
        if (entity instanceof LivingEntity && (item = (living = (LivingEntity)entity).m_21205_().m_41720_()) instanceof LootModifierWeapon) {
            LootModifierWeapon lootModifierWeapon = (LootModifierWeapon)item;
            event.setLootingLevel(lootModifierWeapon.getLootingLevel());
        }
    }

    @SubscribeEvent
    public static void FishingAnInfectedDrowned(ItemFishedEvent event) {
        if (event != null && Math.random() < 0.05 && event.getHookEntity().m_37166_()) {
            InfectedDrowned infectedDrowned = new InfectedDrowned((EntityType<? extends Infected>)((EntityType)Sentities.INF_DROWNED.get()), event.getEntity().f_19853_);
            infectedDrowned.m_6027_(event.getHookEntity().m_20185_(), event.getHookEntity().m_20186_(), event.getHookEntity().m_20189_());
            infectedDrowned.setKills(1);
            infectedDrowned.m_6710_((LivingEntity)event.getEntity());
            event.getEntity().f_19853_.m_7967_((Entity)infectedDrowned);
        }
    }

    @SubscribeEvent
    public static void ExplosiveBite(LivingEntityUseItemEvent.Finish event) {
        if (event != null) {
            LivingEntity entity;
            Item item = event.getItem().m_41720_();
            if (item == Sitems.ROASTED_TUMOR.get() && Math.random() < 0.2) {
                entity = event.getEntity();
                entity.f_19853_.m_46511_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.5f, Explosion.BlockInteraction.NONE);
            }
            if (item == Sitems.MILKY_SACK.get()) {
                entity = event.getEntity();
                ArrayList effectsToRemove = new ArrayList();
                entity.m_21220_().forEach(mobEffectInstance -> {
                    if (!mobEffectInstance.m_19544_().m_19486_()) {
                        effectsToRemove.add(mobEffectInstance);
                    }
                });
                effectsToRemove.forEach(mobEffectInstance -> entity.m_21195_(mobEffectInstance.m_19544_()));
            }
        }
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        ServerLevel level = event.getServer().m_129783_();
        SporeSavedData data = SporeSavedData.getDataLocation(level);
        if (data != null) {
            SporeSavedData.resetHive(level);
        }
    }

    @SubscribeEvent
    public static void LoadCalamity(EntityEvent.EnteringSection event) {
        ChunkLoadRequest request;
        String id;
        UUID ownerId;
        ChunkPos chunk;
        SectionPos NewChunk;
        Entity OldChunk;
        ServerLevel level;
        Entity entity = event.getEntity();
        if (entity instanceof Calamity) {
            Calamity calamity = (Calamity)entity;
            entity = calamity.f_19853_;
            if (entity instanceof ServerLevel) {
                level = (ServerLevel)entity;
                OldChunk = event.getOldPos();
                NewChunk = event.getNewPos();
                if (((Boolean)SConfig.SERVER.calamity_chunk.get()).booleanValue() && event.didChunkChange() && OldChunk != NewChunk && NewChunk != null && calamity.getSearchArea() != BlockPos.f_121853_) {
                    chunk = NewChunk.m_123251_();
                    ownerId = calamity.m_20148_();
                    id = "calamity_" + ownerId + "_" + chunk.toString();
                    request = new ChunkLoadRequest((ResourceKey<Level>)level.m_46472_(), new ChunkPos[]{chunk}, 0, id, 600L, ownerId);
                    ChunkLoaderHelper.addRequest(request);
                }
            }
        }
        if ((OldChunk = event.getEntity()) instanceof Proto) {
            Proto proto = (Proto)OldChunk;
            OldChunk = proto.f_19853_;
            if (OldChunk instanceof ServerLevel) {
                level = (ServerLevel)OldChunk;
                if (((Boolean)SConfig.SERVER.proto_chunk.get()).booleanValue()) {
                    OldChunk = event.getOldPos();
                    NewChunk = event.getNewPos();
                    if (((Boolean)SConfig.SERVER.calamity_chunk.get()).booleanValue() && event.didChunkChange() && OldChunk != NewChunk) {
                        chunk = NewChunk.m_123251_();
                        ownerId = proto.m_20148_();
                        id = "hivemind_" + ownerId + "_" + chunk.toString();
                        request = new ChunkLoadRequest((ResourceKey<Level>)level.m_46472_(), new ChunkPos[]{chunk}, 0, id, 12000L, ownerId);
                        ChunkLoaderHelper.addRequest(request);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void FallProt(LivingFallEvent event) {
        if (event.getEntity().m_6844_(EquipmentSlot.FEET).m_41720_() == Sitems.INF_UP_BOOTS.get()) {
            event.setDistance(event.getDistance() - 25.0f);
        }
    }

    @SubscribeEvent
    public static void ProtectFromEffect(MobEffectEvent.Applicable event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        MobEffect mobEffect = event.getEffectInstance().m_19544_();
        if (living != null) {
            if (mobEffect == Seffects.MYCELIUM.get() && Utilities.helmetList().contains(living.m_6844_(EquipmentSlot.HEAD).m_41720_())) {
                event.setResult(Event.Result.DENY);
            }
            if (((Boolean)SConfig.SERVER.faw_target.get()).booleanValue() && event.getEntity().m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("fromanotherworld:things")))) {
                if (mobEffect == Seffects.MARKER.get()) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (((Boolean)SConfig.SERVER.skulk_target.get()).booleanValue() && event.getEntity().m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("sculkhorde:sculk_entity"))) && mobEffect == Seffects.MARKER.get()) {
                event.setResult(Event.Result.DENY);
            }
            if (living.m_6844_(EquipmentSlot.HEAD).m_41720_() == Sitems.INF_UP_HELMET.get() && mobEffect == Seffects.MADNESS.get() && instance.m_19564_() < 1) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void NoSleep(PlayerSleepInBedEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).m_21023_((MobEffect)Seffects.UNEASY.get())) {
            player.m_5661_((Component)Component.m_237115_((String)"uneasy.message"), true);
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public static void NoSleep(ServerStartedEvent event) {
        SporeSavedData.StartupData(event.getServer().m_129783_());
    }

    @SubscribeEvent
    public static void DefenseBypass(LivingDamageEvent event) {
        int summonerUUID;
        Level level;
        Entity summoner;
        Mob creature;
        int decision;
        Proto smartMob;
        int summonerUUID2;
        Level level2;
        Entity summoner2;
        Mob attacker;
        LivingEntity data;
        Entity i2;
        Entity totalDamageModification2;
        Item d02;
        LivingEntity mobEffectInstance2;
        MobEffectInstance mobEffectInstance2;
        float original_damage;
        DamagePiercingModifier piercingModifier;
        float recalculatedDamage;
        LivingEntity livingEntity;
        Item recalculatedDamage22;
        float original_damage2;
        ArmorPersentageBypass bypass;
        float recalculatedDamage22;
        Infected victim;
        LivingEntity weapon;
        Player player;
        Entity living = event.getSource().m_7639_();
        if (living instanceof Player) {
            PCI pci;
            Item item;
            player = (Player)living;
            if (event.getEntity().m_6844_(EquipmentSlot.CHEST).equals(ItemStack.f_41583_) && (item = (weapon = player.m_21205_()).m_41720_()) instanceof PCI && (pci = (PCI)item).getCharge((ItemStack)weapon) > 0 && !player.m_36335_().m_41519_((Item)pci)) {
                int damageMod = (Integer)SConfig.SERVER.pci_damage_multiplier.get();
                int charge = pci.getCharge((ItemStack)weapon);
                LivingEntity target = event.getEntity();
                boolean freeze = event.getEntity().m_6095_().m_204039_(EntityTypeTags.f_144295_);
                float targetHealth = freeze ? target.m_21223_() / (float)damageMod : target.m_21223_();
                int freezeDamage = (float)charge >= targetHealth ? (int)targetHealth : charge;
                event.setAmount(freeze ? (float)(freezeDamage * damageMod) : (float)freezeDamage);
                pci.setCharge((ItemStack)weapon, charge - freezeDamage);
                target.m_146917_(600);
                player.m_36335_().m_41524_((Item)pci, (int)Math.ceil(targetHealth / 5.0f) * 20);
                pci.playSound(player);
            }
        }
        if ((weapon = event.getEntity()) instanceof Infected && !((victim = (Infected)weapon) instanceof Protector)) {
            LivingEntity e;
            LivingEntity attacker2 = living instanceof LivingEntity ? (e = (LivingEntity)living) : null;
            List<Protector> protectorList = SporeSavedData.protectorList();
            if (!protectorList.isEmpty() && attacker2 != null) {
                for (Protector protector1 : protectorList) {
                    double d02 = protector1.m_20270_((Entity)attacker2);
                    if (!protector1.m_6084_() || !(d02 < 64.0) || attacker2.m_5833_() || !Utilities.TARGET_SELECTOR.Test(attacker2)) continue;
                    protector1.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 0));
                    protector1.m_6710_(attacker2);
                }
            }
        }
        if (living instanceof ArmorPersentageBypass && (recalculatedDamage22 = (bypass = (ArmorPersentageBypass)living).amountOfDamage(original_damage2 = event.getAmount())) >= 0.0f && original_damage2 < recalculatedDamage22) {
            event.setAmount(recalculatedDamage22);
        }
        if (living instanceof LivingEntity && (recalculatedDamage22 = (livingEntity = (LivingEntity)living).m_21205_().m_41720_()) instanceof DamagePiercingModifier && (recalculatedDamage = (piercingModifier = (DamagePiercingModifier)recalculatedDamage22).getMinimalDamage(original_damage = event.getAmount())) >= 0.0f && original_damage < recalculatedDamage) {
            event.setAmount(recalculatedDamage);
        }
        if ((living instanceof Infected || living instanceof UtilityEntity && !(living instanceof Illusion)) && (mobEffectInstance2 = (livingEntity = event.getEntity()).m_21124_((MobEffect)Seffects.MADNESS.get())) != null) {
            int level3 = mobEffectInstance2.m_19564_();
            int duration = mobEffectInstance2.m_19557_() + 1200;
            boolean jumpLevel = duration < 12000;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.MADNESS.get(), jumpLevel ? duration : duration - 12000, jumpLevel ? level3 : level3 + 1));
        }
        if ((mobEffectInstance2 = event.getEntity()) instanceof Player) {
            player = (Player)mobEffectInstance2;
            float totalDamageModification2 = 0.0f;
            for (ItemStack stack : player.m_6168_()) {
                d02 = stack.m_41720_();
                if (!(d02 instanceof SporeBaseArmor)) continue;
                SporeBaseArmor armor = (SporeBaseArmor)d02;
                totalDamageModification2 += armor.calculateAdditionalDamage(event.getSource(), stack, event.getAmount());
            }
            event.setAmount(event.getAmount() + totalDamageModification2);
        }
        if ((totalDamageModification2 = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)totalDamageModification2;
            int i2 = 0;
            for (ItemStack stack : serverPlayer.m_150109_().f_35975_) {
                SporeBaseArmor baseArmor;
                d02 = stack.m_41720_();
                if (!(d02 instanceof SporeBaseArmor) || (baseArmor = (SporeBaseArmor)d02).getVariant(stack) != SporeArmorMutations.CHARRED) continue;
                i2 += 2;
            }
            if (i2 > 0) {
                event.getEntity().m_20254_(i2);
            }
        }
        if ((i2 = event.getSource().m_7639_()) instanceof Mob && (data = (attacker = (Mob)i2).getPersistentData()).m_128441_("hivemind") && (summoner2 = (level2 = attacker.f_19853_).m_6815_(summonerUUID2 = data.m_128451_("hivemind"))) instanceof Proto) {
            smartMob = (Proto)summoner2;
            decision = data.m_128451_("decision");
            int member = data.m_128451_("member");
            smartMob.praisedForDecision(decision, member);
        }
        if ((data = event.getEntity()) instanceof Mob && (data = (creature = (Mob)data).getPersistentData()).m_128441_("hivemind") && (summoner = (level = creature.f_19853_).m_6815_(summonerUUID = data.m_128451_("hivemind"))) instanceof Proto) {
            smartMob = (Proto)summoner;
            decision = data.m_128451_("decision");
            int member = data.m_128451_("member");
            smartMob.punishForDecision(decision, member);
        }
    }

    @SubscribeEvent
    public static void TickEvents(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            int level;
            Player player = (Player)livingEntity;
            MobEffectInstance effectInstance = player.m_21124_((MobEffect)Seffects.MADNESS.get());
            if (effectInstance != null && effectInstance.m_19557_() == 1 && (level = effectInstance.m_19564_()) > 0) {
                effectInstance.m_19558_(new MobEffectInstance((MobEffect)Seffects.MADNESS.get(), 12000, level - 1));
            }
            if (player.f_19797_ % 400 == 0 && player.f_19853_.f_46443_) {
                AABB aabb = player.m_20191_().m_82400_(5.0);
                ArrayList<BlockPos> list = new ArrayList<BlockPos>();
                for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    if (!player.f_19853_.m_8055_(blockPos).m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("spore:fungal_blocks")))) continue;
                    list.add(blockPos);
                }
                if (list.size() > 4) {
                    player.m_216990_((SoundEvent)Ssounds.AREA_AMBIENT.get());
                }
            }
        }
    }
}

