/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.AnimationTrackers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PCIAnimationTracker {
    private static final Map<UUID, Integer> animationTicks = new HashMap<UUID, Integer>();

    public static void trigger(Player player) {
        animationTicks.put(player.getUUID(), 20);
    }

    public static float getProgress(Player player, float partialTicks) {
        int ticks = animationTicks.getOrDefault(player.getUUID(), 0);
        return Math.max(0.0f, (float)ticks - partialTicks) / 10.0f;
    }

    public static void tickAll() {
        animationTicks.replaceAll((uuid, ticks) -> Math.max(0, ticks - 1));
    }
}

