/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.ArmorParts;

import com.Harbinger.Spore.Client.ArmorParts.EnchantingPart;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.Harbinger.Spore.core.Senchantments;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BaseArmorRenderingBit {
    public final EquipmentSlot slot;
    public final Item item;
    public final Supplier<EntityModel<LivingEntity>> model;
    public final Supplier<ModelPart> part;
    public final float x;
    public final float y;
    public final float z;
    public final float expand;
    public final float Xspin;
    public final float Yspin;
    public final float Zspin;

    public BaseArmorRenderingBit(EquipmentSlot slot, Item item, Supplier<EntityModel<LivingEntity>> model, Supplier<ModelPart> part, float x, float y, float z, float expand, float xspin, float yspin, float zspin) {
        this.slot = slot;
        this.item = item;
        this.model = model;
        this.part = part;
        this.x = x;
        this.y = y;
        this.z = z;
        this.expand = expand;
        this.Xspin = xspin;
        this.Yspin = yspin;
        this.Zspin = zspin;
    }

    public BaseArmorRenderingBit(EquipmentSlot slot, Item item, Supplier<EntityModel<LivingEntity>> model, Supplier<ModelPart> part, float x, float y, float z, float expand) {
        this(slot, item, model, part, x, y, z, expand, 0.0f, 0.0f, 0.0f);
    }

    public ItemStack stack(LivingEntity livingEntity) {
        return livingEntity.getItemBySlot(this.slot);
    }

    protected VertexConsumer consumer(MultiBufferSource source, CustomModelArmorData data, HumanoidModel<LivingEntity> model, LivingEntity livingEntity) {
        BaseArmorRenderingBit baseArmorRenderingBit = this;
        if (baseArmorRenderingBit instanceof EnchantingPart) {
            EnchantingPart enchantingPart = (EnchantingPart)((Object)baseArmorRenderingBit);
            return ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)model.renderType(enchantingPart.getTexture()), (boolean)false, (boolean)this.stack(livingEntity).hasFoil());
        }
        return ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)model.renderType(data.getTextureLocation()), (boolean)false, (boolean)this.stack(livingEntity).hasFoil());
    }

    public void tickMovement(LivingEntity livingEntity, PoseStack poseStack, HumanoidModel<LivingEntity> model, int light, MultiBufferSource buffer) {
        int color;
        ItemStack itemStack = this.stack(livingEntity);
        Object object = itemStack.getItem();
        if (object instanceof SporeArmorData) {
            SporeArmorData armorData = (SporeArmorData)object;
            color = armorData.getVariant(itemStack).getColor();
        } else {
            color = -1;
        }
        object = this;
        if (object instanceof EnchantingPart) {
            EnchantingPart enchantingPart = (EnchantingPart)object;
            if (Senchantments.hasEnchant((LevelAccessor)livingEntity.level(), itemStack, enchantingPart.getEnchantment())) {
                VertexConsumer consumer = this.consumer(buffer, null, model, livingEntity);
                this.applyTransformEx(poseStack, this.getPiece(model), this.x, this.y, this.z, this.expand, this.Xspin, this.Yspin, this.Zspin, () -> this.part.get().render(poseStack, consumer, light, OverlayTexture.NO_OVERLAY, color));
            }
        } else {
            Item item = itemStack.getItem();
            if (item instanceof CustomModelArmorData) {
                CustomModelArmorData armorData = (CustomModelArmorData)item;
                if (itemStack.getItem().equals(this.item)) {
                    VertexConsumer consumer = this.consumer(buffer, armorData, model, livingEntity);
                    this.applyTransformEx(poseStack, this.getPiece(model), this.x, this.y, this.z, this.expand, this.Xspin, this.Yspin, this.Zspin, () -> this.part.get().render(poseStack, consumer, light, OverlayTexture.NO_OVERLAY, color));
                }
            }
        }
    }

    protected abstract ModelPart getPiece(HumanoidModel<LivingEntity> var1);

    protected void applyTransformEx(PoseStack poseStack, ModelPart origin, float x, float y, float z, float scale, float xSpin, float ySpin, float ZSpin, Runnable render) {
        poseStack.pushPose();
        origin.translateAndRotate(poseStack);
        poseStack.translate(x, y, z);
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.XP.rotationDegrees(xSpin));
        poseStack.mulPose(Axis.YP.rotationDegrees(ySpin));
        poseStack.mulPose(Axis.ZP.rotationDegrees(ZSpin));
        render.run();
        poseStack.popPose();
    }
}

