/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.ArmorParts;

import com.Harbinger.Spore.Client.ArmorParts.BaseArmorRenderingBit;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.Harbinger.Spore.Sitems.PCI;
import com.Harbinger.Spore.core.Sitems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LeftPCIArmorPart
extends BaseArmorRenderingBit {
    private final ResourceLocation location;

    public LeftPCIArmorPart(Supplier<EntityModel<LivingEntity>> model, Supplier<ModelPart> part, ResourceLocation location) {
        super(EquipmentSlot.OFFHAND, (Item)Sitems.PCI.get(), model, part, 0.15f, -0.35f, 0.05f, 1.0f);
        this.location = location;
    }

    @Override
    protected ModelPart getPiece(HumanoidModel<LivingEntity> model) {
        return model.leftArm;
    }

    @Override
    public void tickMovement(LivingEntity livingEntity, PoseStack poseStack, HumanoidModel<LivingEntity> model, int light, MultiBufferSource buffer) {
        ItemStack itemStack = this.stack(livingEntity);
        Item item = itemStack.getItem();
        if (item instanceof CustomModelArmorData) {
            CustomModelArmorData armorData = (CustomModelArmorData)item;
            if (itemStack.getItem().equals(this.item)) {
                VertexConsumer consumer = this.consumer(buffer, armorData, model, livingEntity);
                this.applyTransformEx(poseStack, this.getPiece(model), this.x, this.y, this.z, this.expand, this.Xspin, this.Yspin, this.Zspin, () -> {
                    ((ModelPart)this.part.get()).render(poseStack, consumer, light, OverlayTexture.NO_OVERLAY, -1);
                    VertexConsumer vertexConsumer = this.glowConsumer(buffer, livingEntity);
                    if (vertexConsumer != null) {
                        ((ModelPart)this.part.get()).render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
                    }
                });
            }
        }
    }

    private VertexConsumer glowConsumer(MultiBufferSource bufferSource, LivingEntity livingEntity) {
        PCI pci;
        ItemStack stack = this.stack(livingEntity);
        Item item = stack.getItem();
        if (item instanceof PCI && (pci = (PCI)item).getCharge(stack) > 0) {
            return bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.location));
        }
        return null;
    }
}

