/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.ArmorParts;

import com.Harbinger.Spore.Client.ArmorParts.BaseArmorRenderingBit;
import com.Harbinger.Spore.Client.Models.SyringeGunModelArm;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.Harbinger.Spore.Sitems.SyringeGun;
import com.Harbinger.Spore.core.Sitems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SyringeGunArmorPartLeft
extends BaseArmorRenderingBit {
    private final SyringeGunModelArm<LivingEntity> parentModel;
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"spore:textures/item/syringe_gun_juice.png");
    private static final ResourceLocation TEXTURET = ResourceLocation.parse((String)"spore:textures/item/syringe_gun_syringe.png");

    public SyringeGunArmorPartLeft(SyringeGunModelArm<LivingEntity> parentModel, Supplier<EntityModel<LivingEntity>> model, Supplier<ModelPart> part, float x, float y, float z, float expand) {
        super(EquipmentSlot.OFFHAND, (Item)Sitems.SYRINGE_GUN.get(), model, part, x, y, z, expand);
        this.parentModel = parentModel;
    }

    @Override
    protected VertexConsumer consumer(MultiBufferSource source, CustomModelArmorData data, HumanoidModel<LivingEntity> model, LivingEntity livingEntity) {
        return ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)RenderType.entityTranslucent((ResourceLocation)data.getTextureLocation()), (boolean)false, (boolean)this.stack(livingEntity).hasFoil());
    }

    @Override
    protected ModelPart getPiece(HumanoidModel<LivingEntity> model) {
        return model.leftArm;
    }

    @Override
    public void tickMovement(LivingEntity livingEntity, PoseStack poseStack, HumanoidModel<LivingEntity> model, int light, MultiBufferSource buffer) {
        Item item;
        super.tickMovement(livingEntity, poseStack, model, light, buffer);
        ItemStack stack = livingEntity.getOffhandItem();
        if (stack.getItem().equals(this.item) && (item = stack.getItem()) instanceof SyringeGun) {
            SyringeGun syringeGun = (SyringeGun)item;
            NonNullList<Integer> clipColors = syringeGun.getClip(stack);
            this.applyTransformEx(poseStack, this.getPiece(model), this.x, this.y, this.z, this.expand, this.Xspin, this.Yspin, this.Zspin, () -> {
                this.handleColorRendering(this.parentModel.syringe, (Integer)clipColors.get(0), poseStack, buffer, light);
                this.handleColorRendering(this.parentModel.syringe2, (Integer)clipColors.get(1), poseStack, buffer, light);
                this.handleColorRendering(this.parentModel.syringe3, (Integer)clipColors.get(2), poseStack, buffer, light);
                this.handleColorRendering(this.parentModel.syringe4, (Integer)clipColors.get(3), poseStack, buffer, light);
            });
        }
    }

    public void handleColorRendering(ModelPart syringe, int color, PoseStack stack, MultiBufferSource source, int light) {
        if (color == 0) {
            return;
        }
        stack.pushPose();
        this.parentModel.syringeGun.translateAndRotate(stack);
        this.parentModel.magazine.translateAndRotate(stack);
        if (color != -1) {
            VertexConsumer consumer = source.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE));
            syringe.render(stack, consumer, light, OverlayTexture.NO_OVERLAY, color);
        }
        VertexConsumer consumerS = source.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURET));
        syringe.render(stack, consumerS, light, OverlayTexture.NO_OVERLAY);
        stack.popPose();
    }
}

