/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Layers;

import com.Harbinger.Spore.Client.Models.HindenXmaslightsModel;
import com.Harbinger.Spore.Client.Models.HindieModel;
import com.Harbinger.Spore.Sentities.Calamities.Hinderburg;
import com.Harbinger.Spore.core.SConfig;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HindenburgLightsLayer<T extends Hinderburg>
extends RenderLayer<T, HindieModel<T>> {
    private int currentTexture;
    private static final ResourceLocation MAIN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hindie_light/hindie_lights.png");
    private final HindenXmaslightsModel<T> model = new HindenXmaslightsModel();
    public static final Map<activeLights, ResourceLocation> TEXTURE = (Map)Util.make((Object)Maps.newEnumMap(activeLights.class), p_114874_ -> {
        p_114874_.put(activeLights.RED, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hindie_light/hindie_red.png"));
        p_114874_.put(activeLights.BLUE, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hindie_light/hindie_blue.png"));
        p_114874_.put(activeLights.GREEN, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hindie_light/hindie_green.png"));
        p_114874_.put(activeLights.YELLOW, ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/hindie_light/hindie_yellow.png"));
    });

    public HindenburgLightsLayer(RenderLayerParent<T, HindieModel<T>> p_117346_) {
        super(p_117346_);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int p_117351_, T type, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
        LocalDate localdate;
        int j;
        if (((Boolean)SConfig.SERVER.costumes.get()).booleanValue() && ((j = (localdate = LocalDate.now()).get(ChronoField.MONTH_OF_YEAR)) == 12 || ((Boolean)SConfig.SERVER.costumes_active.get()).booleanValue())) {
            stack.pushPose();
            stack.translate(0.0, 3.5, 0.0);
            HindenburgLightsLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.model, (ResourceLocation)MAIN_TEXTURE, (PoseStack)stack, (MultiBufferSource)bufferSource, (int)p_117351_, type, (float)p_117353_, (float)p_117354_, (float)p_117355_, (float)p_117356_, (float)p_117357_, (float)p_117358_, (int)-1);
            this.renderActiveLight(bufferSource, stack);
            if (((Hinderburg)type).tickCount % 40 == 0) {
                this.currentTexture = this.currentTexture == activeLights.values().length ? 0 : this.currentTexture + 1;
            }
            stack.popPose();
        }
    }

    public void renderActiveLight(MultiBufferSource bufferSource, PoseStack stack) {
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)TEXTURE.get((Object)activeLights.byId(this.currentTexture & 0xFF))));
        this.model.renderToBuffer(stack, vertexconsumer, 0xF00000, OverlayTexture.NO_OVERLAY, -1);
    }

    static enum activeLights {
        RED(0),
        BLUE(1),
        GREEN(2),
        YELLOW(3);

        private final int type;
        private static final activeLights[] BY_ID;

        private activeLights(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static activeLights byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        static {
            BY_ID = (activeLights[])Arrays.stream(activeLights.values()).sorted(Comparator.comparingInt(activeLights::getType)).toArray(activeLights[]::new);
        }
    }
}

