/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Layers;

import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.HowitzerModel;
import com.Harbinger.Spore.Sentities.Calamities.Howitzer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class HowitzerEmissiveLayer<T extends Howitzer, M extends HowitzerModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/howitzer.png");
    private static final ResourceLocation RADIOACTIVE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/eyes/howitzer_radiation_glow.png");

    public HowitzerEmissiveLayer(RenderLayerParent<T, M> p_117346_) {
        super(p_117346_);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.isInvisible()) {
            float alpha = 0.5f + 0.5f * Mth.sin((float)(ageInTicks * 0.1f));
            int color = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
            VertexConsumer vertexConsumer = buffer.getBuffer(SporeRenderTypes.glowingTranslucent(((Howitzer)entity).isRadioactive() ? RADIOACTIVE : TEXTURE));
            ((HowitzerModel)this.getParentModel()).renderToBuffer(matrixStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        }
    }
}

