/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Models.TentacledModel;
import com.Harbinger.Spore.Sentities.Utility.ArenaEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ArenaTendrilModel<T extends ArenaEntity>
extends EntityModel<T>
implements TentacledModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"arena_tendril"), "main");
    private final ModelPart Tendril;
    private final ModelPart TendrilSeg1;
    private final ModelPart TendrilSeg2;
    private final ModelPart S2Body;
    private final ModelPart Jaw2;
    private final ModelPart S2BEye1;
    private final ModelPart pupil2;
    private final ModelPart S2BEye2;
    private final ModelPart pupil3;
    private final ModelPart S2BEye3;
    private final ModelPart pupil4;
    private final ModelPart T2Tumors;
    private final ModelPart TendrilSeg3;
    private final ModelPart S3Body;
    private final ModelPart Head;
    private final ModelPart Jaw;
    private final ModelPart Eye;
    private final ModelPart pupil;
    private final ModelPart Tumors;
    private final ModelPart TumorBase;

    public ArenaTendrilModel(ModelPart root) {
        this.Tendril = root.getChild("Tendril");
        this.TendrilSeg1 = this.Tendril.getChild("TendrilSeg1");
        this.TendrilSeg2 = this.TendrilSeg1.getChild("TendrilSeg2");
        this.S2Body = this.TendrilSeg2.getChild("S2Body");
        this.Jaw2 = this.S2Body.getChild("Jaw2");
        this.S2BEye1 = this.S2Body.getChild("S2BEye1");
        this.pupil2 = this.S2BEye1.getChild("pupil2");
        this.S2BEye2 = this.S2Body.getChild("S2BEye2");
        this.pupil3 = this.S2BEye2.getChild("pupil3");
        this.S2BEye3 = this.S2Body.getChild("S2BEye3");
        this.pupil4 = this.S2BEye3.getChild("pupil4");
        this.T2Tumors = this.TendrilSeg2.getChild("T2Tumors");
        this.TendrilSeg3 = this.TendrilSeg2.getChild("TendrilSeg3");
        this.S3Body = this.TendrilSeg3.getChild("S3Body");
        this.Head = this.S3Body.getChild("Head");
        this.Jaw = this.Head.getChild("Jaw");
        this.Eye = this.Head.getChild("Eye");
        this.pupil = this.Eye.getChild("pupil");
        this.Tumors = this.S3Body.getChild("Tumors");
        this.TumorBase = this.Tendril.getChild("TumorBase");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Tendril = partdefinition.addOrReplaceChild("Tendril", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition TendrilSeg1 = Tendril.addOrReplaceChild("TendrilSeg1", CubeListBuilder.create().texOffs(64, 58).addBox(-2.5f, -16.0f, -2.5f, 5.0f, 16.0f, 5.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition TendrilSeg2 = TendrilSeg1.addOrReplaceChild("TendrilSeg2", CubeListBuilder.create().texOffs(32, 70).addBox(-2.0f, -20.0f, -2.0f, 4.0f, 20.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)-16.0f, (float)0.0f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition S2Body = TendrilSeg2.addOrReplaceChild("S2Body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.19f, (float)-4.6555f, (float)-4.1262f, (float)-1.8212f, (float)1.2114f, (float)2.9066f));
        PartDefinition Leg_r1 = S2Body.addOrReplaceChild("Leg_r1", CubeListBuilder.create().texOffs(24, 94).addBox(-1.1032f, -1.7548f, -1.27f, 8.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)1.0f, (float)3.0f, (float)0.8091f, (float)0.0688f, (float)2.3514f));
        PartDefinition Arm_r1 = S2Body.addOrReplaceChild("Arm_r1", CubeListBuilder.create().texOffs(24, 94).addBox(-0.5219f, -0.4371f, -1.7124f, 8.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.2366f, (float)-0.5182f, (float)2.8999f, (float)0.037f, (float)1.1318f, (float)0.3131f));
        PartDefinition Arm_r2 = S2Body.addOrReplaceChild("Arm_r2", CubeListBuilder.create().texOffs(26, 94).addBox(-0.6481f, -1.3468f, -1.4118f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.7503f, (float)-1.9185f, (float)9.3653f, (float)0.0163f, (float)-0.2642f, (float)0.2753f));
        PartDefinition TorsoBase_r1 = S2Body.addOrReplaceChild("TorsoBase_r1", CubeListBuilder.create().texOffs(72, 0).addBox(-3.25f, -1.0f, -3.5f, 6.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5912f, (float)-0.28f, (float)3.724f, (float)0.3018f, (float)0.3762f, (float)0.9521f));
        PartDefinition TorsoTop_r1 = S2Body.addOrReplaceChild("TorsoTop_r1", CubeListBuilder.create().texOffs(0, 72).addBox(-6.0f, -3.5f, -4.0f, 6.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.06f, (float)-0.5945f, (float)5.1262f, (float)0.0839f, (float)0.3706f, (float)-0.4731f));
        PartDefinition Head_r1 = S2Body.addOrReplaceChild("Head_r1", CubeListBuilder.create().texOffs(64, 32).addBox(-5.7273f, -3.9945f, -3.9972f, 7.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.6913f, (float)3.8735f, (float)8.9017f, (float)0.0177f, (float)0.4775f, (float)-1.9376f));
        PartDefinition Jaw2 = S2Body.addOrReplaceChild("Jaw2", CubeListBuilder.create(), PartPose.offset((float)-9.6913f, (float)3.8735f, (float)8.9017f));
        PartDefinition Jaw_r1 = Jaw2.addOrReplaceChild("Jaw_r1", CubeListBuilder.create().texOffs(84, 58).addBox(1.4654f, -4.935f, -4.4731f, 1.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1692f, (float)0.2135f, (float)-1.5004f));
        PartDefinition S2BEye1 = S2Body.addOrReplaceChild("S2BEye1", CubeListBuilder.create().texOffs(40, 0).addBox(-4.0f, -4.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)-8.8654f, (float)-0.0115f, (float)8.4655f, (float)-1.8006f, (float)-0.2651f, (float)-0.8419f));
        PartDefinition pupil2 = S2BEye1.addOrReplaceChild("pupil2", CubeListBuilder.create().texOffs(0, 96).addBox(-2.5f, -2.5f, -1.5f, 5.0f, 5.0f, 3.0f, new CubeDeformation(-1.0f)), PartPose.offset((float)-0.0171f, (float)0.0058f, (float)-4.372f));
        PartDefinition S2BEye2 = S2Body.addOrReplaceChild("S2BEye2", CubeListBuilder.create().texOffs(40, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-2.0f)), PartPose.offsetAndRotation((float)-6.2588f, (float)-2.5802f, (float)4.8005f, (float)0.3054f, (float)-1.1285f, (float)-1.9616f));
        PartDefinition pupil3 = S2BEye2.addOrReplaceChild("pupil3", CubeListBuilder.create().texOffs(94, 32).addBox(-2.5f, -2.5f, -2.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(-1.5f)), PartPose.offset((float)-0.0171f, (float)0.0058f, (float)-1.872f));
        PartDefinition S2BEye3 = S2Body.addOrReplaceChild("S2BEye3", CubeListBuilder.create().texOffs(40, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-1.5f)), PartPose.offsetAndRotation((float)-9.7443f, (float)-0.5509f, (float)5.0106f, (float)-0.8373f, (float)-0.2994f, (float)-1.1975f));
        PartDefinition pupil4 = S2BEye3.addOrReplaceChild("pupil4", CubeListBuilder.create().texOffs(0, 96).addBox(-2.5f, -2.5f, -1.5f, 5.0f, 5.0f, 3.0f, new CubeDeformation(-1.25f)), PartPose.offset((float)-0.0171f, (float)0.0058f, (float)-2.872f));
        PartDefinition T2Tumors = TendrilSeg2.addOrReplaceChild("T2Tumors", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-21.0f, (float)0.0f));
        PartDefinition Tumor_r1 = T2Tumors.addOrReplaceChild("Tumor_r1", CubeListBuilder.create().texOffs(11, 7).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)-0.2133f, (float)-0.5419f, (float)0.364f));
        PartDefinition Tumor_r2 = T2Tumors.addOrReplaceChild("Tumor_r2", CubeListBuilder.create().texOffs(11, 7).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)-0.7418f));
        PartDefinition TendrilSeg3 = TendrilSeg2.addOrReplaceChild("TendrilSeg3", CubeListBuilder.create().texOffs(48, 70).addBox(-2.0f, -24.0f, -1.0f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-20.0f, (float)-0.5f, (float)1.3526f, (float)0.0f, (float)0.0f));
        PartDefinition S3Body = TendrilSeg3.addOrReplaceChild("S3Body", CubeListBuilder.create().texOffs(60, 91).addBox(-3.5f, -20.0f, -4.0f, 6.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Arm_r3 = S3Body.addOrReplaceChild("Arm_r3", CubeListBuilder.create().texOffs(16, 100).addBox(-1.0f, -1.0f, -2.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-23.0f, (float)-1.0f, (float)0.3361f, (float)-0.2071f, (float)0.532f));
        PartDefinition Leg_r2 = S3Body.addOrReplaceChild("Leg_r2", CubeListBuilder.create().texOffs(16, 100).addBox(-2.0f, 0.0f, -2.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-17.0f, (float)-2.0f, (float)0.809f, (float)0.4567f, (float)0.3813f));
        PartDefinition TorsoTop_r2 = S3Body.addOrReplaceChild("TorsoTop_r2", CubeListBuilder.create().texOffs(72, 22).addBox(-3.5f, -5.0f, -2.5f, 7.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-20.0f, (float)-2.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition Head = S3Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(32, 56).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-26.0f, (float)-1.0f, (float)-1.3526f, (float)0.0f, (float)0.0f));
        PartDefinition Jaw = Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(64, 48).addBox(-4.0f, -1.0f, -8.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)4.0f, (float)0.8995f, (float)0.2068f, (float)-0.1617f));
        PartDefinition Eye = Head.addOrReplaceChild("Eye", CubeListBuilder.create().texOffs(40, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)-0.8329f, (float)-0.0762f, (float)-0.4545f, (float)0.67f, (float)0.3266f, (float)0.2978f));
        PartDefinition pupil = Eye.addOrReplaceChild("pupil", CubeListBuilder.create().texOffs(0, 96).addBox(-2.5f, -2.5f, -1.5f, 5.0f, 5.0f, 3.0f, new CubeDeformation(-1.0f)), PartPose.offset((float)-0.0171f, (float)0.0058f, (float)-3.372f));
        PartDefinition Tumors = S3Body.addOrReplaceChild("Tumors", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-22.0f, (float)2.0f));
        PartDefinition Tumor4_r1 = Tumors.addOrReplaceChild("Tumor4_r1", CubeListBuilder.create().texOffs(13, 9).addBox(-1.5f, -1.5f, -1.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.576f, (float)-2.7394f, (float)-1.2357f, (float)-0.0523f, (float)-0.1219f, (float)-0.6044f));
        PartDefinition Tumor3_r1 = Tumors.addOrReplaceChild("Tumor3_r1", CubeListBuilder.create().texOffs(13, 9).addBox(-2.828f, -0.5697f, -1.8499f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1032f, (float)1.7896f, (float)-0.1791f, (float)-0.0523f, (float)-0.1219f, (float)-0.6044f));
        PartDefinition Tumor2_r1 = Tumors.addOrReplaceChild("Tumor2_r1", CubeListBuilder.create().texOffs(13, 9).addBox(-2.641f, -3.7504f, -1.5356f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1032f, (float)1.7896f, (float)-0.1791f, (float)-0.0909f, (float)-0.0967f, (float)-0.2541f));
        PartDefinition Tumor1_r1 = Tumors.addOrReplaceChild("Tumor1_r1", CubeListBuilder.create().texOffs(13, 9).addBox(-2.1541f, -4.1761f, -2.2588f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1032f, (float)1.7896f, (float)-0.1791f, (float)-0.4203f, (float)0.4928f, (float)0.2831f));
        PartDefinition TumorBase = Tendril.addOrReplaceChild("TumorBase", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition SmallTumor4_r1 = TumorBase.addOrReplaceChild("SmallTumor4_r1", CubeListBuilder.create().texOffs(10, 8).addBox(-1.5f, -1.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)1.753f, (float)-7.4215f, (float)2.7383f, (float)-0.1417f, (float)0.484f, (float)0.0763f));
        PartDefinition SmallTumor3_r1 = TumorBase.addOrReplaceChild("SmallTumor3_r1", CubeListBuilder.create().texOffs(10, 8).addBox(-2.25f, -5.25f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.2601f, (float)-10.6429f, (float)0.6574f, (float)0.4273f, (float)-0.0631f, (float)0.0946f));
        PartDefinition SmallTumor2_r1 = TumorBase.addOrReplaceChild("SmallTumor2_r1", CubeListBuilder.create().texOffs(10, 8).addBox(-1.0f, -5.5f, -1.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-7.0f, (float)0.0f, (float)0.0998f, (float)-0.0112f, (float)-0.4707f));
        PartDefinition SmallTumor1_r1 = TumorBase.addOrReplaceChild("SmallTumor1_r1", CubeListBuilder.create().texOffs(10, 8).addBox(-2.0f, -2.0f, -3.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-7.0f, (float)0.0f, (float)-0.3463f, (float)-0.0447f, (float)-0.1231f));
        PartDefinition Tumor5_r1 = TumorBase.addOrReplaceChild("Tumor5_r1", CubeListBuilder.create().texOffs(6, 4).addBox(-2.0f, -5.0f, -4.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5403f, (float)0.9305f, (float)-2.5105f, (float)-0.091f, (float)-0.8041f, (float)-0.7118f));
        PartDefinition Tumor4_r2 = TumorBase.addOrReplaceChild("Tumor4_r2", CubeListBuilder.create().texOffs(6, 4).addBox(-3.0f, -3.0f, -4.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5403f, (float)0.9305f, (float)-2.5105f, (float)-0.091f, (float)0.8041f, (float)0.7118f));
        PartDefinition Tumor3_r2 = TumorBase.addOrReplaceChild("Tumor3_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -3.25f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.3767f, (float)-1.0f, (float)3.8812f, (float)-0.4363f, (float)0.6109f, (float)0.0f));
        PartDefinition Tumor2_r2 = TumorBase.addOrReplaceChild("Tumor2_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -6.25f, 2.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)-0.2282f, (float)-0.3594f, (float)-0.2391f));
        PartDefinition Tumor1_r2 = TumorBase.addOrReplaceChild("Tumor1_r2", CubeListBuilder.create().texOffs(6, 4).addBox(-4.0f, -7.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)0.3054f, (float)0.4363f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void animateEye(ModelPart part, float value) {
        this.animateTentacleX(part, value);
        this.animateTentacleY(part, value);
        this.animateTentacleZ(part, value);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animateTumor(this.TumorBase, Mth.sin((float)(ageInTicks / 6.0f)) / 6.0f);
        this.TendrilSeg1.yRot = netHeadYaw / 57.295776f;
        this.animateTentacleX(this.TendrilSeg2, Mth.sin((float)(ageInTicks / 8.0f)) / 3.0f);
        this.animateTentacleX(this.TendrilSeg3, -Mth.sin((float)(ageInTicks / 8.0f)) / 3.0f);
        this.animateTumor(this.T2Tumors, Mth.cos((float)(ageInTicks / 5.0f)) / 4.0f);
        this.Jaw2.yRot = Mth.cos((float)(ageInTicks / 7.0f)) / 7.0f;
        this.animateEye(this.S2BEye1, Mth.cos((float)(ageInTicks / 3.0f)) / 5.0f);
        this.animateEye(this.S2BEye2, Mth.sin((float)(ageInTicks / 5.0f)) / 6.0f);
        this.animateEye(this.S2BEye3, Mth.cos((float)(ageInTicks / 6.0f)) / 7.0f);
        this.animateTumor(this.Tumors, Mth.cos((float)(ageInTicks / 3.0f)) / 8.0f);
        this.Head.yRot = headPitch / 28.647888f;
        this.animateEye(this.Eye, Mth.sin((float)(ageInTicks / 4.0f)) / 3.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.Tendril.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

