/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.Projectile.FleshBomb;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BileRound<T extends FleshBomb>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"bileround"), "main");
    private final ModelPart BileMissile;
    private final ModelPart Tumor;
    private final ModelPart Tendrils;

    public BileRound() {
        ModelPart root = BileRound.createBodyLayer().bakeRoot();
        this.BileMissile = root.getChild("BileMissile");
        this.Tumor = this.BileMissile.getChild("Tail").getChild("Biomass");
        this.Tendrils = this.BileMissile.getChild("Tail").getChild("Tendrils");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition BileMissile = partdefinition.addOrReplaceChild("BileMissile", CubeListBuilder.create().texOffs(0, 0).addBox(-5.7859f, -7.8591f, -5.8501f, 12.0f, 16.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.2141f, (float)15.8591f, (float)-0.1499f));
        PartDefinition Bile_r1 = BileMissile.addOrReplaceChild("Bile_r1", CubeListBuilder.create().texOffs(36, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.9698f, (float)-2.0944f, (float)3.4616f, (float)0.2877f, (float)-0.5467f, (float)-0.5175f));
        PartDefinition Bile_r2 = BileMissile.addOrReplaceChild("Bile_r2", CubeListBuilder.create().texOffs(36, 0).addBox(-3.0f, -1.0f, -7.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.7859f, (float)0.1409f, (float)0.1499f, (float)-0.2877f, (float)-0.5467f, (float)0.5175f));
        PartDefinition Tail = BileMissile.addOrReplaceChild("Tail", CubeListBuilder.create(), PartPose.offset((float)0.2141f, (float)-7.8591f, (float)0.1499f));
        PartDefinition Biomass2 = Tail.addOrReplaceChild("Biomass", CubeListBuilder.create(), PartPose.offset((float)1.4335f, (float)3.0f, (float)-3.3512f));
        PartDefinition Biomass_r1 = Biomass2.addOrReplaceChild("Biomass_r1", CubeListBuilder.create().texOffs(0, 28).addBox(-3.5f, -3.5f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.9926f, (float)-2.3258f, (float)0.612f, (float)0.3699f, (float)0.7124f, (float)0.2154f));
        PartDefinition Biomass_r2 = Biomass2.addOrReplaceChild("Biomass_r2", CubeListBuilder.create().texOffs(2, 30).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8902f, (float)-2.4341f, (float)6.7892f, (float)-0.1987f, (float)-0.4755f, (float)0.1473f));
        PartDefinition Biomass_r3 = Biomass2.addOrReplaceChild("Biomass_r3", CubeListBuilder.create().texOffs(1, 29).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2826f, (float)-1.3864f, (float)-0.1536f, (float)0.0f, (float)0.5236f, (float)0.3491f));
        PartDefinition Biomass_r4 = Biomass2.addOrReplaceChild("Biomass_r4", CubeListBuilder.create().texOffs(0, 28).addBox(-3.5f, -3.5f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.2467f, (float)-2.5148f, (float)7.8847f, (float)-0.1801f, (float)-0.3913f, (float)0.0164f));
        PartDefinition Tendrils = Tail.addOrReplaceChild("Tendrils", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition root_3 = Tendrils.addOrReplaceChild("root_3", CubeListBuilder.create().texOffs(28, 28).addBox(-1.0f, -8.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8403f, (float)0.6943f, (float)1.558f, (float)0.0f, (float)-0.5672f, (float)0.0f));
        PartDefinition r3seg2 = root_3.addOrReplaceChild("r3seg2", CubeListBuilder.create().texOffs(36, 28).addBox(-1.0f, -9.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0138f, (float)-8.4634f, (float)-0.0145f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition r3seg3 = r3seg2.addOrReplaceChild("r3seg3", CubeListBuilder.create().texOffs(44, 28).addBox(-0.5f, -9.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0815f, (float)-8.5697f, (float)-0.0142f));
        PartDefinition root_2 = Tendrils.addOrReplaceChild("root_2", CubeListBuilder.create().texOffs(28, 28).addBox(-1.0f, -10.5f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0041f, (float)0.6943f, (float)-1.4346f, (float)0.0f, (float)0.5672f, (float)0.0f));
        PartDefinition r2seg2 = root_2.addOrReplaceChild("r2seg2", CubeListBuilder.create().texOffs(36, 28).addBox(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0138f, (float)-10.4634f, (float)-0.0145f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition r2seg3 = r2seg2.addOrReplaceChild("r2seg3", CubeListBuilder.create().texOffs(44, 28).addBox(-0.5f, -11.0f, -0.5f, 1.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0815f, (float)-10.5697f, (float)-0.0142f));
        PartDefinition root_1 = Tendrils.addOrReplaceChild("root_1", CubeListBuilder.create().texOffs(28, 28).addBox(-1.0f, -6.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9959f, (float)0.6943f, (float)1.5654f));
        PartDefinition r1seg2 = root_1.addOrReplaceChild("r1seg2", CubeListBuilder.create().texOffs(36, 28).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0138f, (float)-6.4634f, (float)-0.0145f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition r1seg3 = r1seg2.addOrReplaceChild("r1seg3", CubeListBuilder.create().texOffs(44, 28).addBox(-0.5f, -7.0f, -0.5f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0815f, (float)-6.5697f, (float)-0.0142f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void animateTumor(ModelPart part, float value) {
        part.xScale = 1.0f + Mth.cos((float)(value / 6.0f)) / 6.0f;
        part.yScale = 1.0f + Mth.cos((float)(value / 6.0f)) / 6.0f;
        part.zScale = 1.0f + Mth.cos((float)(value / 6.0f)) / 6.0f;
    }

    private void animateTendril(ModelPart part, float value) {
        part.xRot = Mth.sin((float)(value / 9.0f)) / 2.0f;
        part.yRot = Mth.sin((float)(value / 9.0f)) / 3.0f;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animateTumor(this.Tumor, ageInTicks);
        this.animateTendril(this.Tendrils.getChild("root_3"), ageInTicks);
        this.animateTendril(this.Tendrils.getChild("root_3").getChild("r3seg2"), ageInTicks);
        this.animateTendril(this.Tendrils.getChild("root_3").getChild("r3seg2").getChild("r3seg3"), ageInTicks);
        this.animateTendril(this.Tendrils.getChild("root_2"), ageInTicks);
        this.animateTendril(this.Tendrils.getChild("root_2").getChild("r2seg2"), ageInTicks);
        this.animateTendril(this.Tendrils.getChild("root_2").getChild("r2seg2").getChild("r2seg3"), ageInTicks);
        this.animateTendril(this.Tendrils.getChild("root_1"), ageInTicks);
        this.animateTendril(this.Tendrils.getChild("root_1").getChild("r1seg2"), ageInTicks);
        this.animateTendril(this.Tendrils.getChild("root_1").getChild("r1seg2").getChild("r1seg3"), ageInTicks);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.BileMissile.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

