/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Models.WombModel;
import com.Harbinger.Spore.Client.Models.WombModelStageII;
import com.Harbinger.Spore.Client.Models.WombModelStageIII;
import com.Harbinger.Spore.Client.Special.OrganoidMobRenderer;
import com.Harbinger.Spore.Sentities.Organoids.Womb;
import com.Harbinger.Spore.core.SConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomassReconfiguratorRenderer
extends OrganoidMobRenderer<Womb, EntityModel<Womb>> {
    private final EntityModel<Womb> smallModel = this.getModel();
    private final EntityModel<Womb> mediumModel;
    private final EntityModel<Womb> largeModel;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/womb.png");
    private static final ResourceLocation TEXTURE_LARGE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/entity/womb_large.png");

    public BiomassReconfiguratorRenderer(EntityRendererProvider.Context context) {
        super(context, new WombModel(context.bakeLayer(WombModel.LAYER_LOCATION)), 0.5f);
        this.mediumModel = new WombModelStageII<Womb>(context.bakeLayer(WombModelStageII.LAYER_LOCATION));
        this.largeModel = new WombModelStageIII<Womb>(context.bakeLayer(WombModelStageIII.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(Womb reformator) {
        if (reformator.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 4) {
            return TEXTURE_LARGE;
        }
        return TEXTURE;
    }

    @Override
    public void render(Womb type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int value3) {
        this.model = type.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 4 && type.getBiomass() < (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2 ? this.mediumModel : (type.getBiomass() >= (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2 ? this.largeModel : this.smallModel);
        super.render(type, value1, value2, stack, bufferSource, value3);
    }
}

