/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Braionmil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BraionmilModel<T extends Braionmil>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"braionmil"), "main");
    private final ModelPart body;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart head;
    private final ModelPart tongueM;
    private final ModelPart lungs4;
    private final ModelPart lungs2;

    public BraionmilModel(ModelPart root) {
        this.body = root.getChild("body");
        this.LeftLeg = root.getChild("LeftLeg");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftArm = root.getChild("LeftArm");
        this.RightArm = root.getChild("RightArm");
        this.head = root.getChild("head");
        this.tongueM = root.getChild("tongueM");
        this.lungs4 = root.getChild("lungs4");
        this.lungs2 = root.getChild("lungs2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(22, 21).addBox(-4.5f, 8.0f, -2.0f, 9.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(56, 55).addBox(-9.0f, -16.0f, 3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(56, 55).addBox(-5.0f, -18.0f, 3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)-2.0f, (float)0.3491f, (float)0.0f, (float)0.2182f));
        PartDefinition spine = body.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(32, 29).addBox(-2.0f, -2.5f, -4.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)2.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition back = spine.addOrReplaceChild("back", CubeListBuilder.create().texOffs(58, 22).addBox(0.0f, -2.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back2 = spine.addOrReplaceChild("back2", CubeListBuilder.create().texOffs(58, 16).addBox(-2.0f, -2.0f, -2.25f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition spine2 = body.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, -5.5f, -4.5f, 8.0f, 6.0f, 5.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)1.25f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition back3 = spine2.addOrReplaceChild("back3", CubeListBuilder.create().texOffs(36, 50).addBox(0.0f, -4.0f, -1.75f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back4 = spine2.addOrReplaceChild("back4", CubeListBuilder.create().texOffs(10, 49).addBox(-2.0f, -4.0f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition spine3 = body.addOrReplaceChild("spine3", CubeListBuilder.create().texOffs(27, 9).addBox(-2.0f, -2.5f, -4.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)1.75f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition back5 = spine3.addOrReplaceChild("back5", CubeListBuilder.create().texOffs(54, 37).addBox(0.0f, -2.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back6 = spine3.addOrReplaceChild("back6", CubeListBuilder.create().texOffs(52, 0).addBox(-2.0f, -2.0f, -2.25f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(28, 37).addBox(-2.25f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.9f, (float)12.0f, (float)2.0f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(16, 29).addBox(-2.25f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(12, 39).addBox(-1.75f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.9f, (float)12.0f, (float)2.0f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(0, 32).addBox(-1.75f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(0, 55).addBox(-1.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)3.0f, (float)-1.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r2 = LeftForArm.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(51, 7).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(12, 57).addBox(-2.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)3.0f, (float)-1.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(50, 52).addBox(-2.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -6.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-4.0f, -2.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(21, 17).addBox(-3.0f, -2.0f, -6.0f, 6.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-1.0f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(56, 55).addBox(3.0f, -29.75f, -6.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)23.0f, (float)1.0f, (float)0.0873f, (float)0.0f, (float)-0.3054f));
        PartDefinition cube_r4 = head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(56, 55).addBox(3.0f, -29.75f, -2.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)23.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition cube_r5 = head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(56, 55).addBox(-5.0f, -29.0f, -4.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)23.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition FangJoint = head.addOrReplaceChild("FangJoint", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-2.5f, (float)-2.0f));
        PartDefinition rightfang = FangJoint.addOrReplaceChild("rightfang", CubeListBuilder.create().texOffs(50, 30).addBox(-1.0821f, -0.3905f, -2.733f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(-1.0821f, -1.3905f, -2.733f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 0).addBox(-0.0821f, -1.3905f, -8.733f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(40, 13).addBox(-0.0821f, 1.6095f, -2.733f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-2.0f, (float)0.3491f, (float)0.4363f, (float)0.0f));
        PartDefinition FangJoint2 = head.addOrReplaceChild("FangJoint2", CubeListBuilder.create(), PartPose.offset((float)3.15f, (float)-2.5f, (float)-4.0f));
        PartDefinition rightfang2 = FangJoint2.addOrReplaceChild("rightfang2", CubeListBuilder.create().texOffs(49, 45).addBox(-1.0821f, -0.3905f, -2.733f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0821f, -1.3905f, -2.733f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(26, 11).addBox(-0.0821f, -1.3905f, -8.733f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(24, 1).addBox(-0.0821f, 1.6095f, -2.733f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.3491f, (float)-0.4363f, (float)0.0f));
        PartDefinition flower = head.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.9992f, (float)-13.2654f, (float)10.75f, (float)0.4088f, (float)-0.3229f, (float)0.0491f));
        PartDefinition cube_r6 = flower.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(89, 9).addBox(-1.0f, 0.0f, -19.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r7 = flower.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(81, 0).addBox(-1.0f, 0.0f, -19.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.25f, (float)-6.8632f, (float)1.7179f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = flower.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(61, 0).addBox(-8.0f, 0.0f, -19.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0E-4f, (float)0.7654f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r9 = flower.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(96, 0).addBox(-1.0f, 0.0f, -19.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.25f, (float)5.0f, (float)-4.75f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tongueM = partdefinition.addOrReplaceChild("tongueM", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)-2.0f));
        PartDefinition tongue = tongueM.addOrReplaceChild("tongue", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -0.5f, -6.0f, 4.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition tongueM2 = tongue.addOrReplaceChild("tongueM2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition tongue2 = tongueM2.addOrReplaceChild("tongue2", CubeListBuilder.create().texOffs(39, 11).addBox(-1.5f, -0.5f, -6.0f, 3.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition tongueM3 = tongue2.addOrReplaceChild("tongueM3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition tongue3 = tongueM3.addOrReplaceChild("tongue3", CubeListBuilder.create().texOffs(42, 0).addBox(-1.0f, -0.5f, -6.0f, 2.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition lungs4 = partdefinition.addOrReplaceChild("lungs4", CubeListBuilder.create().texOffs(37, 59).mirror().addBox(-2.0f, 1.0f, -1.0f, 6.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(26, 47).mirror().addBox(-1.5f, 1.5f, 1.0f, 5.0f, 10.0f, 2.0f, new CubeDeformation(0.2f)).mirror(false), PartPose.offsetAndRotation((float)1.25f, (float)-3.0f, (float)0.0f, (float)0.3348f, (float)0.4149f, (float)0.1393f));
        PartDefinition cube_r10 = lungs4.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(56, 55).addBox(-6.0f, -19.0f, 1.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.25f, (float)27.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition cube_r11 = lungs4.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(80, 0).addBox(0.0f, -24.0f, -5.0f, 7.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.25f, (float)27.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition lungs2 = partdefinition.addOrReplaceChild("lungs2", CubeListBuilder.create().texOffs(37, 59).addBox(-4.0f, 1.0f, -1.0f, 6.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(26, 47).addBox(-3.5f, 1.5f, 1.0f, 5.0f, 10.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)-1.25f, (float)-3.0f, (float)0.0f, (float)0.3348f, (float)-0.4149f, (float)-0.1393f));
        PartDefinition cube_r12 = lungs2.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(56, 55).addBox(-3.0f, -20.0f, 1.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.25f, (float)27.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((Braionmil)entity).swinging) {
            this.RightArm.xRot = -90.0f;
            this.LeftArm.xRot = -90.0f;
        } else if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        } else {
            this.RightArm.xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.LeftArm.xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        }
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        if (this.LeftLeg.xRot < 0.0f) {
            this.LeftLeg.getChild((String)"leftForLeg").xRot = -this.LeftLeg.xRot;
        }
        if (this.RightLeg.xRot < 0.0f) {
            this.RightLeg.getChild((String)"rightForLeg").xRot = -this.RightLeg.xRot;
        }
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 28.647888f;
        this.lungs4.zScale = 1.0f + Mth.sin((float)(ageInTicks / 10.0f)) / 10.0f;
        this.lungs4.yScale = 1.0f + Mth.sin((float)(ageInTicks / 10.0f)) / 10.0f;
        this.lungs4.xScale = 1.0f - Mth.sin((float)(ageInTicks / 10.0f)) / 10.0f;
        this.lungs2.zScale = 1.0f + Mth.sin((float)(ageInTicks / 10.0f)) / 10.0f;
        this.lungs2.yScale = 1.0f + Mth.sin((float)(ageInTicks / 10.0f)) / 10.0f;
        this.lungs2.xScale = 1.0f - Mth.sin((float)(ageInTicks / 10.0f)) / 10.0f;
        this.tongueM.xRot = Mth.sin((float)(ageInTicks / 6.0f)) / 6.0f;
        this.tongueM.getChild((String)"tongue").getChild((String)"tongueM2").xRot = Mth.sin((float)(ageInTicks / 6.0f)) / 6.0f;
        this.tongueM.getChild((String)"tongue").getChild((String)"tongueM2").getChild((String)"tongue2").getChild((String)"tongueM3").xRot = Mth.sin((float)(ageInTicks / 6.0f)) / 6.0f;
        this.head.getChild((String)"FangJoint").xRot = Mth.sin((float)(ageInTicks / 7.0f)) / 6.0f;
        this.head.getChild((String)"FangJoint2").xRot = Mth.sin((float)(ageInTicks / 6.0f)) / 8.0f;
        this.head.getChild((String)"FangJoint").yRot = Mth.sin((float)(ageInTicks / 6.0f)) / 7.0f;
        this.head.getChild((String)"FangJoint2").yRot = Mth.sin((float)(ageInTicks / 6.0f)) / 6.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.tongueM.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.lungs4.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.lungs2.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

