/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Busser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BusserModel<T extends Busser>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"bussermodel"), "main");
    private final ModelPart busser;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart rightArm;
    private final ModelPart rightForearm;
    private final ModelPart leftArm;
    private final ModelPart leftForearm;
    private final ModelPart tail;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart tail4;
    private final ModelPart tailClaws;
    private final ModelPart tailClaws2;
    private static final float ARM_SCALE = 1.65f;
    private static final float TAIL_BASE_ROTATION = -0.3f;
    private static final float SWIMMING_TAIL_X_ROT = 0.4f;

    public BusserModel(ModelPart root) {
        this.busser = root.getChild("busser");
        this.head = this.busser.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.rightArm = this.busser.getChild("RightArm");
        this.rightForearm = this.rightArm.getChild("RightForArm");
        this.leftArm = this.busser.getChild("LeftArm");
        this.leftForearm = this.leftArm.getChild("LeftForArm");
        this.tail = this.busser.getChild("Tail");
        this.tail2 = this.tail.getChild("Tail2");
        this.tail3 = this.tail2.getChild("Tail3");
        this.tail4 = this.tail3.getChild("Tail4");
        this.tailClaws = this.tail.getChild("claws");
        this.tailClaws2 = this.tail.getChild("claws2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition busser = partdefinition.addOrReplaceChild("busser", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)25.0f, (float)-4.0f));
        PartDefinition Tail = busser.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(32, 0).addBox(-3.0f, 0.0f, -1.75f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-13.0f, (float)2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail.addOrReplaceChild("Tail2", CubeListBuilder.create().texOffs(52, 0).addBox(-2.5f, 0.0f, -1.25f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition Tail3 = Tail2.addOrReplaceChild("Tail3", CubeListBuilder.create().texOffs(52, 0).addBox(-2.5f, 0.0f, -1.25f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition Tail4 = Tail3.addOrReplaceChild("Tail4", CubeListBuilder.create().texOffs(52, 0).addBox(-1.5f, 0.0f, -1.25f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)6.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Claw = Tail4.addOrReplaceChild("Claw", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)9.0f, (float)0.0f));
        PartDefinition cube_r1 = Claw.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 70).addBox(1.0f, -4.0f, -3.0f, 0.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition cube_r2 = Claw.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 88).addBox(-1.0f, -4.0f, -3.0f, 0.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition claws = Tail.addOrReplaceChild("claws", CubeListBuilder.create().texOffs(96, -6).addBox(0.0f, 0.0f, -4.0f, 0.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition claws2 = Tail.addOrReplaceChild("claws2", CubeListBuilder.create().texOffs(114, -7).addBox(0.0f, 0.0f, -4.0f, 0.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition flower5 = Tail.addOrReplaceChild("flower5", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.75f, (float)2.25f, (float)0.0f, (float)-1.309f, (float)-0.3491f, (float)0.0f));
        PartDefinition cube_r3 = flower5.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(74, 6).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r4 = flower5.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(74, 6).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r5 = flower5.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = flower5.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head = busser.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(-0.01f)).texOffs(18, 35).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(38, 37).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-25.0f, (float)-3.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(40, 26).addBox(-3.5f, 0.0f, -3.75f, 7.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition flower2 = head.addOrReplaceChild("flower2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.75f, (float)-5.75f, (float)-3.0f, (float)0.6981f, (float)0.0f, (float)0.4363f));
        PartDefinition cube_r7 = flower2.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(74, 6).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r8 = flower2.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(74, 6).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r9 = flower2.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = flower2.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition flower3 = head.addOrReplaceChild("flower3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.25f, (float)-5.75f, (float)1.0f, (float)-0.1309f, (float)0.0f, (float)-0.5672f));
        PartDefinition cube_r11 = flower3.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(74, 6).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r12 = flower3.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(74, 6).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r13 = flower3.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r14 = flower3.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition flower4 = head.addOrReplaceChild("flower4", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.75f, (float)-6.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = flower4.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(74, 6).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r16 = flower4.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(74, 6).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r17 = flower4.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r18 = flower4.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = busser.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(57, 9).addBox(-2.0f, -1.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(58, 32).addBox(-1.5f, 2.0f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-1.0f, -1.0f, 1.0f, 0.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-23.0f, (float)0.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)-0.5f, (float)6.75f, (float)0.0f));
        PartDefinition cube_r19 = RightForArm.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(46, 36).addBox(0.01f, -5.0f, -0.25f, 0.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)3.25f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r20 = RightForArm.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(22, 14).addBox(0.0f, 0.0f, 0.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition RightHand = RightForArm.addOrReplaceChild("RightHand", CubeListBuilder.create().texOffs(34, 60).addBox(0.0f, -0.25f, -0.75f, 1.0f, 7.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)-1.0f, (float)5.75f, (float)0.0f));
        PartDefinition cube_r21 = RightHand.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(30, 60).addBox(0.0f, 0.0f, -1.75f, 1.0f, 7.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r22 = RightHand.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(8, 53).addBox(0.0f, 0.0f, -0.25f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r23 = RightHand.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(0, 3).addBox(0.5f, -4.0f, -5.0f, 0.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = busser.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(59, 40).addBox(-1.0f, -1.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(20, 60).addBox(-0.5f, 2.0f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(14, 34).addBox(1.0f, -1.0f, 1.0f, 0.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-23.0f, (float)0.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.5f, (float)6.75f, (float)0.0f));
        PartDefinition cube_r24 = LeftForArm.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(42, 46).addBox(1.01f, -5.0f, -0.25f, 0.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)3.25f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r25 = LeftForArm.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(22, 26).addBox(0.0f, 0.0f, 0.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition LeftHand = LeftForArm.addOrReplaceChild("LeftHand", CubeListBuilder.create().texOffs(42, 60).addBox(0.0f, -0.25f, -0.75f, 1.0f, 7.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)5.75f, (float)0.0f));
        PartDefinition cube_r26 = LeftHand.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(38, 60).addBox(0.0f, 0.0f, -1.75f, 1.0f, 7.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r27 = LeftHand.addOrReplaceChild("cube_r27", CubeListBuilder.create().texOffs(46, 60).addBox(0.0f, 0.0f, -0.25f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r28 = LeftHand.addOrReplaceChild("cube_r28", CubeListBuilder.create().texOffs(0, 14).addBox(0.5f, -4.0f, -5.0f, 0.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition body = busser.addOrReplaceChild("body", CubeListBuilder.create().texOffs(50, 19).addBox(-3.0f, 10.0f, -1.75f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)-25.0f, (float)2.0f));
        PartDefinition cube_r29 = body.addOrReplaceChild("cube_r29", CubeListBuilder.create().texOffs(0, 49).addBox(0.0f, -1.0f, 0.0f, 0.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition spine = body.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(28, 42).addBox(-2.0f, -2.5f, -4.5f, 4.0f, 5.0f, 5.0f, new CubeDeformation(-0.5f)).texOffs(22, 26).addBox(-3.0f, -4.5f, -5.2f, 6.0f, 3.0f, 6.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)2.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition back = spine.addOrReplaceChild("back", CubeListBuilder.create().texOffs(8, 56).addBox(0.0f, -4.0f, -2.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back2 = spine.addOrReplaceChild("back2", CubeListBuilder.create().texOffs(54, 46).addBox(-1.0f, -4.0f, -2.25f, 2.0f, 6.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition spine2 = body.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(22, 14).addBox(-4.0f, -5.5f, -5.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)1.25f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition back3 = spine2.addOrReplaceChild("back3", CubeListBuilder.create().texOffs(44, 10).addBox(0.0f, -4.0f, -2.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back4 = spine2.addOrReplaceChild("back4", CubeListBuilder.create().texOffs(0, 44).addBox(-3.0f, -4.0f, -2.25f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition flower = body.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.75f, (float)2.25f, (float)0.0f, (float)-1.1345f, (float)-0.3491f, (float)0.1309f));
        PartDefinition cube_r30 = flower.addOrReplaceChild("cube_r30", CubeListBuilder.create().texOffs(74, 6).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r31 = flower.addOrReplaceChild("cube_r31", CubeListBuilder.create().texOffs(74, 6).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r32 = flower.addOrReplaceChild("cube_r32", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r33 = flower.addOrReplaceChild("cube_r33", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupArmScaling();
        this.setupHeadAnimations(headPitch, ageInTicks);
        this.setupTailClawAnimations(ageInTicks);
        if (entity.isInFluidType()) {
            this.handleSwimmingAnimations(entity, limbSwing, limbSwingAmount, ageInTicks);
        } else {
            this.handleLandAnimations(entity, limbSwing, limbSwingAmount, ageInTicks);
        }
    }

    private void setupArmScaling() {
        this.rightArm.xScale = 1.65f;
        this.rightArm.yScale = 1.65f;
        this.rightArm.zScale = 1.65f;
        this.leftArm.xScale = 1.65f;
        this.leftArm.yScale = 1.65f;
        this.leftArm.zScale = 1.65f;
    }

    private void setupHeadAnimations(float headPitch, float ageInTicks) {
        this.head.xRot = headPitch / 28.647888f;
        this.jaw.xRot = Mth.sin((float)(ageInTicks * 0.125f)) * 0.1f;
    }

    private void setupTailClawAnimations(float ageInTicks) {
        this.tailClaws.xRot = Mth.sin((float)(ageInTicks * 0.25f)) * 0.333f;
        this.tailClaws2.xRot = Mth.sin((float)(ageInTicks * 0.25f)) * 0.5f;
    }

    private void handleSwimmingAnimations(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.setupSwimmingTailAnimations(limbSwing, limbSwingAmount);
        this.setupSwimmingArmAnimations(ageInTicks);
    }

    private void setupSwimmingTailAnimations(float limbSwing, float limbSwingAmount) {
        float tailMovement;
        this.tail.yRot = tailMovement = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.tail2.yRot = tailMovement;
        this.tail3.yRot = tailMovement;
        this.tail4.yRot = tailMovement;
        this.tail.xRot = 0.4f;
        this.tail2.xRot = 0.4f;
        this.tail3.xRot = 0.4f;
        this.tail4.xRot = 0.4f;
    }

    private void setupSwimmingArmAnimations(float ageInTicks) {
        float armWave = Mth.sin((float)(ageInTicks * 0.2f)) * 0.166f;
        float forearmWave = Mth.sin((float)(ageInTicks * 0.333f)) * 0.142f;
        this.rightArm.zRot = armWave;
        this.leftArm.zRot = -armWave;
        if (Mth.sin((float)(ageInTicks * 0.333f)) < 0.0f) {
            this.rightForearm.zRot = forearmWave;
            this.leftForearm.zRot = -forearmWave;
        } else {
            this.resetForearmRotations();
        }
    }

    private void handleLandAnimations(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.resetTailYRotations();
        this.setupLandArmAnimations(ageInTicks);
        this.setupLandTailAnimations(entity, ageInTicks);
    }

    private void resetTailYRotations() {
        this.tail.yRot = 0.0f;
        this.tail2.yRot = 0.0f;
        this.tail3.yRot = 0.0f;
        this.tail4.yRot = 0.0f;
    }

    private void setupLandArmAnimations(float ageInTicks) {
        float armBaseRotation = 1.1f;
        float armWave = Mth.sin((float)(ageInTicks * 0.333f));
        float forearmWave = Mth.sin((float)(ageInTicks * 0.333f)) * 0.5f;
        this.rightArm.zRot = armBaseRotation + armWave;
        this.leftArm.zRot = -armBaseRotation - armWave;
        if (Mth.sin((float)(ageInTicks * 0.333f)) < 0.0f) {
            this.rightForearm.zRot = forearmWave;
            this.leftForearm.zRot = -forearmWave;
        } else {
            this.resetForearmRotations();
        }
    }

    private void setupLandTailAnimations(T entity, float ageInTicks) {
        float tailSway = Mth.sin((float)(ageInTicks * 0.333f)) * 0.166f;
        if (entity.isVehicle()) {
            this.tail.xRot = 0.0f;
            this.tail2.xRot = 0.0f;
            this.tail3.xRot = 0.0f;
        } else {
            this.tail.xRot = -0.3f + tailSway;
            this.tail2.xRot = -0.3f + tailSway;
            this.tail3.xRot = -0.3f + tailSway;
        }
        this.tail4.xRot = -0.3f + tailSway;
    }

    private void resetForearmRotations() {
        this.rightForearm.zRot = 0.0f;
        this.leftForearm.zRot = 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.busser.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

