/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class DrownedScamperModel<T extends Scamper>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"drownedscampermodel"), "main");
    private final ModelPart body;
    private final ModelPart LeftLeg;
    private final ModelPart leftForLeg;
    private final ModelPart Fin;
    private final ModelPart RightLeg;
    private final ModelPart rightForLeg;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart head;
    private final ModelPart mound1;
    private final ModelPart mound2;
    private final ModelPart mound3;

    public DrownedScamperModel(ModelPart root) {
        this.body = root.getChild("body");
        this.LeftLeg = root.getChild("LeftLeg");
        this.leftForLeg = this.LeftLeg.getChild("leftForLeg");
        this.Fin = root.getChild("Fin");
        this.RightLeg = root.getChild("RightLeg");
        this.rightForLeg = this.RightLeg.getChild("rightForLeg");
        this.LeftArm = root.getChild("LeftArm");
        this.RightArm = root.getChild("RightArm");
        this.head = root.getChild("head");
        this.mound1 = root.getChild("mound1");
        this.mound2 = root.getChild("mound2");
        this.mound3 = root.getChild("mound3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 42).addBox(-4.0f, 8.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.1f)).texOffs(31, 12).addBox(-1.0f, 4.0f, 0.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)2.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(57, 61).addBox(-4.0f, -16.0f, -1.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)22.0f, (float)-2.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(32, 13).addBox(2.0f, -17.0f, 1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)22.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(31, 13).addBox(-2.0f, -23.0f, 6.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)22.0f, (float)-2.0f, (float)0.2233f, (float)-0.2129f, (float)-0.0479f));
        PartDefinition spine = body.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(42, 20).addBox(-2.0f, -4.5f, -4.5f, 4.0f, 5.0f, 5.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)2.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition back2 = spine.addOrReplaceChild("back2", CubeListBuilder.create().texOffs(62, 0).addBox(-1.0f, -4.0f, -2.25f, 2.0f, 4.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition spine2 = body.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(0, 23).addBox(-4.0f, -5.5f, -4.5f, 8.0f, 6.0f, 5.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)1.25f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition back3 = spine2.addOrReplaceChild("back3", CubeListBuilder.create().texOffs(58, 16).addBox(0.0f, -4.0f, -1.75f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back4 = spine2.addOrReplaceChild("back4", CubeListBuilder.create().texOffs(48, 12).addBox(-2.0f, -4.0f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(12, 53).addBox(-1.25f, 0.0f, -1.75f, 3.0f, 6.0f, 3.5f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)2.0f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(48, 49).addBox(-1.25f, 0.0f, -1.75f, 3.0f, 6.0f, 3.5f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition Fin = partdefinition.addOrReplaceChild("Fin", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)11.7351f, (float)3.045f));
        PartDefinition Fin_r1 = Fin.addOrReplaceChild("Fin_r1", CubeListBuilder.create().texOffs(0, 86).addBox(-0.01f, -3.6955f, -9.5307f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)8.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(26, 53).addBox(-1.75f, -2.0f, -1.75f, 3.0f, 6.0f, 3.5f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)14.0f, (float)2.0f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(52, 39).addBox(-1.75f, 0.0f, -1.75f, 3.0f, 6.0f, 3.5f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(60, 24).addBox(-1.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)4.0f, (float)0.0f));
        PartDefinition Plane_r1 = LeftArm.addOrReplaceChild("Plane_r1", CubeListBuilder.create().texOffs(4, 88).addBox(-3.0f, -3.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.25f, (float)1.25f, (float)4.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r4 = LeftForArm.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(40, 59).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(60, 24).addBox(-2.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)4.0f, (float)0.0f));
        PartDefinition Plane_r2 = RightArm.addOrReplaceChild("Plane_r2", CubeListBuilder.create().texOffs(4, 88).addBox(-3.0f, -3.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.75f, (float)1.25f, (float)4.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(40, 59).addBox(-2.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(42, 6).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(74, 1).addBox(-4.0f, -1.92f, -4.0f, 8.0f, 4.0f, 5.0f, new CubeDeformation(0.04f)).texOffs(23, -1).addBox(-4.25f, -3.0f, -4.25f, 8.5f, 1.0f, 4.25f, new CubeDeformation(0.04f)), PartPose.offset((float)0.0f, (float)4.5f, (float)-2.5f));
        PartDefinition cube_r5 = head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(57, 61).addBox(-6.0475f, -1.0863f, -1.3418f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)2.5f, (float)0.0436f, (float)-0.3491f, (float)-0.2618f));
        PartDefinition cube_r6 = head.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(58, 61).addBox(-4.0f, -24.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.5f, (float)2.5f, (float)-0.0873f, (float)1.0036f, (float)0.1309f));
        PartDefinition cube_r7 = head.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(31, 12).addBox(-1.0f, -26.0f, 2.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.5f, (float)2.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition flower2 = head.addOrReplaceChild("flower2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.5f, (float)-6.5f, (float)-0.5f, (float)0.238f, (float)-0.3148f, (float)-0.0403f));
        PartDefinition cube_r8 = flower2.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(35, 68).addBox(-4.0406f, 0.0f, 0.0f, 7.0711f, 0.0f, 6.061f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = flower2.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(35, 68).addBox(0.0f, 0.0f, -3.0305f, 6.061f, 0.0f, 6.061f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5051f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r10 = flower2.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(35, 68).addBox(-4.0406f, 0.0f, -6.061f, 7.0711f, 0.0f, 6.061f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r11 = flower2.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(35, 68).addBox(-6.061f, 0.0f, -3.0305f, 6.061f, 0.0f, 6.061f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5051f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition flower = head.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.5f, (float)-6.0f, (float)0.5f, (float)0.6655f, (float)-0.2266f, (float)0.3196f));
        PartDefinition cube_r12 = flower.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(56, 61).addBox(-5.52f, 0.0f, 0.0f, 9.66f, 0.0f, 8.28f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = flower.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(56, 61).addBox(0.0f, 0.0f, -4.14f, 8.28f, 0.0f, 8.28f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.69f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r14 = flower.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(56, 61).addBox(-5.52f, 0.0f, -8.28f, 9.66f, 0.0f, 8.28f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = flower.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(56, 61).addBox(-8.28f, 0.0f, -4.14f, 8.28f, 0.0f, 8.28f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.69f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition flower3 = head.addOrReplaceChild("flower3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.5f, (float)-6.5f, (float)0.5f, (float)-0.9553f, (float)-0.2449f, (float)0.2404f));
        PartDefinition cube_r16 = flower3.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(35, 68).addBox(-4.0406f, 0.0f, 0.0f, 7.0711f, 0.0f, 6.061f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r17 = flower3.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(35, 68).addBox(0.0f, 0.0f, -3.0305f, 6.061f, 0.0f, 6.061f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5051f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r18 = flower3.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(35, 68).addBox(-4.0406f, 0.0f, -6.061f, 7.0711f, 0.0f, 6.061f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r19 = flower3.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(35, 68).addBox(-6.061f, 0.0f, -3.0305f, 6.061f, 0.0f, 6.061f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5051f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition mound1 = partdefinition.addOrReplaceChild("mound1", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0f, (float)6.0f, (float)2.0f, (float)-0.3491f, (float)0.0f, (float)0.3491f));
        PartDefinition body2 = mound1.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(0, 74).addBox(-2.0f, -6.0f, -15.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 66).addBox(-1.5f, -7.0f, -14.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)13.0f));
        PartDefinition cube_r20 = body2.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(12, 80).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-13.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition mound2 = partdefinition.addOrReplaceChild("mound2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)9.0f, (float)2.0f, (float)-0.4363f, (float)0.0f, (float)-0.48f));
        PartDefinition body3 = mound2.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(0, 74).addBox(-2.0f, -6.0f, -15.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 66).addBox(-1.5f, -7.0f, -14.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)13.0f));
        PartDefinition cube_r21 = body3.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(12, 80).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-13.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition mound3 = partdefinition.addOrReplaceChild("mound3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)10.25f, (float)2.0f, (float)0.9599f, (float)0.48f, (float)0.0f));
        PartDefinition body4 = mound3.addOrReplaceChild("body4", CubeListBuilder.create().texOffs(0, 74).addBox(-2.0f, -6.0f, -15.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 66).addBox(-1.5f, -7.0f, -14.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)13.0f));
        PartDefinition cube_r22 = body4.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(12, 80).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-13.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void animateMound(ModelPart part, float value) {
        part.xScale = 1.0f + value;
        part.zScale = 1.0f + value;
        part.yScale = 1.0f - value;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isAggressive()) {
            if (((Scamper)entity).swinging) {
                this.RightArm.xRot = -89.5f;
                this.LeftArm.xRot = -89.5f;
            } else {
                this.RightArm.xRot = -90.0f - Mth.sin((float)(ageInTicks / 4.0f)) / 7.0f;
                this.LeftArm.xRot = -90.0f + Mth.sin((float)(ageInTicks / 4.0f)) / 7.0f;
            }
        } else if (!(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.15f)) {
            this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
            this.RightArm.zRot = 0.0f;
            this.LeftArm.zRot = 0.0f;
        } else {
            this.RightArm.xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.LeftArm.xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        }
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 28.647888f;
        this.LeftLeg.xRot = Mth.cos((float)limbSwing) * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)limbSwing) * -limbSwingAmount;
        if (this.LeftLeg.xRot < 0.0f) {
            this.leftForLeg.xRot = -this.LeftLeg.xRot;
        }
        if (this.RightLeg.xRot < 0.0f) {
            this.rightForLeg.xRot = -this.RightLeg.xRot;
        }
        this.animateMound(this.mound1, Mth.sin((float)(ageInTicks / 8.0f)) / 9.0f);
        this.animateMound(this.mound2, Mth.sin((float)(ageInTicks / 8.0f)) / 8.0f);
        this.animateMound(this.mound3, Mth.sin((float)(ageInTicks / 8.0f)) / 7.0f);
        if (entity.isInFluidType()) {
            this.Fin.yRot = Mth.sin((float)(ageInTicks / 6.0f)) / 6.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.Fin.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.mound1.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.mound2.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.mound3.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

