/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ElytrumModel<T extends LivingEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"elytrummodel"), "main");
    public final ModelPart body;
    private final ModelPart leftJoint;
    private final ModelPart left_wing;
    private final ModelPart left_for_wing;
    private final ModelPart rightJoint;
    private final ModelPart right_wing;
    private final ModelPart right_for_wing;

    public ElytrumModel() {
        ModelPart root = ElytrumModel.createBodyLayer().bakeRoot();
        this.body = root.getChild("body");
        this.leftJoint = this.body.getChild("leftJoint");
        this.left_wing = this.leftJoint.getChild("left_wing");
        this.left_for_wing = this.left_wing.getChild("left_for_wing");
        this.rightJoint = this.body.getChild("rightJoint");
        this.right_wing = this.rightJoint.getChild("right_wing");
        this.right_for_wing = this.right_wing.getChild("right_for_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftJoint = body.addOrReplaceChild("leftJoint", CubeListBuilder.create(), PartPose.offset((float)-5.0f, (float)-3.0f, (float)3.0f));
        PartDefinition left_wing = leftJoint.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(28, 0).addBox(-7.25f, -1.0f, -1.0f, 17.0f, 14.0f, 1.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)6.75f, (float)2.0f, (float)-0.25f, (float)-3.1416f, (float)0.0f, (float)-2.7925f));
        PartDefinition left_for_wing = left_wing.addOrReplaceChild("left_for_wing", CubeListBuilder.create().texOffs(18, 44).addBox(-12.25f, -7.0f, 0.01f, 17.0f, 20.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)12.0f, (float)-1.0f));
        PartDefinition rightJoint = body.addOrReplaceChild("rightJoint", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)-3.0f, (float)3.0f));
        PartDefinition right_wing = rightJoint.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(28, 23).addBox(-9.75f, -1.0f, -0.95f, 17.0f, 14.0f, 1.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)-6.75f, (float)2.0f, (float)-0.25f, (float)-3.1416f, (float)0.0f, (float)2.7925f));
        PartDefinition right_for_wing = right_wing.addOrReplaceChild("right_for_wing", CubeListBuilder.create().texOffs(1, 44).addBox(-4.25f, -7.0f, 0.06f, 17.0f, 20.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.5f, (float)12.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void animatedElytra(T entity, ModelPart rightWing, ModelPart leftWing) {
        float f = 0.2617994f;
        float f1 = -0.2617994f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (entity.isFallFlying()) {
            float f4 = 1.0f;
            Vec3 vec3 = entity.getDeltaMovement();
            if (vec3.y < 0.0) {
                Vec3 vec31 = vec3.normalize();
                f4 = 1.0f - (float)Math.pow(-vec31.y, 1.5);
            }
            f = f4 * 0.34906584f + (1.0f - f4) * f;
            f1 = f4 * -1.5707964f + (1.0f - f4) * f1;
        } else if (entity.isCrouching()) {
            f = 0.6981317f;
            f1 = -0.7853982f;
            f2 = 3.0f;
            f3 = 0.08726646f;
        }
        leftWing.y = f2;
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)entity;
            abstractclientplayer.elytraRotX += (f - abstractclientplayer.elytraRotX) * 0.1f;
            abstractclientplayer.elytraRotY += (f3 - abstractclientplayer.elytraRotY) * 0.1f;
            abstractclientplayer.elytraRotZ += (f1 - abstractclientplayer.elytraRotZ) * 0.1f;
            leftWing.xRot = abstractclientplayer.elytraRotX;
            leftWing.yRot = abstractclientplayer.elytraRotY;
            leftWing.zRot = abstractclientplayer.elytraRotZ;
        } else {
            leftWing.xRot = f;
            leftWing.zRot = f1;
            leftWing.yRot = f3;
        }
        rightWing.yRot = -leftWing.yRot;
        rightWing.y = leftWing.y;
        rightWing.xRot = leftWing.xRot;
        rightWing.zRot = -leftWing.zRot;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animatedElytra(entity, this.leftJoint, this.rightJoint);
        this.right_for_wing.zRot = this.rightJoint.zRot / 2.0f;
        this.left_for_wing.zRot = this.leftJoint.zRot / 2.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

