/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Busser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ExplodingBusserModel<T extends Busser>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"explodingbussermodel"), "main");
    private final ModelPart busser;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart body;
    private final ModelPart bodyTumors;
    private final ModelPart rightArm;
    private final ModelPart rightForearm;
    private final ModelPart leftArm;
    private final ModelPart leftForearm;
    private final ModelPart tail;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart tail4;
    private final ModelPart tailClaws;
    private final ModelPart tailClaws2;
    private final ModelPart tailTumor;
    private final ModelPart payload;
    private static final float ARM_SCALE = 1.65f;
    private static final float SWIMMING_TAIL_X_ROT = 0.4f;
    private static final float LAND_TAIL_BASE_ROT = -0.3f;

    public ExplodingBusserModel(ModelPart root) {
        this.busser = root.getChild("busser");
        this.head = this.busser.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.body = this.busser.getChild("body");
        this.bodyTumors = this.body.getChild("BodyTumors");
        this.rightArm = this.busser.getChild("RightArm");
        this.rightForearm = this.rightArm.getChild("RightForArm");
        this.leftArm = this.busser.getChild("LeftArm");
        this.leftForearm = this.leftArm.getChild("LeftForArm");
        this.tail = this.busser.getChild("Tail");
        this.tail2 = this.tail.getChild("Tail2");
        this.tail3 = this.tail2.getChild("Tail3");
        this.tail4 = this.tail3.getChild("Tail4");
        this.tailClaws = this.tail.getChild("claws");
        this.tailClaws2 = this.tail.getChild("claws2");
        this.tailTumor = this.tail.getChild("tailTumor");
        this.payload = this.tail4.getChild("Payload");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition busser = partdefinition.addOrReplaceChild("busser", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)25.0f, (float)-4.0f));
        PartDefinition Tail = busser.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(32, 0).addBox(-3.0f, 0.0f, -1.75f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-13.0f, (float)2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tailTumor = Tail.addOrReplaceChild("tailTumor", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition TailTumor_r1 = tailTumor.addOrReplaceChild("TailTumor_r1", CubeListBuilder.create().texOffs(5, 68).addBox(0.5f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.2f, (float)2.5f, (float)0.1966f, (float)0.4407f, (float)0.4369f));
        PartDefinition TailTumor_r2 = tailTumor.addOrReplaceChild("TailTumor_r2", CubeListBuilder.create().texOffs(7, 69).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)-1.0f, (float)-0.5841f, (float)0.5692f, (float)-0.4181f));
        PartDefinition Tail2 = Tail.addOrReplaceChild("Tail2", CubeListBuilder.create().texOffs(52, 0).addBox(-2.5f, 0.0f, -1.25f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition TailTumor_r3 = Tail2.addOrReplaceChild("TailTumor_r3", CubeListBuilder.create().texOffs(6, 69).addBox(-3.9f, -0.9f, -4.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.9f, (float)2.7f, (float)1.5f, (float)0.3274f, (float)0.6801f, (float)0.1412f));
        PartDefinition Tail3 = Tail2.addOrReplaceChild("Tail3", CubeListBuilder.create().texOffs(52, 0).addBox(-2.499f, 0.0f, -1.25f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition Tail4 = Tail3.addOrReplaceChild("Tail4", CubeListBuilder.create().texOffs(52, 0).addBox(-1.5f, 0.0f, -1.25f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)6.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Payload = Tail4.addOrReplaceChild("Payload", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)6.0f, (float)0.0f));
        PartDefinition PayloadTumor_r1 = Payload.addOrReplaceChild("PayloadTumor_r1", CubeListBuilder.create().texOffs(5, 68).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)-0.1461f, (float)-2.9007f, (float)2.969f, (float)-1.2401f, (float)0.9768f, (float)-0.2677f));
        PartDefinition PayloadTumor_r2 = Payload.addOrReplaceChild("PayloadTumor_r2", CubeListBuilder.create().texOffs(5, 68).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.9964f, (float)-2.5165f, (float)-1.6017f, (float)-1.4297f, (float)0.926f, (float)-0.4669f));
        PartDefinition PayloadTumor_r3 = Payload.addOrReplaceChild("PayloadTumor_r3", CubeListBuilder.create().texOffs(5, 67).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)-1.3256f, (float)0.3451f, (float)0.9507f, (float)-0.6565f, (float)0.5975f, (float)-0.0604f));
        PartDefinition PayloadTumor_r4 = Payload.addOrReplaceChild("PayloadTumor_r4", CubeListBuilder.create().texOffs(5, 67).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-3.2527f, (float)-2.0338f, (float)1.7426f, (float)-0.8282f, (float)0.6479f, (float)0.394f));
        PartDefinition PayloadTumor_r5 = Payload.addOrReplaceChild("PayloadTumor_r5", CubeListBuilder.create().texOffs(5, 67).addBox(-2.1f, -2.3f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)1.5f, (float)-0.5f, (float)1.5f, (float)-0.3369f, (float)-0.1841f, (float)-0.2906f));
        PartDefinition claws = Tail.addOrReplaceChild("claws", CubeListBuilder.create().texOffs(96, -6).addBox(0.0f, 0.0f, -4.0f, 0.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition claws2 = Tail.addOrReplaceChild("claws2", CubeListBuilder.create().texOffs(114, -7).addBox(0.0f, 0.0f, -4.0f, 0.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition flower5 = Tail.addOrReplaceChild("flower5", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.75f, (float)2.25f, (float)0.0f, (float)-1.309f, (float)-0.3491f, (float)0.0f));
        PartDefinition cube_r1 = flower5.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(74, 6).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r2 = flower5.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(74, 6).addBox(-3.8f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.389f, (float)-2.0719f, (float)2.0f, (float)0.0f, (float)-0.4363f, (float)-0.3927f));
        PartDefinition cube_r3 = flower5.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.2f, 0.7f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = flower5.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head = busser.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(-0.01f)).texOffs(18, 35).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(38, 37).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-25.0f, (float)-3.0f));
        PartDefinition HeadTumor_r1 = head.addOrReplaceChild("HeadTumor_r1", CubeListBuilder.create().texOffs(5, 70).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)3.159f, (float)-7.1507f, (float)2.3093f, (float)0.1276f, (float)-0.5576f, (float)-0.6808f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(40, 26).addBox(-3.5f, 0.0f, -3.75f, 7.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition flower2 = head.addOrReplaceChild("flower2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.75f, (float)-5.75f, (float)-3.0f, (float)0.6981f, (float)0.0f, (float)0.4363f));
        PartDefinition cube_r5 = flower2.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(74, 6).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r6 = flower2.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(74, 6).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r7 = flower2.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = flower2.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition flower3 = head.addOrReplaceChild("flower3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.25f, (float)-5.75f, (float)1.0f, (float)-0.1309f, (float)0.0f, (float)-0.5672f));
        PartDefinition cube_r9 = flower3.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(74, 6).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r10 = flower3.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(74, 6).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r11 = flower3.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = flower3.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition flower4 = head.addOrReplaceChild("flower4", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.75f, (float)-6.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = flower4.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(74, 6).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r14 = flower4.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(74, 6).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r15 = flower4.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r16 = flower4.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = busser.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(57, 9).addBox(-2.0f, -1.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(58, 32).addBox(-1.5f, 2.0f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-1.0f, -1.0f, 1.0f, 0.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-23.0f, (float)0.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)-0.5f, (float)6.75f, (float)0.0f));
        PartDefinition MiddleRightWing_r1 = RightForArm.addOrReplaceChild("MiddleRightWing_r1", CubeListBuilder.create().texOffs(46, 36).addBox(0.01f, -5.0f, -0.25f, 0.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)3.25f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r17 = RightForArm.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(22, 14).addBox(0.0f, 0.0f, 0.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition RightHand = RightForArm.addOrReplaceChild("RightHand", CubeListBuilder.create().texOffs(34, 60).addBox(0.0f, -0.25f, -0.75f, 1.0f, 7.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)-1.0f, (float)5.75f, (float)0.0f));
        PartDefinition cube_r18 = RightHand.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(30, 60).addBox(0.0f, 0.0f, -1.75f, 1.0f, 7.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r19 = RightHand.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(8, 53).addBox(0.0f, 0.0f, -0.25f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition BottomRightWing_r1 = RightHand.addOrReplaceChild("BottomRightWing_r1", CubeListBuilder.create().texOffs(0, 3).addBox(0.5f, -4.0f, -5.0f, 0.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = busser.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(59, 40).addBox(-1.0f, -1.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(58, 32).addBox(-0.5f, 2.0f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(1.0f, -1.0f, 1.0f, 0.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-23.0f, (float)0.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.5f, (float)6.75f, (float)0.0f));
        PartDefinition MiddleLeftWing_r1 = LeftForArm.addOrReplaceChild("MiddleLeftWing_r1", CubeListBuilder.create().texOffs(46, 36).addBox(1.01f, -5.0f, -0.25f, 0.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)3.25f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r20 = LeftForArm.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(22, 14).addBox(0.0f, 0.0f, 0.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition LeftHand = LeftForArm.addOrReplaceChild("LeftHand", CubeListBuilder.create().texOffs(34, 60).addBox(0.0f, -0.25f, -0.75f, 1.0f, 7.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)5.75f, (float)0.0f));
        PartDefinition cube_r21 = LeftHand.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(30, 60).addBox(0.0f, 0.0f, -1.75f, 1.0f, 7.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r22 = LeftHand.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(8, 53).addBox(0.0f, 0.0f, -0.25f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition BottomLeftWing_r1 = LeftHand.addOrReplaceChild("BottomLeftWing_r1", CubeListBuilder.create().texOffs(0, 3).addBox(0.5f, -4.0f, -5.0f, 0.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition body = busser.addOrReplaceChild("body", CubeListBuilder.create().texOffs(50, 19).addBox(-3.0f, 10.0f, -1.75f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)-25.0f, (float)2.0f));
        PartDefinition SpineRidge_r1 = body.addOrReplaceChild("SpineRidge_r1", CubeListBuilder.create().texOffs(0, 49).addBox(0.0f, -1.0f, 0.0f, 0.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition spine = body.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(28, 42).addBox(-2.0f, -2.5f, -4.5f, 4.0f, 5.0f, 5.0f, new CubeDeformation(-0.5f)).texOffs(22, 26).addBox(-3.0f, -4.5f, -5.2f, 6.0f, 3.0f, 6.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)2.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition back = spine.addOrReplaceChild("back", CubeListBuilder.create().texOffs(8, 56).addBox(0.0f, -4.0f, -2.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back2 = spine.addOrReplaceChild("back2", CubeListBuilder.create().texOffs(54, 46).addBox(-1.0f, -4.0f, -2.25f, 2.0f, 6.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition spine2 = body.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(22, 14).addBox(-4.0f, -5.5f, -5.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)1.25f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition back3 = spine2.addOrReplaceChild("back3", CubeListBuilder.create().texOffs(44, 10).addBox(0.0f, -4.0f, -2.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back4 = spine2.addOrReplaceChild("back4", CubeListBuilder.create().texOffs(0, 44).addBox(-3.0f, -4.0f, -2.25f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition BodyTumors = body.addOrReplaceChild("BodyTumors", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition Tumor_r1 = BodyTumors.addOrReplaceChild("Tumor_r1", CubeListBuilder.create().texOffs(4, 68).addBox(-1.0f, 2.0f, -7.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(2, 66).addBox(-3.0f, -3.0f, -6.6f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-2.0f, (float)1.0f, (float)4.0f, (float)-0.4363f, (float)-0.48f, (float)0.0f));
        PartDefinition flower = body.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.75f, (float)2.25f, (float)0.0f, (float)-1.1345f, (float)-0.3491f, (float)0.1309f));
        PartDefinition cube_r23 = flower.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(74, 6).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r24 = flower.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(74, 6).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r25 = flower.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r26 = flower.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupArmScaling();
        this.setupHeadAnimations(headPitch, ageInTicks);
        this.setupTailClawAnimations(ageInTicks);
        this.setupTumorAnimations(ageInTicks);
        if (entity.onGround() || entity.isInFluidType()) {
            this.handleGroundOrSwimmingAnimations(entity, limbSwing, limbSwingAmount, ageInTicks);
        } else {
            this.handleAirborneAnimations(entity, limbSwing, limbSwingAmount, ageInTicks);
        }
    }

    private void setupArmScaling() {
        this.rightArm.xScale = 1.65f;
        this.rightArm.yScale = 1.65f;
        this.rightArm.zScale = 1.65f;
        this.leftArm.xScale = 1.65f;
        this.leftArm.yScale = 1.65f;
        this.leftArm.zScale = 1.65f;
    }

    private void setupHeadAnimations(float headPitch, float ageInTicks) {
        this.head.xRot = headPitch / 28.647888f;
        this.jaw.xRot = Mth.sin((float)(ageInTicks * 0.125f)) * 0.1f;
    }

    private void setupTailClawAnimations(float ageInTicks) {
        this.tailClaws.xRot = Mth.sin((float)(ageInTicks * 0.25f)) * 0.333f;
        this.tailClaws2.xRot = Mth.sin((float)(ageInTicks * 0.25f)) * 0.5f;
    }

    private void setupTumorAnimations(float ageInTicks) {
        this.setupBodyTumorAnimations(ageInTicks);
        this.setupPayloadAnimations(ageInTicks);
        this.setupTailTumorAnimations(ageInTicks);
    }

    private void setupBodyTumorAnimations(float ageInTicks) {
        this.bodyTumors.xScale = 1.0f + Mth.sin((float)(ageInTicks * 0.166f)) * 0.2f;
        this.bodyTumors.yScale = 1.0f - Mth.sin((float)(ageInTicks * 0.142f)) * 0.125f;
        this.bodyTumors.zScale = 1.0f + Mth.sin((float)(ageInTicks * 0.166f)) * 0.125f;
    }

    private void setupPayloadAnimations(float ageInTicks) {
        this.payload.xScale = 1.0f + Mth.sin((float)(ageInTicks * 0.2f)) * 0.25f;
        this.payload.yScale = 1.0f + Mth.sin((float)(ageInTicks * 0.166f)) * 0.142f;
        this.payload.zScale = 1.0f + Mth.sin((float)(ageInTicks * 0.166f)) * 0.2f;
    }

    private void setupTailTumorAnimations(float ageInTicks) {
        this.tailTumor.xScale = 1.0f - Mth.sin((float)(ageInTicks * 0.166f)) * 0.2f;
        this.tailTumor.yScale = 1.0f + Mth.sin((float)(ageInTicks * 0.166f)) * 0.2f;
        this.tailTumor.zScale = 1.0f - Mth.sin((float)(ageInTicks * 0.166f)) * 0.2f;
    }

    private void handleGroundOrSwimmingAnimations(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.setupMovingTailAnimations(limbSwing, limbSwingAmount);
        this.setupGroundArmAnimations(ageInTicks);
    }

    private void setupMovingTailAnimations(float limbSwing, float limbSwingAmount) {
        float tailMovement;
        this.tail.yRot = tailMovement = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.tail2.yRot = tailMovement;
        this.tail3.yRot = tailMovement;
        this.tail4.yRot = tailMovement;
        this.tail.xRot = 0.4f;
        this.tail2.xRot = 0.4f;
        this.tail3.xRot = 0.4f;
        this.tail4.xRot = 0.4f;
    }

    private void setupGroundArmAnimations(float ageInTicks) {
        float armWave = Mth.sin((float)(ageInTicks * 0.2f)) * 0.166f;
        float forearmWave = Mth.sin((float)(ageInTicks * 0.333f)) * 0.142f;
        this.rightArm.zRot = armWave;
        this.leftArm.zRot = -armWave;
        if (Mth.sin((float)(ageInTicks * 0.333f)) < 0.0f) {
            this.rightForearm.zRot = forearmWave;
            this.leftForearm.zRot = -forearmWave;
        } else {
            this.resetForearmRotations();
        }
    }

    private void handleAirborneAnimations(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.resetTailYRotations();
        this.setupAirborneArmAnimations(ageInTicks);
        this.setupAirborneTailAnimations(entity, ageInTicks);
    }

    private void resetTailYRotations() {
        this.tail.yRot = 0.0f;
        this.tail2.yRot = 0.0f;
        this.tail3.yRot = 0.0f;
        this.tail4.yRot = 0.0f;
    }

    private void setupAirborneArmAnimations(float ageInTicks) {
        float armBaseRotation = 1.1f;
        float armWave = Mth.sin((float)(ageInTicks * 0.333f));
        float forearmWave = Mth.sin((float)(ageInTicks * 0.333f)) * 0.5f;
        this.rightArm.zRot = armBaseRotation + armWave;
        this.leftArm.zRot = -armBaseRotation - armWave;
        if (Mth.sin((float)(ageInTicks * 0.333f)) < 0.0f) {
            this.rightForearm.zRot = forearmWave;
            this.leftForearm.zRot = -forearmWave;
        } else {
            this.resetForearmRotations();
        }
    }

    private void setupAirborneTailAnimations(T entity, float ageInTicks) {
        float tailSway = Mth.sin((float)(ageInTicks * 0.333f)) * 0.166f;
        if (entity.isVehicle()) {
            this.setupRidingTailAnimation(tailSway);
        } else {
            this.setupSwayingTailAnimation(tailSway);
        }
    }

    private void setupRidingTailAnimation(float tailSway) {
        this.tail.xRot = 0.0f;
        this.tail2.xRot = 0.0f;
        this.tail3.xRot = 0.0f;
        this.tail4.xRot = -0.3f + tailSway;
    }

    private void setupSwayingTailAnimation(float tailSway) {
        this.tail.xRot = -0.3f + tailSway;
        this.tail2.xRot = -0.3f + tailSway;
        this.tail3.xRot = -0.3f + tailSway;
        this.tail4.xRot = -0.3f + tailSway;
    }

    private void resetForearmRotations() {
        this.rightForearm.zRot = 0.0f;
        this.leftForearm.zRot = 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.busser.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

