/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Griefer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GrieferModel<T extends Griefer>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"griefermodel"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart belly;
    private final ModelPart tumor;
    private final ModelPart tumor2;
    private final ModelPart tumor3;
    private final ModelPart tumor4;

    public GrieferModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
        this.belly = root.getChild("belly");
        this.tumor = root.getChild("tumor");
        this.tumor2 = root.getChild("tumor2");
        this.tumor3 = root.getChild("tumor3");
        this.tumor4 = root.getChild("tumor4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-4.5f, 10.0f, -2.0f, 10.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-5.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(-8, 96).addBox(-6.0f, -22.0f, -4.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)29.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 18).addBox(-4.5f, -7.5f, -2.5f, 10.0f, 9.0f, 7.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -1.0f, 11.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-3.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 24).addBox(-4.0f, -4.0f, -9.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(48, 50).addBox(-4.0f, 2.0f, -5.0f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(60, 45).addBox(-4.0f, 2.0f, -9.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)-3.25f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.0f, (float)-5.0f));
        PartDefinition cube_r4 = jaw.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(48, 50).addBox(-3.75f, -1.0f, -3.5f, 7.5f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition flower2 = head.addOrReplaceChild("flower2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-5.75f, (float)0.4361f, (float)-0.0094f, (float)0.0426f));
        PartDefinition cube_r5 = flower2.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(102, 0).addBox(0.0f, 0.0f, -3.84f, 7.68f, 0.0f, 7.68f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r6 = flower2.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(102, 0).addBox(-7.68f, 0.0f, -3.84f, 7.68f, 0.0f, 7.68f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r7 = flower2.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(102, 0).addBox(-5.12f, 0.0f, -7.68f, 8.96f, 0.0f, 7.68f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.64f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = flower2.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(102, 0).addBox(-5.12f, 0.0f, 0.0f, 8.96f, 0.0f, 7.68f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.64f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition flower3 = head.addOrReplaceChild("flower3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-5.75f, (float)0.3035f, (float)-0.0227f, (float)0.1731f));
        PartDefinition cube_r9 = flower3.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(74, 0).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r10 = flower3.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(74, 0).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r11 = flower3.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = flower3.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(63, 64).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.5f, (float)-5.0f, (float)-3.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(0, 69).addBox(-2.0f, 0.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(36, 64).addBox(-1.0f, -2.0f, -2.5f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.5f, (float)-5.0f, (float)-2.25f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create().texOffs(68, 52).addBox(-1.0f, 0.0f, -2.5f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 57).addBox(-2.75f, -1.0f, -2.0f, 4.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.15f, (float)12.0f, (float)0.75f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(18, 59).addBox(-2.75f, 0.0f, -2.0f, 4.0f, 6.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(49, 56).addBox(-1.25f, -1.0f, -2.0f, 4.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.15f, (float)12.0f, (float)0.75f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(57, 19).addBox(-1.25f, 0.0f, -2.0f, 4.0f, 6.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition belly = partdefinition.addOrReplaceChild("belly", CubeListBuilder.create().texOffs(52, 0).addBox(-4.0f, -3.0f, -1.0f, 8.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)-2.0f));
        PartDefinition cube_r13 = belly.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(-8, 96).addBox(-7.0f, -24.0f, -9.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)18.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition tumor = partdefinition.addOrReplaceChild("tumor", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-7.0f, (float)0.0f));
        PartDefinition cube_r14 = tumor.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(-8, 96).addBox(-6.0f, -31.0f, -2.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)31.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.2618f));
        PartDefinition cube_r15 = tumor.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(-8, 96).addBox(-7.0f, -33.0f, -11.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)31.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition cube_r16 = tumor.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(-8, 96).addBox(-1.0f, -34.0f, -11.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)31.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r17 = tumor.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(0, 80).addBox(-12.0f, -36.0f, -6.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)31.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition tumor2 = partdefinition.addOrReplaceChild("tumor2", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-8.0f, (float)-3.0f));
        PartDefinition cube_r18 = tumor2.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(-8, 96).addBox(-7.0f, -33.0f, -5.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)32.0f, (float)3.0f, (float)0.1739f, (float)0.0151f, (float)-0.0859f));
        PartDefinition cube_r19 = tumor2.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(0, 80).addBox(-2.0f, -34.0f, -12.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)32.0f, (float)3.0f, (float)-0.2164f, (float)-0.0283f, (float)-0.1278f));
        PartDefinition cube_r20 = tumor2.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(0, 80).addBox(-2.0f, -36.0f, -15.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)32.0f, (float)3.0f, (float)-0.1745f, (float)0.0f, (float)-0.0873f));
        PartDefinition flower = tumor2.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0f, (float)-2.0f, (float)2.0f, (float)-0.637f, (float)-0.1678f, (float)-0.374f));
        PartDefinition cube_r21 = flower.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(74, 0).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r22 = flower.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(74, 0).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r23 = flower.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r24 = flower.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(74, 0).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tumor3 = partdefinition.addOrReplaceChild("tumor3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)2.0f));
        PartDefinition cube_r25 = tumor3.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(0, 80).addBox(-12.0f, -27.0f, -4.0f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)28.0f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r26 = tumor3.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(-8, 96).addBox(-4.0f, -26.0f, -3.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)28.0f, (float)-2.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r27 = tumor3.addOrReplaceChild("cube_r27", CubeListBuilder.create().texOffs(0, 80).addBox(-1.0f, -21.0f, -25.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)28.0f, (float)-2.0f, (float)-0.9581f, (float)-0.0283f, (float)-0.1278f));
        PartDefinition tumor4 = partdefinition.addOrReplaceChild("tumor4", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)-3.0f));
        PartDefinition cube_r28 = tumor4.addOrReplaceChild("cube_r28", CubeListBuilder.create().texOffs(-8, 96).addBox(-1.0f, -20.0f, -9.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition cube_r29 = tumor4.addOrReplaceChild("cube_r29", CubeListBuilder.create().texOffs(0, 80).addBox(-4.0f, -24.0f, 0.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)3.0f, (float)0.2597f, (float)-0.0338f, (float)0.1265f));
        PartDefinition cube_r30 = tumor4.addOrReplaceChild("cube_r30", CubeListBuilder.create().texOffs(0, 80).addBox(1.0f, -25.0f, -9.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)3.0f, (float)-0.1309f, (float)0.0f, (float)-0.2182f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isAggressive()) {
            if (((Griefer)entity).swinging) {
                this.RightArm.xRot = -89.0f;
                this.LeftArm.xRot = -89.0f;
            } else {
                this.RightArm.xRot = -89.5f - Mth.sin((float)(ageInTicks / 4.0f)) / 7.0f;
                this.LeftArm.xRot = -89.5f + Mth.sin((float)(ageInTicks / 4.0f)) / 7.0f;
            }
        } else if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        } else {
            this.RightArm.xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.LeftArm.xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.LeftLeg.xRot = 0.0f;
            this.RightLeg.xRot = 0.0f;
        }
        if (((Griefer)entity).grieferExplosion()) {
            this.head.yRot = Mth.cos((float)(ageInTicks / 4.0f)) / 4.0f;
            this.tumor.xScale += 5.0E-4f * (float)((Griefer)entity).getSwell();
            this.tumor.yScale += 5.0E-4f * (float)((Griefer)entity).getSwell();
            this.tumor.zScale += 5.0E-4f * (float)((Griefer)entity).getSwell();
            this.tumor2.xScale += 5.0E-4f * (float)((Griefer)entity).getSwell();
            this.tumor2.yScale += 5.0E-4f * (float)((Griefer)entity).getSwell();
            this.tumor2.zScale += 5.0E-4f * (float)((Griefer)entity).getSwell();
            this.tumor3.xScale += 5.0E-4f * (float)((Griefer)entity).getSwell();
            this.tumor3.yScale += 5.0E-4f * (float)((Griefer)entity).getSwell();
            this.tumor3.zScale += 5.0E-4f * (float)((Griefer)entity).getSwell();
        } else {
            this.tumor.xScale = 1.0f + Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.tumor.yScale = 1.0f - Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.tumor.zScale = 1.0f + Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.tumor2.xScale = 1.0f + Mth.sin((float)(ageInTicks / 6.0f)) / 7.0f;
            this.tumor2.yScale = 1.0f - Mth.sin((float)(ageInTicks / 6.0f)) / 7.0f;
            this.tumor2.zScale = 1.0f + Mth.sin((float)(ageInTicks / 6.0f)) / 7.0f;
            this.tumor3.xScale = 1.0f + Mth.sin((float)(ageInTicks / 7.0f)) / 9.0f;
            this.tumor3.yScale = 1.0f - Mth.sin((float)(ageInTicks / 7.0f)) / 9.0f;
            this.tumor3.zScale = 1.0f + Mth.sin((float)(ageInTicks / 7.0f)) / 9.0f;
            this.tumor4.xScale = 1.0f + Mth.sin((float)(ageInTicks / 8.0f)) / 9.0f;
            this.tumor4.yScale = 1.0f - Mth.sin((float)(ageInTicks / 8.0f)) / 9.0f;
            this.tumor4.zScale = 1.0f + Mth.sin((float)(ageInTicks / 8.0f)) / 9.0f;
        }
        this.head.xRot = headPitch / 28.647888f;
        this.head.getChild((String)"jaw").xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        if (this.LeftLeg.xRot < 0.0f) {
            this.LeftLeg.getChild((String)"leftForLeg").xRot = -this.LeftLeg.xRot;
        }
        if (this.RightLeg.xRot < 0.0f) {
            this.RightLeg.getChild((String)"rightForLeg").xRot = -this.RightLeg.xRot;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.belly.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.tumor.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.tumor2.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.tumor3.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.tumor4.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

