/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Special.BlockEntityModel;
import com.Harbinger.Spore.SBlockEntities.IncubatorBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class IncubatorModel<T extends IncubatorBlockEntity>
extends BlockEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"incubator"), "main");
    private final ModelPart incubator;
    private final ModelPart Juice;
    private final ModelPart Glass;
    private final ModelPart Piston;
    private final ModelPart Piston1;

    public IncubatorModel() {
        ModelPart root = IncubatorModel.createBodyLayer().bakeRoot();
        this.incubator = root.getChild("incubator");
        this.Juice = this.incubator.getChild("Juicy");
        this.Glass = this.incubator.getChild("Glass");
        this.Piston = this.incubator.getChild("Top").getChild("SideTubes").getChild("NorthTubes");
        this.Piston1 = this.incubator.getChild("Top").getChild("SideTubes").getChild("SouthTubes");
    }

    @Override
    public void setupAnim(T entity, float ageInTicks) {
        this.Glass.visible = false;
        this.Juice.visible = false;
        if (((IncubatorBlockEntity)entity).isActive()) {
            this.Piston.yScale = 1.0f + Mth.cos((float)(ageInTicks / 6.0f)) / 6.0f;
            this.Piston1.yScale = 1.0f - Mth.cos((float)(ageInTicks / 6.0f)) / 6.0f;
        } else {
            this.Piston.yScale = 1.0f;
            this.Piston1.yScale = 1.0f;
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition incubator = partdefinition.addOrReplaceChild("incubator", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -2.0f, -8.0f, 16.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(6.0f, -11.0f, -8.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-8.0f, -11.0f, -8.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-8.0f, -11.0f, 6.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(6.0f, -11.0f, 6.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Glass = incubator.addOrReplaceChild("Glass", CubeListBuilder.create().texOffs(48, 0).addBox(-6.0f, -11.0f, -7.0f, 12.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(48, 0).addBox(-6.0f, -11.0f, 7.0f, 12.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition WestPane_r1 = Glass.addOrReplaceChild("WestPane_r1", CubeListBuilder.create().texOffs(48, 0).addBox(-6.0f, -5.0f, -7.0f, 12.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(48, 0).addBox(-6.0f, -5.0f, 7.0f, 12.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition Juicy = incubator.addOrReplaceChild("Juicy", CubeListBuilder.create().texOffs(0, 18).addBox(-6.5f, -9.01f, -6.5f, 13.0f, 9.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition Top = incubator.addOrReplaceChild("Top", CubeListBuilder.create().texOffs(6, 6).addBox(-8.0f, -2.0f, -5.0f, 3.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(19, 6).addBox(5.0f, -2.0f, -5.0f, 3.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(13, 13).addBox(-8.0f, -2.0f, -8.0f, 16.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(45, 27).addBox(6.0f, -3.0f, -5.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(45, 27).addBox(6.0f, -3.0f, 3.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-11.0f, (float)0.0f));
        PartDefinition TopBase_r1 = Top.addOrReplaceChild("TopBase_r1", CubeListBuilder.create().texOffs(13, 13).mirror().addBox(-8.0f, -1.0f, -1.5f, 16.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)6.5f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition Hatch = Top.addOrReplaceChild("Hatch", CubeListBuilder.create().texOffs(39, 18).addBox(-11.0f, -1.0f, -6.0f, 12.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-2.0f, (float)0.0f));
        PartDefinition Handle = Hatch.addOrReplaceChild("Handle", CubeListBuilder.create().texOffs(39, 18).addBox(-1.0f, -0.6667f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(39, 18).addBox(-0.5f, -0.6667f, 1.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(39, 18).addBox(-0.5f, -0.6667f, -4.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(39, 18).addBox(-4.0f, -0.6667f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(39, 18).addBox(1.0f, -0.6667f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-2.0f, (float)-0.3333f));
        PartDefinition HandleRod_r1 = Handle.addOrReplaceChild("HandleRod_r1", CubeListBuilder.create().texOffs(39, 18).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.8333f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition Wheel = Handle.addOrReplaceChild("Wheel", CubeListBuilder.create().texOffs(39, 18).addBox(-1.5f, -8.6667f, -4.1833f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)).texOffs(39, 18).addBox(3.15f, -8.6667f, -8.8333f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.05f)).texOffs(39, 18).addBox(-1.5f, -8.6667f, -11.4833f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)).texOffs(39, 18).addBox(-4.15f, -8.6667f, -8.8333f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.05f)), PartPose.offset((float)0.0f, (float)8.0f, (float)7.3333f));
        PartDefinition WheelCornerSE_r1 = Wheel.addOrReplaceChild("WheelCornerSE_r1", CubeListBuilder.create().texOffs(39, 18).addBox(2.75f, -0.5f, -2.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(39, 18).addBox(-3.75f, -0.5f, -2.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0048f, (float)-8.1567f, (float)-7.3235f, (float)0.0f, (float)2.3562f, (float)0.0f));
        PartDefinition WheelCornerSE_r2 = Wheel.addOrReplaceChild("WheelCornerSE_r2", CubeListBuilder.create().texOffs(39, 18).addBox(-7.25f, -0.5f, -2.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(39, 18).addBox(-0.75f, -0.5f, -2.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.4797f, (float)-8.1567f, (float)-9.7983f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition SideTubes = Top.addOrReplaceChild("SideTubes", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition NorthTubes = SideTubes.addOrReplaceChild("NorthTubes", CubeListBuilder.create().texOffs(0, 45).addBox(-3.0f, -3.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 45).addBox(1.0f, -3.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0607f, (float)-5.9393f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition SouthTubes = SideTubes.addOrReplaceChild("SouthTubes", CubeListBuilder.create().texOffs(0, 45).addBox(-5.0f, -3.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 45).addBox(3.0f, -3.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0607f, (float)5.9393f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Vial1 = SideTubes.addOrReplaceChild("Vial1", CubeListBuilder.create().texOffs(0, 18).addBox(-2.0f, -1.0f, -2.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(-0.1f)).texOffs(15, 19).addBox(-1.5f, -4.5f, -1.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 0).addBox(-1.5f, -4.0f, -1.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.1f)).texOffs(0, 18).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)-6.0f, (float)2.1f, (float)-1.0f));
        PartDefinition Vial2 = SideTubes.addOrReplaceChild("Vial2", CubeListBuilder.create().texOffs(0, 18).addBox(-2.0f, -1.0f, -2.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(-0.1f)).texOffs(15, 19).addBox(-1.5f, -4.5f, -1.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 0).addBox(-1.5f, -4.0f, -1.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.1f)).texOffs(0, 18).mirror().addBox(-2.0f, -5.0f, -2.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(-0.1f)).mirror(false), PartPose.offset((float)-5.5f, (float)3.1f, (float)3.0f));
        PartDefinition Display = incubator.addOrReplaceChild("Display", CubeListBuilder.create().texOffs(0, 11).addBox(-1.4997f, -0.3247f, -1.5003f, 3.0f, 1.0f, 3.0f, new CubeDeformation(-0.4f)).texOffs(16, 14).addBox(0.5003f, -0.5247f, -1.5003f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.4f)).texOffs(16, 14).addBox(-1.4997f, -0.5247f, -1.5003f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.4f)).texOffs(16, 16).addBox(-1.5007f, -0.5257f, -1.4993f, 3.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).texOffs(16, 16).addBox(-1.5007f, -0.5257f, 0.5007f, 3.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-7.0003f, (float)-7.6753f, (float)-8.1497f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition Needle = Display.addOrReplaceChild("Needle", CubeListBuilder.create().texOffs(45, 27).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)3.0E-4f, (float)0.0853f, (float)-0.8503f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.incubator.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

