/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.Utility.InfEvoClaw;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class InfEvoClawModel<T extends InfEvoClaw>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"infevoclawmodel"), "main");
    private final ModelPart baseJoint;
    private final ModelPart middleF;
    private final ModelPart middleF2;
    private final ModelPart middleF3;
    private final ModelPart[] fingerT = new ModelPart[4];
    private final ModelPart[] fingerG = new ModelPart[4];

    public InfEvoClawModel(ModelPart root) {
        this.baseJoint = root.getChild("baseJoint");
        ModelPart base = this.baseJoint.getChild("base");
        this.middleF = base.getChild("middleF");
        this.middleF2 = this.middleF.getChild("middleF2");
        this.middleF3 = this.middleF2.getChild("middleF3");
        this.fingerT[0] = base.getChild("fingerT");
        this.fingerT[1] = base.getChild("fingerT2");
        this.fingerT[2] = base.getChild("fingerT3");
        this.fingerT[3] = base.getChild("fingerT4");
        this.fingerG[0] = this.fingerT[0].getChild("jointT").getChild("fingerG");
        this.fingerG[1] = this.fingerT[1].getChild("jointT2").getChild("fingerG2");
        this.fingerG[2] = this.fingerT[2].getChild("jointT3").getChild("fingerG3");
        this.fingerG[3] = this.fingerT[3].getChild("jointT4").getChild("fingerG4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition baseJoint = partdefinition.addOrReplaceChild("baseJoint", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)7.0f));
        PartDefinition base = baseJoint.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 15).addBox(-1.5f, -6.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.25f, (float)0.0f, (float)-1.5708f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r1 = base.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(10, 9).addBox(-1.5f, -6.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition middleF = base.addOrReplaceChild("middleF", CubeListBuilder.create().texOffs(10, 0).addBox(-1.5f, -5.75f, -1.25f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)1.0f));
        PartDefinition middleF2 = middleF.addOrReplaceChild("middleF2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition cube_r2 = middleF2.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(12, 18).addBox(-1.0f, -5.75f, -1.25f, 2.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition middleF3 = middleF2.addOrReplaceChild("middleF3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition cube_r3 = middleF3.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 20).addBox(0.0f, -5.75f, -1.25f, 0.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition fingerT = base.addOrReplaceChild("fingerT", CubeListBuilder.create(), PartPose.offset((float)1.25f, (float)-7.0f, (float)0.0f));
        PartDefinition jointT = fingerT.addOrReplaceChild("jointT", CubeListBuilder.create().texOffs(32, 9).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition fingerG = jointT.addOrReplaceChild("fingerG", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jointG = fingerG.addOrReplaceChild("jointG", CubeListBuilder.create().texOffs(0, 31).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition claw = jointG.addOrReplaceChild("claw", CubeListBuilder.create().texOffs(8, 25).addBox(0.0f, -6.0f, -1.0f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition fingerT2 = base.addOrReplaceChild("fingerT2", CubeListBuilder.create(), PartPose.offset((float)1.25f, (float)-11.0f, (float)1.0f));
        PartDefinition jointT2 = fingerT2.addOrReplaceChild("jointT2", CubeListBuilder.create().texOffs(30, 0).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.829f));
        PartDefinition fingerG2 = jointT2.addOrReplaceChild("fingerG2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jointG2 = fingerG2.addOrReplaceChild("jointG2", CubeListBuilder.create().texOffs(28, 25).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition claw2 = jointG2.addOrReplaceChild("claw2", CubeListBuilder.create().texOffs(22, 22).addBox(0.0f, -6.0f, -1.0f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition fingerT3 = base.addOrReplaceChild("fingerT3", CubeListBuilder.create(), PartPose.offset((float)-0.75f, (float)-10.75f, (float)1.0f));
        PartDefinition jointT3 = fingerT3.addOrReplaceChild("jointT3", CubeListBuilder.create().texOffs(28, 16).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0036f));
        PartDefinition fingerG3 = jointT3.addOrReplaceChild("fingerG3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jointG3 = fingerG3.addOrReplaceChild("jointG3", CubeListBuilder.create().texOffs(14, 28).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition claw3 = jointG3.addOrReplaceChild("claw3", CubeListBuilder.create().texOffs(22, 15).addBox(0.0f, -6.0f, -1.0f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition fingerT4 = base.addOrReplaceChild("fingerT4", CubeListBuilder.create(), PartPose.offset((float)-0.75f, (float)-5.75f, (float)0.0f));
        PartDefinition jointT4 = fingerT4.addOrReplaceChild("jointT4", CubeListBuilder.create().texOffs(22, 9).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1781f));
        PartDefinition fingerG4 = jointT4.addOrReplaceChild("fingerG4", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jointG4 = fingerG4.addOrReplaceChild("jointG4", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition claw4 = jointG4.addOrReplaceChild("claw4", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -7.0f, -2.0f, 0.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float middleRotation;
        float sinTime = Mth.sin((float)(ageInTicks * 0.125f));
        float baseRotation = sinTime * 0.1667f;
        float fingerRotation = sinTime * 0.125f;
        this.middleF.xRot = middleRotation = baseRotation * 0.5f;
        this.middleF2.xRot = middleRotation * 1.1f;
        this.middleF3.xRot = middleRotation * 1.2f;
        float[] yRotations = new float[]{baseRotation, baseRotation, -baseRotation, -baseRotation};
        float[] zRotations = new float[]{-fingerRotation * 0.75f, -fingerRotation * 0.875f, fingerRotation * 1.125f, -fingerRotation * 0.75f};
        float[] fingerYRotations = new float[]{baseRotation, baseRotation, -baseRotation, -baseRotation};
        for (int i = 0; i < 4; ++i) {
            this.fingerT[i].yRot = yRotations[i];
            this.fingerT[i].zRot = zRotations[i];
            this.fingerG[i].yRot = fingerYRotations[i];
        }
        float secondaryWave = Mth.cos((float)(ageInTicks * 0.2f)) * 0.05f;
        this.middleF.xRot += secondaryWave;
        this.middleF2.xRot += secondaryWave * 0.8f;
        this.middleF3.xRot += secondaryWave * 0.6f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.baseJoint.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

