/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.BasicInfected.InfectedDrowned;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class InfectedDrownModel<T extends InfectedDrowned>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"infecteddrownmodel"), "main");
    private final ModelPart Body;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart leftForeleg;
    private final ModelPart rightForeleg;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart ear;
    private final ModelPart ear2;
    private final ModelPart tendril;
    private final ModelPart tendril2;
    private final ModelPart tendril3;
    private final ModelPart tendril4;
    private final ModelPart tendril5;
    private final ModelPart tendril6;
    private static final float WALK_THRESHOLD = 0.15f;
    private static final float ARM_WALK_SPEED = 0.8f;
    private static final float LEG_WALK_SPEED = 0.8f;
    private static final float IDLE_ARM_SPEED = 0.125f;
    private static final float AGGRESSIVE_ARM_SPEED = 0.25f;
    private static final float BASE_AGGRESSIVE_ARM_ROT = -89.5f;

    public InfectedDrownModel(ModelPart root) {
        this.Body = root.getChild("Body");
        this.RightArm = this.Body.getChild("RightArm");
        this.LeftArm = this.Body.getChild("LeftArm");
        this.LeftLeg = this.Body.getChild("LeftLeg");
        this.RightLeg = this.Body.getChild("RightLeg");
        this.leftForeleg = this.LeftLeg.getChild("leftForLeg");
        this.rightForeleg = this.RightLeg.getChild("rightForLeg");
        this.head = this.Body.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.ear = this.head.getChild("ear");
        this.ear2 = this.head.getChild("ear2");
        this.tendril = this.Body.getChild("tendril");
        this.tendril2 = this.Body.getChild("tendril2");
        this.tendril3 = this.Body.getChild("tendril3");
        this.tendril4 = this.Body.getChild("tendril4");
        this.tendril5 = this.RightLeg.getChild("tendril5");
        this.tendril6 = this.LeftLeg.getChild("tendril6");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(22, 21).addBox(-4.0f, 8.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)2.0f, (float)2.0f));
        PartDefinition spine = Body.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -4.5f, -4.5f, 4.0f, 5.0f, 5.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)2.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition back = spine.addOrReplaceChild("back", CubeListBuilder.create().texOffs(42, 23).addBox(0.0f, -4.0f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back2 = spine.addOrReplaceChild("back2", CubeListBuilder.create().texOffs(38, 41).addBox(-2.0f, -4.0f, -2.25f, 3.0f, 4.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition spine2 = Body.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, -5.5f, -4.5f, 8.0f, 6.0f, 5.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)1.25f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition back3 = spine2.addOrReplaceChild("back3", CubeListBuilder.create().texOffs(28, 37).addBox(0.0f, -4.0f, -1.75f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back4 = spine2.addOrReplaceChild("back4", CubeListBuilder.create().texOffs(32, 6).addBox(-2.0f, -4.0f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition LeftLeg = Body.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 35).addBox(-1.25f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)10.0f, (float)0.0f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(18, 27).addBox(-1.25f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition tendril6 = LeftLeg.addOrReplaceChild("tendril6", CubeListBuilder.create().texOffs(47, 45).addBox(0.0f, 0.0f, -1.0f, 0.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.1f, (float)2.0f, (float)1.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = Body.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(14, 37).addBox(-1.75f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)10.0f, (float)0.0f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(32, 27).addBox(-1.75f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition tendril5 = RightLeg.addOrReplaceChild("tendril5", CubeListBuilder.create().texOffs(48, 8).addBox(0.0f, 0.0f, -1.0f, 0.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.1f, (float)2.0f, (float)1.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = Body.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(46, 3).addBox(-1.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)2.0f, (float)-2.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r1 = LeftForArm.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 45).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = Body.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(46, 31).addBox(-2.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)2.0f, (float)-2.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(25, 45).addBox(-2.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = Body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(-0.01f)).texOffs(24, 0).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(33, 57).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(26, 14).addBox(-3.5f, 0.0f, -3.75f, 7.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ear = head.addOrReplaceChild("ear", CubeListBuilder.create().texOffs(37, 44).addBox(0.0f, -5.0f, -2.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-6.0f, (float)2.0f));
        PartDefinition ear2 = head.addOrReplaceChild("ear2", CubeListBuilder.create().texOffs(12, 42).addBox(0.0f, -5.0f, -2.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-6.0f, (float)2.0f));
        PartDefinition tendril = Body.addOrReplaceChild("tendril", CubeListBuilder.create().texOffs(28, 50).addBox(0.0f, 0.0f, -1.0f, 0.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)3.0f, (float)1.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition tendril2 = Body.addOrReplaceChild("tendril2", CubeListBuilder.create().texOffs(20, 50).addBox(0.0f, 0.0f, -1.0f, 0.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)1.0f, (float)0.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition tendril3 = Body.addOrReplaceChild("tendril3", CubeListBuilder.create().texOffs(0, 50).addBox(0.0f, 0.0f, -1.0f, 0.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)1.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition tendril4 = Body.addOrReplaceChild("tendril4", CubeListBuilder.create().texOffs(12, 48).addBox(0.0f, 0.0f, -1.0f, 0.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)5.0f, (float)1.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupBodyAnimations(entity, headPitch);
        this.setupArmAnimations(entity, limbSwing, limbSwingAmount, ageInTicks);
        this.setupLegAnimations(limbSwing, limbSwingAmount);
        this.setupHeadAnimations(netHeadYaw, headPitch, ageInTicks);
        this.setupTendrilAnimations(ageInTicks);
        this.setupEarAnimations(ageInTicks);
    }

    private void setupBodyAnimations(T entity, float headPitch) {
        this.Body.xRot = entity.isInWater() && entity.isSwimming() && entity.getXRot() < 5.0f ? -headPitch / 28.647888f : 0.0f;
    }

    private void setupArmAnimations(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (entity.isAggressive()) {
            this.handleAggressiveArmAnimations(ageInTicks);
        } else if (this.isWalking(limbSwingAmount) && entity.onGround()) {
            this.handleWalkingArmAnimations(limbSwing, limbSwingAmount);
        } else {
            this.handleIdleArmAnimations(ageInTicks);
        }
    }

    private void handleAggressiveArmAnimations(float ageInTicks) {
        float aggressiveWave = Mth.sin((float)(ageInTicks * 0.25f)) * 0.142f;
        this.RightArm.xRot = -89.5f - aggressiveWave;
        this.LeftArm.xRot = -89.5f + aggressiveWave;
        this.RightArm.zRot = 0.0f;
        this.LeftArm.zRot = 0.0f;
    }

    private void handleWalkingArmAnimations(float limbSwing, float limbSwingAmount) {
        float armMovement;
        this.RightArm.xRot = armMovement = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.LeftArm.xRot = -armMovement;
        this.RightArm.zRot = 0.0f;
        this.LeftArm.zRot = 0.0f;
    }

    private void handleIdleArmAnimations(float ageInTicks) {
        float idleSway;
        this.RightArm.zRot = idleSway = Mth.sin((float)(ageInTicks * 0.125f)) * 0.1f;
        this.LeftArm.zRot = -idleSway;
        this.RightArm.xRot = 0.0f;
        this.LeftArm.xRot = 0.0f;
    }

    private void setupLegAnimations(float limbSwing, float limbSwingAmount) {
        float legMovement;
        this.LeftLeg.xRot = legMovement = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.RightLeg.xRot = -legMovement;
        this.updateForelegAnimations();
    }

    private void updateForelegAnimations() {
        if (this.LeftLeg.xRot < 0.0f) {
            this.leftForeleg.xRot = -this.LeftLeg.xRot;
        }
        if (this.RightLeg.xRot < 0.0f) {
            this.rightForeleg.xRot = -this.RightLeg.xRot;
        }
    }

    private void setupHeadAnimations(float netHeadYaw, float headPitch, float ageInTicks) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 28.647888f;
        this.jaw.xRot = Mth.sin((float)(ageInTicks * 0.125f)) * 0.1f;
    }

    private void setupTendrilAnimations(float ageInTicks) {
        this.tendril.yRot = -Mth.sin((float)(ageInTicks * 0.125f)) * 0.2f;
        this.tendril2.yRot = Mth.sin((float)(ageInTicks * 0.2f)) * 0.142f;
        this.tendril3.yRot = -Mth.sin((float)(ageInTicks * 0.166f)) * 0.125f;
        this.tendril4.yRot = Mth.sin((float)(ageInTicks * 0.111f)) * 0.166f;
        this.tendril5.yRot = Mth.sin((float)(ageInTicks * 0.111f)) * 0.166f;
        this.tendril6.yRot = -Mth.sin((float)(ageInTicks * 0.111f)) * 0.166f;
    }

    private void setupEarAnimations(float ageInTicks) {
        float earWave;
        this.ear.xRot = earWave = Mth.sin((float)(ageInTicks * 0.166f)) * 0.125f;
        this.ear2.xRot = -earWave;
    }

    private boolean isWalking(float limbSwingAmount) {
        return Math.abs(limbSwingAmount) > 0.15f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

