/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.InfectedEvoker;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class InfectedEvokerModel<T extends InfectedEvoker>
extends EntityModel<T>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"infectedevoker"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart RightArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart LeftArm;
    private final ModelPart bodywear;
    private final ModelPart leftForeleg;
    private final ModelPart rightForeleg;
    private final ModelPart base;
    private final ModelPart middleF;
    private final ModelPart middleF2;
    private final ModelPart middleF3;
    private final ModelPart fingerT;
    private final ModelPart fingerT2;
    private final ModelPart fingerT3;
    private final ModelPart fingerT4;
    private final ModelPart jointT;
    private final ModelPart jointT2;
    private final ModelPart jointT3;
    private final ModelPart jointT4;
    private final ModelPart fingerG;
    private final ModelPart fingerG2;
    private final ModelPart fingerG3;
    private final ModelPart fingerG4;
    private static final float WALK_THRESHOLD = 0.15f;
    private static final float ARM_WALK_SPEED = 0.8f;
    private static final float LEG_WALK_SPEED = 0.8f;
    private static final float IDLE_ARM_SPEED = 0.125f;
    private static final float FINGER_ANIM_SPEED = 0.125f;
    private static final float ATTACK_ARM_SPEED = 0.166f;

    public InfectedEvokerModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.RightArm = root.getChild("RightArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
        this.LeftArm = root.getChild("LeftArm");
        this.bodywear = root.getChild("bodywear");
        this.leftForeleg = this.LeftLeg.getChild("leftForLeg");
        this.rightForeleg = this.RightLeg.getChild("rightForLeg");
        this.base = this.LeftArm.getChild("base");
        this.middleF = this.base.getChild("middleF");
        this.middleF2 = this.middleF.getChild("middleF2");
        this.middleF3 = this.middleF2.getChild("middleF3");
        this.fingerT = this.base.getChild("fingerT");
        this.fingerT2 = this.base.getChild("fingerT2");
        this.fingerT3 = this.base.getChild("fingerT3");
        this.fingerT4 = this.base.getChild("fingerT4");
        this.jointT = this.fingerT.getChild("jointT");
        this.jointT2 = this.fingerT2.getChild("jointT2");
        this.jointT3 = this.fingerT3.getChild("jointT3");
        this.jointT4 = this.fingerT4.getChild("jointT4");
        this.fingerG = this.jointT.getChild("fingerG");
        this.fingerG2 = this.jointT2.getChild("fingerG2");
        this.fingerG3 = this.jointT3.getChild("fingerG3");
        this.fingerG4 = this.jointT4.getChild("fingerG4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 14).addBox(-3.5f, -2.0f, -4.5f, 7.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(20, 16).addBox(-4.0f, -10.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(50, 0).addBox(-4.0f, -2.0f, 1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(28, 8).addBox(-3.5f, -2.0f, -4.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(3.5f, -2.0f, -4.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, -3.0f, -6.0f, 0.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 21).addBox(0.0f, -3.0f, -3.0f, 0.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-10.0f, (float)-3.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(64, 31).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 41).addBox(-4.0f, -1.0f, -6.0f, 8.0f, 2.0f, 6.0f, new CubeDeformation(-0.05f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(36, 35).addBox(-4.0f, 9.0f, -3.0f, 8.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(14, 32).addBox(-4.0f, -2.5f, -3.0f, 8.0f, 3.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition body_r2 = body.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(28, 0).addBox(-4.0f, -7.0f, -3.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-0.25f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(52, 52).addBox(-2.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(52, 24).addBox(-2.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition item = RightForArm.addOrReplaceChild("item", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 49).addBox(-1.75f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(39, 44).addBox(-1.75f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(23, 44).addBox(-1.25f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(44, 13).addBox(-1.25f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)2.0f, (float)0.0f));
        PartDefinition base = LeftArm.addOrReplaceChild("base", CubeListBuilder.create().texOffs(56, 4).addBox(-1.5f, -4.0f, -0.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)-1.5708f, (float)-3.1416f));
        PartDefinition cube_r3 = base.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(38, 55).addBox(-1.5f, -6.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition middleF = base.addOrReplaceChild("middleF", CubeListBuilder.create().texOffs(26, 55).addBox(-1.5f, -5.75f, -1.25f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)2.0f));
        PartDefinition middleF2 = middleF.addOrReplaceChild("middleF2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition cube_r4 = middleF2.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 60).addBox(-1.0f, -5.75f, -1.25f, 2.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition middleF3 = middleF2.addOrReplaceChild("middleF3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition cube_r5 = middleF3.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(55, 40).addBox(0.0f, -5.75f, -1.25f, 0.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition fingerT = base.addOrReplaceChild("fingerT", CubeListBuilder.create(), PartPose.offset((float)1.25f, (float)-5.0f, (float)1.0f));
        PartDefinition jointT = fingerT.addOrReplaceChild("jointT", CubeListBuilder.create().texOffs(28, 64).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition fingerG = jointT.addOrReplaceChild("fingerG", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jointG = fingerG.addOrReplaceChild("jointG", CubeListBuilder.create().texOffs(64, 22).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition claw = jointG.addOrReplaceChild("claw", CubeListBuilder.create().texOffs(58, 30).addBox(0.0f, -6.0f, -1.0f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition fingerT2 = base.addOrReplaceChild("fingerT2", CubeListBuilder.create(), PartPose.offset((float)1.25f, (float)-9.0f, (float)2.0f));
        PartDefinition jointT2 = fingerT2.addOrReplaceChild("jointT2", CubeListBuilder.create().texOffs(22, 64).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition fingerG2 = jointT2.addOrReplaceChild("fingerG2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jointG2 = fingerG2.addOrReplaceChild("jointG2", CubeListBuilder.create().texOffs(16, 64).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition claw2 = jointG2.addOrReplaceChild("claw2", CubeListBuilder.create().texOffs(10, 57).addBox(0.0f, -6.0f, -1.0f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition fingerT3 = base.addOrReplaceChild("fingerT3", CubeListBuilder.create(), PartPose.offset((float)-0.75f, (float)-8.75f, (float)2.0f));
        PartDefinition jointT3 = fingerT3.addOrReplaceChild("jointT3", CubeListBuilder.create().texOffs(63, 42).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition fingerG3 = jointT3.addOrReplaceChild("fingerG3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jointG3 = fingerG3.addOrReplaceChild("jointG3", CubeListBuilder.create().texOffs(58, 61).addBox(-0.5f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition claw3 = jointG3.addOrReplaceChild("claw3", CubeListBuilder.create().texOffs(0, 35).addBox(0.0f, -6.0f, -1.0f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition fingerT4 = base.addOrReplaceChild("fingerT4", CubeListBuilder.create(), PartPose.offset((float)-0.75f, (float)-3.75f, (float)1.0f));
        PartDefinition jointT4 = fingerT4.addOrReplaceChild("jointT4", CubeListBuilder.create().texOffs(50, 61).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5672f));
        PartDefinition fingerG4 = jointT4.addOrReplaceChild("fingerG4", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jointG4 = fingerG4.addOrReplaceChild("jointG4", CubeListBuilder.create().texOffs(60, 13).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition claw4 = jointG4.addOrReplaceChild("claw4", CubeListBuilder.create().texOffs(16, 50).addBox(0.0f, -7.0f, -2.0f, 0.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition bodywear = partdefinition.addOrReplaceChild("bodywear", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 0.0f, -3.25f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.25f, (float)0.0436f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupHeadAnimations(netHeadYaw, headPitch);
        this.setupArmAnimations(entity, limbSwing, limbSwingAmount, ageInTicks);
        this.setupLegAnimations(limbSwing, limbSwingAmount);
        this.setupLeftArmVisibility(entity);
        if (((InfectedEvoker)entity).hasArm()) {
            this.setupFingerAnimations(ageInTicks);
        }
    }

    private void setupHeadAnimations(float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 28.647888f;
    }

    private void setupArmAnimations(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (((InfectedEvoker)entity).attackAnim > 0.0f) {
            this.handleAttackAnimation(entity, ageInTicks);
        } else if (Math.abs(limbSwingAmount) > 0.15f) {
            this.handleWalkingArmAnimations(limbSwing, limbSwingAmount);
        } else {
            this.handleIdleArmAnimations(ageInTicks);
        }
    }

    private void handleAttackAnimation(T entity, float ageInTicks) {
        float attackProgress = 1.0f - Mth.abs((float)(10.0f - 2.0f * ((InfectedEvoker)entity).attackAnim)) / 10.0f;
        float attackWave = Mth.sin((float)attackProgress) * 2.0f;
        float idleWave = Mth.sin((float)(ageInTicks * 0.166f)) * 0.125f;
        this.RightArm.xRot = -140.0f;
        this.LeftArm.xRot = -140.0f;
        this.RightArm.yRot = idleWave + attackWave;
        this.LeftArm.yRot = -idleWave + attackWave;
    }

    private void handleWalkingArmAnimations(float limbSwing, float limbSwingAmount) {
        float armMovement;
        this.RightArm.xRot = armMovement = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.LeftArm.xRot = -armMovement;
        this.RightArm.zRot = 0.0f;
        this.LeftArm.zRot = 0.0f;
    }

    private void handleIdleArmAnimations(float ageInTicks) {
        float idleSway;
        this.RightArm.zRot = idleSway = Mth.sin((float)(ageInTicks * 0.125f)) * 0.1f;
        this.LeftArm.zRot = -idleSway;
    }

    private void setupLegAnimations(float limbSwing, float limbSwingAmount) {
        float legMovement;
        this.LeftLeg.xRot = legMovement = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.RightLeg.xRot = -legMovement;
        this.updateForelegAnimations();
    }

    private void updateForelegAnimations() {
        this.leftForeleg.xRot = this.LeftLeg.xRot < 0.0f ? -this.LeftLeg.xRot : 0.0f;
        this.rightForeleg.xRot = this.RightLeg.xRot < 0.0f ? -this.RightLeg.xRot : 0.0f;
    }

    private void setupLeftArmVisibility(T entity) {
        this.LeftArm.visible = ((InfectedEvoker)entity).hasArm();
    }

    private void setupFingerAnimations(float ageInTicks) {
        this.setupMiddleFingerAnimations(ageInTicks);
        this.setupIndividualFingerAnimations(ageInTicks);
    }

    private void setupMiddleFingerAnimations(float ageInTicks) {
        float fingerWave;
        this.middleF.xRot = fingerWave = Mth.sin((float)(ageInTicks * 0.125f)) * 0.166f;
        this.middleF2.xRot = fingerWave;
        this.middleF3.xRot = fingerWave;
    }

    private void setupIndividualFingerAnimations(float ageInTicks) {
        float fingerWave = Mth.sin((float)(ageInTicks * 0.125f));
        float fingerWaveY = fingerWave * 0.166f;
        float fingerWaveZ = fingerWave * 0.125f;
        this.fingerT.yRot = fingerWaveY;
        this.fingerT2.yRot = fingerWaveY;
        this.fingerT3.yRot = -fingerWaveY;
        this.fingerT4.yRot = -fingerWaveY;
        this.fingerT.zRot = -fingerWaveZ;
        this.fingerT2.zRot = -fingerWaveZ * 0.875f;
        this.fingerT3.zRot = fingerWaveZ * 0.888f;
        this.fingerT4.zRot = fingerWaveZ * 0.75f;
        this.fingerG.yRot = fingerWaveY;
        this.fingerG2.yRot = fingerWaveY;
        this.fingerG3.yRot = -fingerWaveY;
        this.fingerG4.yRot = -fingerWaveY;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.bodywear.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        this.getArm(arm).translateAndRotate(stack);
    }
}

