/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.BasicInfected.InfectedHusk;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class InfectedHuskModel<T extends InfectedHusk>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"infectedhuskmodel"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightForLeg;
    private final ModelPart leftForLeg;
    private final ModelPart tendril1;
    private final ModelPart tendril2;

    public InfectedHuskModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.rightArm = this.body.getChild("RightArm");
        this.leftArm = this.body.getChild("LeftArm");
        this.rightLeg = this.body.getChild("RightLeg");
        this.leftLeg = this.body.getChild("LeftLeg");
        this.rightForLeg = this.rightLeg.getChild("rightForLeg");
        this.leftForLeg = this.leftLeg.getChild("leftForLeg");
        this.tendril1 = this.body.getChild("tendril");
        this.tendril2 = this.body.getChild("tendril2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(22, 21).addBox(-4.0f, 8.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)2.0f, (float)2.0f));
        PartDefinition spine = body.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -4.5f, -4.5f, 4.0f, 5.0f, 5.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)2.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition back = spine.addOrReplaceChild("back", CubeListBuilder.create().texOffs(10, 43).addBox(0.0f, -4.0f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back2 = spine.addOrReplaceChild("back2", CubeListBuilder.create().texOffs(42, 10).addBox(-2.0f, -4.0f, -2.25f, 3.0f, 4.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition spine2 = body.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, -5.5f, -4.5f, 8.0f, 6.0f, 5.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)1.25f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition back3 = spine2.addOrReplaceChild("back3", CubeListBuilder.create().texOffs(38, 29).addBox(0.0f, -4.0f, -1.75f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition back4 = spine2.addOrReplaceChild("back4", CubeListBuilder.create().texOffs(32, 6).addBox(-2.0f, -4.0f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition tendril = body.addOrReplaceChild("tendril", CubeListBuilder.create().texOffs(48, 48).addBox(0.0f, -5.0f, -2.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)4.0f, (float)2.0f));
        PartDefinition tendril2 = body.addOrReplaceChild("tendril2", CubeListBuilder.create().texOffs(48, 48).addBox(0.0f, -5.0f, -2.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)2.0f, (float)1.0f));
        PartDefinition LeftLeg = body.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 35).addBox(-1.25f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)10.0f, (float)0.0f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(14, 33).addBox(-1.25f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition RightLeg = body.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(38, 39).addBox(-1.75f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)10.0f, (float)0.0f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(28, 33).addBox(-1.75f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftArm = body.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(0, 48).addBox(-1.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)2.0f, (float)-2.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r1 = LeftForArm.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(24, 43).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = body.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(48, 0).addBox(-2.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)2.0f, (float)-2.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(46, 18).addBox(-2.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(21, 14).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(18, 27).addBox(-3.5f, 0.0f, -3.75f, 7.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.xRot = 0.0f;
        this.body.zRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        float walkCycle = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        float idleSway = Mth.sin((float)(ageInTicks / 15.0f)) / 10.0f;
        float idleSwaySlow = Mth.sin((float)(ageInTicks / 25.0f)) / 20.0f;
        if (entity.isAggressive()) {
            this.jaw.xRot = 0.4f + Mth.sin((float)(ageInTicks / 6.0f)) / 10.0f;
            this.body.xRot = 0.2f + idleSwaySlow;
            this.body.zRot = Mth.cos((float)(ageInTicks / 10.0f)) / 10.0f;
            this.rightArm.xRot = (float)Math.toRadians(-90.0) - Mth.sin((float)(ageInTicks / 4.0f)) / 7.0f;
            this.leftArm.xRot = (float)Math.toRadians(-90.0) + Mth.sin((float)(ageInTicks / 4.0f)) / 7.0f;
        } else if (limbSwingAmount > 0.15f) {
            this.rightArm.xRot = -walkCycle;
            this.leftArm.xRot = walkCycle;
            this.jaw.xRot = idleSwaySlow / 2.0f;
        } else {
            this.rightArm.zRot = idleSway;
            this.leftArm.zRot = -idleSway;
            this.jaw.xRot = idleSway / 2.0f;
        }
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.rightLeg.xRot = -this.leftLeg.xRot;
        this.leftForLeg.xRot = this.leftLeg.xRot < 0.0f ? -this.leftLeg.xRot : 0.0f;
        this.rightForLeg.xRot = this.rightLeg.xRot < 0.0f ? -this.rightLeg.xRot : 0.0f;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.tendril1.xRot = idleSway;
        this.tendril2.xRot = -idleSway;
        this.tendril1.zRot = -idleSway;
        this.tendril2.zRot = idleSway;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

