/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.InfectedVendicator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class InfectedVindicatorModel<T extends InfectedVendicator>
extends EntityModel<T>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"infectedvindicatormodel"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart bodywear;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;

    public InfectedVindicatorModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.bodywear = root.getChild("bodywear");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 13).addBox(-3.5f, -2.0f, -4.5f, 7.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(20, 16).addBox(-4.0f, -10.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 24).addBox(-4.0f, -2.0f, 1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(10, 23).addBox(-3.5f, -2.0f, -4.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 23).addBox(3.5f, -2.0f, -4.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(22, 32).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 41).addBox(-4.0f, -1.0f, -6.0f, 8.0f, 2.0f, 6.0f, new CubeDeformation(-0.05f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 32).addBox(-4.0f, 9.0f, -3.0f, 8.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, -2.5f, -3.0f, 8.0f, 3.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition body_r2 = body.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(28, 0).addBox(-4.0f, -7.0f, -3.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-0.25f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bodywear = partdefinition.addOrReplaceChild("bodywear", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 0.0f, -3.25f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.25f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(16, 49).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(50, 28).addBox(-2.0f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition axe = RightForArm.addOrReplaceChild("axe", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition armthing = RightArm.addOrReplaceChild("armthing", CubeListBuilder.create().texOffs(30, 52).addBox(-1.0f, -4.0f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.1f)).texOffs(22, 0).addBox(-0.5f, 0.0f, -2.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.05f)).texOffs(56, 9).addBox(-3.0f, -9.0f, 0.0f, 5.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r1 = armthing.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, 0.0f, 3.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)1.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition cube_r2 = armthing.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 29).addBox(-2.0f, -4.0f, 0.0f, 3.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-1.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r3 = LeftForArm.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(44, 52).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 49).addBox(-1.75f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(44, 41).addBox(-1.75f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(44, 13).addBox(-1.25f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(28, 41).addBox(-1.25f, 0.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isAggressive()) {
            this.head.getChild((String)"jaw").xRot = Mth.sin((float)(ageInTicks / 6.0f)) / 10.0f + 0.4f;
            this.RightArm.xRot = -90.0f - Mth.sin((float)(ageInTicks / 4.0f)) / 7.0f;
            this.LeftArm.xRot = -90.0f + Mth.sin((float)(ageInTicks / 4.0f)) / 7.0f;
            if (((InfectedVendicator)entity).swinging) {
                float j = 0.0f;
                this.RightArm.xRot = -90.0f + (j += 0.5f);
                this.LeftArm.xRot = -90.0f + j;
            }
        } else if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
            this.RightArm.zRot = 0.0f;
            this.LeftArm.zRot = 0.0f;
        } else {
            this.RightArm.xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.LeftArm.xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            if (Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f <= 0.0f) {
                this.RightArm.getChild((String)"RightForArm").xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            }
        }
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        if (this.LeftLeg.xRot < 0.0f) {
            this.LeftLeg.getChild((String)"leftForLeg").xRot = -this.LeftLeg.xRot;
        }
        if (this.RightLeg.xRot < 0.0f) {
            this.RightLeg.getChild((String)"rightForLeg").xRot = -this.RightLeg.xRot;
        }
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 28.647888f;
        this.head.getChild((String)"jaw").xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.bodywear.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.RIGHT ? this.RightArm : this.RightArm.getChild("RightForArm").getChild("axe");
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        this.getArm(arm).translateAndRotate(stack);
    }
}

