/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.BasicInfected.InfectedWitch;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class InfectedWitchModel<T extends InfectedWitch>
extends EntityModel<T>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"infectedwitchmodel"), "main");
    private final ModelPart body;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart TopBody;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;

    public InfectedWitchModel(ModelPart root) {
        this.body = root.getChild("body");
        this.LeftLeg = root.getChild("LeftLeg");
        this.RightLeg = root.getChild("RightLeg");
        this.TopBody = root.getChild("TopBody");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(27, 37).addBox(-4.0f, 0.0f, -2.5f, 8.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(68, 0).addBox(-4.0f, 4.0f, -3.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.3f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 54).addBox(-1.25f, 0.0f, -4.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)2.0f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(52, 44).addBox(-1.25f, 0.0f, -4.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(38, 48).addBox(-1.75f, 0.0f, -4.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)2.0f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(24, 48).addBox(-1.75f, 0.0f, -4.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition TopBody = partdefinition.addOrReplaceChild("TopBody", CubeListBuilder.create().texOffs(28, 0).addBox(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -6.0f, -3.0f, 8.0f, 10.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition head = TopBody.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 26).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(48, 12).addBox(-4.0f, -2.25f, -3.75f, 8.0f, 1.0f, 4.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(0.0f, 1.0f, -6.75f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 42).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(-0.05f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition headwear = head.addOrReplaceChild("headwear", CubeListBuilder.create().texOffs(18, 14).addBox(0.0f, 0.0f, 0.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-10.05f, (float)-5.0f));
        PartDefinition hat2 = headwear.addOrReplaceChild("hat2", CubeListBuilder.create().texOffs(32, 26).addBox(0.0f, 0.0f, 0.0f, 7.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.75f, (float)-4.0f, (float)2.0f, (float)-0.0524f, (float)0.0f, (float)0.0262f));
        PartDefinition hat3 = hat2.addOrReplaceChild("hat3", CubeListBuilder.create().texOffs(54, 22).addBox(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.75f, (float)-4.0f, (float)2.0f, (float)-0.1047f, (float)0.0f, (float)0.0524f));
        PartDefinition hat4 = hat3.addOrReplaceChild("hat4", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)1.75f, (float)-2.0f, (float)2.0f, (float)-0.2094f, (float)0.0f, (float)0.1047f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(14, 55).addBox(-2.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)3.0f, (float)0.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(52, 54).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)-1.0f, (float)4.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(57, 34).addBox(-1.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)3.0f, (float)0.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r1 = LeftForArm.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition item = LeftForArm.addOrReplaceChild("item", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((InfectedWitch)entity).swinging) {
            this.RightArm.xRot = -90.0f;
            this.LeftArm.xRot = -90.0f;
        } else {
            this.RightArm.xRot = 0.0f;
            this.LeftArm.xRot = 0.0f;
        }
        if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
            this.RightArm.zRot = 0.0f;
            this.LeftArm.zRot = 0.0f;
        } else {
            this.RightArm.zRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.LeftArm.zRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        }
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        if (this.LeftLeg.xRot < 0.0f) {
            this.LeftLeg.getChild((String)"leftForLeg").xRot = -this.LeftLeg.xRot;
        }
        if (this.RightLeg.xRot < 0.0f) {
            this.RightLeg.getChild((String)"rightForLeg").xRot = -this.RightLeg.xRot;
        }
        this.TopBody.getChild((String)"head").yRot = netHeadYaw / 57.295776f;
        this.TopBody.getChild((String)"head").xRot = headPitch / 28.647888f;
        this.TopBody.getChild((String)"head").getChild((String)"jaw").xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.TopBody.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.RIGHT ? this.LeftArm : this.RightArm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        this.getArm(arm).translateAndRotate(stack);
    }
}

