/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.Hyper.Inquisitor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class InquisitorModel<T extends Inquisitor>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"inquisitor"), "main");
    private final ModelPart KnightHyper;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart RightForLeg;
    private final ModelPart LeftForLeg;
    private final ModelPart Arm;
    private final ModelPart ForArm;
    private final ModelPart Claw1;
    private final ModelPart Claw2;
    private final ModelPart Claw3;
    private final ModelPart Claw4;

    public InquisitorModel(ModelPart root) {
        this.KnightHyper = root.getChild("KnightHyper");
        this.LeftLeg = this.KnightHyper.getChild("Legs").getChild("LeftLeg");
        this.RightLeg = this.KnightHyper.getChild("Legs").getChild("RightLeg");
        this.RightForLeg = this.RightLeg.getChild("RightLegSeg2");
        this.LeftForLeg = this.LeftLeg.getChild("LeftLegSeg2");
        this.Arm = this.KnightHyper.getChild("Torso").getChild("UpperTorso").getChild("RightArm");
        this.ForArm = this.Arm.getChild("RightArmSeg2");
        this.Claw1 = this.ForArm.getChild("RightArmClaw").getChild("Claw1");
        this.Claw2 = this.ForArm.getChild("RightArmClaw").getChild("Claw2");
        this.Claw3 = this.ForArm.getChild("RightArmClaw").getChild("Claw3");
        this.Claw4 = this.ForArm.getChild("RightArmClaw").getChild("Claw4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition KnightHyper = partdefinition.addOrReplaceChild("KnightHyper", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Torso = KnightHyper.addOrReplaceChild("Torso", CubeListBuilder.create().texOffs(31, 8).addBox(-5.5f, -5.5f, -2.5f, 11.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.25f, (float)-17.5f, (float)0.0f));
        PartDefinition LowerTorsoGrowth = Torso.addOrReplaceChild("LowerTorsoGrowth", CubeListBuilder.create().texOffs(26, 39).addBox(1.0f, -10.0f, -3.0f, 6.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(49, 48).addBox(3.0f, -2.0f, -2.85f, 3.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(54, 54).addBox(-3.0f, -6.0f, 2.95f, 7.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(54, 54).addBox(-7.0f, -4.0f, 3.15f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(54, 54).addBox(-6.5f, -6.5f, 2.65f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(55, 57).addBox(-3.25f, -6.5f, -2.45f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)1.5f, (float)-0.5f));
        PartDefinition GrowthSeg7_r1 = LowerTorsoGrowth.addOrReplaceChild("GrowthSeg7_r1", CubeListBuilder.create().texOffs(50, 57).addBox(-3.0f, -2.0f, -0.5f, 6.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.25f, (float)-2.5f, (float)-1.85f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition GrowthSeg1_r1 = LowerTorsoGrowth.addOrReplaceChild("GrowthSeg1_r1", CubeListBuilder.create().texOffs(46, 48).addBox(-1.0f, -8.0f, -3.0f, 6.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition LowerTorsoGrowthFungus = LowerTorsoGrowth.addOrReplaceChild("LowerTorsoGrowthFungus", CubeListBuilder.create(), PartPose.offset((float)-11.25f, (float)16.0f, (float)0.5f));
        PartDefinition FungalPlanes_r1 = LowerTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r1", CubeListBuilder.create().texOffs(-7, 63).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)14.9934f, (float)-21.1492f, (float)-3.0f, (float)0.0f, (float)-0.3491f, (float)-0.2182f));
        PartDefinition FungalPlanes_r2 = LowerTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r2", CubeListBuilder.create().texOffs(-7, 63).addBox(-3.0f, -25.0f, 0.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)12.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.2182f));
        PartDefinition FungalPlanes_r3 = LowerTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r3", CubeListBuilder.create().texOffs(-7, 49).addBox(-2.0f, -21.0f, -6.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(-7, 63).addBox(-6.0f, -18.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)12.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.2182f));
        PartDefinition FungalPlanes_r4 = LowerTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r4", CubeListBuilder.create().texOffs(-7, 56).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.9394f, (float)-20.9556f, (float)4.0847f, (float)-0.257f, (float)0.5522f, (float)0.0811f));
        PartDefinition FungalPlanes_r5 = LowerTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r5", CubeListBuilder.create().texOffs(-7, 49).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.444f, (float)-23.2317f, (float)2.8091f, (float)-0.2284f, (float)-0.298f, (float)0.2863f));
        PartDefinition FungalPlanes_r6 = LowerTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r6", CubeListBuilder.create().texOffs(-7, 56).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.1467f, (float)-15.6184f, (float)-2.0f, (float)0.0f, (float)0.3054f, (float)-0.2182f));
        PartDefinition LowerTGrowthFungalPlate = LowerTorsoGrowth.addOrReplaceChild("LowerTGrowthFungalPlate", CubeListBuilder.create().texOffs(22, 57).mirror().addBox(-0.2469f, -1.6942f, -5.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(-0.3f)).mirror(false).texOffs(28, 44).mirror().addBox(7.1531f, -1.1942f, -5.5f, 2.0f, 1.0f, 9.0f, new CubeDeformation(-0.3f)).mirror(false).texOffs(34, 51).mirror().addBox(-0.2469f, -1.2042f, -6.4f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.3f)).mirror(false).texOffs(34, 51).mirror().addBox(-0.2469f, -1.2042f, 2.4f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.3f)).mirror(false), PartPose.offsetAndRotation((float)3.2826f, (float)-4.9988f, (float)1.5267f, (float)0.2618f, (float)0.0f, (float)0.2618f));
        PartDefinition UpperTorso = Torso.addOrReplaceChild("UpperTorso", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -7.0f, -3.0f, 12.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.5f, (float)0.0f));
        PartDefinition UpperTorsoGrowth = UpperTorso.addOrReplaceChild("UpperTorsoGrowth", CubeListBuilder.create().texOffs(48, 48).addBox(11.4389f, -7.7352f, -4.251f, 3.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-1.0f, (float)0.0f));
        PartDefinition GrowthSeg4_r1 = UpperTorsoGrowth.addOrReplaceChild("GrowthSeg4_r1", CubeListBuilder.create().texOffs(27, 22).addBox(-1.5f, -7.5f, -3.5f, 3.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)12.5f, (float)-8.5f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition GrowthSeg3_r1 = UpperTorsoGrowth.addOrReplaceChild("GrowthSeg3_r1", CubeListBuilder.create().texOffs(47, 48).addBox(-2.5f, -3.5f, -3.5f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.5f, (float)-8.5f, (float)-0.75f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition GrowthSeg2_r1 = UpperTorsoGrowth.addOrReplaceChild("GrowthSeg2_r1", CubeListBuilder.create().texOffs(46, 48).addBox(-4.0f, -3.0f, -4.0f, 4.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition GrowthSeg1_r2 = UpperTorsoGrowth.addOrReplaceChild("GrowthSeg1_r2", CubeListBuilder.create().texOffs(24, 21).addBox(-4.0f, -6.0f, -4.0f, 5.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)-1.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition UpperTorsoGrowthFungus = UpperTorsoGrowth.addOrReplaceChild("UpperTorsoGrowthFungus", CubeListBuilder.create(), PartPose.offset((float)10.25f, (float)24.0f, (float)0.0f));
        PartDefinition FungalPlanes_r7 = UpperTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r7", CubeListBuilder.create().texOffs(-7, 63).addBox(4.0f, -20.0f, -1.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition FungalPlanes_r8 = UpperTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r8", CubeListBuilder.create().texOffs(-7, 49).addBox(-4.5f, 0.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.9114f, (float)-32.3546f, (float)2.4821f, (float)-0.202f, (float)-0.0829f, (float)-0.1661f));
        PartDefinition FungalPlanes_r9 = UpperTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r9", CubeListBuilder.create().texOffs(-7, 56).addBox(-3.5f, 0.0f, -5.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0425f, (float)-28.3255f, (float)-1.6163f, (float)0.2449f, (float)0.4677f, (float)0.3304f));
        PartDefinition FungalPlanes_r10 = UpperTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r10", CubeListBuilder.create().texOffs(-7, 63).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.4097f, (float)-25.9092f, (float)-2.9196f, (float)-0.1309f, (float)0.0f, (float)0.2182f));
        PartDefinition FungalPlanes_r11 = UpperTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r11", CubeListBuilder.create().texOffs(-7, 49).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.7107f, (float)-36.5075f, (float)-2.1551f, (float)0.2449f, (float)0.4677f, (float)0.3304f));
        PartDefinition FungalPlanes_r12 = UpperTorsoGrowthFungus.addOrReplaceChild("FungalPlanes_r12", CubeListBuilder.create().texOffs(-7, 56).addBox(-2.75f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.1467f, (float)-23.6184f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)-0.2182f));
        PartDefinition UpperTGrowthFungalPlate = UpperTorsoGrowth.addOrReplaceChild("UpperTGrowthFungalPlate", CubeListBuilder.create().texOffs(22, 57).mirror().addBox(-0.2469f, -1.6942f, -5.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(-0.2f)).mirror(false).texOffs(28, 44).mirror().addBox(7.3531f, -1.1942f, -5.5f, 2.0f, 1.0f, 9.0f, new CubeDeformation(-0.2f)).mirror(false).texOffs(34, 51).mirror().addBox(-0.2469f, -1.2042f, -6.6f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)).mirror(false).texOffs(34, 51).mirror().addBox(-0.2469f, -1.2042f, 2.6f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)).mirror(false), PartPose.offsetAndRotation((float)10.9685f, (float)-2.5551f, (float)0.3096f, (float)-0.3491f, (float)0.0f, (float)-0.2618f));
        PartDefinition RightArm = UpperTorso.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(0, 75).addBox(-4.75f, -2.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.25f, (float)-5.0f, (float)0.0f));
        PartDefinition ShoulderPad = RightArm.addOrReplaceChild("ShoulderPad", CubeListBuilder.create().texOffs(50, 53).addBox(-2.0f, 1.75f, -3.51f, 2.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.75f, (float)-2.0f, (float)0.5f));
        PartDefinition Fungus_r1 = ShoulderPad.addOrReplaceChild("Fungus_r1", CubeListBuilder.create().texOffs(-7, 49).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.183f, (float)4.5485f, (float)-1.3507f, (float)-0.3563f, (float)-0.3651f, (float)0.2993f));
        PartDefinition PadBack_r1 = ShoulderPad.addOrReplaceChild("PadBack_r1", CubeListBuilder.create().texOffs(53, 48).addBox(-1.5f, -3.0f, -0.5f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)3.75f, (float)1.76f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition PadFront_r1 = ShoulderPad.addOrReplaceChild("PadFront_r1", CubeListBuilder.create().texOffs(52, 51).addBox(-1.5f, -3.0f, -0.5f, 3.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)3.75f, (float)-2.76f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition PadCenter_r1 = ShoulderPad.addOrReplaceChild("PadCenter_r1", CubeListBuilder.create().texOffs(47, 48).addBox(-2.25f, -1.0f, -3.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.75f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.6545f));
        PartDefinition RightArmSeg2 = RightArm.addOrReplaceChild("RightArmSeg2", CubeListBuilder.create().texOffs(82, 87).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(84, 46).addBox(-2.5f, -0.01f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.25f, (float)6.0f, (float)0.0f));
        PartDefinition RightArmClaw = RightArmSeg2.addOrReplaceChild("RightArmClaw", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition Claw1 = RightArmClaw.addOrReplaceChild("Claw1", CubeListBuilder.create().texOffs(44, 93).addBox(-4.75f, -3.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.0f));
        PartDefinition Claw2 = RightArmClaw.addOrReplaceChild("Claw2", CubeListBuilder.create().texOffs(44, 93).addBox(-5.25f, -2.5f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition Claw3 = RightArmClaw.addOrReplaceChild("Claw3", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition Claw3_r1 = Claw3.addOrReplaceChild("Claw3_r1", CubeListBuilder.create().texOffs(44, 87).mirror().addBox(1.5f, -2.0f, -2.0f, 0.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)-1.25f, (float)-2.8362f, (float)0.0f, (float)3.1416f));
        PartDefinition Claw4 = RightArmClaw.addOrReplaceChild("Claw4", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-2.0f, (float)0.0f));
        PartDefinition Claw4_r1 = Claw4.addOrReplaceChild("Claw4_r1", CubeListBuilder.create().texOffs(44, 87).addBox(0.0f, -2.0f, -4.0f, 0.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.25f, (float)0.3927f, (float)0.0f, (float)0.0873f));
        PartDefinition Head = UpperTorso.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 13).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.25f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition Helmet = Head.addOrReplaceChild("Helmet", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition HelmTopCenter_r1 = Helmet.addOrReplaceChild("HelmTopCenter_r1", CubeListBuilder.create().texOffs(1, 39).addBox(-2.0f, -1.0f, -4.0f, 4.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-4.75f, (float)0.249f, (float)0.0f, (float)-0.0873f, (float)-0.1309f));
        PartDefinition HelmTopRight_r1 = Helmet.addOrReplaceChild("HelmTopRight_r1", CubeListBuilder.create().texOffs(2, 33).addBox(-1.0f, -0.5f, -3.75f, 4.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5672f));
        PartDefinition HelmBackRightTorsoConnection_r1 = Helmet.addOrReplaceChild("HelmBackRightTorsoConnection_r1", CubeListBuilder.create().texOffs(3, 44).addBox(-3.4847f, -1.5046f, -0.9859f, 7.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0153f, (float)7.1046f, (float)2.8859f, (float)-0.5236f, (float)0.0f, (float)0.1309f));
        PartDefinition HelmBackRight_r1 = Helmet.addOrReplaceChild("HelmBackRight_r1", CubeListBuilder.create().texOffs(0, 33).addBox(-4.0f, -7.0f, -5.0f, 7.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0237f, (float)3.4033f, (float)3.5019f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition HelmBackUpperLeft_r1 = Helmet.addOrReplaceChild("HelmBackUpperLeft_r1", CubeListBuilder.create().texOffs(9, 39).addBox(-2.0f, -6.0f, 0.0f, 3.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.7737f, (float)1.4033f, (float)3.0019f, (float)0.0f, (float)0.4363f, (float)0.0f));
        PartDefinition HelmBackLowerLeft_r1 = Helmet.addOrReplaceChild("HelmBackLowerLeft_r1", CubeListBuilder.create().texOffs(0, 39).addBox(-3.0f, -2.0f, -1.0f, 7.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0237f, (float)3.4033f, (float)3.5019f, (float)0.0f, (float)0.2182f, (float)-0.48f));
        PartDefinition HelmRightEyepatch_r1 = Helmet.addOrReplaceChild("HelmRightEyepatch_r1", CubeListBuilder.create().texOffs(61, 34).addBox(-1.0571f, -1.1944f, -0.9f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(1, 44).addBox(-2.0571f, -4.1944f, -0.9f, 8.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1429f, (float)-0.0556f, (float)-3.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition HelmRightBase_r1 = Helmet.addOrReplaceChild("HelmRightBase_r1", CubeListBuilder.create().texOffs(3, 36).addBox(-1.0f, -3.5f, -1.5f, 2.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.2737f, (float)-0.0967f, (float)-1.9981f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition HelmFrontMiddleRight_r1 = Helmet.addOrReplaceChild("HelmFrontMiddleRight_r1", CubeListBuilder.create().texOffs(12, 35).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.2737f, (float)0.4033f, (float)-3.4981f, (float)0.0f, (float)-0.6981f, (float)0.0f));
        PartDefinition HelmJawRight_r1 = Helmet.addOrReplaceChild("HelmJawRight_r1", CubeListBuilder.create().texOffs(89, 34).mirror().addBox(-4.0f, -2.0434f, -1.2462f, 8.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.4429f, (float)3.6944f, (float)-3.1f, (float)0.1745f, (float)0.0f, (float)0.48f));
        PartDefinition HelmJawLeft_r1 = Helmet.addOrReplaceChild("HelmJawLeft_r1", CubeListBuilder.create().texOffs(89, 34).addBox(-4.0f, -1.0f, -0.5f, 8.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.9733f, (float)2.2864f, (float)-4.0f, (float)0.0f, (float)0.0873f, (float)-0.48f));
        PartDefinition HelmCrest = Helmet.addOrReplaceChild("HelmCrest", CubeListBuilder.create().texOffs(0, 81).addBox(0.0436f, -6.4981f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2678f, (float)-5.0444f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition RightFungus_r1 = HelmCrest.addOrReplaceChild("RightFungus_r1", CubeListBuilder.create().texOffs(0, 81).addBox(-2.0f, -4.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0382f, (float)-1.6531f, (float)-0.0436f, (float)0.0f, (float)-0.1309f, (float)-0.3491f));
        PartDefinition LeftFungus_r1 = HelmCrest.addOrReplaceChild("LeftFungus_r1", CubeListBuilder.create().texOffs(0, 81).mirror().addBox(-0.75f, -3.75f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0841f, (float)-1.6531f, (float)-0.0436f, (float)-3.1416f, (float)-0.1309f, (float)-2.7925f));
        PartDefinition HelmExtraDetails = Helmet.addOrReplaceChild("HelmExtraDetails", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)0.0f, (float)0.0f));
        PartDefinition FungalPlate1 = HelmExtraDetails.addOrReplaceChild("FungalPlate1", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.3034f, (float)-2.9293f, (float)0.8665f, (float)0.0f, (float)0.2618f, (float)0.0436f));
        PartDefinition FungalRidgeEdge_r1 = FungalPlate1.addOrReplaceChild("FungalRidgeEdge_r1", CubeListBuilder.create().texOffs(34, 51).addBox(-5.0f, -1.51f, 2.75f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.25f)).texOffs(34, 51).addBox(-5.0f, -1.51f, -6.75f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.25f)).texOffs(28, 44).addBox(-5.75f, -1.5f, -5.5f, 2.0f, 1.0f, 9.0f, new CubeDeformation(-0.25f)).texOffs(22, 57).addBox(-4.0f, -1.5f, -5.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.7531f, (float)0.3058f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition FungalPlate2 = HelmExtraDetails.addOrReplaceChild("FungalPlate2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.1402f, (float)-1.2328f, (float)0.9948f, (float)0.0f, (float)0.5672f, (float)-0.2618f));
        PartDefinition FungalRidgeEdge_r2 = FungalPlate2.addOrReplaceChild("FungalRidgeEdge_r2", CubeListBuilder.create().texOffs(34, 51).addBox(-5.0f, -1.51f, 2.5f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.25f)).texOffs(34, 51).addBox(-5.0f, -1.51f, -6.5f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.25f)).texOffs(28, 44).addBox(-5.5f, -1.5f, -5.5f, 2.0f, 1.0f, 9.0f, new CubeDeformation(-0.25f)).texOffs(22, 57).addBox(-4.0f, -2.0f, -5.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)-3.7531f, (float)0.3058f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition FungalPlate3 = HelmExtraDetails.addOrReplaceChild("FungalPlate3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0655f, (float)0.876f, (float)2.5103f, (float)0.0f, (float)-0.3491f, (float)-0.5236f));
        PartDefinition FungalRidgeEdge_r3 = FungalPlate3.addOrReplaceChild("FungalRidgeEdge_r3", CubeListBuilder.create().texOffs(34, 51).addBox(-5.0f, -1.51f, 2.8f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)).texOffs(34, 51).addBox(-5.0f, -1.51f, -6.8f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)).texOffs(28, 44).addBox(-5.8f, -1.5f, -5.5f, 2.0f, 1.0f, 9.0f, new CubeDeformation(-0.2f)).texOffs(22, 57).addBox(-4.0f, -1.5f, -5.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.7531f, (float)0.3058f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition FungalPlate4 = HelmExtraDetails.addOrReplaceChild("FungalPlate4", CubeListBuilder.create().texOffs(22, 57).addBox(-5.0f, -1.1942f, -0.2469f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(27, 46).addBox(-5.5f, -1.1942f, 7.4531f, 9.0f, 1.0f, 2.0f, new CubeDeformation(-0.3f)).texOffs(29, 57).addBox(-6.7f, -1.2042f, -0.2469f, 2.0f, 1.0f, 9.0f, new CubeDeformation(-0.3f)).texOffs(30, 57).addBox(2.7f, -1.2042f, -0.2469f, 2.0f, 1.0f, 9.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)2.5757f, (float)0.9283f, (float)1.2508f, (float)0.2182f, (float)0.3491f, (float)-0.2618f));
        PartDefinition UpperTorsoFungalPlate = UpperTorso.addOrReplaceChild("UpperTorsoFungalPlate", CubeListBuilder.create().texOffs(22, 57).mirror().addBox(-3.0f, -1.6942f, -0.2469f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(28, 46).mirror().addBox(-3.5f, -1.1942f, 7.7531f, 9.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(30, 57).mirror().addBox(5.0f, -1.2042f, -0.2469f, 2.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(30, 57).mirror().addBox(-5.0f, -1.2042f, -0.2469f, 2.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.2336f, (float)-0.3932f, (float)1.1873f, (float)0.3054f, (float)-0.48f, (float)0.0f));
        PartDefinition Legs = KnightHyper.addOrReplaceChild("Legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition RightLeg = Legs.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(10, 91).addBox(-3.0f, -1.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(36, 82).addBox(-3.5f, -1.01f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-14.0f, (float)0.0f));
        PartDefinition RightLegSeg2 = RightLeg.addOrReplaceChild("RightLegSeg2", CubeListBuilder.create().texOffs(77, 2).addBox(-3.5f, 1.01f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition RightLegSeg2_r1 = RightLegSeg2.addOrReplaceChild("RightLegSeg2_r1", CubeListBuilder.create().texOffs(10, 91).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition LeftLeg = Legs.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(75, 74).addBox(-2.0f, -1.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-14.0f, (float)0.0f));
        PartDefinition LeftLegSeg2 = LeftLeg.addOrReplaceChild("LeftLegSeg2", CubeListBuilder.create().texOffs(75, 21).addBox(-2.0f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition LeftLegFungus = LeftLegSeg2.addOrReplaceChild("LeftLegFungus", CubeListBuilder.create(), PartPose.offset((float)12.75f, (float)20.0527f, (float)-2.4006f));
        PartDefinition Fungus_r2 = LeftLegFungus.addOrReplaceChild("Fungus_r2", CubeListBuilder.create().texOffs(-7, 49).addBox(-3.5f, 0.0f, -1.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.25f, (float)-20.05f, (float)0.55f, (float)0.0392f, (float)0.5172f, (float)0.2531f));
        PartDefinition Fungus_r3 = LeftLegFungus.addOrReplaceChild("Fungus_r3", CubeListBuilder.create().texOffs(-7, 49).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.25f, (float)-17.05f, (float)2.45f, (float)0.0602f, (float)-0.5154f, (float)0.0523f));
        PartDefinition Fungus_r4 = LeftLegFungus.addOrReplaceChild("Fungus_r4", CubeListBuilder.create().texOffs(-7, 56).addBox(-4.25f, -1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.25f, (float)-13.05f, (float)1.55f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        this.LeftForLeg.xRot = this.LeftLeg.xRot < 0.0f ? -this.LeftLeg.xRot : 0.0f;
        float f = this.RightForLeg.xRot = this.RightLeg.xRot < 0.0f ? -this.RightLeg.xRot : 0.0f;
        if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            this.Arm.xRot = -0.5f + Mth.cos((float)(ageInTicks / 6.0f)) / 6.0f;
            this.ForArm.xRot = -0.5f + Mth.cos((float)(ageInTicks / 8.0f)) / 8.0f;
        } else {
            this.Arm.xRot = Mth.cos((float)(ageInTicks / 8.0f)) / 8.0f;
            float f2 = this.ForArm.xRot = this.Arm.xRot < 0.0f ? this.Arm.xRot : 0.0f;
        }
        if (((Inquisitor)((Object)entity)).attackAnim > 0.0f) {
            float f1 = 1.0f - Mth.abs((float)(10.0f - 2.0f * ((Inquisitor)((Object)entity)).attackAnim)) / 6.5f;
            this.Arm.xRot = -0.5f + Mth.sin((float)f1) * 3.0f;
        }
        this.Claw1.zRot = Mth.cos((float)(ageInTicks / 7.0f)) / 8.0f;
        this.Claw2.zRot = Mth.sin((float)(ageInTicks / 7.0f)) / 7.0f;
        this.Claw3.xRot = Mth.cos((float)(ageInTicks / 7.0f)) / 6.0f;
        this.Claw4.xRot = -Mth.cos((float)(ageInTicks / 7.0f)) / 6.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.KnightHyper.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

