/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Knight;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class KnightModel<T extends Knight>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"knightmodel"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart rightArm;
    private final ModelPart rightForearm;
    private final ModelPart rightFingers;
    private final ModelPart rightThumb;
    private final ModelPart leftLeg;
    private final ModelPart leftForeleg;
    private final ModelPart rightLeg;
    private final ModelPart rightForeleg;

    public KnightModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.rightArm = this.body.getChild("RightArm");
        this.rightForearm = this.rightArm.getChild("RightForArm");
        this.rightFingers = this.rightForearm.getChild("fingers");
        this.rightThumb = this.rightForearm.getChild("tumb");
        this.leftLeg = this.body.getChild("LeftLeg");
        this.leftForeleg = this.leftLeg.getChild("leftForLeg");
        this.rightLeg = this.body.getChild("RightLeg");
        this.rightForeleg = this.rightLeg.getChild("rightForLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 30).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 34).addBox(-3.5f, 4.5f, -2.0f, 7.0f, 6.0f, 4.0f, new CubeDeformation(-0.3f)).texOffs(22, 39).addBox(-3.5f, 10.0f, -2.0f, 7.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 63).addBox(3.0f, -3.0f, -3.0f, 2.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 63).addBox(5.0f, -7.0f, -3.0f, 2.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(17, 57).addBox(3.0f, 9.0f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(27, 55).addBox(-2.0f, -0.25f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(19, 66).addBox(-2.0f, 7.75f, -2.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(-6, 81).addBox(1.0f, -15.0f, -5.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(-6, 81).addBox(4.0f, -20.0f, -5.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(-6, 81).addBox(-3.0f, -25.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.2182f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(-6, 81).addBox(-2.0f, -21.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(-6, 81).addBox(-6.0f, -18.0f, -4.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(-6, 81).addBox(-12.0f, -28.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(-6, 81).addBox(-12.0f, -30.0f, -9.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.2182f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 22).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(40, 41).addBox(-3.5f, 0.0f, -3.75f, 7.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition mushroom2 = head.addOrReplaceChild("mushroom2", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, -4.0f, -6.0f, 0.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(-2.0f, -2.0f, -6.0f, 0.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 22).addBox(-0.5f, -1.0f, -3.0f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-0.5f, -2.0f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.48f, (float)0.0f));
        PartDefinition RightArm = body.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(0, 54).addBox(-2.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(52, 27).addBox(-2.0f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition fingers = RightForArm.addOrReplaceChild("fingers", CubeListBuilder.create().texOffs(12, 55).addBox(-2.0f, -1.0f, 1.0f, 4.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(12, 55).addBox(-2.0f, -1.0f, -1.0f, 4.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)6.0f, (float)0.0f));
        PartDefinition tumb = RightForArm.addOrReplaceChild("tumb", CubeListBuilder.create().texOffs(58, -3).addBox(0.0f, -1.0f, -3.0f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.0f));
        PartDefinition RightLeg = body.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(42, 47).addBox(-1.75f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition rightForLeg = RightLeg.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(14, 45).addBox(-1.75f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg = body.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(28, 45).addBox(-1.25f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition leftForLeg = LeftLeg.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(0, 44).addBox(-1.25f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition mushroom = body.addOrReplaceChild("mushroom", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)2.0f));
        PartDefinition tendril = body.addOrReplaceChild("tendril", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)6.0f, (float)2.0f));
        PartDefinition tendril2 = body.addOrReplaceChild("tendril2", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)6.0f, (float)-2.0f));
        PartDefinition tendril3 = body.addOrReplaceChild("tendril3", CubeListBuilder.create(), PartPose.offset((float)7.0f, (float)0.0f, (float)-1.0f));
        PartDefinition tendril4 = body.addOrReplaceChild("tendril4", CubeListBuilder.create(), PartPose.offset((float)7.0f, (float)-3.0f, (float)1.0f));
        PartDefinition flower = body.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)5.0f, (float)-5.0f, (float)-1.0f, (float)0.3054f, (float)0.0f, (float)0.4363f));
        PartDefinition cube_r4 = flower.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(10, 75).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r5 = flower.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(10, 75).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r6 = flower.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(10, 75).addBox(-4.0f, 0.0f, 0.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = flower.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(10, 75).addBox(-4.0f, 0.0f, -6.0f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupHeadAnimations(entity, ageInTicks);
        if (entity.isAggressive()) {
            this.handleAggressiveAnimations(entity, limbSwing, limbSwingAmount, ageInTicks);
        } else if (Math.abs(limbSwingAmount) > 0.15f) {
            this.handleWalkingAnimations(limbSwing, limbSwingAmount);
        } else {
            this.handleIdleAnimations(ageInTicks);
        }
        this.setupLegAnimations(limbSwing, limbSwingAmount);
    }

    private void setupHeadAnimations(T entity, float ageInTicks) {
        float jawMovement = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        if (entity.isAggressive()) {
            jawMovement = Mth.sin((float)(ageInTicks / 6.0f)) / 10.0f;
        }
        this.jaw.xRot = jawMovement;
    }

    private void handleAggressiveAnimations(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.rightArm.xRot = 25.0f + Mth.cos((float)(limbSwing * 0.2f)) * limbSwingAmount;
        this.rightForearm.xRot = -88.5f;
        this.body.zRot = Mth.cos((float)(limbSwing / 4.0f)) / 10.0f;
        if (((Knight)entity).swinging) {
            this.handleSwingAttackAnimation();
        } else if (((Knight)entity).attackAnim > 0.0f) {
            this.handleAttackAnimation(entity);
        }
    }

    private void handleSwingAttackAnimation() {
        float attackProgress = 1.0f;
        this.rightArm.xRot = -90.0f + attackProgress;
        this.rightForearm.xRot = 0.0f;
    }

    private void handleAttackAnimation(T entity) {
        float attackProgress = 1.0f - Mth.abs((float)(10.0f - 2.0f * ((Knight)entity).attackAnim)) / 10.0f;
        this.rightArm.xRot = Mth.sin((float)attackProgress) * 2.0f;
    }

    private void handleWalkingAnimations(float limbSwing, float limbSwingAmount) {
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.rightArm.zRot = 0.0f;
        this.resetBodyRotation();
    }

    private void handleIdleAnimations(float ageInTicks) {
        this.resetBodyRotation();
        this.rightArm.zRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        this.rightFingers.zRot = Mth.sin((float)(ageInTicks / 4.0f)) / 8.0f;
        this.rightThumb.xRot = -Mth.sin((float)(ageInTicks / 4.0f)) / 8.0f;
        this.rightForearm.xRot = 0.0f;
    }

    private void setupLegAnimations(float limbSwing, float limbSwingAmount) {
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        this.updateForelegAnimations();
    }

    private void updateForelegAnimations() {
        if (this.leftLeg.xRot < 0.0f) {
            this.leftForeleg.xRot = -2.0f * this.leftLeg.xRot;
        }
        if (this.rightLeg.xRot < 0.0f) {
            this.rightForeleg.xRot = -2.0f * this.rightLeg.xRot;
        }
    }

    private void resetBodyRotation() {
        this.body.zRot = 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

