/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Leaper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class LeaperModel<T extends Leaper>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"leapermodel"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart armor;

    public LeaperModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
        this.armor = root.getChild("armor");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(13, 44).addBox(-3.5f, -2.0f, -5.0f, 7.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-4.0f, -10.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(69, 24).addBox(-4.0f, -2.0f, 1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(13, 36).addBox(-4.0f, -2.0f, -5.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(13, 38).addBox(4.0f, -2.0f, -4.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(67, 64).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(24, 40).addBox(-4.0f, -1.0f, -6.0f, 8.0f, 2.0f, 6.0f, new CubeDeformation(-0.05f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.0f));
        PartDefinition flower = head.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0f, (float)-5.5f, (float)-3.75f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r1 = flower.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(18, 31).addBox(-6.6073f, -2.8145f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r2 = flower.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(36, 16).addBox(-3.484f, -2.617f, -7.084f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = flower.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(40, 40).addBox(-3.484f, -2.617f, 1.084f, 7.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition flower2 = flower.addOrReplaceChild("flower2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.0f, (float)1.0f, (float)2.0f, (float)0.2182f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r4 = flower2.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(30, 0).addBox(2.3057f, -1.6184f, -3.4729f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r5 = flower2.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(34, 8).addBox(-7.514f, -2.7747f, -3.4729f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r6 = flower2.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(16, 15).addBox(-3.4892f, -2.3983f, -8.4229f, 9.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = flower2.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(63, 18).addBox(2.3057f, -1.6184f, -2.4729f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r8 = flower2.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(24, 23).addBox(-3.4892f, -1.9949f, 1.3968f, 9.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition fungus = head.addOrReplaceChild("fungus", CubeListBuilder.create().texOffs(12, 62).addBox(-6.0f, -34.7f, -5.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)27.5f, (float)3.25f));
        PartDefinition cube_r9 = fungus.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(59, 58).addBox(5.75f, -30.75f, -3.5f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.7f, (float)0.0f, (float)0.228f, (float)0.1298f, (float)-0.3342f));
        PartDefinition cube_r10 = fungus.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(60, 0).addBox(-4.0f, -34.0f, -2.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.7f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r11 = fungus.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(43, 60).addBox(-4.0f, -32.0f, -4.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r12 = fungus.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(62, 31).addBox(-6.0f, -35.0f, -5.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.7f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(30, 31).addBox(-5.0f, 9.0f, -3.0f, 10.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 31).addBox(-4.5f, 4.5f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(-0.1f)).texOffs(48, 0).addBox(0.75f, 10.05f, -6.25f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition cube_r13 = body.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(21, 7).addBox(-3.0f, -19.0f, -20.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)25.8f, (float)2.5f, (float)-0.829f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r14 = body.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(50, 31).addBox(0.75f, 7.25f, -10.75f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)2.8f, (float)6.5f, (float)-0.3054f, (float)0.2618f, (float)0.0f));
        PartDefinition cube_r15 = body.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(52, 6).addBox(0.75f, 7.25f, -11.75f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)2.8f, (float)6.5f, (float)-0.6109f, (float)-0.2618f, (float)0.1309f));
        PartDefinition cube_r16 = body.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(54, 40).addBox(0.75f, 7.25f, -5.75f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)2.8f, (float)6.5f, (float)0.0f, (float)0.3491f, (float)0.2618f));
        PartDefinition cube_r17 = body.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(58, 12).addBox(-1.25f, -2.75f, -4.75f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)2.8f, (float)6.5f, (float)0.4363f, (float)-0.2182f, (float)0.2182f));
        PartDefinition cube_r18 = body.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(59, 46).addBox(3.75f, -8.75f, -3.75f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)11.8f, (float)6.5f, (float)-0.2182f, (float)0.2618f, (float)0.0f));
        PartDefinition cube_r19 = body.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(59, 52).addBox(-4.25f, -6.75f, -5.75f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)11.8f, (float)6.5f, (float)-0.3054f, (float)-0.2618f, (float)0.0f));
        PartDefinition spine2 = body.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -5.5f, -6.5f, 12.0f, 8.0f, 7.0f, new CubeDeformation(-0.3f)), PartPose.offset((float)0.0f, (float)3.0f, (float)3.25f));
        PartDefinition back3 = spine2.addOrReplaceChild("back3", CubeListBuilder.create().texOffs(12, 68).addBox(0.0f, -4.0f, -2.75f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-1.0f, (float)-3.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        PartDefinition back4 = spine2.addOrReplaceChild("back4", CubeListBuilder.create().texOffs(55, 64).addBox(-2.0f, -4.0f, -4.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-1.0f, (float)-2.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(51, 17).addBox(-2.0f, -2.0f, -2.5f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-9.0f, (float)-1.0f, (float)0.0f));
        PartDefinition RightForArm = RightArm.addOrReplaceChild("RightForArm", CubeListBuilder.create().texOffs(68, 71).addBox(-2.0f, 0.0f, -2.25f, 4.0f, 7.0f, 5.0f, new CubeDeformation(0.1f)).texOffs(76, 6).addBox(-4.0f, 4.0f, -1.5f, 4.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 69).addBox(-4.0f, 4.0f, 2.0f, 4.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)-0.25f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(18, 48).addBox(-2.0f, -3.0f, -2.5f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftForArm = LeftArm.addOrReplaceChild("LeftForArm", CubeListBuilder.create().texOffs(30, 70).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 7.0f, 5.0f, new CubeDeformation(0.1f)).texOffs(36, 48).addBox(0.0f, 4.0f, 1.75f, 4.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(0.0f, 4.0f, -1.75f, 4.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create(), PartPose.offset((float)-2.9f, (float)10.0f, (float)0.0f));
        PartDefinition RL = RightLeg.addOrReplaceChild("RL", CubeListBuilder.create().texOffs(31, 57).addBox(-1.75f, -1.0f, -2.5f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightForLeg = RL.addOrReplaceChild("rightForLeg", CubeListBuilder.create().texOffs(47, 46).addBox(-1.75f, -1.0f, -2.5f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)6.5f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create(), PartPose.offset((float)2.9f, (float)10.0f, (float)0.0f));
        PartDefinition LJ = LeftLeg.addOrReplaceChild("LJ", CubeListBuilder.create().texOffs(0, 56).addBox(-2.25f, -1.0f, -2.5f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftForLeg = LJ.addOrReplaceChild("leftForLeg", CubeListBuilder.create().texOffs(0, 42).addBox(-2.25f, -1.0f, -2.5f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)6.5f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition armor = partdefinition.addOrReplaceChild("armor", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition cube_r20 = armor.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(72, 37).addBox(0.0f, -2.0f, -1.0f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition cube_r21 = armor.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(75, 62).addBox(-6.0f, -2.0f, -1.0f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isAggressive()) {
            this.RightArm.xRot = -90.0f + Mth.sin((float)(ageInTicks / 10.0f)) / 10.0f;
            this.LeftArm.xRot = -90.0f + Mth.cos((float)(ageInTicks / 10.0f)) / 10.0f;
            if (((Leaper)entity).swinging) {
                float f = 0.0f;
                this.RightArm.xRot = -89.5f + (f += 1.0f);
                this.LeftArm.xRot = -89.5f + f;
            }
        } else if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
            this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        } else {
            this.RightArm.xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.LeftArm.xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        }
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.8f)) * -0.8f * limbSwingAmount;
        this.head.getChild((String)"jaw").xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 28.647888f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.armor.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

