/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MoundModel<T extends Mound>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"moundmodel"), "main");
    private final ModelPart body;
    private final ModelPart tendrils;
    private final ModelPart small_tendrils;
    private final ModelPart bb_main;

    public MoundModel(ModelPart root) {
        this.body = root.getChild("body");
        this.tendrils = root.getChild("tendrils");
        this.small_tendrils = root.getChild("small_tendrils");
        this.bb_main = root.getChild("bb_main");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 8).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.5f, -7.0f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(12, 14).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition tendrils = partdefinition.addOrReplaceChild("tendrils", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition tendril = tendrils.addOrReplaceChild("tendril", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = tendril.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(50, 0).addBox(-6.0f, -13.0f, 0.0f, 7.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition tendril2 = tendrils.addOrReplaceChild("tendril2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.5f));
        PartDefinition cube_r3 = tendril2.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(50, 6).addBox(0.0f, -13.0f, -7.5f, 0.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition tendril3 = tendrils.addOrReplaceChild("tendril3", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = tendril3.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(50, 26).addBox(-1.0f, -13.0f, 0.0f, 7.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition tendril4 = tendrils.addOrReplaceChild("tendril4", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition cube_r5 = tendril4.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(50, 32).addBox(0.0f, -13.0f, -0.5f, 0.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition small_tendrils = partdefinition.addOrReplaceChild("small_tendrils", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition tendril5 = small_tendrils.addOrReplaceChild("tendril5", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = tendril5.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(36, 0).addBox(-6.0f, -13.0f, 0.0f, 7.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition tendril6 = small_tendrils.addOrReplaceChild("tendril6", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.5f));
        PartDefinition cube_r7 = tendril6.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(36, 6).addBox(0.0f, -13.0f, -7.5f, 0.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition tendril7 = small_tendrils.addOrReplaceChild("tendril7", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = tendril7.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(36, 26).addBox(-1.0f, -13.0f, 0.0f, 7.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition tendril8 = small_tendrils.addOrReplaceChild("tendril8", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition cube_r9 = tendril8.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(36, 32).addBox(0.0f, -13.0f, -0.5f, 0.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bb_main = partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, 0.0f, -6.0f, 12.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.xScale = 1.0f + Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
        this.body.zScale = 1.0f + Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
        this.body.yScale = 1.0f - Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
        this.small_tendrils.visible = ((Mound)entity).getAge() >= 3;
        this.tendrils.visible = ((Mound)entity).getAge() >= 4;
        this.bb_main.visible = entity.onGround();
        if (this.small_tendrils.visible) {
            this.small_tendrils.getChild((String)"tendril5").zRot = -Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
            this.small_tendrils.getChild((String)"tendril7").zRot = Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
            this.small_tendrils.getChild((String)"tendril6").xRot = Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
            this.small_tendrils.getChild((String)"tendril8").xRot = -Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
        }
        if (this.tendrils.visible) {
            this.tendrils.getChild((String)"tendril").zRot = -Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
            this.tendrils.getChild((String)"tendril3").zRot = Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
            this.tendrils.getChild((String)"tendril2").xRot = Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
            this.tendrils.getChild((String)"tendril4").xRot = -Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.tendrils.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.small_tendrils.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.bb_main.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

