/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Models.TentacledModel;
import com.Harbinger.Spore.Sentities.Hyper.Ogre;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class OgreModel<T extends Ogre>
extends EntityModel<T>
implements TentacledModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"ogremodel"), "main");
    private final ModelPart H_brute;
    private final ModelPart TailSegment1;
    private final ModelPart TailSegment2;
    private final ModelPart TailSegment3;
    private final ModelPart TailSegment4;
    private final ModelPart TailTumor;
    private final ModelPart TailSpikes;
    private final ModelPart TailBody;
    private final ModelPart Spike1;
    private final ModelPart Spike2;
    private final ModelPart Spike3;
    private final ModelPart Spike4;
    private final ModelPart Spike5;
    private final ModelPart Spike6;
    private final ModelPart Spike7;
    private final ModelPart Jaw1;
    private final ModelPart Jaw2;
    private final ModelPart Jaw3;
    private final ModelPart HeadY;
    private final ModelPart HeadX;
    private final ModelPart Legs;
    private final ModelPart RightBackLeg;
    private final ModelPart RightBackForLeg;
    private final ModelPart LeftBackLeg;
    private final ModelPart LeftBackForLeg;
    private final ModelPart RightFrontArm;
    private final ModelPart LeftFrontArm;
    private final ModelPart RightFrontForArm;
    private final ModelPart LeftFrontForArm;

    public OgreModel(ModelPart root) {
        this.H_brute = root.getChild("H_brute");
        this.TailSegment1 = this.H_brute.getChild("Tail");
        this.TailSegment2 = this.TailSegment1.getChild("TailSeg2");
        this.TailSegment3 = this.TailSegment2.getChild("TailSeg3");
        this.TailSegment4 = this.TailSegment3.getChild("TailSeg4");
        this.TailTumor = this.TailSegment4.getChild("TumorTip").getChild("Tumors");
        this.TailSpikes = this.TailSegment4.getChild("TumorTip").getChild("Thorns");
        this.TailBody = this.TailSegment4.getChild("TumorTip").getChild("Impaled");
        this.Spike1 = this.TailSpikes.getChild("Thorn1");
        this.Spike2 = this.TailSpikes.getChild("Thorn2");
        this.Spike3 = this.TailSpikes.getChild("Thorn3");
        this.Spike4 = this.TailSpikes.getChild("Thorn4");
        this.Spike5 = this.TailSpikes.getChild("Thorn5");
        this.Spike6 = this.TailSpikes.getChild("Thorn6");
        this.Spike7 = this.TailSpikes.getChild("Thorn7");
        this.Jaw1 = this.H_brute.getChild("LowerTorso").getChild("UpperTorso").getChild("Jaw");
        this.Jaw2 = this.Jaw1.getChild("TorsoMiddle").getChild("TorsoTop");
        this.Jaw3 = this.Jaw2.getChild("JawTip");
        this.HeadY = this.H_brute.getChild("LowerTorso").getChild("UpperTorso").getChild("Neck");
        this.HeadX = this.HeadY.getChild("Head");
        this.Legs = this.H_brute.getChild("Legs");
        this.RightBackLeg = this.Legs.getChild("RightLeg");
        this.RightBackForLeg = this.RightBackLeg.getChild("RightLegSeg2");
        this.LeftBackLeg = this.Legs.getChild("LeftLeg");
        this.LeftBackForLeg = this.LeftBackLeg.getChild("LeftLegSeg2");
        this.RightFrontArm = this.H_brute.getChild("LowerTorso").getChild("UpperTorso").getChild("Arms").getChild("RightArm");
        this.LeftFrontArm = this.H_brute.getChild("LowerTorso").getChild("UpperTorso").getChild("Arms").getChild("LeftArm");
        this.RightFrontForArm = this.RightFrontArm.getChild("RightArmSeg2");
        this.LeftFrontForArm = this.LeftFrontArm.getChild("LeftArmSeg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition H_brute = partdefinition.addOrReplaceChild("H_brute", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)16.0f, (float)3.0f));
        PartDefinition LowerTorso = H_brute.addOrReplaceChild("LowerTorso", CubeListBuilder.create().texOffs(64, 34).addBox(-10.0f, -10.0f, -5.0f, 20.0f, 14.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-14.0f, (float)6.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition UpperTorso = LowerTorso.addOrReplaceChild("UpperTorso", CubeListBuilder.create().texOffs(0, 0).addBox(-14.0f, -23.0f, -3.0f, 28.0f, 23.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(24, 199).mirror().addBox(-14.0f, -11.0f, -8.0f, 6.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 199).addBox(8.0f, -11.0f, -8.0f, 6.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 193).mirror().addBox(-14.0f, -23.0f, -8.0f, 7.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 193).addBox(7.0f, -23.0f, -8.0f, 7.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition RightShoulder_r1 = UpperTorso.addOrReplaceChild("RightShoulder_r1", CubeListBuilder.create().texOffs(48, 151).mirror().addBox(-6.0f, -6.0f, -7.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-10.0f, (float)-19.0f, (float)5.0f, (float)0.2618f, (float)0.0f, (float)-0.48f));
        PartDefinition LeftShoulder_r1 = UpperTorso.addOrReplaceChild("LeftShoulder_r1", CubeListBuilder.create().texOffs(48, 151).addBox(-6.0f, -6.0f, -7.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)-19.0f, (float)5.0f, (float)0.2618f, (float)0.0f, (float)0.48f));
        PartDefinition Arms = UpperTorso.addOrReplaceChild("Arms", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-13.6868f, (float)-1.0746f, (float)-1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = Arms.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(0, 34).addBox(-14.0f, -7.5f, -7.5f, 17.0f, 15.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0195f, (float)-2.0f, (float)3.34f, (float)0.2546f, (float)-0.4114f, (float)-0.577f));
        PartDefinition ArmCrown1 = RightArm.addOrReplaceChild("ArmCrown1", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-9.6088f, (float)-6.5266f, (float)7.0266f, (float)-0.683f, (float)-0.8025f, (float)0.4237f));
        PartDefinition Petal5_r1 = ArmCrown1.addOrReplaceChild("Petal5_r1", CubeListBuilder.create().texOffs(-7, 136).addBox(-2.0f, -1.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8861f, (float)-0.5245f, (float)0.0399f, (float)0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition Petal4_r1 = ArmCrown1.addOrReplaceChild("Petal4_r1", CubeListBuilder.create().texOffs(-7, 122).addBox(-6.0f, -2.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6315f, (float)1.4073f, (float)0.0399f, (float)0.263f, (float)-0.1603f, (float)-0.1693f));
        PartDefinition Petal3_r1 = ArmCrown1.addOrReplaceChild("Petal3_r1", CubeListBuilder.create().texOffs(-7, 122).addBox(-4.0f, 0.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1139f, (float)-0.5245f, (float)-3.9601f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal2_r1 = ArmCrown1.addOrReplaceChild("Petal2_r1", CubeListBuilder.create().texOffs(-7, 136).addBox(-3.5f, 0.0f, -1.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2969f, (float)0.3356f, (float)0.5792f, (float)0.4726f, (float)0.2047f, (float)0.1036f));
        PartDefinition ArmCrown2 = RightArm.addOrReplaceChild("ArmCrown2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-12.6864f, (float)-5.7593f, (float)-7.111f, (float)1.4358f, (float)-0.3455f, (float)-2.2499f));
        PartDefinition Petal6_r1 = ArmCrown2.addOrReplaceChild("Petal6_r1", CubeListBuilder.create().texOffs(-7, 129).addBox(-2.0f, -1.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8861f, (float)-0.5245f, (float)0.0399f, (float)0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition Petal5_r2 = ArmCrown2.addOrReplaceChild("Petal5_r2", CubeListBuilder.create().texOffs(-7, 122).addBox(-6.0f, -2.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6315f, (float)1.4073f, (float)0.0399f, (float)0.263f, (float)-0.1603f, (float)-0.1693f));
        PartDefinition Petal4_r2 = ArmCrown2.addOrReplaceChild("Petal4_r2", CubeListBuilder.create().texOffs(-7, 129).addBox(-4.0f, 0.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1139f, (float)-0.5245f, (float)-3.9601f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal3_r2 = ArmCrown2.addOrReplaceChild("Petal3_r2", CubeListBuilder.create().texOffs(-7, 136).addBox(-3.5f, 0.0f, -1.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2969f, (float)0.3356f, (float)0.5792f, (float)0.4726f, (float)0.2047f, (float)0.1036f));
        PartDefinition RightArmSeg2 = RightArm.addOrReplaceChild("RightArmSeg2", CubeListBuilder.create().texOffs(64, 58).addBox(-13.0f, -6.0f, -6.0f, 17.0f, 12.0f, 12.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)-13.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.829f));
        PartDefinition RightArmSeg3 = RightArmSeg2.addOrReplaceChild("RightArmSeg3", CubeListBuilder.create().texOffs(168, 112).addBox(-4.0f, -6.0f, -6.0f, 8.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition RightArmFist = RightArmSeg3.addOrReplaceChild("RightArmFist", CubeListBuilder.create().texOffs(0, 94).addBox(-16.0f, -7.0f, -7.0f, 12.0f, 14.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition CrownFist = RightArmFist.addOrReplaceChild("CrownFist", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-7.2549f, (float)-6.8517f, (float)-3.2775f, (float)0.1262f, (float)-0.1659f, (float)0.0297f));
        PartDefinition Petal5_r3 = CrownFist.addOrReplaceChild("Petal5_r3", CubeListBuilder.create().texOffs(-7, 136).addBox(-2.0f, -1.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8861f, (float)-0.5245f, (float)-0.0399f, (float)-0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition Petal4_r3 = CrownFist.addOrReplaceChild("Petal4_r3", CubeListBuilder.create().texOffs(-7, 136).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.6825f, (float)-0.6481f, (float)1.3381f, (float)-0.1019f, (float)0.1482f, (float)-0.2567f));
        PartDefinition Petal3_r3 = CrownFist.addOrReplaceChild("Petal3_r3", CubeListBuilder.create().texOffs(-7, 136).addBox(-4.0f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1139f, (float)-0.5245f, (float)3.9601f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal2_r2 = CrownFist.addOrReplaceChild("Petal2_r2", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 0.0f, -5.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2969f, (float)0.3356f, (float)-0.5792f, (float)-0.4726f, (float)-0.2047f, (float)0.1036f));
        PartDefinition RightArmFungus = RightArmSeg2.addOrReplaceChild("RightArmFungus", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.094f, (float)-4.7859f, (float)4.9093f, (float)0.2618f, (float)0.0f, (float)-1.7453f));
        PartDefinition Fungus_r1 = RightArmFungus.addOrReplaceChild("Fungus_r1", CubeListBuilder.create().texOffs(-7, 136).addBox(-3.5f, 0.75f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.3069f, (float)-11.0285f, (float)-9.0354f, (float)-2.0584f, (float)1.0432f, (float)-2.2283f));
        PartDefinition Fungus_r2 = RightArmFungus.addOrReplaceChild("Fungus_r2", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.6919f, 3.5973f, -4.9266f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0258f, (float)-7.9789f, (float)-9.5116f, (float)-2.6021f, (float)0.2949f, (float)3.0982f));
        PartDefinition Fungus_r3 = RightArmFungus.addOrReplaceChild("Fungus_r3", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.6759f, (float)-6.7553f, (float)-5.0483f, (float)-2.8814f, (float)0.562f, (float)3.0473f));
        PartDefinition Fungus_r4 = RightArmFungus.addOrReplaceChild("Fungus_r4", CubeListBuilder.create().texOffs(-7, 129).addBox(-4.4074f, -0.4938f, -1.9099f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0258f, (float)-7.9789f, (float)-9.5116f, (float)-2.7416f, (float)0.3455f, (float)-2.8459f));
        PartDefinition Fungus_r5 = RightArmFungus.addOrReplaceChild("Fungus_r5", CubeListBuilder.create().texOffs(-7, 136).addBox(-1.5f, -1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1221f, (float)-2.9969f, (float)1.2752f, (float)-0.3325f, (float)-0.5154f, (float)0.0523f));
        PartDefinition Fungus_r6 = RightArmFungus.addOrReplaceChild("Fungus_r6", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 1.0f, 0.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.1221f, (float)2.0031f, (float)-4.7248f, (float)0.1797f, (float)0.4891f, (float)0.195f));
        PartDefinition Fungus_r7 = RightArmFungus.addOrReplaceChild("Fungus_r7", CubeListBuilder.create().texOffs(-7, 136).addBox(-2.25f, -5.0f, -2.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1221f, (float)4.0031f, (float)-3.7248f, (float)-0.0333f, (float)-0.6219f, (float)0.3593f));
        PartDefinition Fungus_r8 = RightArmFungus.addOrReplaceChild("Fungus_r8", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 0.0f, -4.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1221f, (float)-0.9969f, (float)2.2752f, (float)-0.1783f, (float)0.2977f, (float)-0.0909f));
        PartDefinition LeftArm = Arms.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(0, 34).mirror().addBox(-3.0f, -7.5f, -7.5f, 17.0f, 15.0f, 15.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)10.0195f, (float)-2.0f, (float)3.34f, (float)0.2546f, (float)0.4114f, (float)0.577f));
        PartDefinition LeftShoulderFungus = LeftArm.addOrReplaceChild("LeftShoulderFungus", CubeListBuilder.create(), PartPose.offsetAndRotation((float)10.067f, (float)-5.6637f, (float)6.1784f, (float)-0.6137f, (float)-0.2264f, (float)0.2434f));
        PartDefinition Petal5_r4 = LeftShoulderFungus.addOrReplaceChild("Petal5_r4", CubeListBuilder.create().texOffs(-7, 136).addBox(-2.0f, -1.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8861f, (float)-0.5245f, (float)-0.0399f, (float)-0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition Petal4_r4 = LeftShoulderFungus.addOrReplaceChild("Petal4_r4", CubeListBuilder.create().texOffs(-7, 136).addBox(-6.0f, -2.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6315f, (float)1.4073f, (float)-0.0399f, (float)-0.263f, (float)0.1603f, (float)-0.1693f));
        PartDefinition Petal3_r4 = LeftShoulderFungus.addOrReplaceChild("Petal3_r4", CubeListBuilder.create().texOffs(-7, 129).addBox(-4.0f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1139f, (float)-0.5245f, (float)3.9601f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal2_r3 = LeftShoulderFungus.addOrReplaceChild("Petal2_r3", CubeListBuilder.create().texOffs(-7, 136).addBox(-3.5f, 0.0f, -5.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2969f, (float)0.3356f, (float)-0.5792f, (float)-0.4726f, (float)-0.2047f, (float)0.1036f));
        PartDefinition LeftArmSeg2 = LeftArm.addOrReplaceChild("LeftArmSeg2", CubeListBuilder.create().texOffs(64, 58).mirror().addBox(-4.0f, -6.0f, -6.0f, 17.0f, 12.0f, 12.0f, new CubeDeformation(-0.01f)).mirror(false), PartPose.offsetAndRotation((float)13.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.829f));
        PartDefinition LeftArmFungus = LeftArmSeg2.addOrReplaceChild("LeftArmFungus", CubeListBuilder.create(), PartPose.offsetAndRotation((float)7.9086f, (float)-4.1524f, (float)-3.0731f, (float)-1.5708f, (float)1.3526f, (float)-3.1416f));
        PartDefinition Fungus_r9 = LeftArmFungus.addOrReplaceChild("Fungus_r9", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5593f, (float)-2.2108f, (float)1.8975f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r10 = LeftArmFungus.addOrReplaceChild("Fungus_r10", CubeListBuilder.create().texOffs(-7, 122).addBox(0.5f, -5.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.4407f, (float)-2.2108f, (float)-2.1025f, (float)-0.2664f, (float)-0.4504f, (float)0.3859f));
        PartDefinition Fungus_r11 = LeftArmFungus.addOrReplaceChild("Fungus_r11", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.678f, (float)0.6324f, (float)2.3074f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        PartDefinition Fungus_r12 = LeftArmFungus.addOrReplaceChild("Fungus_r12", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5593f, (float)0.7892f, (float)-3.1025f, (float)0.0037f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition LeftArmSeg3 = LeftArmSeg2.addOrReplaceChild("LeftArmSeg3", CubeListBuilder.create().texOffs(168, 112).mirror().addBox(-4.0f, -6.0f, -6.0f, 8.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition LeftArmFist = LeftArmSeg3.addOrReplaceChild("LeftArmFist", CubeListBuilder.create().texOffs(0, 94).mirror().addBox(4.0f, -7.0f, -7.0f, 12.0f, 14.0f, 14.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition CrownFist2 = LeftArmFist.addOrReplaceChild("CrownFist2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)9.0267f, (float)4.335f, (float)6.9435f, (float)-1.829f, (float)0.1898f, (float)0.6841f));
        PartDefinition Petal5_r5 = CrownFist2.addOrReplaceChild("Petal5_r5", CubeListBuilder.create().texOffs(-7, 129).addBox(-2.0f, -1.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8861f, (float)-0.5245f, (float)-0.0399f, (float)-0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition Petal4_r5 = CrownFist2.addOrReplaceChild("Petal4_r5", CubeListBuilder.create().texOffs(-7, 136).addBox(-6.0f, -2.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6315f, (float)1.4073f, (float)-0.0399f, (float)-0.263f, (float)0.1603f, (float)-0.1693f));
        PartDefinition Petal3_r5 = CrownFist2.addOrReplaceChild("Petal3_r5", CubeListBuilder.create().texOffs(-7, 122).addBox(-4.0f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1139f, (float)-0.5245f, (float)3.9601f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal2_r4 = CrownFist2.addOrReplaceChild("Petal2_r4", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 0.0f, -5.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2969f, (float)0.3356f, (float)-0.5792f, (float)-0.4726f, (float)-0.2047f, (float)0.1036f));
        PartDefinition Neck = UpperTorso.addOrReplaceChild("Neck", CubeListBuilder.create().texOffs(64, 130).addBox(-8.0f, -4.5f, -11.0f, 16.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-21.0462f, (float)2.4881f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition NeckTeeth = Neck.addOrReplaceChild("NeckTeeth", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.2964f, (float)4.0265f, (float)-6.1846f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition Teeth_r1 = NeckTeeth.addOrReplaceChild("Teeth_r1", CubeListBuilder.create().texOffs(247, 162).addBox(0.0f, -3.5f, -1.5f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0916f, (float)0.5459f, (float)1.5601f, (float)3.0536f, (float)0.0461f, (float)-2.7626f));
        PartDefinition Teeth_r2 = NeckTeeth.addOrReplaceChild("Teeth_r2", CubeListBuilder.create().texOffs(246, 171).addBox(0.0f, -3.5f, -2.0f, 0.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0067f, (float)1.585f, (float)1.938f, (float)-3.0725f, (float)0.0559f, (float)0.3201f));
        PartDefinition Teeth_r3 = NeckTeeth.addOrReplaceChild("Teeth_r3", CubeListBuilder.create().texOffs(246, 169).addBox(1.75f, -5.0f, -4.25f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5172f, (float)-0.556f, (float)-0.3135f, (float)3.0944f, (float)-0.1593f, (float)2.4556f));
        PartDefinition Teeth_r4 = NeckTeeth.addOrReplaceChild("Teeth_r4", CubeListBuilder.create().texOffs(247, 166).addBox(-2.25f, -5.5f, -2.75f, 0.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5864f, (float)1.6749f, (float)-0.1998f, (float)3.032f, (float)0.1902f, (float)-3.1102f));
        PartDefinition Head = Neck.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(136, 0).addBox(-6.0f, -9.0f, -10.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(106, 24).addBox(-2.0f, -1.0f, -14.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.1451f, (float)0.5564f, (float)-11.0f));
        PartDefinition FungalBloom = Head.addOrReplaceChild("FungalBloom", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.8595f, (float)-6.8603f, (float)-6.562f, (float)0.3361f, (float)0.2071f, (float)-0.532f));
        PartDefinition Plane2_r1 = FungalBloom.addOrReplaceChild("Plane2_r1", CubeListBuilder.create().texOffs(81, 181).addBox(-11.8501f, -13.8001f, -7.6583f, 0.0f, 12.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.2533f, (float)1.5803f, (float)-7.8924f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition Plane1_r1 = FungalBloom.addOrReplaceChild("Plane1_r1", CubeListBuilder.create().texOffs(81, 181).mirror().addBox(-0.8501f, -13.8001f, 5.3417f, 0.0f, 12.0f, 14.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)9.2533f, (float)1.5803f, (float)-7.8924f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition Npetal_r1 = FungalBloom.addOrReplaceChild("Npetal_r1", CubeListBuilder.create().texOffs(124, 24).addBox(-16.8501f, -0.8001f, -17.6583f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.5033f, (float)1.5803f, (float)-0.3924f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition Spetal_r1 = FungalBloom.addOrReplaceChild("Spetal_r1", CubeListBuilder.create().texOffs(64, 82).addBox(-16.8501f, -0.8001f, 2.3417f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.5033f, (float)1.5803f, (float)-0.3924f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition Wpetal_r1 = FungalBloom.addOrReplaceChild("Wpetal_r1", CubeListBuilder.create().texOffs(124, 40).addBox(1.1499f, -0.8001f, 0.3417f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5033f, (float)1.5803f, (float)-8.3924f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition Epetal_r1 = FungalBloom.addOrReplaceChild("Epetal_r1", CubeListBuilder.create().texOffs(122, 58).addBox(-17.8501f, -0.8001f, 0.3417f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5033f, (float)1.5803f, (float)-8.3924f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition crown1 = Head.addOrReplaceChild("crown1", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.372f, (float)-6.7264f, (float)-8.1261f, (float)0.3982f, (float)0.0864f, (float)0.9492f));
        PartDefinition Petal4_r6 = crown1.addOrReplaceChild("Petal4_r6", CubeListBuilder.create().texOffs(-7, 122).addBox(-2.0f, -1.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8861f, (float)-0.5245f, (float)0.0399f, (float)0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition Petal3_r6 = crown1.addOrReplaceChild("Petal3_r6", CubeListBuilder.create().texOffs(-7, 122).addBox(-6.0f, -2.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6315f, (float)1.4073f, (float)0.0399f, (float)0.263f, (float)-0.1603f, (float)-0.1693f));
        PartDefinition Petal2_r5 = crown1.addOrReplaceChild("Petal2_r5", CubeListBuilder.create().texOffs(-7, 136).addBox(-4.0f, 0.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1139f, (float)-0.5245f, (float)-3.9601f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal1_r1 = crown1.addOrReplaceChild("Petal1_r1", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 0.0f, -1.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2969f, (float)0.3356f, (float)0.5792f, (float)0.4726f, (float)0.2047f, (float)0.1036f));
        PartDefinition HeadTeeth = Head.addOrReplaceChild("HeadTeeth", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.1513f, (float)3.47f, (float)-4.1846f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition Teeth_r5 = HeadTeeth.addOrReplaceChild("Teeth_r5", CubeListBuilder.create().texOffs(247, 162).addBox(0.0f, -3.0f, -1.5f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.3143f, (float)-2.1356f, (float)-0.143f, (float)2.932f, (float)0.0607f, (float)-2.5885f));
        PartDefinition Teeth_r6 = HeadTeeth.addOrReplaceChild("Teeth_r6", CubeListBuilder.create().texOffs(247, 172).addBox(1.0f, -3.5f, -1.75f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.6309f, (float)1.5351f, (float)0.2817f, (float)-3.0529f, (float)-0.0054f, (float)1.0597f));
        PartDefinition Teeth_r7 = HeadTeeth.addOrReplaceChild("Teeth_r7", CubeListBuilder.create().texOffs(247, 170).addBox(1.75f, -5.0f, -2.25f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5172f, (float)-0.556f, (float)-0.3135f, (float)3.0944f, (float)-0.1593f, (float)2.4556f));
        PartDefinition Teeth_r8 = HeadTeeth.addOrReplaceChild("Teeth_r8", CubeListBuilder.create().texOffs(247, 166).addBox(2.0f, -3.5f, -1.5f, 0.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5715f, (float)0.7438f, (float)0.0709f, (float)2.9259f, (float)0.0393f, (float)2.3066f));
        PartDefinition Jaw = UpperTorso.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(168, 136).addBox(-8.0f, -11.0f, -4.0f, 16.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition Teeth_r9 = Jaw.addOrReplaceChild("Teeth_r9", CubeListBuilder.create().texOffs(246, 162).addBox(0.0f, -6.0f, -2.0f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.684f, (float)-5.0f, (float)1.8794f, (float)3.0363f, (float)0.2707f, (float)2.806f));
        PartDefinition Teeth_r10 = Jaw.addOrReplaceChild("Teeth_r10", CubeListBuilder.create().texOffs(246, 162).addBox(0.0f, -5.0f, -2.0f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.5117f, (float)-6.0619f, (float)0.8699f, (float)-2.9884f, (float)-0.459f, (float)2.8016f));
        PartDefinition Teeth_r11 = Jaw.addOrReplaceChild("Teeth_r11", CubeListBuilder.create().texOffs(246, 162).addBox(0.0f, -5.0f, -2.0f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9706f, (float)-5.3617f, (float)1.0201f, (float)-3.086f, (float)0.0964f, (float)2.8932f));
        PartDefinition Teeth_r12 = Jaw.addOrReplaceChild("Teeth_r12", CubeListBuilder.create().texOffs(246, 169).addBox(-1.0f, -5.0f, -1.5f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.6994f, (float)-5.7937f, (float)0.7501f, (float)3.0413f, (float)0.6461f, (float)3.025f));
        PartDefinition Teeth_r13 = Jaw.addOrReplaceChild("Teeth_r13", CubeListBuilder.create().texOffs(246, 162).addBox(0.0f, -5.0f, -2.0f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-5.0f, (float)0.0f, (float)0.0309f, (float)0.2629f, (float)-0.074f));
        PartDefinition Teeth_r14 = Jaw.addOrReplaceChild("Teeth_r14", CubeListBuilder.create().texOffs(246, 163).addBox(0.0f, -6.0f, -2.0f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.9706f, (float)-5.3617f, (float)1.0201f, (float)-3.0615f, (float)0.3829f, (float)-2.9047f));
        PartDefinition TorsoMiddle = Jaw.addOrReplaceChild("TorsoMiddle", CubeListBuilder.create().texOffs(184, 0).addBox(-7.5f, -9.0f, -2.866f, 15.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)-0.634f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Teeth_r15 = TorsoMiddle.addOrReplaceChild("Teeth_r15", CubeListBuilder.create().texOffs(247, 170).addBox(0.0f, -4.0f, -1.5f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.1033f, (float)-5.0364f, (float)2.1385f, (float)-3.0872f, (float)0.6074f, (float)-2.9874f));
        PartDefinition Teeth_r16 = TorsoMiddle.addOrReplaceChild("Teeth_r16", CubeListBuilder.create().texOffs(247, 167).addBox(0.0f, -4.0f, -1.5f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.6754f, (float)-4.3451f, (float)2.2116f, (float)-3.0861f, (float)0.0779f, (float)-2.8836f));
        PartDefinition Teeth_r17 = TorsoMiddle.addOrReplaceChild("Teeth_r17", CubeListBuilder.create().texOffs(247, 169).addBox(0.0f, -4.0f, -1.5f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.1189f, (float)-4.0676f, (float)1.3443f, (float)-2.9579f, (float)0.1771f, (float)-3.0841f));
        PartDefinition Teeth_r18 = TorsoMiddle.addOrReplaceChild("Teeth_r18", CubeListBuilder.create().texOffs(247, 172).addBox(0.0f, -4.0f, -1.5f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.7025f, (float)-4.1358f, (float)2.4479f, (float)-3.0656f, (float)-0.2088f, (float)2.9189f));
        PartDefinition TorsoTop = TorsoMiddle.addOrReplaceChild("TorsoTop", CubeListBuilder.create().texOffs(188, 13).addBox(-7.5f, -8.0f, -2.866f, 14.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-9.0f, (float)1.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Teeth_r19 = TorsoTop.addOrReplaceChild("Teeth_r19", CubeListBuilder.create().texOffs(247, 162).addBox(0.0f, -3.0f, -1.5f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8967f, (float)-4.5172f, (float)1.9775f, (float)-3.1124f, (float)-0.2587f, (float)-2.8988f));
        PartDefinition Teeth_r20 = TorsoTop.addOrReplaceChild("Teeth_r20", CubeListBuilder.create().texOffs(247, 162).addBox(0.0f, -4.0f, -1.5f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.3417f, (float)-2.9538f, (float)1.5414f, (float)3.051f, (float)-0.4201f, (float)-2.4319f));
        PartDefinition Teeth_r21 = TorsoTop.addOrReplaceChild("Teeth_r21", CubeListBuilder.create().texOffs(247, 162).addBox(0.0f, -4.0f, -1.5f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.6491f, (float)-3.5487f, (float)1.9493f, (float)-3.1416f, (float)0.3054f, (float)2.5307f));
        PartDefinition JawTip = TorsoTop.addOrReplaceChild("JawTip", CubeListBuilder.create().texOffs(190, 151).addBox(-6.4705f, -11.9542f, -1.7892f, 12.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition Teeth_r22 = JawTip.addOrReplaceChild("Teeth_r22", CubeListBuilder.create().texOffs(247, 162).addBox(0.0f, -3.0f, -1.5f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.1107f, (float)-9.4053f, (float)1.7945f, (float)2.932f, (float)0.0607f, (float)-2.5885f));
        PartDefinition Teeth_r23 = JawTip.addOrReplaceChild("Teeth_r23", CubeListBuilder.create().texOffs(247, 166).addBox(0.0f, -3.5f, -1.5f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.8345f, (float)-5.7346f, (float)2.2192f, (float)3.1133f, (float)-0.0843f, (float)2.8937f));
        PartDefinition Teeth_r24 = JawTip.addOrReplaceChild("Teeth_r24", CubeListBuilder.create().texOffs(247, 170).addBox(0.0f, -5.4f, -1.5f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.7208f, (float)-7.8257f, (float)1.624f, (float)-3.0578f, (float)-0.1593f, (float)2.4556f));
        PartDefinition Teeth_r25 = JawTip.addOrReplaceChild("Teeth_r25", CubeListBuilder.create().texOffs(247, 166).addBox(0.0f, -4.5f, -1.5f, 0.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0558f, (float)-7.4716f, (float)1.918f, (float)3.0471f, (float)0.2909f, (float)-2.85f));
        PartDefinition crown2 = JawTip.addOrReplaceChild("crown2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.13f, (float)-8.6143f, (float)-2.3207f, (float)1.4835f, (float)0.0f, (float)0.0f));
        PartDefinition Petal4_r7 = crown2.addOrReplaceChild("Petal4_r7", CubeListBuilder.create().texOffs(-7, 136).addBox(-5.0f, -1.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8861f, (float)-0.5245f, (float)0.0399f, (float)0.1745f, (float)0.0f, (float)-0.4363f));
        PartDefinition Petal3_r7 = crown2.addOrReplaceChild("Petal3_r7", CubeListBuilder.create().texOffs(-7, 122).addBox(-1.0f, -2.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.6315f, (float)1.4073f, (float)0.0399f, (float)0.263f, (float)0.1603f, (float)0.1693f));
        PartDefinition Petal2_r6 = crown2.addOrReplaceChild("Petal2_r6", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.0f, 0.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1139f, (float)-0.5245f, (float)-3.9601f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal1_r2 = crown2.addOrReplaceChild("Petal1_r2", CubeListBuilder.create().texOffs(-7, 136).addBox(-3.5f, 0.0f, -1.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2969f, (float)0.3356f, (float)0.5792f, (float)0.4726f, (float)-0.2047f, (float)-0.1036f));
        PartDefinition TorsoTeeth = UpperTorso.addOrReplaceChild("TorsoTeeth", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Teeth_r26 = TorsoTeeth.addOrReplaceChild("Teeth_r26", CubeListBuilder.create().texOffs(247, 162).addBox(3.0f, -3.0f, -0.75f, 0.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.773f, (float)-17.9413f, (float)-4.1499f, (float)-0.0027f, (float)0.2523f, (float)-0.4726f));
        PartDefinition Teeth_r27 = TorsoTeeth.addOrReplaceChild("Teeth_r27", CubeListBuilder.create().texOffs(247, 162).addBox(-2.0f, -6.0f, 0.25f, 0.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5586f, (float)-11.137f, (float)-4.189f, (float)0.0026f, (float)-0.3025f, (float)0.4382f));
        PartDefinition Teeth_r28 = TorsoTeeth.addOrReplaceChild("Teeth_r28", CubeListBuilder.create().texOffs(247, 162).addBox(0.0f, -4.0f, -1.5f, 0.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5835f, (float)-8.474f, (float)-3.1881f, (float)-0.0381f, (float)-0.3001f, (float)0.5752f));
        PartDefinition Teeth_r29 = TorsoTeeth.addOrReplaceChild("Teeth_r29", CubeListBuilder.create().texOffs(246, 161).addBox(0.0f, -9.0f, -1.5f, 0.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.7317f, (float)-12.2284f, (float)-4.3483f, (float)-0.0914f, (float)-0.2912f, (float)0.1646f));
        PartDefinition Teeth_r30 = TorsoTeeth.addOrReplaceChild("Teeth_r30", CubeListBuilder.create().texOffs(246, 161).addBox(0.0f, -9.0f, -2.0f, 0.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.3289f, (float)-10.2357f, (float)-4.1108f, (float)-0.0503f, (float)-0.3367f, (float)-0.2458f));
        PartDefinition ChestFungus = UpperTorso.addOrReplaceChild("ChestFungus", CubeListBuilder.create(), PartPose.offset((float)-7.0593f, (float)-4.8392f, (float)6.3475f));
        PartDefinition Fungus_r13 = ChestFungus.addOrReplaceChild("Fungus_r13", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0807f, (float)3.4883f, (float)-8.2795f, (float)-0.8456f, (float)-0.6546f, (float)-0.4256f));
        PartDefinition Fungus_r14 = ChestFungus.addOrReplaceChild("Fungus_r14", CubeListBuilder.create().texOffs(-7, 122).addBox(-4.241f, -0.3123f, -0.4428f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8713f, (float)0.588f, (float)-1.62f, (float)-0.5944f, (float)0.3348f, (float)-0.4974f));
        PartDefinition Fungus_r15 = ChestFungus.addOrReplaceChild("Fungus_r15", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5526f, 4.0227f, -6.0795f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8713f, (float)-1.412f, (float)-13.0751f, (float)0.4547f, (float)0.3998f, (float)-0.6482f));
        PartDefinition Fungus_r16 = ChestFungus.addOrReplaceChild("Fungus_r16", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.2856f, (float)-0.0744f, (float)-12.7007f, (float)0.1952f, (float)-0.2126f, (float)-0.3265f));
        PartDefinition Fungus_r17 = ChestFungus.addOrReplaceChild("Fungus_r17", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.2841f, (float)3.3438f, (float)-2.8038f, (float)-0.3775f, (float)-0.0885f, (float)-0.4054f));
        PartDefinition Fungus_r18 = ChestFungus.addOrReplaceChild("Fungus_r18", CubeListBuilder.create().texOffs(-7, 129).addBox(-2.8602f, -3.0523f, 0.2132f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)20.7662f, (float)-15.3685f, (float)2.4507f, (float)-1.6719f, (float)-1.0825f, (float)1.2891f));
        PartDefinition Fungus_r19 = ChestFungus.addOrReplaceChild("Fungus_r19", CubeListBuilder.create().texOffs(-7, 129).addBox(-2.7034f, 0.0733f, -2.5899f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)20.7662f, (float)-15.3685f, (float)2.4507f, (float)-0.9185f, (float)-0.8459f, (float)0.634f));
        PartDefinition Fungus_r20 = ChestFungus.addOrReplaceChild("Fungus_r20", CubeListBuilder.create().texOffs(-7, 129).addBox(-0.0265f, 2.8663f, -5.2365f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)20.7662f, (float)-15.3685f, (float)2.4507f, (float)-1.2328f, (float)-0.3271f, (float)0.3532f));
        PartDefinition Fungus_r21 = ChestFungus.addOrReplaceChild("Fungus_r21", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)21.1994f, (float)4.4883f, (float)-8.2795f, (float)-0.8456f, (float)0.6546f, (float)0.4256f));
        PartDefinition Fungus_r22 = ChestFungus.addOrReplaceChild("Fungus_r22", CubeListBuilder.create().texOffs(-7, 129).addBox(-2.759f, -0.3123f, -0.4428f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)20.99f, (float)1.588f, (float)-1.62f, (float)-0.5944f, (float)-0.3348f, (float)0.4974f));
        PartDefinition Fungus_r23 = ChestFungus.addOrReplaceChild("Fungus_r23", CubeListBuilder.create().texOffs(-7, 136).addBox(-3.4474f, 4.0227f, -6.0795f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)20.99f, (float)-0.412f, (float)-13.0751f, (float)0.4547f, (float)-0.3998f, (float)0.6482f));
        PartDefinition Fungus_r24 = ChestFungus.addOrReplaceChild("Fungus_r24", CubeListBuilder.create().texOffs(-7, 136).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)20.4043f, (float)0.9256f, (float)-12.7007f, (float)0.1952f, (float)0.2126f, (float)0.3265f));
        PartDefinition Fungus_r25 = ChestFungus.addOrReplaceChild("Fungus_r25", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)21.4028f, (float)4.3438f, (float)-2.8038f, (float)-0.3775f, (float)0.0885f, (float)0.4054f));
        PartDefinition Fungus_r26 = ChestFungus.addOrReplaceChild("Fungus_r26", CubeListBuilder.create().texOffs(-7, 122).addBox(0.5f, 0.0f, -5.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5497f, (float)-10.4561f, (float)3.3171f, (float)0.3717f, (float)-0.2126f, (float)-0.3261f));
        PartDefinition Fungus_r27 = ChestFungus.addOrReplaceChild("Fungus_r27", CubeListBuilder.create().texOffs(-7, 129).addBox(-7.5572f, -1.3123f, -4.241f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.3318f, (float)-11.412f, (float)-13.2782f, (float)0.4974f, (float)0.3348f, (float)-0.5944f));
        PartDefinition Fungus_r28 = ChestFungus.addOrReplaceChild("Fungus_r28", CubeListBuilder.create().texOffs(-7, 129).addBox(-0.9205f, 4.0227f, -3.4474f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)12.7869f, (float)-13.412f, (float)2.5831f, (float)-0.6482f, (float)-0.3998f, (float)0.4547f));
        PartDefinition Fungus_r29 = ChestFungus.addOrReplaceChild("Fungus_r29", CubeListBuilder.create().texOffs(-7, 122).addBox(0.5572f, -1.3123f, -4.241f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)12.7869f, (float)-13.412f, (float)-13.2782f, (float)0.4974f, (float)-0.3348f, (float)0.0708f));
        PartDefinition Fungus_r30 = ChestFungus.addOrReplaceChild("Fungus_r30", CubeListBuilder.create().texOffs(-7, 122).addBox(0.5572f, 1.3123f, -2.759f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)12.7869f, (float)-0.9096f, (float)-12.4169f, (float)0.4974f, (float)0.3348f, (float)-0.5944f));
        PartDefinition Fungus_r31 = ChestFungus.addOrReplaceChild("Fungus_r31", CubeListBuilder.create().texOffs(-7, 122).addBox(-9.0795f, -4.0227f, -5.4474f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.3318f, (float)1.0904f, (float)-12.4169f, (float)0.6482f, (float)0.3998f, (float)0.4547f));
        PartDefinition Fungus_r32 = ChestFungus.addOrReplaceChild("Fungus_r32", CubeListBuilder.create().texOffs(-7, 136).addBox(-7.5572f, 1.3123f, -2.759f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.3318f, (float)1.0904f, (float)-12.4169f, (float)0.4974f, (float)-0.3348f, (float)0.0708f));
        PartDefinition Bloom = ChestFungus.addOrReplaceChild("Bloom", CubeListBuilder.create().texOffs(188, 41).addBox(-4.0f, -2.0324f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0593f, (float)-3.1608f, (float)4.6201f, (float)-1.6939f, (float)-0.0447f, (float)-0.3463f));
        PartDefinition NPetal_r2 = Bloom.addOrReplaceChild("NPetal_r2", CubeListBuilder.create().texOffs(124, 24).addBox(-16.0f, 0.0f, -19.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)3.9676f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition SPetal_r2 = Bloom.addOrReplaceChild("SPetal_r2", CubeListBuilder.create().texOffs(64, 82).addBox(-16.0f, 0.0f, 3.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)3.9676f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition WPetal_r2 = Bloom.addOrReplaceChild("WPetal_r2", CubeListBuilder.create().texOffs(124, 40).addBox(3.0f, 0.0f, 0.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.9676f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition EPetal_r2 = Bloom.addOrReplaceChild("EPetal_r2", CubeListBuilder.create().texOffs(122, 58).addBox(-19.0f, 0.0f, 0.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.9676f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition RightShoulderFungus = ChestFungus.addOrReplaceChild("RightShoulderFungus", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-9.2009f, (float)-17.9677f, (float)0.1562f, (float)-0.7424f, (float)0.4783f, (float)-0.803f));
        PartDefinition Petal5_r6 = RightShoulderFungus.addOrReplaceChild("Petal5_r6", CubeListBuilder.create().texOffs(-7, 136).mirror().addBox(-5.0f, -1.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.8861f, (float)-0.5245f, (float)-0.0399f, (float)-0.1745f, (float)0.0f, (float)-0.4363f));
        PartDefinition Petal4_r8 = RightShoulderFungus.addOrReplaceChild("Petal4_r8", CubeListBuilder.create().texOffs(-7, 136).mirror().addBox(-1.0f, -2.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-5.6315f, (float)1.4073f, (float)-0.0399f, (float)-0.263f, (float)-0.1603f, (float)0.1693f));
        PartDefinition Petal3_r8 = RightShoulderFungus.addOrReplaceChild("Petal3_r8", CubeListBuilder.create().texOffs(-7, 129).mirror().addBox(-3.0f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.1139f, (float)-0.5245f, (float)3.9601f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal2_r7 = RightShoulderFungus.addOrReplaceChild("Petal2_r7", CubeListBuilder.create().texOffs(-7, 136).mirror().addBox(-3.5f, 0.0f, -5.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.2969f, (float)0.3356f, (float)-0.5792f, (float)-0.4726f, (float)0.2047f, (float)-0.1036f));
        PartDefinition LowerTorsoFungus = LowerTorso.addOrReplaceChild("LowerTorsoFungus", CubeListBuilder.create(), PartPose.offset((float)-8.0593f, (float)28.1608f, (float)-24.3475f));
        PartDefinition Fungus_r33 = LowerTorsoFungus.addOrReplaceChild("Fungus_r33", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5593f, (float)-34.2108f, (float)29.8975f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r34 = LowerTorsoFungus.addOrReplaceChild("Fungus_r34", CubeListBuilder.create().texOffs(-7, 122).addBox(2.5f, -2.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.4407f, (float)-31.2108f, (float)26.8975f, (float)-0.2664f, (float)-0.4504f, (float)0.3859f));
        PartDefinition Fungus_r35 = LowerTorsoFungus.addOrReplaceChild("Fungus_r35", CubeListBuilder.create().texOffs(-7, 136).addBox(-1.5f, -1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.678f, (float)-28.3676f, (float)30.3074f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        PartDefinition Fungus_r36 = LowerTorsoFungus.addOrReplaceChild("Fungus_r36", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 0.0f, -2.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4407f, (float)-26.2108f, (float)26.8975f, (float)0.0037f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition crown3 = LowerTorsoFungus.addOrReplaceChild("crown3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)17.2655f, (float)-31.0592f, (float)28.9654f, (float)-1.2502f, (float)0.6569f, (float)0.5029f));
        PartDefinition Petal5_r7 = crown3.addOrReplaceChild("Petal5_r7", CubeListBuilder.create().texOffs(-7, 122).addBox(-2.0f, -1.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8861f, (float)-0.5245f, (float)-0.0399f, (float)-0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition Petal4_r9 = crown3.addOrReplaceChild("Petal4_r9", CubeListBuilder.create().texOffs(-7, 122).addBox(-6.0f, -2.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6315f, (float)1.4073f, (float)-0.0399f, (float)-0.263f, (float)0.1603f, (float)-0.1693f));
        PartDefinition Petal3_r9 = crown3.addOrReplaceChild("Petal3_r9", CubeListBuilder.create().texOffs(-7, 136).addBox(-4.0f, 0.0f, -3.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1139f, (float)-0.5245f, (float)3.9601f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal2_r8 = crown3.addOrReplaceChild("Petal2_r8", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 0.0f, -5.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2969f, (float)0.3356f, (float)-0.5792f, (float)-0.4726f, (float)-0.2047f, (float)0.1036f));
        PartDefinition Legs = H_brute.addOrReplaceChild("Legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-9.0f, (float)9.0f));
        PartDefinition LeftLeg = Legs.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 167).addBox(-5.0f, -3.0f, -5.0f, 10.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)0.0f, (float)0.0f, (float)0.6981f, (float)0.3927f, (float)0.0f));
        PartDefinition LeftLegFungus = LeftLeg.addOrReplaceChild("LeftLegFungus", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.9407f, (float)3.7902f, (float)-4.5132f, (float)-2.9671f, (float)0.0f, (float)0.0f));
        PartDefinition Fungus_r37 = LeftLegFungus.addOrReplaceChild("Fungus_r37", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.0932f, 1.3301f, -3.1862f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6515f, (float)-2.9744f, (float)-8.7382f, (float)-0.7818f, (float)-0.5816f, (float)-0.0141f));
        PartDefinition Fungus_r38 = LeftLegFungus.addOrReplaceChild("Fungus_r38", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5053f, -1.4258f, -3.5113f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6515f, (float)-2.9744f, (float)-8.7382f, (float)-0.3242f, (float)-0.5581f, (float)-0.4005f));
        PartDefinition Fungus_r39 = LeftLegFungus.addOrReplaceChild("Fungus_r39", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 1.0f, -7.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4407f, (float)2.7892f, (float)3.1475f, (float)-0.1797f, (float)-0.4891f, (float)0.195f));
        PartDefinition Fungus_r40 = LeftLegFungus.addOrReplaceChild("Fungus_r40", CubeListBuilder.create().texOffs(-7, 136).addBox(-3.5f, 1.0f, -2.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5593f, (float)-0.2108f, (float)-2.1025f, (float)0.1783f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition LeftLegSeg2 = LeftLeg.addOrReplaceChild("LeftLegSeg2", CubeListBuilder.create().texOffs(120, 130).addBox(-6.0f, -4.0f, -6.0f, 12.0f, 13.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)0.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLegCrown = LeftLegSeg2.addOrReplaceChild("LeftLegCrown", CubeListBuilder.create(), PartPose.offsetAndRotation((float)6.7438f, (float)2.7633f, (float)2.2462f, (float)-0.1376f, (float)-0.7713f, (float)1.6938f));
        PartDefinition Petal6_r2 = LeftLegCrown.addOrReplaceChild("Petal6_r2", CubeListBuilder.create().texOffs(-7, 129).addBox(-5.0f, -1.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8861f, (float)-0.5245f, (float)0.0399f, (float)0.1745f, (float)0.0f, (float)-0.4363f));
        PartDefinition Petal5_r8 = LeftLegCrown.addOrReplaceChild("Petal5_r8", CubeListBuilder.create().texOffs(-7, 136).addBox(-1.0f, -2.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.6315f, (float)1.4073f, (float)0.0399f, (float)0.263f, (float)0.1603f, (float)0.1693f));
        PartDefinition Petal4_r10 = LeftLegCrown.addOrReplaceChild("Petal4_r10", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.0f, 0.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1139f, (float)-0.5245f, (float)-3.9601f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal3_r10 = LeftLegCrown.addOrReplaceChild("Petal3_r10", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 0.0f, -1.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2969f, (float)0.3356f, (float)0.5792f, (float)0.4726f, (float)-0.2047f, (float)-0.1036f));
        PartDefinition RightLeg = Legs.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 168).mirror().addBox(-5.0f, -3.0f, -5.0f, 10.0f, 13.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)0.0f, (float)0.0f, (float)0.6981f, (float)-0.3927f, (float)0.0f));
        PartDefinition RightLegCrown = RightLeg.addOrReplaceChild("RightLegCrown", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0946f, (float)7.3601f, (float)5.4695f, (float)-1.4586f, (float)-0.1369f, (float)0.6616f));
        PartDefinition Petal5_r9 = RightLegCrown.addOrReplaceChild("Petal5_r9", CubeListBuilder.create().texOffs(-7, 129).addBox(-2.0f, -1.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8861f, (float)-0.5245f, (float)0.0399f, (float)0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition Petal4_r11 = RightLegCrown.addOrReplaceChild("Petal4_r11", CubeListBuilder.create().texOffs(-7, 122).addBox(-6.0f, -2.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6315f, (float)1.4073f, (float)0.0399f, (float)0.263f, (float)-0.1603f, (float)-0.1693f));
        PartDefinition Petal3_r11 = RightLegCrown.addOrReplaceChild("Petal3_r11", CubeListBuilder.create().texOffs(-7, 129).addBox(-4.0f, 0.0f, -4.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1139f, (float)-0.5245f, (float)-3.9601f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal2_r9 = RightLegCrown.addOrReplaceChild("Petal2_r9", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 0.0f, -1.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2969f, (float)0.3356f, (float)0.5792f, (float)0.4726f, (float)0.2047f, (float)0.1036f));
        PartDefinition RightLegSeg2 = RightLeg.addOrReplaceChild("RightLegSeg2", CubeListBuilder.create().texOffs(120, 130).addBox(-6.0f, -6.0f, -6.0f, 12.0f, 15.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)0.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = H_brute.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(184, 180).addBox(-3.5f, -3.4769f, -0.6504f, 7.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-14.0f, (float)9.5f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition TailSeg2 = Tail.addOrReplaceChild("TailSeg2", CubeListBuilder.create().texOffs(144, 157).addBox(-3.5f, -3.5f, -2.0f, 7.0f, 7.0f, 16.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)9.25f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2Fungus = TailSeg2.addOrReplaceChild("Tail2Fungus", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0593f, (float)-0.3601f, (float)2.948f, (float)1.3963f, (float)0.0f, (float)0.0f));
        PartDefinition Fungus_r41 = Tail2Fungus.addOrReplaceChild("Fungus_r41", CubeListBuilder.create().texOffs(-7, 129).addBox(-1.5f, 10.0f, -5.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5593f, (float)-2.2108f, (float)-2.1025f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r42 = Tail2Fungus.addOrReplaceChild("Fungus_r42", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 2.0f, -4.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4407f, (float)2.7892f, (float)3.8975f, (float)-0.1797f, (float)-0.4891f, (float)0.195f));
        PartDefinition Fungus_r43 = Tail2Fungus.addOrReplaceChild("Fungus_r43", CubeListBuilder.create().texOffs(-7, 129).addBox(-2.25f, -4.0f, -4.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5593f, (float)4.7892f, (float)2.8975f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        PartDefinition Fungus_r44 = Tail2Fungus.addOrReplaceChild("Fungus_r44", CubeListBuilder.create().texOffs(-7, 122).addBox(-4.5f, 1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5593f, (float)-0.2108f, (float)-3.1025f, (float)0.1783f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition TailSeg3 = TailSeg2.addOrReplaceChild("TailSeg3", CubeListBuilder.create().texOffs(168, 90).addBox(-3.0f, -2.9619f, -0.8087f, 6.0f, 6.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)12.75f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition Tail3Fungus = TailSeg3.addOrReplaceChild("Tail3Fungus", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.0593f, (float)-0.3505f, (float)9.8527f, (float)-1.3963f, (float)0.0f, (float)0.0f));
        PartDefinition Fungus_r45 = Tail3Fungus.addOrReplaceChild("Fungus_r45", CubeListBuilder.create().texOffs(-7, 129).addBox(-5.5f, 10.0f, -1.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5593f, (float)-2.2108f, (float)2.1025f, (float)-0.3325f, (float)0.5154f, (float)-0.0523f));
        PartDefinition Fungus_r46 = Tail3Fungus.addOrReplaceChild("Fungus_r46", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 2.0f, -2.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.4407f, (float)2.7892f, (float)-3.8975f, (float)0.1797f, (float)-0.4891f, (float)-0.195f));
        PartDefinition Fungus_r47 = Tail3Fungus.addOrReplaceChild("Fungus_r47", CubeListBuilder.create().texOffs(-7, 129).addBox(-4.75f, -4.0f, -2.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5593f, (float)4.7892f, (float)-2.8975f, (float)-0.0333f, (float)0.6219f, (float)-0.3593f));
        PartDefinition Fungus_r48 = Tail3Fungus.addOrReplaceChild("Fungus_r48", CubeListBuilder.create().texOffs(-7, 122).addBox(-2.5f, 1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5593f, (float)-0.2108f, (float)3.1025f, (float)-0.1783f, (float)-0.2977f, (float)0.0909f));
        PartDefinition TailSeg4 = TailSeg3.addOrReplaceChild("TailSeg4", CubeListBuilder.create().texOffs(186, 56).addBox(-2.5f, -2.4995f, -1.0218f, 5.0f, 5.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)14.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition TumorTip = TailSeg4.addOrReplaceChild("TumorTip", CubeListBuilder.create(), PartPose.offset((float)0.0046f, (float)-1.302f, (float)10.8573f));
        PartDefinition Tumors = TumorTip.addOrReplaceChild("Tumors", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Tumor_r1 = Tumors.addOrReplaceChild("Tumor_r1", CubeListBuilder.create().texOffs(190, 27).addBox(-12.5f, -4.5f, -0.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0505f, (float)-3.6208f, (float)-2.2754f, (float)0.2392f, (float)-0.0133f, (float)-0.3783f));
        PartDefinition Tumor_r2 = Tumors.addOrReplaceChild("Tumor_r2", CubeListBuilder.create().texOffs(190, 27).addBox(-8.0f, -8.0f, -4.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.9334f, (float)-3.2841f, (float)5.6127f, (float)1.361f, (float)0.0565f, (float)-1.1111f));
        PartDefinition Tumor_r3 = Tumors.addOrReplaceChild("Tumor_r3", CubeListBuilder.create().texOffs(190, 27).addBox(-2.0f, 2.0f, 1.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5248f, (float)-1.8629f, (float)-7.4953f, (float)0.4094f, (float)0.4032f, (float)-0.6728f));
        PartDefinition Tumor_r4 = Tumors.addOrReplaceChild("Tumor_r4", CubeListBuilder.create().texOffs(193, 30).addBox(-1.0f, -3.0f, 13.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.4412f, (float)-7.3435f, (float)-9.375f, (float)-0.5151f, (float)0.3039f, (float)0.5625f));
        PartDefinition Tumor_r5 = Tumors.addOrReplaceChild("Tumor_r5", CubeListBuilder.create().texOffs(188, 25).addBox(3.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.937f, (float)-2.7617f, (float)-7.9204f, (float)-0.329f, (float)-1.0983f, (float)1.1961f));
        PartDefinition Thorns = TumorTip.addOrReplaceChild("Thorns", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Thorn1 = Thorns.addOrReplaceChild("Thorn1", CubeListBuilder.create().texOffs(48, 142).addBox(-1.0f, -0.8333f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.2981f, (float)-1.3398f, (float)0.4115f, (float)1.3865f, (float)-1.0916f, (float)2.7498f));
        PartDefinition Plane_r1 = Thorn1.addOrReplaceChild("Plane_r1", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, 0.0f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.1667f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition Plane_r2 = Thorn1.addOrReplaceChild("Plane_r2", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, 0.0f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.1667f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition Thorn2 = Thorns.addOrReplaceChild("Thorn2", CubeListBuilder.create().texOffs(48, 142).addBox(-1.0f, -0.8333f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.9744f, (float)-0.8246f, (float)3.0539f, (float)1.629f, (float)-0.2731f, (float)3.1152f));
        PartDefinition Plane_r3 = Thorn2.addOrReplaceChild("Plane_r3", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, 0.0f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.1667f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition Plane_r4 = Thorn2.addOrReplaceChild("Plane_r4", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, 0.0f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.1667f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition Thorn3 = Thorns.addOrReplaceChild("Thorn3", CubeListBuilder.create().texOffs(48, 142).addBox(-1.0f, -0.8333f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6094f, (float)0.7797f, (float)1.796f, (float)0.8865f, (float)0.5052f, (float)2.559f));
        PartDefinition Plane_r5 = Thorn3.addOrReplaceChild("Plane_r5", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, 0.0f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.1667f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition Plane_r6 = Thorn3.addOrReplaceChild("Plane_r6", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, 0.0f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.1667f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition Thorn4 = Thorns.addOrReplaceChild("Thorn4", CubeListBuilder.create().texOffs(48, 142).addBox(-1.0f, -0.8333f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.9294f, (float)-3.5137f, (float)-0.6748f, (float)0.0766f, (float)0.8535f, (float)2.5889f));
        PartDefinition Plane_r7 = Thorn4.addOrReplaceChild("Plane_r7", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, 0.0f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.1667f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition Plane_r8 = Thorn4.addOrReplaceChild("Plane_r8", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, 0.0f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.1667f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition Thorn5 = Thorns.addOrReplaceChild("Thorn5", CubeListBuilder.create().texOffs(48, 142).addBox(-1.0f, -4.1667f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.6898f, (float)2.6578f, (float)1.2416f, (float)-0.1748f, (float)0.8426f, (float)-2.7199f));
        PartDefinition Plane_r9 = Thorn5.addOrReplaceChild("Plane_r9", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, -2.5f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.6667f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)3.1416f));
        PartDefinition Plane_r10 = Thorn5.addOrReplaceChild("Plane_r10", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, -2.5f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.6667f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)3.1416f));
        PartDefinition Thorn6 = Thorns.addOrReplaceChild("Thorn6", CubeListBuilder.create().texOffs(48, 142).addBox(-1.0f, -4.1667f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9078f, (float)2.0814f, (float)-2.4799f, (float)1.5705f, (float)0.8426f, (float)-2.7199f));
        PartDefinition Plane_r11 = Thorn6.addOrReplaceChild("Plane_r11", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, -2.5f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.6667f, (float)0.0f, (float)-3.1416f, (float)-0.7854f, (float)0.0f));
        PartDefinition Plane_r12 = Thorn6.addOrReplaceChild("Plane_r12", CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, -2.5f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.6667f, (float)0.0f, (float)-3.1416f, (float)0.7854f, (float)0.0f));
        PartDefinition Thorn7 = Thorns.addOrReplaceChild("Thorn7", CubeListBuilder.create().texOffs(48, 142).addBox(-1.0f, -4.1667f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.7308f, (float)-1.2011f, (float)-3.5711f, (float)2.1814f, (float)-0.8426f, (float)2.7199f));
        PartDefinition Plane_r13 = Thorn7.addOrReplaceChild("Plane_r13", CubeListBuilder.create().texOffs(0, -2).mirror().addBox(0.0f, -2.5f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-6.6667f, (float)0.0f, (float)-3.1416f, (float)0.7854f, (float)0.0f));
        PartDefinition Plane_r14 = Thorn7.addOrReplaceChild("Plane_r14", CubeListBuilder.create().texOffs(0, -2).mirror().addBox(0.0f, -2.5f, -1.0f, 0.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-6.6667f, (float)0.0f, (float)-3.1416f, (float)-0.7854f, (float)0.0f));
        PartDefinition Impaled = TumorTip.addOrReplaceChild("Impaled", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition Jaw_r1 = Impaled.addOrReplaceChild("Jaw_r1", CubeListBuilder.create().texOffs(48, 89).addBox(-4.0f, -0.5f, 0.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.9758f, (float)-4.0093f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition Head_r1 = Impaled.addOrReplaceChild("Head_r1", CubeListBuilder.create().texOffs(40, 74).addBox(-4.0f, -7.0f, 0.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.3136f, (float)-4.378f, (float)2.0379f, (float)-0.0767f, (float)-0.1188f));
        PartDefinition Leg_r1 = Impaled.addOrReplaceChild("Leg_r1", CubeListBuilder.create().texOffs(23, 66).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)2.5f, (float)2.5f, (float)0.303f, (float)0.0393f, (float)-0.1249f));
        PartDefinition Leg_r2 = Impaled.addOrReplaceChild("Leg_r2", CubeListBuilder.create().texOffs(22, 65).addBox(-1.0f, -1.0f, -5.25f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-7.0f, (float)-1.0f, (float)0.4363f, (float)0.0f, (float)-0.4363f));
        PartDefinition Leg_r3 = Impaled.addOrReplaceChild("Leg_r3", CubeListBuilder.create().texOffs(22, 65).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)2.0f, (float)3.0f, (float)-0.3927f, (float)0.0f, (float)0.3491f));
        PartDefinition LowerTorso_r1 = Impaled.addOrReplaceChild("LowerTorso_r1", CubeListBuilder.create().texOffs(0, 75).addBox(-4.0f, -6.0f, -2.5f, 8.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-2.3123f, (float)0.1895f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition LowerTorso_r2 = Impaled.addOrReplaceChild("LowerTorso_r2", CubeListBuilder.create().texOffs(0, 65).addBox(-4.0f, -2.0f, -3.0f, 7.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)2.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Tail1Fungus = Tail.addOrReplaceChild("Tail1Fungus", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.9213f, (float)-1.0139f, (float)4.4424f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition Fungus_r49 = Tail1Fungus.addOrReplaceChild("Fungus_r49", CubeListBuilder.create().texOffs(-7, 122).addBox(-3.5f, 2.0f, -2.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5787f, (float)-3.5475f, (float)-3.4873f, (float)0.1797f, (float)-0.4891f, (float)-0.195f));
        PartDefinition Fungus_r50 = Tail1Fungus.addOrReplaceChild("Fungus_r50", CubeListBuilder.create().texOffs(-7, 129).addBox(-3.5f, 12.0f, -4.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5787f, (float)-8.5475f, (float)2.5127f, (float)-0.3325f, (float)0.5154f, (float)-0.0523f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)512, (int)512);
    }

    public void animateSpike(ModelPart part, float value) {
        part.yScale = 1.0f + value;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float tailSpin = Mth.sin((float)(ageInTicks / 8.0f)) / 4.0f;
        float spikeValue = Mth.cos((float)(ageInTicks / 8.0f)) / 4.0f;
        float walkingValue = Mth.cos((float)(limbSwing * 0.2f)) * 0.8f * limbSwingAmount;
        this.animateTentacleY(this.TailSegment1, tailSpin);
        this.animateTentacleY(this.TailSegment2, tailSpin);
        this.animateTentacleY(this.TailSegment3, tailSpin);
        this.animateTentacleY(this.TailSegment4, tailSpin);
        this.animateTumor(this.TailTumor, Mth.cos((float)(ageInTicks / 7.0f)) / 6.0f);
        this.animateSpike(this.Spike1, spikeValue);
        this.animateSpike(this.Spike2, -spikeValue);
        this.animateSpike(this.Spike3, spikeValue);
        this.animateSpike(this.Spike4, -spikeValue);
        this.animateSpike(this.Spike5, spikeValue);
        this.animateSpike(this.Spike6, -spikeValue);
        this.animateSpike(this.Spike7, spikeValue);
        this.TailBody.visible = ((Ogre)entity).hasImpaledBody();
        this.Jaw1.xRot = entity.isAggressive() ? (float)(0.5 + (double)(Mth.sin((float)(ageInTicks / 2.0f)) / 8.0f)) : 0.0f;
        this.Jaw2.xRot = this.Jaw2.getInitialPose().xRot + Mth.sin((float)(ageInTicks / 8.0f)) / 8.0f;
        this.Jaw3.xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 8.0f;
        this.HeadY.yRot = netHeadYaw / 57.295776f;
        this.HeadX.xRot = headPitch / 28.647888f;
        this.Legs.yRot = walkingValue * 0.3f;
        this.LeftBackLeg.xRot = this.LeftBackLeg.getInitialPose().xRot + walkingValue;
        this.LeftBackForLeg.xRot = this.LeftBackForLeg.getInitialPose().xRot - walkingValue;
        this.RightBackLeg.xRot = this.RightBackLeg.getInitialPose().xRot - walkingValue;
        this.RightBackForLeg.xRot = this.RightBackForLeg.getInitialPose().xRot + walkingValue;
        this.RightFrontArm.zRot = this.RightFrontArm.getInitialPose().zRot + walkingValue * 0.6f;
        this.LeftFrontArm.zRot = this.LeftFrontArm.getInitialPose().zRot + walkingValue * 0.6f;
        this.RightFrontForArm.zRot = this.RightFrontForArm.getInitialPose().zRot + walkingValue * 0.3f;
        this.LeftFrontForArm.zRot = this.LeftFrontForArm.getInitialPose().zRot + walkingValue * 0.3f;
        this.RightFrontArm.y = this.RightFrontArm.getInitialPose().y + walkingValue * 1.3f;
        this.LeftFrontArm.y = this.LeftFrontArm.getInitialPose().y - walkingValue * 1.3f;
    }

    public void prepareMobModel(T entity, float value1, float value2, float value3) {
        super.prepareMobModel(entity, value1, value2, value3);
        int attackAnimationTick = ((Ogre)entity).getAttackAnimationTick();
        if (attackAnimationTick > 0) {
            float spinValue = -2.0f + 1.5f * Mth.triangleWave((float)((float)attackAnimationTick - value3), (float)10.0f);
            this.H_brute.yRot = spinValue * 2.0f;
            this.TailSegment1.yRot = spinValue;
            this.TailSegment2.yRot = spinValue / 2.0f;
            this.TailSegment3.yRot = spinValue / 2.0f;
            this.TailSegment4.yRot = spinValue / 2.0f;
        } else {
            this.H_brute.yRot = 0.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.H_brute.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

