/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Special.BlockEntityModel;
import com.Harbinger.Spore.SBlockEntities.OutpostWatcherBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class OutpostWatcherModel<T extends OutpostWatcherBlockEntity>
extends BlockEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"outpost_watcher"), "main");
    private final List<ModelPart> segements = new ArrayList<ModelPart>();
    private final ModelPart OutpostCore;
    private final ModelPart Biomass;
    private final ModelPart Brain1;
    private final ModelPart Brain2;
    private final ModelPart Brain3;
    private final ModelPart Brain4;
    private final ModelPart Neck1;
    private final ModelPart Neck2;
    private final ModelPart Neck3;
    private final ModelPart Neck4;
    private final ModelPart Neck5;
    private final ModelPart Pupil;
    private final ModelPart Rib1;
    private final ModelPart Rib2;
    private final ModelPart Rib3;
    private final ModelPart Rib4;

    public OutpostWatcherModel() {
        ModelPart root = OutpostWatcherModel.createBodyLayer().bakeRoot();
        this.OutpostCore = root.getChild("OutpostCore");
        this.Biomass = this.OutpostCore.getChild("Base").getChild("Biomass");
        this.Brain1 = this.OutpostCore.getChild("Base").getChild("Brains").getChild("Brain1");
        this.Brain2 = this.OutpostCore.getChild("Base").getChild("Brains").getChild("Brain2");
        this.Brain3 = this.OutpostCore.getChild("Base").getChild("Brains").getChild("Brain3");
        this.Brain4 = this.OutpostCore.getChild("Base").getChild("Brains").getChild("Brain4");
        this.Neck1 = this.OutpostCore.getChild("Stalk").getChild("Spine");
        this.Neck2 = this.Neck1.getChild("SpineSeg2");
        this.Neck3 = this.Neck2.getChild("SpineSeg3");
        this.Neck4 = this.Neck3.getChild("SpineSeg4");
        this.Neck5 = this.Neck4.getChild("SpineSeg5");
        this.Pupil = this.Neck5.getChild("Eye").getChild("Pupil");
        this.segements.add(this.Neck1);
        this.segements.add(this.Neck2);
        this.segements.add(this.Neck5);
        this.Rib1 = this.OutpostCore.getChild("Base").getChild("Ribs").getChild("Rib1");
        this.Rib2 = this.OutpostCore.getChild("Base").getChild("Ribs").getChild("Rib2");
        this.Rib3 = this.OutpostCore.getChild("Base").getChild("Ribs").getChild("Rib3");
        this.Rib4 = this.OutpostCore.getChild("Base").getChild("Ribs").getChild("Rib4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition OutpostCore = partdefinition.addOrReplaceChild("OutpostCore", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)22.0f, (float)0.0f));
        PartDefinition Base = OutpostCore.addOrReplaceChild("Base", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Biomass2 = Base.addOrReplaceChild("Biomass", CubeListBuilder.create(), PartPose.offset((float)-0.4597f, (float)-1.0134f, (float)-0.332f));
        PartDefinition Biomass4_r1 = Biomass2.addOrReplaceChild("Biomass4_r1", CubeListBuilder.create().texOffs(4, 4).addBox(-3.5f, -1.5f, -1.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.323f, (float)-2.1995f, (float)1.2635f, (float)-0.1987f, (float)0.4755f, (float)-0.1473f));
        PartDefinition Biomass3_r1 = Biomass2.addOrReplaceChild("Biomass3_r1", CubeListBuilder.create().texOffs(2, 2).addBox(-4.5f, -2.5f, -2.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5599f, (float)-1.0913f, (float)-2.9138f, (float)0.3699f, (float)-0.7124f, (float)-0.2154f));
        PartDefinition Biomass2_r1 = Biomass2.addOrReplaceChild("Biomass2_r1", CubeListBuilder.create().texOffs(3, 3).addBox(-4.0f, -2.0f, -2.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.7154f, (float)-0.1518f, (float)-3.6794f, (float)0.0f, (float)-0.5236f, (float)-0.3491f));
        PartDefinition Biomass1_r1 = Biomass2.addOrReplaceChild("Biomass1_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-5.5f, -3.5f, -3.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.814f, (float)-1.2803f, (float)2.359f, (float)-0.1801f, (float)0.3913f, (float)-0.0164f));
        PartDefinition Brains = Base.addOrReplaceChild("Brains", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Brain1 = Brains.addOrReplaceChild("Brain1", CubeListBuilder.create().texOffs(0, 34).addBox(-2.6667f, -5.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 60).addBox(0.8333f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)).texOffs(0, 60).addBox(-3.6667f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)-3.1973f, (float)-1.8588f, (float)-3.564f, (float)0.3054f, (float)0.7854f, (float)0.0f));
        PartDefinition Brain2 = Brains.addOrReplaceChild("Brain2", CubeListBuilder.create().texOffs(0, 34).addBox(-2.6667f, -5.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 60).addBox(0.8333f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)).texOffs(0, 60).addBox(-3.6667f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)3.6996f, (float)-1.0907f, (float)-2.6466f, (float)0.549f, (float)-0.3252f, (float)0.4096f));
        PartDefinition Brain3 = Brains.addOrReplaceChild("Brain3", CubeListBuilder.create().texOffs(0, 34).addBox(-2.6667f, -5.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 60).addBox(0.8333f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)).texOffs(0, 60).addBox(-3.6667f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)3.8157f, (float)-2.9002f, (float)3.9551f, (float)-0.549f, (float)0.3252f, (float)0.4096f));
        PartDefinition Brain4 = Brains.addOrReplaceChild("Brain4", CubeListBuilder.create().texOffs(0, 34).addBox(-2.6667f, -5.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 60).addBox(0.8333f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)).texOffs(0, 60).addBox(-3.6667f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)-2.7248f, (float)-3.202f, (float)1.1037f, (float)-0.9961f, (float)-0.6061f, (float)0.0913f));
        PartDefinition Ribs = Base.addOrReplaceChild("Ribs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Rib1 = Ribs.addOrReplaceChild("Rib1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -6.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2113f, (float)-3.6046f, (float)7.1676f, (float)-0.5633f, (float)-0.0702f, (float)-0.1106f));
        PartDefinition Rib1Seg = Rib1.addOrReplaceChild("Rib1Seg", CubeListBuilder.create().texOffs(0, 73).addBox(-1.0013f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Rib2 = Ribs.addOrReplaceChild("Rib2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -6.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.1144f, (float)-2.2051f, (float)-1.07f, (float)-0.48f, (float)-1.1345f, (float)0.0f));
        PartDefinition Rib2Seg = Rib2.addOrReplaceChild("Rib2Seg", CubeListBuilder.create().texOffs(0, 73).addBox(-1.0013f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Rib3 = Ribs.addOrReplaceChild("Rib3", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -6.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2113f, (float)-4.6886f, (float)-3.4758f, (float)0.5899f, (float)-0.3135f, (float)0.0025f));
        PartDefinition Rib3Seg = Rib3.addOrReplaceChild("Rib3Seg", CubeListBuilder.create().texOffs(0, 73).addBox(-1.0013f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Rib4 = Ribs.addOrReplaceChild("Rib4", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -6.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0942f, (float)-1.4646f, (float)-0.2558f, (float)-0.6545f, (float)1.3963f, (float)0.0f));
        PartDefinition Rib4Seg = Rib4.addOrReplaceChild("Rib4Seg", CubeListBuilder.create().texOffs(0, 73).addBox(-1.0013f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Stalk = OutpostCore.addOrReplaceChild("Stalk", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Spine = Stalk.addOrReplaceChild("Spine", CubeListBuilder.create().texOffs(27, 0).addBox(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-2.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(1.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(24, 16).addBox(0.0f, -4.0f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-5.0f, (float)0.0f));
        PartDefinition SpineSeg2 = Spine.addOrReplaceChild("SpineSeg2", CubeListBuilder.create().texOffs(27, 0).addBox(-1.49f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-2.49f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(1.51f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(24, 16).addBox(0.01f, -4.0f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition SpineSeg3 = SpineSeg2.addOrReplaceChild("SpineSeg3", CubeListBuilder.create().texOffs(27, 0).addBox(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(1.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-2.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(24, 16).addBox(0.0f, -4.0f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition SpineSeg4 = SpineSeg3.addOrReplaceChild("SpineSeg4", CubeListBuilder.create().texOffs(27, 0).addBox(-1.49f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(1.51f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-2.49f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(24, 16).mirror().addBox(0.01f, -4.0f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition SpineSeg5 = SpineSeg4.addOrReplaceChild("SpineSeg5", CubeListBuilder.create().texOffs(27, 0).addBox(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(1.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-2.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(24, 16).addBox(0.0f, -4.0f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.829f, (float)0.0f, (float)0.0f));
        PartDefinition Eye = SpineSeg5.addOrReplaceChild("Eye", CubeListBuilder.create().texOffs(0, 18).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0975f, (float)0.8978f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition Pupil = Eye.addOrReplaceChild("Pupil", CubeListBuilder.create().texOffs(0, 47).addBox(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-8.25f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void animateBiomass(ModelPart part, float value) {
        part.xScale = 1.0f + Mth.cos((float)(value / 6.0f)) / 6.0f;
        part.yScale = 1.0f + Mth.cos((float)(value / 6.0f)) / 6.0f;
        part.zScale = 1.0f + Mth.cos((float)(value / 6.0f)) / 6.0f;
    }

    private void animateBrain(ModelPart part, float value) {
        part.xScale = 1.0f + Mth.cos((float)(value / 8.0f)) / 8.0f;
        part.yScale = 1.0f - Mth.cos((float)(value / 8.0f)) / 8.0f;
        part.zScale = 1.0f + Mth.cos((float)(value / 8.0f)) / 8.0f;
    }

    private void RotateStalk(T thisEntity, Entity entity) {
        if (entity != null) {
            double d1 = entity.getX() - (double)thisEntity.getBlockPos().getX();
            double d2 = entity.getZ() - (double)thisEntity.getBlockPos().getZ();
            float value = -((float)Mth.atan2((double)(-d1), (double)(-d2))) * 57.295776f;
            this.segements.forEach(part -> {
                part.yRot = value / 57.295776f / (float)this.segements.size();
            });
        }
    }

    private void animatePupil(T block, Entity entity, ModelPart part) {
        if (entity != null) {
            Vec3 vec3 = entity.getEyePosition(0.0f);
            Vec3 vec31 = new Vec3((double)block.getBlockPos().getX() - 0.5, (double)block.getBlockPos().getY() + 0.75, (double)block.getBlockPos().getZ() - 0.5);
            double d0 = vec3.y - vec31.y;
            part.y = d0 > 0.0 ? -0.5f : 0.5f;
            Vec3 vec32 = vec31;
            vec32 = new Vec3(vec32.x, 0.0, vec32.z);
            Vec3 vec33 = new Vec3(vec31.x - vec3.x, 0.0, vec31.z - vec3.z).normalize().yRot(1.5707964f);
            double d1 = vec32.dot(vec33);
            part.x = Mth.sqrt((float)((float)Math.abs(d1))) * 0.01f * (float)Math.signum(d1);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.OutpostCore.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    @Override
    public void setupAnim(T entity, float ageInTicks) {
        this.animateBiomass(this.Biomass, ageInTicks);
        this.animateBrain(this.Brain1, ageInTicks);
        this.animateBrain(this.Brain2, -ageInTicks);
        this.animateBrain(this.Brain3, ageInTicks);
        this.animateBrain(this.Brain4, -ageInTicks);
        this.RotateStalk(entity, Minecraft.getInstance().cameraEntity);
        this.animatePupil(entity, Minecraft.getInstance().cameraEntity, this.Pupil);
        this.Rib1.xRot = -0.6f + Mth.sin((float)(ageInTicks / 7.0f)) / 5.0f;
        this.Rib2.xRot = -0.6f + Mth.sin((float)(ageInTicks / 7.0f)) / 5.0f;
        this.Rib3.xRot = 0.6f + Mth.sin((float)(ageInTicks / 7.0f)) / 5.0f;
        this.Rib4.xRot = -0.6f + Mth.sin((float)(ageInTicks / 7.0f)) / 5.0f;
    }
}

