/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Special.BlockEntityModel;
import com.Harbinger.Spore.SBlockEntities.OvergrownSpawnerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class OvergrownSpawnerModel<T extends OvergrownSpawnerEntity>
extends BlockEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"overgrownspawnermodel"), "main");
    private final ModelPart body;
    private final ModelPart tumor;

    public OvergrownSpawnerModel() {
        ModelPart root = OvergrownSpawnerModel.createBodyLayer().bakeRoot();
        this.body = root.getChild("body");
        this.tumor = root.getChild("tumor");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -16.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(22, 50).addBox(-7.0f, -0.05f, -7.0f, 14.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition tumor = partdefinition.addOrReplaceChild("tumor", CubeListBuilder.create().texOffs(24, 32).addBox(-3.0f, -4.85f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(48, 32).addBox(-2.0f, -10.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.75f, (float)0.0f));
        PartDefinition cube_r1 = tumor.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 32).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r2 = tumor.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -11.25f, -1.75f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r3 = tumor.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 43).addBox(-2.25f, -13.25f, -0.5f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = tumor.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 43).addBox(-4.0f, -13.0f, -1.5f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition cube_r5 = tumor.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 43).addBox(-2.5f, -12.0f, -3.5f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = tumor.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(48, 0).addBox(-3.0f, -14.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0873f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(T entity, float ageInTicks) {
        this.tumor.xScale = 1.0f + Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
        this.tumor.zScale = 1.0f + Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
        this.tumor.yScale = 1.0f - Mth.cos((float)(ageInTicks / 9.0f)) / 6.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.tumor.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

