/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.Experiments.Plagued;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PlaguedModel<T extends Plagued>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"plagued"), "main");
    private final ModelPart covid;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart RightForLeg;
    private final ModelPart LeftForLeg;
    private final ModelPart Torso;
    private final ModelPart Head;
    private final ModelPart Jaw;
    private final ModelPart Brain;
    private final ModelPart HeadTumors;
    private final ModelPart Arm;
    private final ModelPart ArmTumor;

    public PlaguedModel(ModelPart root) {
        this.covid = root.getChild("covid");
        this.RightLeg = this.covid.getChild("legs").getChild("RightLeg");
        this.LeftLeg = this.covid.getChild("legs").getChild("LeftLeg");
        this.RightForLeg = this.RightLeg.getChild("RightLegSeg2");
        this.LeftForLeg = this.LeftLeg.getChild("LeftLegSeg2");
        this.Torso = this.covid.getChild("Torso").getChild("TorsoTop");
        this.Head = this.Torso.getChild("Head");
        this.Jaw = this.Head.getChild("Jaw");
        this.Brain = this.Head.getChild("JuicyBrain");
        this.HeadTumors = this.Head.getChild("Tumors");
        this.Arm = this.Torso.getChild("Arms").getChild("RightLump");
        this.ArmTumor = this.Torso.getChild("Arms").getChild("LeftTumors");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition covid = partdefinition.addOrReplaceChild("covid", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition legs = covid.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = legs.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(51, 51).addBox(-1.25f, 0.0f, -1.25f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offset((float)-2.025f, (float)-12.0f, (float)0.0f));
        PartDefinition RightLeg_r1 = RightLeg.addOrReplaceChild("RightLeg_r1", CubeListBuilder.create().texOffs(0, 53).addBox(-1.5f, -3.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.25f, (float)3.0f, (float)0.25f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition RightLegSeg2 = RightLeg.addOrReplaceChild("RightLegSeg2", CubeListBuilder.create().texOffs(12, 54).addBox(-1.225f, 0.0f, -1.25f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg = legs.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 53).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.25f));
        PartDefinition LeftLegSeg2 = LeftLeg.addOrReplaceChild("LeftLegSeg2", CubeListBuilder.create(), PartPose.offset((float)0.025f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg_r1 = LeftLegSeg2.addOrReplaceChild("LeftLeg_r1", CubeListBuilder.create().texOffs(12, 54).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.05f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition Torso = covid.addOrReplaceChild("Torso", CubeListBuilder.create().texOffs(18, 45).addBox(-3.499f, -6.0f, -1.25f, 7.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 14).addBox(-3.499f, -6.0f, -1.25f, 7.0f, 6.0f, 3.0f, new CubeDeformation(0.15f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition TorsoBasefungus = Torso.addOrReplaceChild("TorsoBasefungus", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition fungus_r1 = TorsoBasefungus.addOrReplaceChild("fungus_r1", CubeListBuilder.create().texOffs(17, 0).addBox(0.5f, -2.0f, -5.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-15.0f, (float)1.5f, (float)0.1367f, (float)0.3198f, (float)-0.0888f));
        PartDefinition fungus_r2 = TorsoBasefungus.addOrReplaceChild("fungus_r2", CubeListBuilder.create().texOffs(17, 9).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-15.0f, (float)1.5f, (float)0.1289f, (float)-0.0227f, (float)0.1731f));
        PartDefinition TorsoBaseSyringes = Torso.addOrReplaceChild("TorsoBaseSyringes", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition Syringe3 = TorsoBaseSyringes.addOrReplaceChild("Syringe3", CubeListBuilder.create().texOffs(0, 40).addBox(-1.0f, -2.3667f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.5f)).texOffs(10, 45).addBox(-1.5f, -2.3667f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)).texOffs(0, 9).addBox(-0.5f, 0.7333f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)4.5f, (float)-16.1333f, (float)-0.5f, (float)2.8926f, (float)1.0827f, (float)-2.3866f));
        PartDefinition ThumbPress5 = Syringe3.addOrReplaceChild("ThumbPress5", CubeListBuilder.create().texOffs(48, 0).addBox(-0.5f, -1.25f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.3f)).texOffs(0, 62).addBox(-1.0f, -1.55f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)0.0f, (float)-2.3667f, (float)0.0f));
        PartDefinition TorsoTop = Torso.addOrReplaceChild("TorsoTop", CubeListBuilder.create().texOffs(24, 30).addBox(-4.0f, -6.0f, -2.0f, 8.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 9).addBox(-4.0f, -6.0f, -2.0f, 8.0f, 9.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition Head = TorsoTop.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(36, 54).addBox(-3.0f, -7.0f, -4.0f, 6.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(54, 45).addBox(-3.0f, -6.0f, 3.0f, 6.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 0).addBox(3.0f, -8.0f, -4.0f, 1.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(-4.0f, -7.0f, -4.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(44, 23).addBox(0.0f, -8.0f, -4.0f, 3.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(48, 0).addBox(-4.0f, -8.0f, -4.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(10, 40).addBox(-4.0f, -1.0f, 0.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition Jaw = Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(10, 40).addBox(-3.99f, -0.5f, -4.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Fang4_r1 = Jaw.addOrReplaceChild("Fang4_r1", CubeListBuilder.create().texOffs(24, 7).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.625f, (float)-1.9435f, (float)-4.3501f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition Fang3_r1 = Jaw.addOrReplaceChild("Fang3_r1", CubeListBuilder.create().texOffs(4, 25).addBox(-5.0f, -1.5f, 1.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.875f, (float)-0.175f, (float)-4.7f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition Teeth_r1 = Jaw.addOrReplaceChild("Teeth_r1", CubeListBuilder.create().texOffs(18, 29).addBox(0.0628f, -1.0528f, -0.4459f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.7073f, (float)-1.2831f, (float)-3.315f, (float)-0.102f, (float)-0.1932f, (float)0.4899f));
        PartDefinition Teeth_r2 = Jaw.addOrReplaceChild("Teeth_r2", CubeListBuilder.create().texOffs(19, 28).addBox(0.25f, -0.5f, -1.5f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.9666f, (float)-0.7541f, (float)-2.2927f, (float)0.0573f, (float)-0.2106f, (float)-0.2679f));
        PartDefinition Teeth_r3 = Jaw.addOrReplaceChild("Teeth_r3", CubeListBuilder.create().texOffs(18, 26).addBox(0.75f, -0.75f, -2.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0334f, (float)-1.2541f, (float)-2.5427f, (float)-1.5879f, (float)1.2947f, (float)-1.5886f));
        PartDefinition Teeth_r4 = Jaw.addOrReplaceChild("Teeth_r4", CubeListBuilder.create().texOffs(18, 27).addBox(-0.25f, -1.0f, -1.75f, 0.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-0.3f, (float)-1.95f, (float)0.0411f, (float)0.3027f, (float)0.1372f));
        PartDefinition topTeeth = Head.addOrReplaceChild("topTeeth", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition BigAssToothie_r1 = topTeeth.addOrReplaceChild("BigAssToothie_r1", CubeListBuilder.create().texOffs(18, 32).addBox(-1.75f, -0.25f, 0.5f, 4.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)-0.2618f, (float)-0.1745f, (float)0.0f));
        PartDefinition Toothie_r1 = topTeeth.addOrReplaceChild("Toothie_r1", CubeListBuilder.create().texOffs(6, 0).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.9f, (float)0.0978f, (float)-4.6654f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Toothie_r2 = topTeeth.addOrReplaceChild("Toothie_r2", CubeListBuilder.create().texOffs(0, 0).addBox(0.25f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.15f, (float)-1.75f, (float)-3.9f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition Toothie_r3 = topTeeth.addOrReplaceChild("Toothie_r3", CubeListBuilder.create().texOffs(26, 7).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)0.3478f, (float)-4.5154f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition Toothie_r4 = topTeeth.addOrReplaceChild("Toothie_r4", CubeListBuilder.create().texOffs(4, 23).addBox(0.25f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.25f, (float)-1.5f, (float)-3.75f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition JuicyBrain = Head.addOrReplaceChild("JuicyBrain", CubeListBuilder.create().texOffs(0, 29).addBox(-3.0f, -3.0f, -4.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)1.0f));
        PartDefinition HeadSyringe = Head.addOrReplaceChild("HeadSyringe", CubeListBuilder.create().texOffs(0, 40).addBox(-1.0f, -2.3667f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.5f)).texOffs(10, 45).addBox(-1.5f, -2.3667f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)).texOffs(0, 9).addBox(-0.5f, 0.7333f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-1.0f, (float)-8.1333f, (float)2.5f, (float)-0.2823f, (float)0.3786f, (float)-0.1068f));
        PartDefinition ThumbPress4 = HeadSyringe.addOrReplaceChild("ThumbPress4", CubeListBuilder.create().texOffs(48, 0).addBox(-0.5f, -1.25f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.3f)).texOffs(0, 62).addBox(-1.0f, -1.55f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)0.0f, (float)-2.3667f, (float)0.0f));
        PartDefinition Tumors = Head.addOrReplaceChild("Tumors", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-8.0f, (float)0.0f));
        PartDefinition Tumor_r1 = Tumors.addOrReplaceChild("Tumor_r1", CubeListBuilder.create().texOffs(56, 5).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)-0.54f, (float)0.0099f, (float)0.7953f, (float)1.3418f, (float)-0.2467f, (float)-1.0482f));
        PartDefinition Tumor_r2 = Tumors.addOrReplaceChild("Tumor_r2", CubeListBuilder.create().texOffs(56, 5).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.5f, (float)1.6434f, (float)0.2952f, (float)1.318f, (float)0.0071f, (float)-0.5688f));
        PartDefinition Tumor_r3 = Tumors.addOrReplaceChild("Tumor_r3", CubeListBuilder.create().texOffs(56, 5).addBox(-1.5f, -1.5f, -0.75f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)1.5f, (float)0.5f, (float)0.5208f, (float)0.3352f, (float)-0.5208f));
        PartDefinition HeadFungus = Head.addOrReplaceChild("HeadFungus", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition fungus_r3 = HeadFungus.addOrReplaceChild("fungus_r3", CubeListBuilder.create().texOffs(17, 0).addBox(-3.5f, 1.25f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.784f, (float)-4.089f, (float)3.4013f, (float)-0.0692f, (float)-0.3066f, (float)-0.0425f));
        PartDefinition fungus_r4 = HeadFungus.addOrReplaceChild("fungus_r4", CubeListBuilder.create().texOffs(17, 9).addBox(-3.5f, -2.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.7018f, (float)-4.4812f, (float)-4.2523f, (float)-0.3235f, (float)0.3066f, (float)-0.0425f));
        PartDefinition fungus_r5 = HeadFungus.addOrReplaceChild("fungus_r5", CubeListBuilder.create().texOffs(17, 16).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0438f, (float)-3.2531f, (float)1.2876f, (float)0.3765f, (float)0.3568f, (float)0.2294f));
        PartDefinition fungus_r6 = HeadFungus.addOrReplaceChild("fungus_r6", CubeListBuilder.create().texOffs(17, 16).addBox(-2.75f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-4.0f, (float)-1.5f, (float)-0.2934f, (float)0.4623f, (float)-0.1339f));
        PartDefinition Arms = TorsoTop.addOrReplaceChild("Arms", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightLump = Arms.addOrReplaceChild("RightLump", CubeListBuilder.create().texOffs(38, 45).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.0f, 2.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-4.0f, (float)0.0f));
        PartDefinition RightArmSyringe = RightLump.addOrReplaceChild("RightArmSyringe", CubeListBuilder.create().texOffs(0, 40).addBox(-1.0f, -2.3667f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.5f)).texOffs(10, 45).addBox(-1.5f, -2.3667f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)).texOffs(0, 9).addBox(-0.5f, 0.7333f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-5.0f, (float)-0.1333f, (float)0.75f, (float)-0.6328f, (float)-1.0191f, (float)-0.8598f));
        PartDefinition ThumbPress3 = RightArmSyringe.addOrReplaceChild("ThumbPress3", CubeListBuilder.create().texOffs(48, 0).addBox(-0.5f, -1.25f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.3f)).texOffs(0, 62).addBox(-1.0f, -1.55f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)0.0f, (float)-2.3667f, (float)0.0f));
        PartDefinition LeftTumors = Arms.addOrReplaceChild("LeftTumors", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)-4.0f, (float)0.0f));
        PartDefinition Tumor_r4 = LeftTumors.addOrReplaceChild("Tumor_r4", CubeListBuilder.create().texOffs(56, 5).addBox(-1.5f, -1.75f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.6478f, (float)1.1829f, (float)0.4605f, (float)0.8238f, (float)-0.625f, (float)-1.2707f));
        PartDefinition Tumor_r5 = LeftTumors.addOrReplaceChild("Tumor_r5", CubeListBuilder.create().texOffs(56, 5).addBox(-2.75f, 0.0f, -0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.7078f, (float)-0.2784f, (float)-0.8331f, (float)0.1436f, (float)-0.9803f, (float)-0.3689f));
        PartDefinition Tumor_r6 = LeftTumors.addOrReplaceChild("Tumor_r6", CubeListBuilder.create().texOffs(56, 5).addBox(-2.0f, -1.5f, -2.25f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-1.5f, (float)0.5f, (float)0.7813f, (float)-0.286f, (float)-0.2729f));
        PartDefinition TorsoSyringes = TorsoTop.addOrReplaceChild("TorsoSyringes", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Syringe1 = TorsoSyringes.addOrReplaceChild("Syringe1", CubeListBuilder.create().texOffs(0, 40).addBox(-1.0f, -2.3667f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.5f)).texOffs(10, 45).addBox(-1.5f, -2.3667f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)).texOffs(0, 9).addBox(-0.5f, 0.7333f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.1333f, (float)3.5f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition ThumbPress = Syringe1.addOrReplaceChild("ThumbPress", CubeListBuilder.create().texOffs(48, 0).addBox(-0.5f, -1.25f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.3f)).texOffs(0, 62).addBox(-1.0f, -1.55f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)0.0f, (float)-2.3667f, (float)0.0f));
        PartDefinition Syringe2 = TorsoSyringes.addOrReplaceChild("Syringe2", CubeListBuilder.create().texOffs(0, 40).addBox(-1.0f, -2.3667f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.5f)).texOffs(10, 45).addBox(-1.5f, -2.3667f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)).texOffs(0, 9).addBox(-0.5f, 0.7333f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)-2.0f, (float)-2.1333f, (float)3.5f, (float)-1.5567f, (float)-0.1624f, (float)0.3591f));
        PartDefinition ThumbPress2 = Syringe2.addOrReplaceChild("ThumbPress2", CubeListBuilder.create().texOffs(48, 0).addBox(-0.5f, -1.25f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.3f)).texOffs(0, 62).addBox(-1.0f, -1.55f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)0.0f, (float)-2.3667f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void animateTumor(ModelPart part, float value) {
        part.xScale = 1.0f + Mth.cos((float)(value / 6.0f)) / 8.0f;
        part.zScale = 1.0f + Mth.cos((float)(value / 7.0f)) / 6.0f;
        part.yScale = 1.0f - Mth.cos((float)(value / 6.0f)) / 7.0f;
    }

    public void animateTumor1(ModelPart part, float value) {
        part.xScale = 1.0f + Mth.cos((float)(value / 8.0f)) / 8.0f;
        part.zScale = 1.0f + Mth.cos((float)(value / 7.0f)) / 8.0f;
        part.yScale = 1.0f - Mth.cos((float)(value / 8.0f)) / 7.0f;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6f)) * 0.6f * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 0.6f)) * 0.6f * -limbSwingAmount;
        this.LeftForLeg.xRot = this.LeftLeg.xRot < 0.0f ? -this.LeftLeg.xRot : 0.0f;
        this.RightForLeg.xRot = this.RightLeg.xRot < 0.0f ? -this.RightLeg.xRot : 0.0f;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 28.647888f;
        this.Jaw.xRot = 0.9f + Mth.cos((float)(ageInTicks / 6.0f)) / 6.0f;
        this.animateTumor(this.ArmTumor, ageInTicks);
        this.animateTumor1(this.HeadTumors, -ageInTicks);
        this.animateTumor(this.Brain, ageInTicks);
        this.Torso.xRot = 0.3f + Mth.sin((float)(ageInTicks / 8.0f)) / 8.0f;
        if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            this.Torso.zRot = Mth.sin((float)(ageInTicks / 8.0f)) / 8.0f;
            this.Arm.xRot = -0.5f + Mth.cos((float)(ageInTicks / 6.0f)) / 6.0f;
        } else {
            this.Torso.zRot = 0.0f;
            this.Arm.xRot = Mth.cos((float)(ageInTicks / 7.0f)) / 8.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.covid.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

