/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Models.TentacledModel;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Protector;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ProtectorModel<T extends Protector>
extends EntityModel<T>
implements TentacledModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"protectormodel"), "main");
    public final ModelPart Protector;
    private final ModelPart FullBody;
    private final ModelPart Body;
    private final ModelPart RibHeart;
    private final ModelPart RibCage1;
    private final ModelPart Heart;
    private final ModelPart RibCage2;
    private final ModelPart Arms;
    private final ModelPart ShieldArm;
    private final ModelPart rightArm;
    private final ModelPart rightForArm;
    private final ModelPart shield;
    private final ModelPart ShieldFoliage3;
    private final ModelPart ShieldFoliage2;
    private final ModelPart ShieldFoliage;
    private final ModelPart tumors;
    private final ModelPart Head;
    private final ModelPart Jaw;
    public final ModelPart headWear;
    private final ModelPart Legs;
    private final ModelPart LeftLeg;
    public final ModelPart LeftBoot;
    private final ModelPart RightLeg;
    public final ModelPart RightBoot;
    public final ModelPart LeftArm;
    private final boolean armor;

    public ProtectorModel(ModelPart root, boolean armor) {
        this.Protector = root.getChild("Protector");
        this.FullBody = this.Protector.getChild("FullBody");
        this.Body = this.FullBody.getChild("Body");
        this.RibHeart = this.Body.getChild("RibHeart");
        this.RibCage1 = this.RibHeart.getChild("RibCage1");
        this.Heart = this.RibHeart.getChild("Heart");
        this.RibCage2 = this.RibHeart.getChild("RibCage2");
        this.Arms = this.FullBody.getChild("Arms");
        this.ShieldArm = this.Arms.getChild("ShieldArm");
        this.rightArm = this.ShieldArm.getChild("rightArm");
        this.rightForArm = this.rightArm.getChild("rightForArm");
        this.shield = this.rightForArm.getChild("shield");
        this.ShieldFoliage3 = this.shield.getChild("ShieldFoliage3");
        this.ShieldFoliage2 = this.shield.getChild("ShieldFoliage2");
        this.ShieldFoliage = this.shield.getChild("ShieldFoliage");
        this.tumors = this.shield.getChild("tumors");
        this.Head = this.FullBody.getChild("Head");
        this.Jaw = this.Head.getChild("Jaw");
        this.headWear = this.Head.getChild("headWear");
        this.Legs = this.Protector.getChild("Legs");
        this.LeftLeg = this.Legs.getChild("LeftLeg");
        this.LeftBoot = this.LeftLeg.getChild("LeftBoot");
        this.RightLeg = this.Legs.getChild("RightLeg");
        this.RightBoot = this.RightLeg.getChild("RightBoot");
        this.LeftArm = root.getChild("LeftArm");
        this.armor = armor;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Protector2 = partdefinition.addOrReplaceChild("Protector", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition FullBody = Protector2.addOrReplaceChild("FullBody", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Body = FullBody.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 27).addBox(-3.6f, -5.0f, -2.2f, 8.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-4.0f, 2.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.4f, (float)-19.0f, (float)-0.3f));
        PartDefinition CalciumChunk_r1 = Body.addOrReplaceChild("CalciumChunk_r1", CubeListBuilder.create().texOffs(21, 64).addBox(0.0f, -4.0f, -5.0f, 5.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-2.1f, (float)3.1f, (float)-0.9791f, (float)0.4257f, (float)-0.0399f));
        PartDefinition CalciumChunk_r2 = Body.addOrReplaceChild("CalciumChunk_r2", CubeListBuilder.create().texOffs(27, 27).addBox(-1.0f, -5.0f, -6.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8f, (float)-0.9f, (float)0.5f, (float)-1.0756f, (float)-0.3435f, (float)-0.0915f));
        PartDefinition CalciumArmor_r1 = Body.addOrReplaceChild("CalciumArmor_r1", CubeListBuilder.create().texOffs(65, 40).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2f, (float)-2.2f, (float)4.4f, (float)1.8459f, (float)0.1528f, (float)-1.476f));
        PartDefinition Petal_r1 = Body.addOrReplaceChild("Petal_r1", CubeListBuilder.create().texOffs(23, 56).addBox(-1.0f, 0.0f, -1.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.6f, (float)0.4f, (float)2.0f, (float)-0.0698f, (float)0.6109f, (float)0.0f));
        PartDefinition Petal_r2 = Body.addOrReplaceChild("Petal_r2", CubeListBuilder.create().texOffs(50, 48).addBox(-1.0f, 0.0f, -1.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6f, (float)2.4f, (float)1.5f, (float)-0.1745f, (float)-0.2967f, (float)0.0f));
        PartDefinition Petal_r3 = Body.addOrReplaceChild("Petal_r3", CubeListBuilder.create().texOffs(56, 8).addBox(-1.0f, 0.0f, -1.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.4f, (float)5.0f, (float)0.3f, (float)-0.1222f, (float)0.2793f, (float)0.0f));
        PartDefinition RibHeart = Body.addOrReplaceChild("RibHeart", CubeListBuilder.create(), PartPose.offset((float)2.9f, (float)-2.0f, (float)-3.3f));
        PartDefinition RibCage1 = RibHeart.addOrReplaceChild("RibCage1", CubeListBuilder.create(), PartPose.offset((float)-5.0f, (float)3.0f, (float)1.0f));
        PartDefinition Rib_r1 = RibCage1.addOrReplaceChild("Rib_r1", CubeListBuilder.create().texOffs(104, 35).addBox(-1.0f, -2.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.25f, (float)0.0f, (float)1.2741f, (float)0.0f));
        PartDefinition Rib_r2 = RibCage1.addOrReplaceChild("Rib_r2", CubeListBuilder.create().texOffs(104, 30).addBox(-1.0f, -2.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)1.2741f, (float)0.0f));
        PartDefinition Heart = RibHeart.addOrReplaceChild("Heart", CubeListBuilder.create(), PartPose.offset((float)-2.8f, (float)0.0f, (float)1.3f));
        PartDefinition HeartTumor_r1 = Heart.addOrReplaceChild("HeartTumor_r1", CubeListBuilder.create().texOffs(91, 104).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.296f, (float)0.307f, (float)0.1599f));
        PartDefinition HeartTumor_r2 = Heart.addOrReplaceChild("HeartTumor_r2", CubeListBuilder.create().texOffs(101, 89).addBox(-1.0f, -3.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.7f, (float)3.3f, (float)-0.5f, (float)0.0185f, (float)-0.2086f, (float)-0.0892f));
        PartDefinition HeartTumor_r3 = Heart.addOrReplaceChild("HeartTumor_r3", CubeListBuilder.create().texOffs(67, 85).addBox(-1.0f, -4.0f, -3.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8f, (float)2.3f, (float)1.4f, (float)0.0222f, (float)0.2083f, (float)0.107f));
        PartDefinition RibCage2 = RibHeart.addOrReplaceChild("RibCage2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition Rib_r3 = RibCage2.addOrReplaceChild("Rib_r3", CubeListBuilder.create().texOffs(104, 40).addBox(-1.0f, -2.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3265f, (float)0.0f));
        PartDefinition Rib_r4 = RibCage2.addOrReplaceChild("Rib_r4", CubeListBuilder.create().texOffs(104, 45).addBox(-1.0f, -2.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-0.5f, (float)0.0f, (float)-1.3265f, (float)0.0f));
        PartDefinition Arms = FullBody.addOrReplaceChild("Arms", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition ShieldArm = Arms.addOrReplaceChild("ShieldArm", CubeListBuilder.create(), PartPose.offset((float)-2.6f, (float)-20.7f, (float)0.5f));
        PartDefinition rightArm = ShieldArm.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(85, 0).addBox(-2.5179f, -0.6818f, -2.5f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition rightForArm = rightArm.addOrReplaceChild("rightForArm", CubeListBuilder.create().texOffs(0, 57).addBox(-1.7f, 0.0f, -2.9f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.1179f, (float)6.0182f, (float)0.0f, (float)-0.4821f, (float)-0.2129f, (float)-0.3838f));
        PartDefinition shield = rightForArm.addOrReplaceChild("shield", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)2.0f, (float)3.0f, (float)1.4775f, (float)1.1324f, (float)1.4679f));
        PartDefinition ShieldBase_r1 = shield.addOrReplaceChild("ShieldBase_r1", CubeListBuilder.create().texOffs(27, 40).addBox(-1.0f, -7.0f, -1.0f, 8.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.2f, (float)-2.4f, (float)-1.1f, (float)0.0f, (float)0.4538f, (float)0.0f));
        PartDefinition ShieldBase_r2 = shield.addOrReplaceChild("ShieldBase_r2", CubeListBuilder.create().texOffs(0, 42).addBox(-1.0f, -7.0f, -1.0f, 8.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-1.9f, (float)-1.9f, (float)-0.0037f, (float)-0.2094f, (float)0.0178f));
        PartDefinition ShieldBase_r3 = shield.addOrReplaceChild("ShieldBase_r3", CubeListBuilder.create().texOffs(52, 56).addBox(0.0f, -7.0f, -1.0f, 7.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.6f, (float)6.5f, (float)-2.2f, (float)0.1939f, (float)0.1732f, (float)0.0135f));
        PartDefinition ShieldBase_r4 = shield.addOrReplaceChild("ShieldBase_r4", CubeListBuilder.create().texOffs(65, 71).addBox(-1.0f, -7.0f, -1.0f, 6.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.4f, (float)5.8f, (float)-2.2f, (float)0.0646f, (float)-0.3134f, (float)0.0734f));
        PartDefinition ShieldBase_r5 = shield.addOrReplaceChild("ShieldBase_r5", CubeListBuilder.create().texOffs(33, 0).addBox(-1.0f, -8.0f, -1.0f, 8.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.1f, (float)11.3f, (float)-1.2f, (float)0.1047f, (float)0.0036f, (float)-0.0347f));
        PartDefinition CalciumArmor_r2 = shield.addOrReplaceChild("CalciumArmor_r2", CubeListBuilder.create().texOffs(0, 99).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.7f, (float)4.9f, (float)-3.2f, (float)1.4484f, (float)-0.1195f, (float)0.1422f));
        PartDefinition CalciumArmor_r3 = shield.addOrReplaceChild("CalciumArmor_r3", CubeListBuilder.create().texOffs(98, 62).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2f, (float)-3.7f, (float)-1.4f, (float)1.3049f, (float)0.6029f, (float)-0.3666f));
        PartDefinition CalciumArmor_r4 = shield.addOrReplaceChild("CalciumArmor_r4", CubeListBuilder.create().texOffs(98, 54).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.8f, (float)-3.7f, (float)-1.2f, (float)1.3865f, (float)-0.0829f, (float)0.2202f));
        PartDefinition ShieldTumor_r1 = shield.addOrReplaceChild("ShieldTumor_r1", CubeListBuilder.create().texOffs(19, 99).addBox(-3.0f, -4.0f, -1.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.4f, (float)3.7f, (float)-1.3f, (float)-0.1855f, (float)-0.3435f, (float)0.0631f));
        PartDefinition ConnectiveBone_r1 = shield.addOrReplaceChild("ConnectiveBone_r1", CubeListBuilder.create().texOffs(60, 103).addBox(-2.0f, -2.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.8f, (float)-5.4f, (float)0.1f, (float)0.0f, (float)0.4887f, (float)0.0f));
        PartDefinition ConnectiveBone_r2 = shield.addOrReplaceChild("ConnectiveBone_r2", CubeListBuilder.create().texOffs(82, 104).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-2.0f, (float)-1.0f, (float)-0.429f, (float)0.048f, (float)-0.3615f));
        PartDefinition ConnectiveBone_r3 = shield.addOrReplaceChild("ConnectiveBone_r3", CubeListBuilder.create().texOffs(71, 104).addBox(-1.0f, -2.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.3f, (float)-3.1f, (float)0.5f, (float)0.0f, (float)0.4887f, (float)0.0f));
        PartDefinition ShieldFoliage3 = shield.addOrReplaceChild("ShieldFoliage3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)8.8034f, (float)-2.9808f, (float)-4.6487f, (float)1.6836f, (float)-0.614f, (float)-0.73f));
        PartDefinition Petal4_r1 = ShieldFoliage3.addOrReplaceChild("Petal4_r1", CubeListBuilder.create().texOffs(79, 40).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.6016f, (float)1.4674f, (float)-1.161f, (float)0.2443f, (float)0.0f, (float)-0.4363f));
        PartDefinition Petal3_r1 = ShieldFoliage3.addOrReplaceChild("Petal3_r1", CubeListBuilder.create().texOffs(84, 70).addBox(-2.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.416f, (float)2.4992f, (float)-1.161f, (float)0.263f, (float)0.1603f, (float)0.1693f));
        PartDefinition Petal2_r1 = ShieldFoliage3.addOrReplaceChild("Petal2_r1", CubeListBuilder.create().texOffs(79, 33).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.8984f, (float)1.6674f, (float)-5.161f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal1_r1 = ShieldFoliage3.addOrReplaceChild("Petal1_r1", CubeListBuilder.create().texOffs(83, 23).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.8984f, (float)0.5674f, (float)2.839f, (float)0.4354f, (float)0.0295f, (float)-0.0633f));
        PartDefinition ShieldFoliage2 = shield.addOrReplaceChild("ShieldFoliage2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.4034f, (float)2.2192f, (float)-6.7487f, (float)1.164f, (float)0.2572f, (float)-0.4245f));
        PartDefinition Petal4_r2 = ShieldFoliage2.addOrReplaceChild("Petal4_r2", CubeListBuilder.create().texOffs(60, 16).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.6016f, (float)1.4674f, (float)-1.161f, (float)0.2443f, (float)0.0f, (float)-0.4363f));
        PartDefinition Petal3_r2 = ShieldFoliage2.addOrReplaceChild("Petal3_r2", CubeListBuilder.create().texOffs(0, 84).addBox(-2.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.416f, (float)2.4992f, (float)-1.161f, (float)0.263f, (float)0.1603f, (float)0.1693f));
        PartDefinition Petal2_r2 = ShieldFoliage2.addOrReplaceChild("Petal2_r2", CubeListBuilder.create().texOffs(54, 33).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.8984f, (float)1.6674f, (float)-5.161f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal1_r2 = ShieldFoliage2.addOrReplaceChild("Petal1_r2", CubeListBuilder.create().texOffs(84, 77).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.8984f, (float)0.5674f, (float)2.839f, (float)0.4354f, (float)0.0295f, (float)-0.0633f));
        PartDefinition ShieldFoliage = shield.addOrReplaceChild("ShieldFoliage", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.1034f, (float)-9.5808f, (float)-4.1487f, (float)1.1183f, (float)-0.1441f, (float)-0.6485f));
        PartDefinition Petal4_r3 = ShieldFoliage.addOrReplaceChild("Petal4_r3", CubeListBuilder.create().texOffs(73, 63).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.6016f, (float)-0.9326f, (float)-1.161f, (float)0.2443f, (float)0.0f, (float)-0.4363f));
        PartDefinition Petal3_r3 = ShieldFoliage.addOrReplaceChild("Petal3_r3", CubeListBuilder.create().texOffs(25, 84).addBox(-2.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.416f, (float)0.0992f, (float)-1.161f, (float)0.263f, (float)0.1603f, (float)0.1693f));
        PartDefinition Petal2_r3 = ShieldFoliage.addOrReplaceChild("Petal2_r3", CubeListBuilder.create().texOffs(73, 56).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.8984f, (float)-0.7326f, (float)-5.161f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Petal1_r3 = ShieldFoliage.addOrReplaceChild("Petal1_r3", CubeListBuilder.create().texOffs(79, 47).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.8984f, (float)-0.7326f, (float)1.539f, (float)0.4354f, (float)0.0295f, (float)-0.0633f));
        PartDefinition tumors = shield.addOrReplaceChild("tumors", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition ShieldTumor_r2 = tumors.addOrReplaceChild("ShieldTumor_r2", CubeListBuilder.create().texOffs(49, 103).addBox(-2.0f, -3.0f, -1.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)7.3f, (float)2.5f, (float)-0.1231f, (float)0.1213f, (float)-0.015f));
        PartDefinition ShieldTumor_r3 = tumors.addOrReplaceChild("ShieldTumor_r3", CubeListBuilder.create().texOffs(36, 103).addBox(-2.0f, -2.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.1f, (float)-2.7f, (float)2.0f, (float)-0.3204f, (float)0.0282f, (float)-0.1378f));
        PartDefinition Head = FullBody.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -6.5f, -5.6f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(101, 84).addBox(-4.0f, -0.7f, 0.4f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-25.0f, (float)-2.2f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Petal_r4 = Head.addOrReplaceChild("Petal_r4", CubeListBuilder.create().texOffs(54, 25).addBox(-1.0f, 0.0f, -1.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.6f, (float)-6.4f, (float)-1.0f, (float)-0.1571f, (float)-0.2094f, (float)0.0f));
        PartDefinition Petal_r5 = Head.addOrReplaceChild("Petal_r5", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, 0.0f, -1.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.2f, (float)-0.9f, (float)-0.1396f, (float)0.2443f, (float)0.0f));
        PartDefinition CalciumArmor_r5 = Head.addOrReplaceChild("CalciumArmor_r5", CubeListBuilder.create().texOffs(0, 91).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2f, (float)-4.6f, (float)-5.5f, (float)0.3233f, (float)-0.0516f, (float)-0.1748f));
        PartDefinition CalciumArmor_r6 = Head.addOrReplaceChild("CalciumArmor_r6", CubeListBuilder.create().texOffs(19, 91).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.4f, (float)-6.0f, (float)-3.1f, (float)-0.0873f, (float)-0.0698f, (float)1.3439f));
        PartDefinition CalciumArmor_r7 = Head.addOrReplaceChild("CalciumArmor_r7", CubeListBuilder.create().texOffs(21, 75).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-3.0f, (float)-6.3f, (float)0.291f, (float)-0.4577f, (float)-0.1036f));
        PartDefinition CalciumArmor_r8 = Head.addOrReplaceChild("CalciumArmor_r8", CubeListBuilder.create().texOffs(57, 95).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.9f, (float)-1.4f, (float)-6.3f, (float)0.0897f, (float)-0.5546f, (float)0.1217f));
        PartDefinition Jaw = Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(31, 16).addBox(-4.0f, -0.4128f, -5.0038f, 8.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 106).addBox(-4.0f, -1.4128f, -5.0038f, 8.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.25f, (float)0.4f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition headWear = Head.addOrReplaceChild("headWear", CubeListBuilder.create().texOffs(0, 0).addBox(-16.0f, -19.0f, -18.0f, 32.0f, 32.0f, 32.0f, new CubeDeformation(-11.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Legs = Protector2.addOrReplaceChild("Legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg = Legs.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(85, 12).addBox(-2.5f, 0.0f, -2.5f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 71).addBox(-3.0f, 5.0f, -3.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(63, 111).addBox(-3.057f, 3.9154f, -3.0535f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offset((float)2.5f, (float)-12.0f, (float)0.5f));
        PartDefinition Petal_r6 = LeftLeg.addOrReplaceChild("Petal_r6", CubeListBuilder.create().texOffs(54, 25).addBox(-1.0f, 0.0f, -1.0f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.7f, (float)2.9f, (float)-0.1f, (float)-0.1222f, (float)-0.0524f, (float)0.0f));
        PartDefinition LeftBoot = LeftLeg.addOrReplaceChild("LeftBoot", CubeListBuilder.create().texOffs(0, 88).addBox(-7.5f, 1.5f, -8.5f, 16.0f, 16.0f, 16.0f, new CubeDeformation(-5.2f)), PartPose.offset((float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = Legs.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(50, 85).addBox(-1.5f, 0.0f, -2.5f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 71).addBox(-2.0f, 5.0f, -3.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(98, 109).addBox(-1.957f, 3.9154f, -3.0535f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-2.5f, (float)-12.0f, (float)0.5f));
        PartDefinition RightBoot = RightLeg.addOrReplaceChild("RightBoot", CubeListBuilder.create().texOffs(0, 88).addBox(-7.5f, 1.5f, -8.5f, 16.0f, 16.0f, 16.0f, new CubeDeformation(-5.21f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(84, 84).addBox(-0.4f, -0.6f, -1.6f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(102, 0).addBox(0.0f, 5.1f, -1.3f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.4f, (float)0.6f, (float)-0.4f));
        PartDefinition CalciumArmor_r9 = LeftArm.addOrReplaceChild("CalciumArmor_r9", CubeListBuilder.create().texOffs(95, 96).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.1f, (float)0.8f, (float)-0.1f, (float)0.0f, (float)-0.1571f, (float)0.6283f));
        PartDefinition CalciumArmor_r10 = LeftArm.addOrReplaceChild("CalciumArmor_r10", CubeListBuilder.create().texOffs(76, 96).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.4f, (float)0.9f, (float)-1.0f, (float)0.1482f, (float)0.243f, (float)0.1079f));
        PartDefinition CalciumArmor_r11 = LeftArm.addOrReplaceChild("CalciumArmor_r11", CubeListBuilder.create().texOffs(38, 95).addBox(-1.0f, -3.0f, -1.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.3f, (float)-0.1f, (float)-0.0043f, (float)-0.1221f, (float)0.0352f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public void setDraw(ModelPart part) {
        part.skipDraw = this.armorParts().contains(part) ? !this.armor : this.armor;
    }

    private List<ModelPart> armorParts() {
        ArrayList<ModelPart> values = new ArrayList<ModelPart>();
        values.add(this.headWear);
        values.add(this.LeftBoot);
        values.add(this.RightBoot);
        return values;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float moveValue = Mth.cos((float)(limbSwing * 0.8f)) * 0.8f * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 28.647888f;
        this.LeftLeg.xRot = moveValue;
        this.RightLeg.xRot = -this.LeftLeg.xRot;
        if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            if (!((Protector)entity).getShielded()) {
                this.ShieldArm.yRot = 0.0f;
                this.ShieldArm.xRot = moveValue / 2.0f;
            }
            this.LeftArm.xRot = -moveValue / 2.0f;
        } else {
            this.ShieldArm.xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
            this.LeftArm.xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        }
        if (((Protector)entity).getShielded()) {
            this.ShieldArm.xRot = 0.0f;
            this.ShieldArm.yRot = -1.2f;
        }
        this.animateTentacleX(this.Jaw, Mth.sin((float)(ageInTicks / 7.0f)) / 8.0f);
        this.animateTumor(this.Heart, Mth.cos((float)(ageInTicks / 6.0f)) / 6.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.Protector.getAllParts().forEach(this::setDraw);
        this.Protector.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

