/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ProtoHivemindModel<T extends Proto>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"protohivemindmodel"), "main");
    private final ModelPart base;
    private final ModelPart body;

    public ProtoHivemindModel(ModelPart root) {
        this.base = root.getChild("base");
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r1 = base.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 52).addBox(-8.0f, -16.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition roots = base.addOrReplaceChild("roots", CubeListBuilder.create().texOffs(193, 192).addBox(-13.984f, -10.6729f, -2.0f, 8.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition roots2 = roots.addOrReplaceChild("roots2", CubeListBuilder.create().texOffs(60, 0).addBox(-5.016f, -4.0271f, -1.0f, 5.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.484f, (float)6.3271f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.9163f));
        PartDefinition cube_r2 = roots2.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(40, 93).addBox(-0.016f, -0.0271f, -2.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)-5.0f, (float)7.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.9599f));
        PartDefinition roots3 = base.addOrReplaceChild("roots3", CubeListBuilder.create().texOffs(24, 189).addBox(-2.0f, -10.6729f, 5.984f, 4.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition roots4 = roots3.addOrReplaceChild("roots4", CubeListBuilder.create().texOffs(0, 52).addBox(-1.016f, -4.0271f, 0.0f, 3.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.484f, (float)6.3271f, (float)9.5f, (float)0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = roots4.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(84, 75).addBox(-2.0f, -0.0271f, -2.984f, 3.0f, 5.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.984f, (float)7.0f, (float)4.984f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition roots5 = base.addOrReplaceChild("roots5", CubeListBuilder.create().texOffs(144, 188).addBox(-2.0f, -10.6729f, -13.984f, 4.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition roots6 = roots5.addOrReplaceChild("roots6", CubeListBuilder.create().texOffs(0, 0).addBox(-2.016f, -4.0271f, -5.0f, 3.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.516f, (float)6.3271f, (float)-9.5f, (float)-0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = roots6.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(76, 0).addBox(-1.0f, -0.0271f, -0.016f, 3.0f, 5.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)-1.016f, (float)7.0f, (float)-4.984f, (float)0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition roots7 = base.addOrReplaceChild("roots7", CubeListBuilder.create().texOffs(192, 117).addBox(5.984f, -10.6729f, -2.0f, 8.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition roots8 = roots7.addOrReplaceChild("roots8", CubeListBuilder.create().texOffs(48, 52).addBox(-0.016f, -4.0271f, -1.0f, 5.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.516f, (float)6.3271f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.9163f));
        PartDefinition cube_r5 = roots8.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(64, 52).addBox(-2.984f, -0.0271f, -1.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)4.9681f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9599f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -32.0f, -10.0f, 20.0f, 32.0f, 20.0f, new CubeDeformation(0.0f)).texOffs(64, 52).addBox(-6.0f, -43.0f, -6.0f, 12.0f, 11.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition sides = body.addOrReplaceChild("sides", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r6 = sides.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(120, 24).addBox(12.0f, -40.0f, -4.0f, 10.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r7 = sides.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(114, 108).addBox(5.0f, -30.0f, -4.5f, 10.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition cube_r8 = sides.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 84).addBox(5.0f, -16.0f, -5.0f, 10.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition sides2 = body.addOrReplaceChild("sides2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r9 = sides2.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(120, 0).addBox(12.0f, -40.0f, -4.0f, 10.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r10 = sides2.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(103, 66).addBox(5.0f, -30.0f, -4.5f, 10.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition cube_r11 = sides2.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(80, 26).addBox(5.0f, -16.0f, -5.0f, 10.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition sides3 = body.addOrReplaceChild("sides3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f));
        PartDefinition cube_r12 = sides3.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(0, 118).addBox(12.0f, -40.0f, -4.0f, 10.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r13 = sides3.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(31, 101).addBox(5.0f, -30.0f, -4.5f, 10.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition cube_r14 = sides3.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(80, 0).addBox(5.0f, -16.0f, -5.0f, 10.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition sides4 = body.addOrReplaceChild("sides4", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f));
        PartDefinition cube_r15 = sides4.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(69, 117).addBox(12.0f, -40.0f, -4.0f, 10.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r16 = sides4.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(85, 92).addBox(5.0f, -30.0f, -4.5f, 10.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition cube_r17 = sides4.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(54, 75).addBox(5.0f, -16.0f, -5.0f, 10.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition eye = body.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(30, 84).addBox(-4.0f, -4.0f, -3.0f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(117, 49).addBox(-5.0f, -5.0f, -2.0f, 10.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-10.0f));
        PartDefinition pupil = eye.addOrReplaceChild("pupil", CubeListBuilder.create().texOffs(11, 0).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition brains = body.addOrReplaceChild("brains", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition brain3 = brains.addOrReplaceChild("brain3", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-26.0f, (float)5.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition brain2 = brains.addOrReplaceChild("brain2", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)-19.0f, (float)6.0f));
        PartDefinition brain = brains.addOrReplaceChild("brain", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)5.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition brains2 = body.addOrReplaceChild("brains2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition brain4 = brains2.addOrReplaceChild("brain4", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-26.0f, (float)5.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition brain5 = brains2.addOrReplaceChild("brain5", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)-19.0f, (float)6.0f));
        PartDefinition brain6 = brains2.addOrReplaceChild("brain6", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)5.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition brains3 = body.addOrReplaceChild("brains3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition brain7 = brains3.addOrReplaceChild("brain7", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-26.0f, (float)5.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition brain8 = brains3.addOrReplaceChild("brain8", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)-19.0f, (float)6.0f));
        PartDefinition brain9 = brains3.addOrReplaceChild("brain9", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)5.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition brains4 = body.addOrReplaceChild("brains4", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition brain10 = brains4.addOrReplaceChild("brain10", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-26.0f, (float)5.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition brain11 = brains4.addOrReplaceChild("brain11", CubeListBuilder.create().texOffs(224, 240).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)-19.0f, (float)6.0f));
        PartDefinition tentacleBase = body.addOrReplaceChild("tentacleBase", CubeListBuilder.create(), PartPose.offsetAndRotation((float)9.0f, (float)0.0f, (float)-9.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition tentacle = tentacleBase.addOrReplaceChild("tentacle", CubeListBuilder.create().texOffs(23, 146).addBox(-2.0f, -2.0f, -13.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle2 = tentacle.addOrReplaceChild("tentacle2", CubeListBuilder.create().texOffs(82, 145).addBox(-2.0f, -2.0f, -15.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-12.75f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle3 = tentacle2.addOrReplaceChild("tentacle3", CubeListBuilder.create().texOffs(143, 95).addBox(-2.0f, -2.0f, -15.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-14.75f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle4 = tentacle3.addOrReplaceChild("tentacle4", CubeListBuilder.create().texOffs(155, 33).addBox(-1.5f, -1.5f, -15.0f, 3.0f, 3.0f, 15.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-14.75f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleBase2 = body.addOrReplaceChild("tentacleBase2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-9.0f, (float)0.0f, (float)-9.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition tentacle5 = tentacleBase2.addOrReplaceChild("tentacle5", CubeListBuilder.create().texOffs(0, 142).addBox(-2.0f, -2.0f, -13.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle6 = tentacle5.addOrReplaceChild("tentacle6", CubeListBuilder.create().texOffs(59, 141).addBox(-2.0f, -2.0f, -15.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-12.75f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle7 = tentacle6.addOrReplaceChild("tentacle7", CubeListBuilder.create().texOffs(136, 137).addBox(-2.0f, -2.0f, -15.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-14.75f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle8 = tentacle7.addOrReplaceChild("tentacle8", CubeListBuilder.create().texOffs(105, 152).addBox(-1.5f, -1.5f, -15.0f, 3.0f, 3.0f, 15.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-14.75f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleBase3 = body.addOrReplaceChild("tentacleBase3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)9.0f, (float)0.0f, (float)9.0f, (float)0.0f, (float)-2.3562f, (float)0.0f));
        PartDefinition tentacle9 = tentacleBase3.addOrReplaceChild("tentacle9", CubeListBuilder.create().texOffs(137, 118).addBox(-2.0f, -2.0f, -13.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle10 = tentacle9.addOrReplaceChild("tentacle10", CubeListBuilder.create().texOffs(113, 133).addBox(-2.0f, -2.0f, -15.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-12.75f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle11 = tentacle10.addOrReplaceChild("tentacle11", CubeListBuilder.create().texOffs(132, 48).addBox(-2.0f, -2.0f, -15.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-14.75f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle12 = tentacle11.addOrReplaceChild("tentacle12", CubeListBuilder.create().texOffs(149, 67).addBox(-1.5f, -1.5f, -15.0f, 3.0f, 3.0f, 15.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-14.75f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleBase4 = body.addOrReplaceChild("tentacleBase4", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-8.0f, (float)1.0f, (float)9.0f, (float)0.0f, (float)2.3562f, (float)0.0f));
        PartDefinition tentacle13 = tentacleBase4.addOrReplaceChild("tentacle13", CubeListBuilder.create().texOffs(90, 126).addBox(-2.0f, -2.0f, -13.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle14 = tentacle13.addOrReplaceChild("tentacle14", CubeListBuilder.create().texOffs(126, 76).addBox(-2.0f, -2.0f, -15.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-12.75f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle15 = tentacle14.addOrReplaceChild("tentacle15", CubeListBuilder.create().texOffs(36, 126).addBox(-2.0f, -2.0f, -15.0f, 4.0f, 4.0f, 15.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-14.75f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle16 = tentacle15.addOrReplaceChild("tentacle16", CubeListBuilder.create().texOffs(148, 9).addBox(-1.5f, -1.5f, -15.0f, 3.0f, 3.0f, 15.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-14.75f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(Proto proto, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.yRot = netHeadYaw / 57.295776f;
        this.body.getChild((String)"tentacleBase").xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        this.body.getChild((String)"tentacleBase2").xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        this.body.getChild((String)"tentacleBase3").xRot = Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        this.body.getChild((String)"tentacleBase4").xRot = -Mth.sin((float)(ageInTicks / 8.0f)) / 10.0f;
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (entity != null) {
            Vec3 vec3 = entity.getEyePosition(0.0f);
            Vec3 vec31 = proto.getEyePosition(0.0f);
            double d0 = vec3.y - vec31.y;
            this.body.getChild((String)"eye").getChild((String)"pupil").y = d0 > 0.0 ? 0.0f : 1.0f;
            Vec3 vec32 = proto.getViewVector(0.0f);
            vec32 = new Vec3(vec32.x, 0.0, vec32.z);
            Vec3 vec33 = new Vec3(vec31.x - vec3.x, 0.0, vec31.z - vec3.z).normalize().yRot(1.5707964f);
            double d1 = vec32.dot(vec33);
            this.body.getChild((String)"eye").getChild((String)"pupil").x = Mth.sqrt((float)((float)Math.abs(d1))) * 3.0f * (float)Math.signum(d1);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.base.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }
}

